package jp.hasc.hasctool.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;

import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;


/**
 * @author iwasaki
 */
public class CoreUtil {
	
	public static void throwAsRuntimeException(Throwable th) {
		if (th instanceof RuntimeException) {
			throw (RuntimeException)th;
		}else{
			throw new RuntimeException(th);
		}
	}
	
	public static void copyToClipboard(Display display, String text) {
		final Clipboard cb = new Clipboard(display);
		TextTransfer textTransfer = TextTransfer.getInstance();
		cb.setContents(new Object[] { text },
				new Transfer[] { textTransfer });
	}
	
	public static String readReaderAsString(Reader r) throws IOException {
		StringBuilder sb=new StringBuilder();
		char[] buff=new char[1024];
		while(true) {
			int len=r.read(buff);
			if (len<0) break;
			sb.append(buff,0,len);
		}
		return sb.toString();
	}
	
	public static void copyStreamAndClose(InputStream inps, OutputStream outs) throws IOException {
		byte[] buff=new byte[1024];
		try{
			while(true) {
				int bytes=inps.read(buff);
				if (bytes<0) break;
				outs.write(buff,0,bytes);
			}
		}finally{
			inps.close();
			outs.close();
		}
	}

	private static String hexDigits_="0123456789abcdef";
	
	public static int hexToInt(String hexStr) {
		int r=0;
		hexStr=hexStr.toLowerCase();
		for(int i=0,num=hexStr.length();i<num;++i) {
			char c=hexStr.charAt(i);
			int idx=hexDigits_.indexOf(c);
			if (idx<0) throw new IllegalArgumentException(hexStr);
			r=r*16+idx;
		}
		return r;
	}
}
