package jp.hasc.hasctool.ui.bdeditor2;

import jp.hasc.hasctool.core.blockdiagram.model.BlockDiagram;
import jp.hasc.hasctool.ui.bdeditor2.model.commands.BlockDiagramPasteCommand;

import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.actions.ActionFactory;

/**
 * @author iwasaki
 */
public class BlockDiagramEditorPasteAction extends SelectionAction {
	/** logger for this class */
	private final static org.apache.commons.logging.Log LOG = org.apache.commons.logging.LogFactory
			.getLog(BlockDiagramEditorPasteAction.class);

	private BlockDiagramEditor editor_;
	
	public BlockDiagramEditorPasteAction(BlockDiagramEditor part) {
		super(part);
		editor_=part;
	}

	@Override
	protected boolean calculateEnabled() {
		return true;
	}
	
	@Override
	protected void init() {
		setId(ActionFactory.PASTE.getId());
		setText("Paste");
	}
	
	@Override
	public void run() {
		Object contents=Clipboard.getDefault().getContents();
		if (contents==null) return;
		if (contents instanceof BlockDiagram) {
			execute(new BlockDiagramPasteCommand(editor_, (BlockDiagram)contents));
		}else{
			LOG.warn("Unknown object: " + contents);
		}
	}

}
