// based on GEF ShapesEditor example
/*******************************************************************************
 * Copyright (c) 2004, 2005 Elias Volanakis and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Elias Volanakis - initial API and implementation
 *******************************************************************************/
package jp.hasc.hasctool.ui.bdeditor2.model;

import java.util.List;

import jp.hasc.hasctool.core.blockdiagram.model.Comment;
import jp.hasc.hasctool.core.blockdiagram.model.Shape;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

/**
 * @author iwasaki
 */
public class CommentElement extends ShapeElement{
	private static final long serialVersionUID = 1;

	private Comment comment_;
	
	public CommentElement() {
		this(new Comment("Text"));
	}
	
	public CommentElement(Comment c) {
		comment_=c;
	}
	
	@Override
	public Shape getShape() { return comment_; }
	
	@Override
	public String toString() {
		return "Comment - "+truncateText(getText(),16);
	}

	private String truncateText(String text, int len) {
		text=text.replace("\n"," ");
		if (text.length()>len) {
			return text.substring(0,len)+"..";
		}else{
			return text;
		}
	}

	public static final String TEXT_PROP = "Comment.Text";
	public static final String FOREGROUND_COLOR_PROP = "Comment.ForegroundColor";
	public static final String BACKGROUND_COLOR_PROP = "Comment.BackgroundColor";
	
	@Override
	protected void setupPropertyDescriptors(
			List<IPropertyDescriptor> descriptors) {
		descriptors.add(new TextDialogPropertDescriptor(TEXT_PROP,"Text"));
		descriptors.add(new TextPropertyDescriptor(FOREGROUND_COLOR_PROP,"Foreground Color"));
		descriptors.add(new TextPropertyDescriptor(BACKGROUND_COLOR_PROP,"Background Color"));
		//
		super.setupPropertyDescriptors(descriptors);
	}
	
	public String getText() {
		String s = comment_.getText();
		return s!=null?s:"";
	}
	
	public void setText(String s) {
		comment_.setText(s);
		firePropertyChange(TEXT_PROP, null, s);
	}
	
	public String getForegroundColor() {
		String s = comment_.getForegroundColor();
		return s!=null?s:"";
	}
	
	public void setForegroundColor(String s) {
		if (s!=null && s.isEmpty()) s=null;
		comment_.setForegroundColor(s);
		firePropertyChange(FOREGROUND_COLOR_PROP, null, s);
	}
	
	public String getBackgroundColor() {
		String s = comment_.getBackgroundColor();
		return s!=null?s:"";
	}
	
	public void setBackgroundColor(String s) {
		if (s!=null && s.isEmpty()) s=null;
		comment_.setBackgroundColor(s);
		firePropertyChange(BACKGROUND_COLOR_PROP, null, s);
	}
	
	@Override
	public Object getPropertyValue(Object id) {
		if (TEXT_PROP.equals(id)) {
			return getText();
		}else if (FOREGROUND_COLOR_PROP.equals(id)) {
			return getForegroundColor();
		}else if (BACKGROUND_COLOR_PROP.equals(id)) {
			return getBackgroundColor();
		}else{
			return super.getPropertyValue(id);
		}
	}
	
	@Override
	public void setPropertyValue(Object id, Object value) {
		if (TEXT_PROP.equals(id)) {
			setText((String)value);
		}else if (FOREGROUND_COLOR_PROP.equals(id)) {
			setForegroundColor((String)value);
		}else if (BACKGROUND_COLOR_PROP.equals(id)) {
			setBackgroundColor((String)value);
		}else {
			super.setPropertyValue(id, value);
		}
	}
}
