package jp.hasc.hasctool.ui.bdeditor2.model;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TextDialog extends Dialog {
	private String textStr_;
	private Text textArea_;

	protected TextDialog(Shell parentShell) {
		super(parentShell);
	}
	
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite composite = (Composite)super.createDialogArea(parent);
		textArea_ = new Text(composite, SWT.MULTI|SWT.WRAP|SWT.BORDER);
		textArea_.setText(textStr_);
		GridData gd=new GridData(GridData.VERTICAL_ALIGN_FILL|GridData.HORIZONTAL_ALIGN_FILL);
		gd.widthHint=200;
		gd.heightHint=200;
		textArea_.setLayoutData(gd);
		return composite;
	}
	
	@Override
	protected void buttonPressed(int buttonId) {
		textStr_=textArea_.getText();
		super.buttonPressed(buttonId);
	}
	
	public String getText() {
		return textStr_;
	}

	public void setText(String text) {
		textStr_ = text;
	}
	
}