// based on GEF ShapesEditor example
/*******************************************************************************
 * Copyright (c) 2004, 2005 Elias Volanakis and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Elias Volanakis - initial API and implementation
 *******************************************************************************/
package jp.hasc.hasctool.ui.bdeditor2.parts;

import jp.hasc.hasctool.ui.bdeditor2.model.BlockDiagramElement;
import jp.hasc.hasctool.ui.bdeditor2.model.BlockElement;
import jp.hasc.hasctool.ui.bdeditor2.model.ConnectionElement;
import jp.hasc.hasctool.ui.bdeditor2.model.ShapeElement;
import jp.hasc.hasctool.ui.bdeditor2.model.commands.BlockDeleteCommand;
import jp.hasc.hasctool.ui.bdeditor2.model.commands.ConnectionDeleteCommand;
import jp.hasc.hasctool.ui.bdeditor2.model.commands.ShapeDeleteCommand;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;

/**
 * @author iwasaki
 */
public class ModelElementComponentEditPolicy extends ComponentEditPolicy {

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.gef.editpolicies.ComponentEditPolicy#createDeleteCommand(
	 * org.eclipse.gef.requests.GroupRequest)
	 */
	protected Command createDeleteCommand(GroupRequest deleteRequest) {
		Object parent = getHost().getParent().getModel();
		Object child = getHost().getModel();
		if (child instanceof ConnectionElement) {
			return new ConnectionDeleteCommand((ConnectionElement)child);
		}else if (child instanceof BlockElement) {
			return new BlockDeleteCommand((BlockDiagramElement) parent, (BlockElement) child);
		}else if (child instanceof ShapeElement) {
			return new ShapeDeleteCommand((BlockDiagramElement) parent, (ShapeElement) child);
		}
		return super.createDeleteCommand(deleteRequest);
	}
}