package jp.hasc.hasctool.core.runtime.filter.weka.file;

import jp.hasc.hasctool.core.data.EnumCommand;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;


/**
 * FileParser
 * HASC DataからWEKA Data にパースします
 * @author hiro
 */
public class ArffFileCreator extends AbstractFilter{

	//評価対象を指定
	String element_;

	//特徴量を指定
	String feature_;
	String[] fList_;
	int fLength_;

	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
		fList_ = feature_.split(",");
		fLength_ = fList_.length;
	}

	public void setElement(String element) {
		element_ = element;
	}

	public void setFeature(String feature) {
		feature_ = feature;
	}

	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof String) {
			String line = (String)message;
			outputMessage(line);

		} else if (message == EnumCommand.BEGIN) {
			outputMessage(EnumCommand.BEGIN);
			outputMessage("@RELATION activity");
			for(int i=0; i<fLength_; i++){
				outputMessage("@ATTRIBUTE " + fList_[i] +" NUMERIC");
			}
			outputMessage("@ATTRIBUTE class	" 
					+ "{" + element_ + "}");
			outputMessage("@Data");
		} else {
			// その他のメッセージはそのまま出力
			outputMessage(message);
		}
	}
}
