package jp.hasc.hasctool.core.runtime.filter.weka.message;

import java.util.ArrayList;

import jp.hasc.hasctool.core.data.EnumCommand;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

/**
 * 入力形式は、filePath,label。
 * 出力形式は、filePath もしくは label,label,...
 * ちなみに、ファイルごとにまとめて出力します
 * @author hiro
 */
public class MessageSplitter extends AbstractFilter{

	boolean label_filePath;
	boolean start_ = true;
	String filePath_ = "FILE PATH";//現在のファイルパス
	ArrayList<String> labelList_;

	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
	}

	public void setLabel_filePath(String val){
		if(val.equals("label")){
			label_filePath = true;
		} else {
			label_filePath = false;
		}
	}

	private String createLabelLine() {
		int len = labelList_.size();
		String label = labelList_.get(0);
		for(int i=1; i<len; i++){
			label += "," + labelList_.get(i);
		}
		return label;
	}

	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof String) {
			String s =(String)message;
			String[] dpart = s.split(",");
			if(!(dpart[0].equals(filePath_))){
				if(start_){
					start_ = false;
				} else {
					if(label_filePath){
						String label = createLabelLine();
						outputMessage(label);
					}else{
						outputMessage(filePath_);
					}
				}
				labelList_ = new ArrayList<String>();//labelList_をクリア
				filePath_ = dpart[0];//filePath_を更新
			}
			labelList_.add(dpart[1]);
		} else if (message == EnumCommand.END) {
			if(label_filePath){
				String label = createLabelLine();
				outputMessage(label);
			}else{
				outputMessage(filePath_);
			}
			outputMessage(EnumCommand.END);
			
		}else{
			//BEGIN,message
			outputMessage(message);
		}
	}
}
