package jp.hasc.hasctool.core.data;

/**
 * Objectを持ったSignalMessageです。
 * @author iwasaki
 */
public class ObjectSignalMessage extends AbstractSignalMessage {

	private Object value_;

	public ObjectSignalMessage(long time, Object value) {
		super(time);
		value_ = value;
	}

	/**
	 * 値を取得します。中身のObjectを変更しないで下さい。
	 */
	public Object getValue() {
		return value_;
	}

	@Override
	public SignalMessage createDelayedElement(long delay) {
		if (delay==0) return this;
		return new ObjectSignalMessage(getTime()+delay, value_);
	}

}
