package jp.hasc.hasctool.core.runtime.filter;

import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessages;

/**
 * ベクトルの各要素に対して絶対値を返すフィルタ
 * @author hiro
 */
public class AbsoluteFilter extends AbstractFilter {
	private double constantToMultiply_ = -1;

	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof VectorSignalMessage) {
			// VectorSignalMessageの場合
			VectorSignalMessage vsig=(VectorSignalMessage)message;
			// 新しいベクトルの値を計算
			double[] newValue = new double[vsig.getVectorSize()];
			for(int i=0;i<newValue.length;++i){
				if(vsig.getVectorElement(i) <= 0){
					newValue[i] = vsig.getVectorElement(i)*constantToMultiply_;
				}else{
					newValue[i] = vsig.getVectorElement(i);
				}
			}
			// 結果を出力
			outputMessage(VectorSignalMessages.create(vsig.getTime(), newValue));
		}else{
			// その他のメッセージ（BEGIN, ENDなど）はそのまま出力
			outputMessage(message);
		}
	}
}
