package jp.hasc.hasctool.core.runtime.filter;

import jp.hasc.hasctool.core.data.SignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessages;
import jp.hasc.hasctool.core.runtime.annotation.PortInfo;
import jp.hasc.hasctool.core.runtime.annotation.RuntimeBeanInfo;
import jp.hasc.hasctool.core.runtime.filter.interpolator.AbstractMultipleInputsFilter;
import jp.hasc.hasctool.core.runtime.filter.interpolator.LinearVectorInterporator;
import jp.hasc.hasctool.core.runtime.filter.interpolator.SignalInterpolator;

/**
 * 複数のベクトルを加算するフィルタです。
 * @author iwasaki
 */
@RuntimeBeanInfo(
		inputPorts = { @PortInfo(name = "inputPort[]", classes = {VectorSignalMessage.class}) },
		outputPorts = { @PortInfo(name = "outputPort", classes = {VectorSignalMessage.class}) }
)
public class VectorAdder extends AbstractMultipleInputsFilter {

	@Override
	public SignalInterpolator createSignalInterpolator(int portIndex) {
		return new LinearVectorInterporator();
	}
	
	@Override
	protected boolean acceptSignalMessage(int portIndex, SignalMessage signalMessage) {
		return signalMessage instanceof VectorSignalMessage;
	}

	@Override
	protected void processSignalMessages(long time, SignalMessage[] messages) throws InterruptedException {
		int pi=getPrimaryInputPortIndex();
		VectorSignalMessage pvse=(VectorSignalMessage) messages[pi];
		int valSize = pvse.getVectorSize();
		double[] val=new double[valSize];
		for(int j=0;j<valSize;++j) val[j]=0;
		for(int i=0;i<messages.length;++i) {
			VectorSignalMessage vse = (VectorSignalMessage)messages[i];
			for(int j=0;j<valSize;++j) {
				val[j]+=vse.getVectorElement(j);
			}
		}
		outputMessage(VectorSignalMessages.create(time, val, false));
	}
}
