package jp.hasc.hasctool.core.runtime.filter;

import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessages;

/**
 * VectorSignalMessageの選択した要素を出力するフィルタです
 * @author hiro
 */
public class VectorElementsFilter extends AbstractFilter {
	
	private int startIndex_;
	private int endIndex_;

	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof VectorSignalMessage) {
			VectorSignalMessage vsig = (VectorSignalMessage) message;
			int len = endIndex_ - startIndex_+1;
			double[] newValue = new double[len];
			int index = startIndex_;
			for(int i=0; i<len; i++){
				newValue[i] = vsig.getVectorElement(index+i);
			}
			// output
			outputMessage(VectorSignalMessages.create(vsig.getTime(), newValue));
		}else{
			outputMessage(message);
		}
	}

	public void setStartIndex(int startIndex) {
		startIndex_ = startIndex;
	}
	
	public void setEndIndex(int endIndex) {
		endIndex_ = endIndex;
	}
}
