package jp.hasc.hasctool.core.runtime.filter.file.path;

import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

/**
 * ファイル名を入力順にカウントしながら自動生成します
 * @author hiro
 */
public class FileNameCreator extends AbstractFilter{

	private String feature_;
	private int count_;
	
	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof String) {
			String s =(String)message;
			count_++;
			String extension = s.split("\\.")[1];
			String[] part = s.split("/");
			String fpath = "";
			for(int i=0; i<part.length-1; i++){
				fpath += part[i];
				if(i != part.length-2)fpath += "/";
			}
			outputMessage(fpath+"/"+feature_+count_+"."+extension);
		}else{
			//BEGIN,END message
			outputMessage(message);
		}
	}

	public void setFeature(String feature){
		feature_ = feature;
	}
	
	public void setStart(int count){
		count_ = count;
	}
	

}
