package jp.hasc.hasctool.core.runtime.filter.file.table;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.util.CoreUtil;

/*  
 * ファイルの行数, 単語数, 文字数をカウント(wc)し、数とファイル名をcsv形式で出力します
 * 単語の分割は "空白とタブ", 文字数は、UTF-8で、改行文字を1文字としてカウントしています。
 * @author kawaguti
 */


public class FileWordCountToCSVFilter extends AbstractElementFilter {

	
	String element_= "LineCount, WordCount, FileSize, Filepath, FilePathElements";
	
	public void setup(RuntimeContext context) {
		super.setup(context);
		super.element_ = this.element_;
	}


	@Override
	String getFeature(String filePath) {
		int linect = 0, wordct = 0, size= 0;
		try{
			InputStream inps = getRuntimeContext().getFileStreamProvider().openInputStream(filePath);
			BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inps, RuntimeContext.DEFAULT_CHARSET));

			while(true){
				String line = bufferedReader.readLine();
				if (line == null) {
					break;
				} else {
					linect++;
					String[] row = line.trim().split("[ \t]+");
					wordct += row.length;
					size += line.length()+1; // +1 for new line.
				}
			}
			bufferedReader.close();
			inps.close();
		} catch (IOException ex) {
			CoreUtil.throwAsRuntimeException(ex);
		} catch (RuntimeException ex) {
		}
		String row = ""+linect+","+wordct+","+size+ ","+filePath;
		
		String pathCmp[] =filePath.split("/");
		for(int i = 0 ;i <  pathCmp.length; i++){
			row +=","+pathCmp[i];
		}

		return row;
	}

}
