package jp.hasc.hasctool.core.runtime.filter.label;

import jp.hasc.hasctool.core.data.ScalarSignalMessage;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

/**
 * ScalarSignalMessageの値が、しきい値より大きい場合に、指定されたラベルを出力するフィルタです
 * @author hiro
 */
public class ThretholdLabelingFilter extends AbstractFilter {

	private double threthold_=0;
	private String label_="label";
	private ScalarSignalMessage previousHighSignal_=null;

	public void setThrethold(double threthold) {
		threthold_ = threthold;
	}

	public void setLabel(String label) {
		label_=label;
	}

	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof ScalarSignalMessage) {
			ScalarSignalMessage sig=(ScalarSignalMessage)message;
			double v=sig.getScalarValue();
			String label = "none";
			if (threthold_<v) {
				if (previousHighSignal_==null) {
					// 信号の立ち上がりを検出した
					label = label_;
				}
				previousHighSignal_=sig;
			}else{
				if (previousHighSignal_!=null) {
					// 信号の立ち下がりを検出した
					previousHighSignal_=null;
				}
			}
			outputMessage(label);
		}else{
			// その他のメッセージ（BEGIN, ENDなど）はそのまま出力
			outputMessage(message);
		}
	}

}
