package jp.hasc.hasctool.core.runtime.filter.window;

import jp.hasc.hasctool.core.data.Complex;


/**
 * 窓関数クラスです
 * ハニング窓、ハミング窓、ブラックマン窓、ガウス窓
 * @author hiro
 */

public class WindowFunction{

	double PI = Math.PI;
	Complex[] output_;
	
	//ハニング窓
	public Complex[] WindowHanning(Complex[] input){
		int N = input.length;
		output_ = new Complex[N];
		for(int n=0; n<N; n++){
			double val = 0.5 - 0.5*Math.cos( 2.0*PI*n/(N-1) );
			output_[n] = input[n].times(val);
		}
		return output_;
	}

	//ハミング窓
	public Complex[] WindowHamming(Complex[] input){
		int N = input.length;
		output_ = new Complex[N];
		for(int n=0; n<N; n++){
			double val = 0.54 - 0.46*Math.cos( 2.0*PI*n/(N-1) );
			output_[n] = input[n].times(val);
		}
		return output_;
	}

	//ブラックマン窓
	public Complex[] WindowBlackman(Complex[] input, int index){
		int N = input.length;
		output_ = new Complex[N];
		for(int n=0; n<N; n++){
			double val = 0.42 - 0.5*Math.cos( 2.0*PI*n/(N-1) ) + 0.08*Math.cos( 4.0*PI*n/(N-1) );
			output_[n] = input[n].times(val);
		}
		return output_;
	}

	//ガウス窓
	public Complex[] WindowGaussian(Complex[] input, int index, double k){
		int N = input.length;
		output_ = new Complex[N];
		for(int n=0; n<N; n++){
			double val1 = Math.pow( n-(N-1)/2, 2.0 );
			double val2 = -2.0*k*k / Math.pow((N-1), 2.0);
			double val = Math.exp(val1*val2);
			output_[n] = input[n].times(val);
		}
		return output_;
	}
}
