package jp.hasc.hasctool.ui;

import jp.hasc.hasctool.ui.views.RuntimeSamplesView;
import jp.hasc.hasctool.ui.views.VectorView;
import jp.hasc.hasctool.ui.views.WaveView;
import jp.hasc.hasctool.ui.views.beanslist.BeansListView;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

/**
 * @author iwasaki
 */
public class HascToolPerspective implements IPerspectiveFactory {

	public static final String ID = "jp.hasc.hasctool.ui.HascToolPerspective";

	public void createInitialLayout(IPageLayout layout) {
		String editorArea = layout.getEditorArea();
		layout.setEditorAreaVisible(true);
		// layout.setFixed(true);

		//
		layout.addShowViewShortcut(BeansListView.ID);
		layout.addShowViewShortcut(RuntimeSamplesView.ID);
		layout.addShowViewShortcut(IPageLayout.ID_PROJECT_EXPLORER);
		layout.addShowViewShortcut(IPageLayout.ID_PROP_SHEET);
		layout.addShowViewShortcut("org.eclipse.ui.console.ConsoleView");
		layout.addShowViewShortcut("org.eclipse.pde.runtime.LogView");

		//
		IFolderLayout topLeft = layout.createFolder("topLeft",
				IPageLayout.LEFT, (float) 0.3, editorArea);
		// topLeftFolder.addView(ViewsIdInfo.ID_NAVIGATOR_VIEW);
		// topLeftFolder.addView(NavigationView.ID);
		topLeft.addView(IPageLayout.ID_PROJECT_EXPLORER);
		topLeft.addView(BeansListView.ID);
		topLeft.addPlaceholder(RuntimeSamplesView.ID);

		//
		IFolderLayout bottomLeft = layout.createFolder("bottomLeft",
				IPageLayout.BOTTOM, (float) 0.5, "topLeft");
		bottomLeft.addView(IPageLayout.ID_PROP_SHEET);

		//
		IFolderLayout bottomRight = layout.createFolder("bottomRight",
				IPageLayout.BOTTOM, (float) 0.6, editorArea);
		bottomRight.addPlaceholder(WaveView.ID);
		bottomRight.addPlaceholder(WaveView.ID + ":*");
		bottomRight.addPlaceholder(VectorView.ID);
		bottomRight.addPlaceholder(VectorView.ID + ":*");
		bottomRight.addView("org.eclipse.ui.console.ConsoleView");
		bottomRight.addView("org.eclipse.pde.runtime.LogView");

	}

}
