package jp.hasc.hasctool.ui.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import jp.hasc.hasctool.core.runtime.filter.ScalarAdder;
import jp.hasc.hasctool.core.runtime.filter.ScalarMultiplier;
import jp.hasc.hasctool.core.runtime.filter.file.CSVToVectorFilter;
import jp.hasc.hasctool.core.runtime.filter.file.VectorToCSVFilter;
import jp.hasc.hasctool.core.runtime.sink.LineWriterSink;
import jp.hasc.hasctool.core.runtime.source.LineReaderSource;
import jp.hasc.hasctool.core.runtime.source.SinWaveGenerator;
import jp.hasc.hasctool.ui.views.RuntimeWaveView;
import jp.hasc.hasctool.ui.views.beanslist.BeanClass;
import jp.hasc.hasctool.ui.views.beanslist.BeansFolder;
import jp.hasc.hasctool.ui.views.beanslist.BeansListLoader;
import junit.framework.TestCase;

import com.thoughtworks.xstream.XStream;

/**
 * @author iwasaki
 */
public class BeansListModelTest extends TestCase {
	public void test1() {
		String s;
		{
			Collection<BeansFolder> data = BeansListModelTest.makeSampleData();
			XStream xs=BeansListLoader.newXStream();
			s=xs.toXML(data);
			System.out.println(s);
		}
		
		{
			XStream xs=BeansListLoader.newXStream();
			@SuppressWarnings("unchecked")
			Collection<BeansFolder> data=(Collection<BeansFolder>)xs.fromXML(s);
			//
			XStream xs2=BeansListLoader.newXStream();
			String s2 = xs2.toXML(data);
			assertEquals(s, s2);
		}
	}
	
	public static Collection<BeansFolder> makeSampleData() {
		List<BeansFolder> li=new ArrayList<BeansFolder>();
		{
			BeansFolder n = new BeansFolder("jp.hasc.hasctool.core.runtime.filter");
			n.classes().add(new BeanClass(ScalarAdder.class));
			n.classes().add(new BeanClass(ScalarMultiplier.class));
			li.add(n);
		}
		{
			BeansFolder n = new BeansFolder("jp.hasc.hasctool.core.runtime.filter.file");
			n.classes().add(new BeanClass(CSVToVectorFilter.class));
			n.classes().add(new BeanClass(VectorToCSVFilter.class));
			li.add(n);
		}
		{
			BeansFolder n = new BeansFolder("jp.hasc.hasctool.core.runtime.source");
			n.classes().add(new BeanClass(LineReaderSource.class));
			n.classes().add(new BeanClass(SinWaveGenerator.class));
			li.add(n);
		}
		{
			BeansFolder n = new BeansFolder("jp.hasc.hasctool.core.runtime.sink");
			n.classes().add(new BeanClass(LineWriterSink.class));
			li.add(n);
		}
		{
			BeansFolder n = new BeansFolder("jp.hasc.hasctool.views");
			n.classes().add(new BeanClass(RuntimeWaveView.class));
			li.add(n);
		}
		return li;
	}
}
