package jp.hasc.hasctool.ui.views.beanslist;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

/**
 * @author iwasaki
 */
public class BeansListLabelProvider extends LabelProvider  {

	@Override
	public String getText(Object v) {
		if (v instanceof BeansFolder) {
			BeansFolder m = (BeansFolder) v;
			return m.getLabel();
		}
		if (v instanceof BeanClass) {
			BeanClass m = (BeanClass) v;
			return m.getLabel();
		}
		return "";
	}

	@Override
	public Image getImage(Object v) {
		if (v instanceof BeansFolder) {
			//FolderModel m = (FolderModel) v;
			return getSharedImage(ISharedImages.IMG_OBJ_FOLDER);
		}
		if (v instanceof BeanClass) {
			//ClassModel m = (ClassModel) v;
			return getSharedImage(ISharedImages.IMG_OBJ_FILE);
		}
		return getSharedImage(ISharedImages.IMG_OBJ_ELEMENT);
	}

	private static Image getSharedImage(String key) {
		return PlatformUI.getWorkbench().getSharedImages().getImage(key);
	}
}
