package hayashi.yuu.tools.mail.gui;
import hayashi.yuu.tools.properties.Properties;
import hayashi.yuu.tools.properties.PropertyItem;
import hayashi.yuu.tools.mail.SendMail;
import hayashi.yuu.tools.mail.SiteData;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Logger;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;


/**
 * <p>アプリケーション設定を行うモーダルダイアログフォーム</p>
 * <code>
 * ・タイトルパネル
 * 		"メール送信 設定"
 * ・メインパネル
 * 		"<メールサーバーの設定>"
 * ・ボタンパネル
 * 		[OK]ボタン
 * 		[Cancel]ボタン
 * </code>
 * @author hayashi
 *
 */
@SuppressWarnings("serial")
public class SettingDialog extends JDialog implements WindowListener
{
    JLabel label1;
    JLabel label2;
    JTextArea textArea;
    JFrame parent;
    public static Properties prop;
    public static SetupMailServer mailServerPanel;
    public static MailAddrPanel mailAddrPanel;
	public static String fileName;
	static Logger logger;
    
    /*
     * 設定項目：
     * 	
     */
    public SettingDialog(JFrame parent, boolean modal, String propertiesFileName, Logger logger) throws FileNotFoundException, IOException {
        super(parent, modal);
        SettingDialog.logger = logger;
        SettingDialog.fileName = propertiesFileName;
        
        // 設定ファイルの読み込み
        prop = new Properties();
        prop.load(new FileInputStream(propertiesFileName));

        addWindowListener(this);
        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        this.parent = parent;
        setTitle("設定");
        getContentPane().setLayout(new BorderLayout());
        setSize(420, SetupMailServer.CATEGORY_HEIGHT + MailAddrPanel.CATEGORY_HEIGHT + (PropertyItem.LINE_HEIGHT * 9));
        
        /*
         * タイトルパネル
         */
		JPanel topPanel = new JPanel();
        label1 = new JLabel("メール送信 設定", JLabel.CENTER);
        label1.setBounds(10,10,340,20);
        topPanel.add(label1);
        getContentPane().add(topPanel, BorderLayout.NORTH);
        
		/*
		 * カテゴリ：[ メールサーバーの設定 ]
		 */
        mailServerPanel = new SetupMailServer(prop);
		
		/*
		 * カテゴリ：[ メールの配信先設定 ]
		 */
        mailAddrPanel = new MailAddrPanel(prop);
		
        /*
		 * メインパネル
		 */
		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new FlowLayout());
		mainPanel.add(makePanel("メールサーバーの設定", mailServerPanel));
		mainPanel.add(makePanel("メールの配信先", mailAddrPanel));
        getContentPane().add(mainPanel, BorderLayout.CENTER);

        /*
		 * [OK]ボタン　:　このダイアログウインドウを閉じる
		 */
	    JButton saveButton = new JButton("保存");
        saveButton.setBounds(145,65,66,27);
        saveButton.addActionListener(new java.awt.event.ActionListener() {
        	public void actionPerformed(java.awt.event.ActionEvent evt) {
        		try {
        			SettingDialog.prop.store(new FileOutputStream(SettingDialog.fileName), "SendMail GUI");
				}
        		catch (FileNotFoundException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
        		catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
        		
        		Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(SettingDialog.this, WindowEvent.WINDOW_CLOSING));
        		setVisible(false);
        	}
        });

		/*
		 * [Cancel]ボタン　:　このダイアログウインドウを閉じる
		 */
	    JButton cancelButton = new JButton("取消");
	    cancelButton.setBounds(145,65,66,27);
	    cancelButton.addActionListener(new java.awt.event.ActionListener() {
        	public void actionPerformed(java.awt.event.ActionEvent evt) {
        		Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(SettingDialog.this, WindowEvent.WINDOW_CLOSING));
        		setVisible(false);
        	}
        });
	    
	    /*
	     * [テスト送信]ボタン　:　テストメールを送信する
	     */
	    JButton testButton = new JButton("テスト送信");
	    testButton.setBounds(145,65,66,27);
	    testButton.addActionListener(new java.awt.event.ActionListener() {
        	public void actionPerformed(java.awt.event.ActionEvent evt) {
        		SiteData siteData = SettingDialog.mailServerPanel.getSiteData();
        		SettingDialog.mailAddrPanel.getSiteData(siteData);
    			SendMail mail = new SendMail(siteData);
                mail.setSubject("[SendMail] メール送信テスト");
                mail.setContent("このメールは[SendMail]からのメール送信テストです。");
    			try {
					mail.send();
					SettingDialog.logger.info("メールを送信しました。");
	                JOptionPane.showMessageDialog(SendMailGUI.mainFrame, "メールを送信しました。", "成功", JOptionPane.INFORMATION_MESSAGE);
				} catch (Exception e) {
					e.printStackTrace();
					SettingDialog.logger.warning("メール送信に失敗しました。");
	                JOptionPane.showMessageDialog(SendMailGUI.mainFrame, "メールを送信できませんでした。", "失敗", JOptionPane.ERROR_MESSAGE);
				}
        	}
        });

        /*
		 * ボタンパネル
		 */
		JPanel bottomPanel = new JPanel();
        bottomPanel.add(saveButton);
        bottomPanel.add(cancelButton);
        bottomPanel.add(testButton);
        getContentPane().add(bottomPanel, BorderLayout.SOUTH);
    }

	/**
	 * 枠で囲まれたパネル
	 * @param title
	 * @param compo
	 * @return
	 */
	private JPanel makePanel(String title, JComponent compo) {
        JPanel p = new JPanel(new GridLayout(1,1));
        p.setBorder(BorderFactory.createTitledBorder(title));
        p.add(compo);
        return p;
    }
	
	public String getPropertiesFilename() {
		return fileName;
	}

    /**
    * Shows or hides the component depending on the boolean flag b.
    * @param b  if true, show the component; otherwise, hide the component.
    * @see java.awt.Component#isVisible
    */
    public void setVisible(boolean b) {
        if (b) {
            Rectangle bounds = getParent().getBounds();
            Rectangle abounds = getBounds();
            setLocation(bounds.x + (bounds.width - abounds.width)/ 2, bounds.y + (bounds.height - abounds.height)/2);
        }
        super.setVisible(b);
    }

	public void windowClosed(WindowEvent e) {
		setVisible(false);
    }

	public void windowActivated(WindowEvent arg0) {
	}

	public void windowClosing(WindowEvent arg0) {
		setVisible(false);
	}

	public void windowDeactivated(WindowEvent arg0) {
	}

	public void windowDeiconified(WindowEvent arg0) {
	}

	public void windowIconified(WindowEvent arg0) {
	}

	public void windowOpened(WindowEvent arg0) {
	}
}
