package hayashi.yuu.tools.mail.gui;

import hayashi.yuu.tools.properties.Properties;
import hayashi.yuu.tools.properties.PropertyCheckItem;
import hayashi.yuu.tools.properties.PropertyFieldItem;
import hayashi.yuu.tools.properties.PropertyItem;
import hayashi.yuu.tools.properties.PropertyPasswordItem;
import hayashi.yuu.tools.mail.SiteData;

import java.awt.Dimension;

import javax.swing.BoxLayout;
import javax.swing.JPanel;



/**
 * セットアップフォーム：[]
 * 	・メール送信に関する設定
 * (1)アイテム: [ mail.smtp.host : SMPTサーバー ]
 * (2)アイテム: [ mail.smtp.port : SMPTサーバーのポート番号 ]
 * (3)アイテム: [ MAIL_POP : POPサーバー ]
 * (4)アイテム: [ mail.smtp.user : ユーザーID ]
 * (5)アイテム: [ MAIL_PASSWORD : パスワード ]
 * (6)アイテム: [ mail.smtp.auth : SMTP auth 認証 ]
 * (7)アイテム: [ mail.smtp.starttls.enable : STARTTLS ]
 * (8)アイテム: [ MAIL_POP_before_SMTP : POP before SMTP ]
 * (9)アイテム: [ mail.smtp.from ]
 */
@SuppressWarnings("serial")
public class SetupMailServer extends JPanel
{
    public static final int LINE_COUNT = 9;
    public static final int CATEGORY_HEIGHT = PropertyItem.LINE_HEIGHT * LINE_COUNT;
    PropertyFieldItem ismtp;		// 'mail.smtp.host' SMTPサーバー
    PropertyFieldItem ismtpPort;	// 'mail.smtp.port' SMTPサーバーのポート番号(25)
    PropertyFieldItem iPop;			// 'MAIL_POP' POPサーバー
    PropertyFieldItem iuser;		// 'mail.smtp.user'　ユーザーＩＤ
    PropertyPasswordItem ipassword;	// 'MAIL_PASSWORD'　パスワード
	PropertyCheckItem checkMailSMTPauth;	// 'mail.smtp.auth' : SMTP auth 認証
	PropertyCheckItem checkSTARTTLS;	// 'mail.smtp.starttls.enable' : STARTTLS
	PropertyCheckItem checkPOPbeforeSMTP;	// 'MAIL_POP_before_SMTP : "POP before SMTP'
    PropertyFieldItem iFrom;		// 'mail.smtp.from'　メール発信元アドレス
    
	public SetupMailServer(Properties prop) {
		super();

		/*
		 * カテゴリの配置
		 */
	    setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));

	    /*
	     * (1)アイテム: [ mail.smtp.host : SMPTサーバー ]
	     */
	    ismtp = new PropertyFieldItem(prop, "mail.smtp.host", "SMPTサーバー", true);
		add(ismtp);
		ismtp.setBounds(0, PropertyItem.LINE_HEIGHT * 0, PropertyItem.LINE_WIDTH, PropertyItem.LINE_HEIGHT);

	    /*
	     * (2)アイテム: [ mail.smtp.port : SMPTサーバーのポート番号 ]
	     */
	    ismtpPort = new PropertyFieldItem(prop, "mail.smtp.port", "ポート番号", true);
		add(ismtpPort);
		ismtpPort.setBounds(0, PropertyItem.LINE_HEIGHT * 1, PropertyItem.LINE_WIDTH, PropertyItem.LINE_HEIGHT);

		/*
		 * (3)アイテム: [ MAIL_POP : POPサーバー ]
		 */
		iPop = new PropertyFieldItem(prop, "MAIL_POP", "POPサーバー", true);
		add(iPop);
		iPop.setBounds(0, PropertyItem.LINE_HEIGHT * 2, PropertyItem.LINE_WIDTH, PropertyItem.LINE_HEIGHT);

		/*
		 * (4)アイテム: [ mail.smtp.user : ユーザーID ]
		 */
		iuser = new PropertyFieldItem(prop, "mail.smtp.user", "ユーザーID", true);
		add(iuser);
		iuser.setBounds(0, PropertyItem.LINE_HEIGHT * 3, PropertyItem.LINE_WIDTH, PropertyItem.LINE_HEIGHT);

		/*
		 * (5)アイテム: [ MAIL_PASSWORD : パスワード ]
		 */
		ipassword = new PropertyPasswordItem(prop, "MAIL_PASSWORD", "パスワード", true);
		add(ipassword);
		ipassword.setBounds(0, PropertyItem.LINE_HEIGHT * 4, PropertyItem.LINE_WIDTH, PropertyItem.LINE_HEIGHT);
		
		/*
		 * (6)アイテム: [ mail.smtp.auth : SMTP auth 認証 ]
		 */
		checkMailSMTPauth = new PropertyCheckItem(prop, "mail.smtp.auth", "SMTP auth 認証", false, true);
		add(checkMailSMTPauth);
		checkMailSMTPauth.setBounds(PropertyItem.ITEM_WIDTH_1, PropertyItem.LINE_HEIGHT * 5, PropertyItem.ITEM_WIDTH_2, PropertyItem.LINE_HEIGHT);

		/*
		 * (7)アイテム: [ mail.smtp.starttls.enable : STARTTLS ]
		 */
		checkSTARTTLS = new PropertyCheckItem(prop, "mail.smtp.starttls.enable", "STARTTLS", false, true);
		add(checkSTARTTLS);
		checkSTARTTLS.setBounds(PropertyItem.ITEM_WIDTH_1, PropertyItem.LINE_HEIGHT * 6, PropertyItem.ITEM_WIDTH_2, PropertyItem.LINE_HEIGHT);

		/*
		 * (8)アイテム: [ MAIL_POP_before_SMTP : POP before SMTP ]
		 */
		checkPOPbeforeSMTP = new PropertyCheckItem(prop, "MAIL_POP_before_SMTP", "POP before SMTP", false, true);
		add(checkPOPbeforeSMTP);
		checkPOPbeforeSMTP.setBounds(PropertyItem.ITEM_WIDTH_1, PropertyItem.LINE_HEIGHT * 7, PropertyItem.ITEM_WIDTH_2, PropertyItem.LINE_HEIGHT);
		
		/*
		 * (9)アイテム: [ mail.smtp.from ]
		 */
		iFrom = new PropertyFieldItem(prop, "mail.smtp.from", "発信元アドレス", true);
		add(iFrom);
		iFrom.setBounds(0, PropertyItem.LINE_HEIGHT * 8, PropertyItem.LINE_WIDTH, PropertyItem.LINE_HEIGHT);
		
		setPreferredSize(new Dimension(PropertyItem.LINE_WIDTH, CATEGORY_HEIGHT));
	}
	
	public SiteData getSiteData() {
		SiteData data = new SiteData("");

		/*
	     * (1)アイテム: [ MAIL_SMTP : SMPTサーバー ]
	     */
		data.MAIL_SMTP = ismtp.getValue();
		
	    /*
	     * (2)アイテム: [ MAIL_SMTP_PORT : SMPTサーバーのポート番号 ]
	     */
	    data.MAIL_SMTP_PORT = ismtpPort.getValue();

		/*
		 * (3)アイテム: [ MAIL_POP : POPサーバー ]
		 */
		data.MAIL_POP = iPop.getValue();
		
		/*
		 * (4)アイテム: [ MAIL_USER_ID : ユーザーID ]
		 */
		data.USER_ID = iuser.getValue();

		/*
		 * (5)アイテム: [ MAIL_PASSWORD : パスワード ]
		 */
		data.PASSWORD = ipassword.getValue();
		
		/*
		 * (6)アイテム: [ mail.smtp.auth : SMTP auth 認証 ]
		 */
		data.USER_AUTH = checkMailSMTPauth.isSelected();

		/*
		 * (7)アイテム: [ mail.smtp.starttls.enable : STARTTLS ]
		 */
		data.STARTTLS = checkSTARTTLS.isSelected();

		/*
		 * (8)アイテム: [ MAIL_POP_before_SMTP : POP before SMTP ]
		 */
		data.POP_before_SMTP = checkPOPbeforeSMTP.isSelected();
		
		/*
		 * (9)アイテム: [ MAIL_FROM ]
		 */
		data.MAIL_FROM = iFrom.getValue();
		
		return data;
	}
}
