package jp.co.areaweb.tools.command;
import java.io.*;
import java.text.SimpleDateFormat;
import java.text.ParsePosition;
import java.util.Date;
import java.util.Calendar;

/**
 * 指定されたディレクトリ内にある、指定時刻以前に更新されたファイルを削除する。<br/>
 * java jp.co.areaweb.tools.command.DeleteOldFile [directory] [CCYY.MM.DD-HH:mm:ss]<br/>
 * <br/>
 * 指定されたディレクトリ内にある、現在の時刻よりday日以前に更新されたファイルを削除する。<br/>
 * jp.co.areaweb.tools.command.DeleteOldFile [directory] -day [day]<br/>
 * <br/>
 * (注意)<br/>
 * 指定されたディレクトリのサブディレクトリ内のファイルも削除対象とします。<br/>
 * ディレクトリ自身は削除されません。<br/>
 */
public class DeleteOldFile
{
    public static void main (String args[]) {
        if (args.length < 2) {
            System.out.println("jp.co.areaweb.tools.command.DeleteOldFile [directory] [CCYY.MM.DD-HH:mm:ss]");
            return;
        }
        
        if (args[1].equals("-day")) {
			if (args.length < 3) {
				System.out.println("jp.co.areaweb.tools.command.DeleteOldFile [directory] -day [day]");
				return;
			}
			
			int date = 0;
			try {
				date = Integer.parseInt(args[2]);
			}
			catch(NumberFormatException e) {
				System.out.println("jp.co.areaweb.tools.command.DeleteOldFile [directory] -day [day]");
				return;
			}
			Calendar cal = Calendar.getInstance();
			cal.add(Calendar.DATE, date*(-1));
			try {
				DeleteOldFile.listup(new File(args[0]), cal.getTime());
			}
			catch(IOException e) {
				e.printStackTrace();
				System.out.println(e.toString());
			}
        }
        else {
			try {
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd'-'hh:mm:ss");
				Date startTime = sdf.parse(args[1], new ParsePosition(0));

				DeleteOldFile.listup(new File(args[0]), startTime);
			}
			catch(Exception e) {
				e.printStackTrace();
				System.out.println(e.toString());
			}
        }
    }
    
    public static void listup(File file, Date startTime) throws IOException {
        if (file == null) {
            System.out.println("ERROR: ディレクトリが見つかりませんでした。");
            return;
        }
        
        if (file.isDirectory()) {
            File files[] = file.listFiles();
            if (files != null) {
                for (int i=0; i < files.length; i++) {
                    listup(files[i], startTime);    // 再帰呼び出し
                }
            }
        }
        else {
            if ((new Date(file.lastModified())).before(startTime)) {
                System.out.print(file.getAbsolutePath());
                if (file.delete()) {
					System.out.println(" ... [DELETE]");
                }
                else {
					System.out.println(" ... [ERROR!]");
                }
            }
        }
        return;
    }
}
