package jp.co.areaweb.tools.command;
import java.io.*;

/**
 * 実際にはメールへの送信を行わずに、指定された情報をファイルに吐き出す。
 * 「/usr/sbin/sendmail」の代替コマンド
 * @author hayashi
 */
public class JSendmail
{
    /** 
     *	サンプル
     *	exp: java jp.co.areaweb.tools.command.JSendmail [parameter]
     */
    static public void main(String[] args) throws Exception {
        String commandLine = "";
        for (int i=0; i < args.length; i++) {
            if (i != 0) {
                commandLine += " ";
            }
            commandLine += args[i];
        }

        // 標準入力ストリームを取得
        BufferedReader stdReader = new BufferedReader(new InputStreamReader(System.in));

        // 出力ファイルの準備
        File out = new File("mail.txt");
        FileOutputStream fo=new FileOutputStream(out);
        PrintStream ps = new PrintStream(fo);

        /**
         * 標準入力の内容を、出力ファイルに書き出す。
         */
        ps.println(commandLine);
        ps.println();
        ps.println(convBufferedReader(stdReader));
        
        ps.close();
        fo.close();
    }


    private static String convBufferedReader(BufferedReader reader) throws IOException {
        if (reader == null) {
            return "";
        }
        StringBuffer strbuf = new StringBuffer();
        for (String line; (line = reader.readLine()) != null; strbuf.append(line +"\n"));
        reader.close();
        reader = null;
        return strbuf.toString();
    }
}
