package hayashi.yuu.tools.mail.gui;

import hayashi.yuu.tools.logger.LoggerFactory;
import hayashi.yuu.tools.mail.SendMail;
import hayashi.yuu.tools.mail.SiteData;
import hayashi.yuu.tools.properties.Encrypt;

import java.awt.*;
import java.awt.event.*;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Logger;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.WindowConstants;


@SuppressWarnings("serial")
public class SendMailGUI extends JFrame implements ActionListener
{
    public static SendMailGUI mainFrame;
    boolean fComponentsAdjusted;
    JPanel headPanel;
    JMenuBar mainMenuBar;	// [メニュー]
    JMenu menuFile;			// [メニュー]->[ファイル(F)]
    JMenuItem miSetting;	// [メニュー]->[ファイル(F)]->[設定...]
    JMenuItem miExit;		// [メニュー]->[ファイル(F)]->[終了(X)]
    
    public Logger logger;
    public static SiteData mailProp;
    public static String propertiesFileName;
    
    /**
     * 「メール送信(SendMail)」
     * 起動オプション：
     * 　第一：　メールアカウントの設定ファイル名
     */
    public static void main(String args[]) throws Exception {
		String fileName = "sendmail.properties";
    	if (args.length > 0) {
    		fileName = args[0];
    	}
        (new SendMailGUI(fileName)).setVisible(true);
    }
    
    public SendMailGUI(String propertiesName) throws Exception {
    	Encrypt.PASSWORD_KEY = "hayashihimitukagi";
        logger = LoggerFactory.getInstance();	// Loggerオブジェクトの生成
    	SendMailGUI.propertiesFileName = propertiesName;
        SendMailGUI.mailProp = new SiteData(SendMailGUI.propertiesFileName);

        // ログ出力
        logger.info("SendMailGUI - プログラム起動");
        
        // 初期設定
        fComponentsAdjusted = false;
        setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
        Container container = getContentPane();
        container.setLayout(new BorderLayout());
        setTitle("SendMail GUI");
        
        mainFrame = this;
        
        // [メニュー]->[ファイル(F)]
        menuFile = new JMenu("ファイル(F)");
        menuFile.setMnemonic('F');
        menuFile.setFont(new Font("Dialog", 0, 12));
        
        // [メニュー]->[ファイル(F)]->[設定...]
        miSetting = new JMenuItem("設定...");
        miSetting.addActionListener(this);
        miSetting.setFont(new Font("Dialog", 0, 12));
        menuFile.add(miSetting);
        
        // [メニュー]->[ファイル(F)]->[------------]
        menuFile.addSeparator();

        // [メニュー]->[ファイル(F)]->[終了(X)]
        miExit = new JMenuItem("終了(X)");
        miExit.addActionListener(this);
        miExit.setMnemonic('X');
        miExit.setFont(new Font("Dialog", 0, 12));
        menuFile.add(miExit);
        
        // [メニュー]
        mainMenuBar = new JMenuBar();
        mainMenuBar.add(menuFile);
        getRootPane().setJMenuBar(mainMenuBar);

        // 上部にヘッダパネル
        headPanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
        getContentPane().add(BorderLayout.NORTH, headPanel);
        JLabel label1 = new JLabel("SendMail GUI - サンプルプログラム", JLabel.CENTER);
        label1.setBounds(10,10,340,20);
        
        // 中央に、メインパネルを配置
        JPanel mainPanel = new JPanel(new FlowLayout());
        //mainPanel.setPreferredSize(new Dimension(500, 400));
        getContentPane().add(mainPanel, BorderLayout.CENTER);
        
        JTextArea textArea = new JTextArea(20, 60);
        textArea.setEditable(false);
        textArea.setFont(new Font(Font.MONOSPACED, Font.PLAIN, 12));
		textArea.append("メール送信設定　サンプルプログラム\n");
		textArea.setCaretPosition(0);
		JScrollPane scrollPane = new JScrollPane(textArea);
		scrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		mainPanel.add(scrollPane, BorderLayout.CENTER);
        
        // 下部にコピーライトを配置
        JPanel southPanel = new JPanel(new FlowLayout());
        getContentPane().add(BorderLayout.SOUTH, southPanel);
        
        JLabel label2 = new JLabel("All rights reserved.Copyright(c) 2010,, Hayashi,Yuu.", JLabel.CENTER);
        label2.setBounds(10,40,340,20);
        southPanel.add(label2);
        
		pack();
		setLocationRelativeTo(null);
		setVisible(true);
    }
    
    public SendMail getMailInstance() {
		return new SendMail(SendMailGUI.mailProp);
    }
    
    public static String getPropertiesFileName() {
    	return propertiesFileName;
    }

	public void addNotify() {
        Dimension d = getSize();
        super.addNotify();
        if (fComponentsAdjusted) {
            return;
        }
        setSize(getInsets().left + getInsets().right + d.width, getInsets().top + getInsets().bottom + d.height);
        Component components[] = getComponents();
        for (int i = 0; i < components.length; i++) {
            Point p = components[i].getLocation();
            p.translate(getInsets().left, getInsets().top);
            components[i].setLocation(p);
        }

        fComponentsAdjusted = true;
    }

	/**
	 * [メニュー]アクション： 
	 * @param event
	 */
	public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if(object == miExit) {
            miExit_Action(event);
        }
        else if (object == miSetting) {
            miSetting_Action(event);
        }
    }
	
    /**
     * アクション：
     * [メニュー]->[ファイル]->[終了]
     * 
     * @param event
     */
    void miExit_Action(ActionEvent event) {
    	setVisible(false);
        logger.info("SendMailGUI - プログラム終了");
        System.exit(0);
    }

    /**
     * アクション：
     * [メニュー]->[ファイル]->[設定...]
     * 
     * @param event
     */
    void miSetting_Action(ActionEvent event) {
        try {
			(new SettingDialog(this, true, SendMailGUI.getPropertiesFileName(), logger)).setVisible(true);
		}
        catch (FileNotFoundException e) {
			// 回復不能な重大なエラー
			e.printStackTrace();
		}
        catch (IOException e) {
			// 回復不能な重大なエラー
			e.printStackTrace();
		}
    }
}
