/*!
 * @file mspells3.c
 * @brief ˡν / Blue magic
 * @date 2014/01/15
 * @author
 * Copyright (c) 1997 Ben Harrison, James E. Wilson, Robert A. Koeneke\n
 * This software may be copied and distributed for educational, research,\n
 * and not for profit purposes provided that this copyright and statement\n
 * are included in all such copies.  Other copyrights may also apply.\n
 * 2014 Deskull rearranged comment for Doxygen.\n
 */

#include "angband.h"

#define pseudo_plev() (((p_ptr->lev + 40) * (p_ptr->lev + 40) - 1550) / 130) /*!< 󥹥ˡץ쥤䡼Ѥδ٥ */

/*!
 * @brief ä󥹥ˡID˱ˡθ̾ޤȤ᤿եޥåȤ֤
 * @param p ֤ʸ󻲾ȥݥ
 * @param power 󥹥ˡID
 * @return ʤ
 */
static void learned_info(char *p, int power)
{
	int plev = pseudo_plev();
	int hp = p_ptr->chp;

#ifdef JP
	cptr s_dam = "»:";
	cptr s_dur = ":";
	cptr s_range = "ϰ:";
	cptr s_heal = ":";
#else
	cptr s_dam = "dam ";
	cptr s_dur = "dur ";
	cptr s_range = "range ";
	cptr s_heal = "heal ";
#endif

	strcpy(p, "");

	switch (power)
	{
		case MS_SHRIEK:
		case MS_XXX1:
		case MS_XXX2:
		case MS_XXX3:
		case MS_XXX4:
		case MS_SCARE:
		case MS_BLIND:
		case MS_CONF:
		case MS_SLOW:
		case MS_SLEEP:
		case MS_HAND_DOOM:
		case MS_WORLD:
		case MS_SPECIAL:
		case MS_TELE_TO:
		case MS_TELE_AWAY:
		case MS_TELE_LEVEL:
		case MS_DARKNESS:
		case MS_MAKE_TRAP:
		case MS_FORGET:
		case MS_S_KIN:
		case MS_S_CYBER:
		case MS_S_MONSTER:
		case MS_S_MONSTERS:
		case MS_S_ANT:
		case MS_S_SPIDER:
		case MS_S_HOUND:
		case MS_S_HYDRA:
		case MS_S_ANGEL:
		case MS_S_DEMON:
		case MS_S_UNDEAD:
		case MS_S_DRAGON:
		case MS_S_HI_UNDEAD:
		case MS_S_HI_DRAGON:
		case MS_S_AMBERITE:
		case MS_S_UNIQUE:
			break;
		case MS_BALL_MANA:
		case MS_BALL_DARK:
		case MS_STARBURST:
			sprintf(p, " %s%d+10d10", s_dam, plev * 8 + 50);
			break;
		case MS_DISPEL:
			break;
		case MS_ROCKET:
			sprintf(p, " %s%d", s_dam, hp/4);
			break;
		case MS_SHOOT:
		{
			object_type *o_ptr = NULL;
			if (buki_motteruka(INVEN_RARM)) o_ptr = &inventory[INVEN_RARM];
			else if (buki_motteruka(INVEN_LARM)) o_ptr = &inventory[INVEN_LARM];
			else
				sprintf(p, " %s1", s_dam);
			if (o_ptr)
				sprintf(p, " %s%dd%d+%d", s_dam, o_ptr->dd, o_ptr->ds, o_ptr->to_d);
			break;
		}
		case MS_BR_ACID:
		case MS_BR_ELEC:
		case MS_BR_FIRE:
		case MS_BR_COLD:
		case MS_BR_POIS:
		case MS_BR_NUKE:
			sprintf(p, " %s%d", s_dam, hp/3);
			break;
		case MS_BR_NEXUS:
			sprintf(p, " %s%d", s_dam, MIN(hp/3, 250));
			break;
		case MS_BR_TIME:
			sprintf(p, " %s%d", s_dam, MIN(hp/3, 150));
			break;
		case MS_BR_GRAVITY:
			sprintf(p, " %s%d", s_dam, MIN(hp/3, 200));
			break;
		case MS_BR_MANA:
			sprintf(p, " %s%d", s_dam, MIN(hp/3, 250));
			break;
		case MS_BR_NETHER:
		case MS_BR_LITE:
		case MS_BR_DARK:
		case MS_BR_CONF:
		case MS_BR_SOUND:
		case MS_BR_CHAOS:
		case MS_BR_DISEN:
		case MS_BR_SHARDS:
		case MS_BR_PLASMA:
			sprintf(p, " %s%d", s_dam, hp/6);
			break;
		case MS_BR_INERTIA:
		case MS_BR_FORCE:
			sprintf(p, " %s%d", s_dam, MIN(hp/6, 200));
			break;
		case MS_BR_DISI:
			sprintf(p, " %s%d", s_dam, MIN(hp/6, 150));
			break;
		case MS_BALL_NUKE:
			sprintf(p, " %s%d+10d6", s_dam, plev * 2);
			break;
		case MS_BALL_CHAOS:
			sprintf(p, " %s%d+10d10", s_dam, plev * 4);
			break;
		case MS_BALL_ACID:
			sprintf(p, " %s15+d%d", s_dam, plev * 6);
			break;
		case MS_BALL_ELEC:
			sprintf(p, " %s8+d%d", s_dam, plev * 3);
			break;
		case MS_BALL_FIRE:
			sprintf(p, " %s10+d%d", s_dam, plev * 7);
			break;
		case MS_BALL_COLD:
			sprintf(p, " %s10+d%d", s_dam, plev * 3);
			break;
		case MS_BALL_POIS:
			sprintf(p, " %s12d2", s_dam);
			break;
		case MS_BALL_NETHER:
			sprintf(p, " %s%d+10d10", s_dam, plev * 2 + 50);
			break;
		case MS_BALL_WATER:
			sprintf(p, " %s50+d%d", s_dam, plev * 4);
			break;
		case MS_DRAIN_MANA:
			sprintf(p, " %sd%d+%d", s_heal, plev, plev);
			break;
		case MS_MIND_BLAST:
			sprintf(p, " %s8d8", s_dam);
			break;
		case MS_BRAIN_SMASH:
			sprintf(p, " %s12d15", s_dam);
			break;
		case MS_CAUSE_1:
			sprintf(p, " %s3d8", s_dam);
			break;
		case MS_CAUSE_2:
			sprintf(p, " %s8d8", s_dam);
			break;
		case MS_CAUSE_3:
			sprintf(p, " %s10d15", s_dam);
			break;
		case MS_CAUSE_4:
			sprintf(p, " %s15d15", s_dam);
			break;
		case MS_BOLT_ACID:
			sprintf(p, " %s%d+7d8", s_dam, plev * 2 / 3);
			break;
		case MS_BOLT_ELEC:
			sprintf(p, " %s%d+4d8", s_dam, plev * 2 / 3);
			break;
		case MS_BOLT_FIRE:
			sprintf(p, " %s%d+9d8", s_dam, plev * 2 / 3);
			break;
		case MS_BOLT_COLD:
			sprintf(p, " %s%d+6d8", s_dam, plev * 2 / 3);
			break;
		case MS_BOLT_NETHER:
			sprintf(p, " %s%d+5d5", s_dam, 30 + plev * 8 / 3);
			break;
		case MS_BOLT_WATER:
			sprintf(p, " %s%d+10d10", s_dam, plev * 2);
			break;
		case MS_BOLT_MANA:
			sprintf(p, " %s50+d%d", s_dam, plev * 7);
			break;
		case MS_BOLT_PLASMA:
			sprintf(p, " %s%d+8d7", s_dam, plev * 2 + 10);
			break;
		case MS_BOLT_ICE:
			sprintf(p, " %s%d+6d6", s_dam, plev * 2);
			break;
		case MS_MAGIC_MISSILE:
			sprintf(p, " %s%d+2d6", s_dam, plev * 2 / 3);
			break;
		case MS_SPEED:
			sprintf(p, " %sd%d+%d", s_dur, 20+plev, plev);
			break;
		case MS_HEAL:
			sprintf(p, " %s%d", s_heal, plev*4);
			break;
		case MS_INVULNER:
			sprintf(p, " %sd7+7", s_dur);
			break;
		case MS_BLINK:
			sprintf(p, " %s10", s_range);
			break;
		case MS_TELEPORT:
			sprintf(p, " %s%d", s_range, plev * 5);
			break;
		case MS_PSY_SPEAR:
			sprintf(p, " %s100+d%d", s_dam, plev * 3);
			break;
		case MS_RAISE_DEAD:
			sprintf(p, " %s5", s_range);
			break;
		default:
			break;
	}
}


/*!
 * @brief Ѳǽˡ򤹤 /
 * Allow user to choose a imitation.
 * @param sn 򤷤󥹥ID󥻥ξ-1ξ-2֤
 * @return ȯưǽˡ򤷤TRUE󥻥򤬹Ԥ줿FALSE֤
 * @details
 * If a valid spell is chosen, saves it in '*sn' and returns TRUE\n
 * If the user hits escape, returns FALSE, and set '*sn' to -1\n
 * If there are no legal choices, returns FALSE, and sets '*sn' to -2\n
 *\n
 * The "prompt" should be "cast", "recite", or "study"\n
 * The "known" should be TRUE for cast/pray, FALSE for study\n
 *\n
 * nb: This function has a (trivial) display bug which will be obvious\n
 * when you run it. It's probably easy to fix but I haven't tried,\n
 * sorry.\n
 */
static int get_learned_power(int *sn)
{
	int             i = 0;
	int             num = 0;
	int             y = 1;
	int             x = 18;
	int             minfail = 0;
	int             plev = p_ptr->lev;
	int             chance = 0;
	int             ask = TRUE, mode = 0;
	int             spellnum[MAX_MONSPELLS];
	char            ch;
	char            choice;
	char            out_val[160];
	char            comment[80];
	s32b            f4 = 0, f5 = 0, f6 = 0;
#ifdef JP
cptr            p = "ˡ";
#else
	cptr            p = "magic";
#endif

	monster_power   spell;
	bool            flag, redraw;
	int menu_line = (use_menu ? 1 : 0);

	/* Assume cancelled */
	*sn = (-1);

	/* Nothing chosen yet */
	flag = FALSE;

	/* No redraw yet */
	redraw = FALSE;

#ifdef ALLOW_REPEAT /* TNB */

	/* Get the spell, if available */
	if (repeat_pull(sn))
	{
		/* Success */
		return (TRUE);
	}

#endif /* ALLOW_REPEAT -- TNB */

	if (use_menu)
	{
		screen_save();

		while(!mode)
		{
#ifdef JP
			prt(format(" %s ܥ", (menu_line == 1) ? "" : "  "), 2, 14);
			prt(format(" %s ܡ", (menu_line == 2) ? "" : "  "), 3, 14);
			prt(format(" %s ֥쥹", (menu_line == 3) ? "" : "  "), 4, 14);
			prt(format(" %s ", (menu_line == 4) ? "" : "  "), 5, 14);
			prt(format(" %s ¾", (menu_line == 5) ? "" : "  "), 6, 14);
			prt("ɤμˡȤޤ", 0, 0);
#else
			prt(format(" %s bolt", (menu_line == 1) ? "> " : "  "), 2, 14);
			prt(format(" %s ball", (menu_line == 2) ? "> " : "  "), 3, 14);
			prt(format(" %s breath", (menu_line == 3) ? "> " : "  "), 4, 14);
			prt(format(" %s sommoning", (menu_line == 4) ? "> " : "  "), 5, 14);
			prt(format(" %s others", (menu_line == 5) ? "> " : "  "), 6, 14);
			prt("use which type of magic? ", 0, 0);
#endif
			choice = inkey();
			switch(choice)
			{
			case ESCAPE:
			case 'z':
			case 'Z':
				screen_load();
				return FALSE;
			case '2':
			case 'j':
			case 'J':
				menu_line++;
				break;
			case '8':
			case 'k':
			case 'K':
				menu_line+= 4;
				break;
			case '\r':
			case 'x':
			case 'X':
				mode = menu_line;
				break;
			}
			if (menu_line > 5) menu_line -= 5;
		}
		screen_load();
	}
	else
	{
#ifdef JP
	sprintf(comment, "[A]ܥ, [B]ܡ, [C]֥쥹, [D], [E]¾:");
#else
	sprintf(comment, "[A] bolt, [B] ball, [C] breath, [D] summoning, [E] others:");
#endif
	while (TRUE)
	{
		if (!get_com(comment, &ch, TRUE))
		{
			return FALSE;
		}
		if (ch == 'A' || ch == 'a')
		{
			mode = 1;
			break;
		}
		if (ch == 'B' || ch == 'b')
		{
			mode = 2;
			break;
		}
		if (ch == 'C' || ch == 'c')
		{
			mode = 3;
			break;
		}
		if (ch == 'D' || ch == 'd')
		{
			mode = 4;
			break;
		}
		if (ch == 'E' || ch == 'e')
		{
			mode = 5;
			break;
		}
	}
	}

	set_rf_masks(&f4, &f5, &f6, mode);

	for (i = 0, num = 0; i < 32; i++)
	{
		if ((0x00000001 << i) & f4) spellnum[num++] = i;
	}
	for (; i < 64; i++)
	{
		if ((0x00000001 << (i - 32)) & f5) spellnum[num++] = i;
	}
	for (; i < 96; i++)
	{
		if ((0x00000001 << (i - 64)) & f6) spellnum[num++] = i;
	}
	for (i = 0; i < num; i++)
	{
		if (p_ptr->magic_num2[spellnum[i]])
		{
			if (use_menu) menu_line = i+1;
			break;
		}
	}
	if (i == num)
	{
#ifdef JP
		msg_print("μˡϳФƤʤ");
#else
		msg_print("You don't know any spell of this type.");
#endif
		return (FALSE);
	}

	/* Build a prompt (accept all spells) */
	(void)strnfmt(out_val, 78, 
#ifdef JP
		      "(%c-%c, '*'ǰ, ESC) ɤ%s򾧤ޤ",
#else
		      "(%c-%c, *=List, ESC=exit) Use which %s? ",
#endif
		      I2A(0), I2A(num - 1), p);

	if (use_menu) screen_save();

	/* Get a spell from the user */

	choice= (always_show_list || use_menu) ? ESCAPE:1 ;
	while (!flag)
	{
		if(choice==ESCAPE) choice = ' '; 
		else if( !get_com(out_val, &choice, TRUE) )break; 

		if (use_menu && choice != ' ')
		{
			switch(choice)
			{
				case '0':
				{
					screen_load();
					return (FALSE);
				}

				case '8':
				case 'k':
				case 'K':
				{
					do
					{
						menu_line += (num-1);
						if (menu_line > num) menu_line -= num;
					} while(!p_ptr->magic_num2[spellnum[menu_line-1]]);
					break;
				}

				case '2':
				case 'j':
				case 'J':
				{
					do
					{
						menu_line++;
						if (menu_line > num) menu_line -= num;
					} while(!p_ptr->magic_num2[spellnum[menu_line-1]]);
					break;
				}

				case '6':
				case 'l':
				case 'L':
				{
					menu_line=num;
					while(!p_ptr->magic_num2[spellnum[menu_line-1]]) menu_line--;
					break;
				}

				case '4':
				case 'h':
				case 'H':
				{
					menu_line=1;
					while(!p_ptr->magic_num2[spellnum[menu_line-1]]) menu_line++;
					break;
				}

				case 'x':
				case 'X':
				case '\r':
				{
					i = menu_line - 1;
					ask = FALSE;
					break;
				}
			}
		}
		/* Request redraw */
		if ((choice == ' ') || (choice == '*') || (choice == '?') || (use_menu && ask))
		{
			/* Show the list */
			if (!redraw || use_menu)
			{
				char psi_desc[80];

				/* Show list */
				redraw = TRUE;

				/* Save the screen */
				if (!use_menu) screen_save();

				/* Display a list of spells */
				prt("", y, x);
#ifdef JP
put_str("̾", y, x + 5);
#else
				put_str("Name", y, x + 5);
#endif

#ifdef JP
put_str("MP Ψ ", y, x + 33);
#else
				put_str("SP Fail Info", y, x + 32);
#endif


				/* Dump the spells */
				for (i = 0; i < num; i++)
				{
					int need_mana;

					prt("", y + i + 1, x);
					if (!p_ptr->magic_num2[spellnum[i]]) continue;

					/* Access the spell */
					spell = monster_powers[spellnum[i]];

					chance = spell.fail;

					/* Reduce failure rate by "effective" level adjustment */
					if (plev > spell.level) chance -= 3 * (plev - spell.level);
					else chance += (spell.level - plev);

					/* Reduce failure rate by INT/WIS adjustment */
					chance -= 3 * (adj_mag_stat[p_ptr->stat_ind[A_INT]] - 1);

					chance = mod_spell_chance_1(chance);

					need_mana = mod_need_mana(monster_powers[spellnum[i]].smana, 0, REALM_NONE);

					/* Not enough mana to cast */
					if (need_mana > p_ptr->csp)
					{
						chance += 5 * (need_mana - p_ptr->csp);
					}

					/* Extract the minimum failure rate */
					minfail = adj_mag_fail[p_ptr->stat_ind[A_INT]];

					/* Minimum failure rate */
					if (chance < minfail) chance = minfail;

					/* Stunning makes spells harder */
					if (p_ptr->stun > 50) chance += 25;
					else if (p_ptr->stun) chance += 15;

					/* Always a 5 percent chance of working */
					if (chance > 95) chance = 95;

					chance = mod_spell_chance_2(chance);

					/* Get info */
					learned_info(comment, spellnum[i]);

					if (use_menu)
					{
#ifdef JP
						if (i == (menu_line-1)) strcpy(psi_desc, "  ");
#else
						if (i == (menu_line-1)) strcpy(psi_desc, "  > ");
#endif
						else strcpy(psi_desc, "    ");
					}
					else sprintf(psi_desc, "  %c)", I2A(i));

					/* Dump the spell --(-- */
					strcat(psi_desc, format(" %-26s %3d %3d%%%s",
						spell.name, need_mana,
						chance, comment));
					prt(psi_desc, y + i + 1, x);
				}

				/* Clear the bottom line */
				if (y < 22) prt("", y + i + 1, x);
			}

			/* Hide the list */
			else
			{
				/* Hide list */
				redraw = FALSE;

				/* Restore the screen */
				screen_load();
			}

			/* Redo asking */
			continue;
		}

		if (!use_menu)
		{
			/* Note verify */
			ask = isupper(choice);

			/* Lowercase */
			if (ask) choice = tolower(choice);

			/* Extract request */
			i = (islower(choice) ? A2I(choice) : -1);
		}

		/* Totally Illegal */
		if ((i < 0) || (i >= num) || !p_ptr->magic_num2[spellnum[i]])
		{
			bell();
			continue;
		}

		/* Save the spell index */
		spell = monster_powers[spellnum[i]];

		/* Verify it */
		if (ask)
		{
			char tmp_val[160];

			/* Prompt */
#ifdef JP
			(void) strnfmt(tmp_val, 78, "%sˡ򾧤ޤ", monster_powers[spellnum[i]].name);
#else
			(void)strnfmt(tmp_val, 78, "Use %s? ", monster_powers[spellnum[i]].name);
#endif


			/* Belay that order */
			if (!get_check(tmp_val)) continue;
		}

		/* Stop the loop */
		flag = TRUE;
	}

	/* Restore the screen */
	if (redraw) screen_load();

	/* Show choices */
	p_ptr->window |= (PW_SPELL);

	/* Window stuff */
	window_stuff();

	/* Abort if needed */
	if (!flag) return (FALSE);

	/* Save the choice */
	(*sn) = spellnum[i];

#ifdef ALLOW_REPEAT /* TNB */

	repeat_push(*sn);

#endif /* ALLOW_REPEAT -- TNB */

	/* Success */
	return (TRUE);
}


/*!
 * @brief ˡȯư /
 * do_cmd_cast calls this function if the player's class is 'blue-mage'.
 * @param spell ȯư󥹥ID
 * @param success TRUEFALSEϼԻνԤ
 * @return ¹ԤTRUE󥻥뤷FALSE֤
 */
static bool cast_learned_spell(int spell, bool success)
{
	int             dir;
	int             plev = pseudo_plev();
	int     summon_lev = p_ptr->lev * 2 / 3 + randint1(p_ptr->lev/2);
	int             hp = p_ptr->chp;
	int             damage = 0;
	bool   pet = success;
	bool   no_trump = FALSE;
	u32b p_mode, u_mode = 0L, g_mode;

	if (pet)
	{
		p_mode = PM_FORCE_PET;
		g_mode = 0;
	}
	else
	{
		p_mode = PM_NO_PET;
		g_mode = PM_ALLOW_GROUP;
	}

	if (!success || (randint1(50+plev) < plev/10)) u_mode = PM_ALLOW_UNIQUE;

	/* spell code */
	switch (spell)
	{
	case MS_SHRIEK:
        msg_print(_("⤤ڤ򤢤", "You make a high pitched shriek."));
		aggravate_monsters(0);
		break;
	case MS_XXX1:
		break;
	case MS_DISPEL:
	{
		int m_idx;

		if (!target_set(TARGET_KILL)) return FALSE;
		m_idx = cave[target_row][target_col].m_idx;
		if (!m_idx) break;
		if (!player_has_los_bold(target_row, target_col)) break;
		if (!projectable(py, px, target_row, target_col)) break;
		dispel_monster_status(m_idx);
		break;
	}
	case MS_ROCKET:
		if (!get_aim_dir(&dir)) return FALSE;
		
        msg_print(_("åȤȯͤ", "You fire a rocket."));
        damage = monspell_bluemage_damage(monspell_num(RF4_SPELL_START, RF4_ROCKET), plev, DAM_ROLL);
		fire_rocket(GF_ROCKET, dir, damage, 2);
		break;
	case MS_SHOOT:
	{
		object_type *o_ptr = NULL;

		if (!get_aim_dir(&dir)) return FALSE;
		
        msg_print(_("ä", "You fire an arrow."));
        damage = monspell_bluemage_damage(monspell_num(RF4_SPELL_START, RF4_SHOOT), plev, DAM_ROLL);
		fire_bolt(GF_ARROW, dir, damage);
		break;
	}
	case MS_XXX2:
		break;
	case MS_XXX3:
		break;
	case MS_XXX4:
		break;
	case MS_BR_ACID:
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("Υ֥쥹Ǥ", "You breathe acid."));
        damage = monspell_bluemage_damage(monspell_num(RF4_SPELL_START, RF4_BR_ACID), plev, DAM_ROLL);
		fire_ball(GF_ACID, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_ELEC:
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("ʤΥ֥쥹Ǥ", "You breathe lightning."));
        damage = monspell_bluemage_damage(monspell_num(RF4_SPELL_START, RF4_BR_ELEC), plev, DAM_ROLL);
		fire_ball(GF_ELEC, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_FIRE:
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("бΥ֥쥹Ǥ", "You breathe fire."));
        damage = monspell_bluemage_damage(monspell_num(RF4_SPELL_START, RF4_BR_FIRE), plev, DAM_ROLL);
		fire_ball(GF_FIRE, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_COLD:
        if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("䵤Υ֥쥹Ǥ", "You breathe frost."));
        damage = monspell_bluemage_damage(monspell_num(RF4_SPELL_START, RF4_BR_COLD), plev, DAM_ROLL);
		fire_ball(GF_COLD, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_POIS:
        if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("Υ֥쥹Ǥ", "You breathe gas."));
        damage = monspell_bluemage_damage(monspell_num(RF4_SPELL_START, RF4_BR_POIS), plev, DAM_ROLL);
		fire_ball(GF_POIS, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_NETHER:
        if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("ϹΥ֥쥹Ǥ", "You breathe nether."));
        damage = monspell_bluemage_damage(monspell_num(RF4_SPELL_START, RF4_BR_NETH), plev, DAM_ROLL);
		fire_ball(GF_NETHER, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_LITE:
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("Υ֥쥹Ǥ", "You breathe light."));
        damage = monspell_bluemage_damage(monspell_num(RF4_SPELL_START, RF4_BR_LITE), plev, DAM_ROLL);
		fire_ball(GF_LITE, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_DARK:
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("ŹΥ֥쥹Ǥ", "You breathe darkness."));
        damage = monspell_bluemage_damage(monspell_num(RF4_SPELL_START, RF4_BR_DARK), plev, DAM_ROLL);
		fire_ball(GF_DARK, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_CONF:
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("Υ֥쥹Ǥ", "You breathe confusion."));
        damage = monspell_bluemage_damage(monspell_num(RF4_SPELL_START, RF4_BR_CONF), plev, DAM_ROLL);
		fire_ball(GF_CONFUSION, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_SOUND:
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("첻Υ֥쥹Ǥ", "You breathe sound."));
        damage = monspell_bluemage_damage(monspell_num(RF4_SPELL_START, RF4_BR_SOUN), plev, DAM_ROLL);
		fire_ball(GF_SOUND, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_CHAOS:
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("Υ֥쥹Ǥ", "You breathe chaos."));
        damage = monspell_bluemage_damage(monspell_num(RF4_SPELL_START, RF4_BR_CHAO), plev, DAM_ROLL);
		fire_ball(GF_CHAOS, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_DISEN:
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("Υ֥쥹Ǥ", "You breathe disenchantment."));
        damage = monspell_bluemage_damage(monspell_num(RF4_SPELL_START, RF4_BR_DISE), plev, DAM_ROLL);
		fire_ball(GF_DISENCHANT, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_NEXUS:
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("̺Υ֥쥹Ǥ", "You breathe nexus."));
        damage = monspell_bluemage_damage(monspell_num(RF4_SPELL_START, RF4_BR_NEXU), plev, DAM_ROLL);
		fire_ball(GF_NEXUS, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_TIME:
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("ֵžΥ֥쥹Ǥ", "You breathe time."));
        damage = monspell_bluemage_damage(monspell_num(RF4_SPELL_START, RF4_BR_TIME), plev, DAM_ROLL);
		fire_ball(GF_TIME, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_INERTIA:
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("ߤΥ֥쥹Ǥ", "You breathe inertia."));
        damage = monspell_bluemage_damage(monspell_num(RF4_SPELL_START, RF4_BR_INER), plev, DAM_ROLL);
		fire_ball(GF_INERTIA, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_GRAVITY:
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("ϤΥ֥쥹Ǥ", "You breathe gravity."));
        damage = monspell_bluemage_damage(monspell_num(RF4_SPELL_START, RF4_BR_GRAV), plev, DAM_ROLL);
		fire_ball(GF_GRAVITY, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_SHARDS:
        if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("ҤΥ֥쥹Ǥ", "You breathe shards."));
        damage = monspell_bluemage_damage(monspell_num(RF4_SPELL_START, RF4_BR_SHAR), plev, DAM_ROLL);
		fire_ball(GF_SHARDS, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_PLASMA:
        if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("ץ饺ޤΥ֥쥹Ǥ", "You breathe plasma."));
        damage = monspell_bluemage_damage(monspell_num(RF4_SPELL_START, RF4_BR_PLAS), plev, DAM_ROLL);
		fire_ball(GF_PLASMA, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_FORCE:
        if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("եΥ֥쥹Ǥ", "You breathe force."));
        damage = monspell_bluemage_damage(monspell_num(RF4_SPELL_START, RF4_BR_WALL), plev, DAM_ROLL);
		fire_ball(GF_FORCE, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_MANA:
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("ϤΥ֥쥹Ǥ", "You breathe mana."));
        damage = monspell_bluemage_damage(monspell_num(RF4_SPELL_START, RF4_BR_MANA), plev, DAM_ROLL);
		fire_ball(GF_MANA, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BALL_NUKE:
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("ǽä", "You cast a ball of radiation."));
        damage = monspell_bluemage_damage(monspell_num(RF4_SPELL_START, RF4_BA_NUKE), plev, DAM_ROLL);
		fire_ball(GF_NUKE, dir, damage, 2);
		break;
	case MS_BR_NUKE:
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("ѴʪΥ֥쥹Ǥ", "You breathe toxic waste."));
        damage = monspell_bluemage_damage(monspell_num(RF4_SPELL_START, RF4_BR_NUKE), plev, DAM_ROLL);
		fire_ball(GF_NUKE, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BALL_CHAOS:
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("륹ä", "You invoke a raw Logrus."));
        damage = monspell_bluemage_damage(monspell_num(RF4_SPELL_START, RF4_BA_CHAO), plev, DAM_ROLL);
		fire_ball(GF_CHAOS, dir, damage, 4);
		break;
	case MS_BR_DISI:
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("ʬΥ֥쥹Ǥ", "You breathe disintegration."));
        damage = monspell_bluemage_damage(monspell_num(RF4_SPELL_START, RF4_BR_DISI), plev, DAM_ROLL);
		fire_ball(GF_DISINTEGRATE, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BALL_ACID:
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("åɡܡμʸ򾧤", "You cast an acid ball."));
        damage = monspell_bluemage_damage(monspell_num(RF5_SPELL_START, RF5_BA_ACID), plev, DAM_ROLL);
		fire_ball(GF_ACID, dir, damage, 2);
		break;
	case MS_BALL_ELEC:
        if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("ܡμʸ򾧤", "You cast a lightning ball."));
        damage = monspell_bluemage_damage(monspell_num(RF5_SPELL_START, RF5_BA_ELEC), plev, DAM_ROLL);
		fire_ball(GF_ELEC, dir, damage, 2);
		break;
	case MS_BALL_FIRE:
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("եܡμʸ򾧤", "You cast a fire ball."));
        damage = monspell_bluemage_damage(monspell_num(RF5_SPELL_START, RF5_BA_FIRE), plev, DAM_ROLL);
		fire_ball(GF_FIRE, dir, damage, 2);
		break;
	case MS_BALL_COLD:
        if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("ܡμʸ򾧤", "You cast a frost ball."));
        damage = monspell_bluemage_damage(monspell_num(RF5_SPELL_START, RF5_BA_COLD), plev, DAM_ROLL);
		fire_ball(GF_COLD, dir, damage, 2);
		break;
	case MS_BALL_POIS:
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("μʸ򾧤", "You cast a stinking cloud."));
        damage = monspell_bluemage_damage(monspell_num(RF5_SPELL_START, RF5_BA_POIS), plev, DAM_ROLL);
		fire_ball(GF_POIS, dir, damage, 2);
		break;
	case MS_BALL_NETHER:
        if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("Ϲμʸ򾧤", "You cast a nether ball."));
        damage = monspell_bluemage_damage(monspell_num(RF5_SPELL_START, RF5_BA_NETH), plev, DAM_ROLL);
		fire_ball(GF_NETHER, dir, damage, 2);
		break;
	case MS_BALL_WATER:
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("ή褦ʿȿ򤷤", "You gesture fluidly."));
        damage = monspell_bluemage_damage(monspell_num(RF5_SPELL_START, RF5_BA_WATE), plev, DAM_ROLL);
		fire_ball(GF_WATER, dir, damage, 4);
		break;
	case MS_BALL_MANA:
        if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("Ϥμʸǰ", "You invoke a mana storm."));
        damage = monspell_bluemage_damage(monspell_num(RF5_SPELL_START, RF5_BA_MANA), plev, DAM_ROLL);
		fire_ball(GF_MANA, dir, damage, 4);
		break;
	case MS_BALL_DARK:
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("Źμʸǰ", "You invoke a darkness storm."));
        damage = monspell_bluemage_damage(monspell_num(RF5_SPELL_START, RF5_BA_DARK), plev, DAM_ROLL);
		fire_ball(GF_DARK, dir, damage, 4);
		break;
	case MS_DRAIN_MANA:
		if (!get_aim_dir(&dir)) return FALSE;

        damage = monspell_bluemage_damage(monspell_num(RF5_SPELL_START, RF5_DRAIN_MANA), plev, DAM_ROLL);
        fire_ball_hide(GF_DRAIN_MANA, dir, damage, 0);
		break;
	case MS_MIND_BLAST:
		if (!get_aim_dir(&dir)) return FALSE;

        damage = monspell_bluemage_damage(monspell_num(RF5_SPELL_START, RF5_MIND_BLAST), plev, DAM_ROLL);
		fire_ball_hide(GF_MIND_BLAST, dir, damage, 0);
		break;
	case MS_BRAIN_SMASH:
        if (!get_aim_dir(&dir)) return FALSE;

        damage = monspell_bluemage_damage(monspell_num(RF5_SPELL_START, RF5_BRAIN_SMASH), plev, DAM_ROLL);
		fire_ball_hide(GF_BRAIN_SMASH, dir, damage, 0);
		break;
	case MS_CAUSE_1:
		if (!get_aim_dir(&dir)) return FALSE;

        damage = monspell_bluemage_damage(monspell_num(RF5_SPELL_START, RF5_CAUSE_1), plev, DAM_ROLL);
		fire_ball_hide(GF_CAUSE_1, dir, damage, 0);
		break;
	case MS_CAUSE_2:
		if (!get_aim_dir(&dir)) return FALSE;

        damage = monspell_bluemage_damage(monspell_num(RF5_SPELL_START, RF5_CAUSE_2), plev, DAM_ROLL);
		fire_ball_hide(GF_CAUSE_2, dir, damage, 0);
		break;
	case MS_CAUSE_3:
		if (!get_aim_dir(&dir)) return FALSE;

        damage = monspell_bluemage_damage(monspell_num(RF5_SPELL_START, RF5_CAUSE_3), plev, DAM_ROLL);
		fire_ball_hide(GF_CAUSE_3, dir, damage, 0);
		break;
	case MS_CAUSE_4:
		if (!get_aim_dir(&dir)) return FALSE;

        damage = monspell_bluemage_damage(monspell_num(RF5_SPELL_START, RF5_CAUSE_4), plev, DAM_ROLL);
		fire_ball_hide(GF_CAUSE_4, dir, damage, 0);
		break;
	case MS_BOLT_ACID:
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("åɡܥȤμʸ򾧤", "You cast an acid bolt."));
        damage = monspell_bluemage_damage(monspell_num(RF5_SPELL_START, RF5_BO_ACID), plev, DAM_ROLL);
        fire_bolt(GF_ACID, dir, damage);
		break;
	case MS_BOLT_ELEC:
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("ܥȤμʸ򾧤", "You cast a lightning bolt."));
        damage = monspell_bluemage_damage(monspell_num(RF5_SPELL_START, RF5_BO_ELEC), plev, DAM_ROLL);
		fire_bolt(GF_ELEC, dir, damage);
		break;
	case MS_BOLT_FIRE:
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("եܥȤμʸ򾧤", "You cast a fire bolt."));
        damage = monspell_bluemage_damage(monspell_num(RF5_SPELL_START, RF5_BO_FIRE), plev, DAM_ROLL);
		fire_bolt(GF_FIRE, dir, damage);
		break;
	case MS_BOLT_COLD:
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("ܥȤμʸ򾧤", "You cast a frost bolt."));
        damage = monspell_bluemage_damage(monspell_num(RF5_SPELL_START, RF5_BO_COLD), plev, DAM_ROLL);
		fire_bolt(GF_COLD, dir, damage);
		break;
	case MS_STARBURST:
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("СȤμʸǰ", "You invoke a starburst."));
        damage = monspell_bluemage_damage(monspell_num(RF5_SPELL_START, RF5_BA_LITE), plev, DAM_ROLL);
		fire_ball(GF_LITE, dir, damage, 4);
		break;
	case MS_BOLT_NETHER:
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("Ϲμʸ򾧤", "You cast a nether bolt."));
        damage = monspell_bluemage_damage(monspell_num(RF5_SPELL_START, RF5_BO_NETH), plev, DAM_ROLL);
		fire_bolt(GF_NETHER, dir, damage);
		break;
	case MS_BOLT_WATER:
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("ܥȤμʸ򾧤", "You cast a water bolt."));
        damage = monspell_bluemage_damage(monspell_num(RF5_SPELL_START, RF5_BO_WATE), plev, DAM_ROLL);
		fire_bolt(GF_WATER, dir, damage);
		break;
	case MS_BOLT_MANA:
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("Ϥμʸ򾧤", "You cast a mana bolt."));
        damage = monspell_bluemage_damage(monspell_num(RF5_SPELL_START, RF5_BO_MANA), plev, DAM_ROLL);
		fire_bolt(GF_MANA, dir, damage);
		break;
	case MS_BOLT_PLASMA:
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("ץ饺ޡܥȤμʸ򾧤", "You cast a plasma bolt."));
        damage = monspell_bluemage_damage(monspell_num(RF5_SPELL_START, RF5_BO_PLAS), plev, DAM_ROLL);
		fire_bolt(GF_PLASMA, dir, damage);
		break;
	case MS_BOLT_ICE:
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("˴μʸ򾧤", "You cast a ice bolt."));
        damage = monspell_bluemage_damage(monspell_num(RF5_SPELL_START, RF5_BO_ICEE), plev, DAM_ROLL);
		fire_bolt(GF_ICE, dir, damage);
		break;
	case MS_MAGIC_MISSILE:
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("ޥåߥμʸ򾧤", "You cast a magic missile."));
        damage = monspell_bluemage_damage(monspell_num(RF5_SPELL_START, RF5_MISSILE), plev, DAM_ROLL);
		fire_bolt(GF_MISSILE, dir, damage);
		break;
	case MS_SCARE:
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("ʸФФ", "You cast a fearful illusion."));
		fear_monster(dir, plev+10);
		break;
	case MS_BLIND:
		if (!get_aim_dir(&dir)) return FALSE;
		confuse_monster(dir, plev * 2);
		break;
	case MS_CONF:
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("ͶŪʸФĤФ", "You cast a mesmerizing illusion."));
		confuse_monster(dir, plev * 2);
		break;
	case MS_SLOW:
		if (!get_aim_dir(&dir)) return FALSE;
		slow_monster(dir, plev);
		break;
	case MS_SLEEP:
		if (!get_aim_dir(&dir)) return FALSE;
		sleep_monster(dir, plev);
		break;
	case MS_SPEED:
		(void)set_fast(randint1(20 + plev) + plev, FALSE);
		break;
	case MS_HAND_DOOM:
	{
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("<Ǥμ>ä", "You invoke the Hand of Doom!"));
		fire_ball_hide(GF_HAND_DOOM, dir, plev * 3, 0);
		break;
	}
	case MS_HEAL:
        msg_print(_("ʬνǰ椷", "You concentrate on your wounds!"));
		(void)hp_player(plev*4);
		(void)set_stun(0);
		(void)set_cut(0);
		break;
	case MS_INVULNER:
        msg_print(_("̵εμʸ򾧤", "You cast a Globe of Invulnerability."));
		(void)set_invuln(randint1(4) + 4, FALSE);
		break;
	case MS_BLINK:
		teleport_player(10, 0L);
		break;
	case MS_TELEPORT:
		teleport_player(plev * 5, 0L);
		break;
	case MS_WORLD:
        world_player = TRUE;
        msg_print(_("ֻ衪", "'Time!'"));
		msg_print(NULL);

		/* Hack */
		p_ptr->energy_need -= 1000 + (100 + randint1(200)+200)*TURNS_PER_TICK/10;

		/* Redraw map */
		p_ptr->redraw |= (PR_MAP);

		/* Update monsters */
		p_ptr->update |= (PU_MONSTERS);

		/* Window stuff */
		p_ptr->window |= (PW_OVERHEAD | PW_DUNGEON);

		handle_stuff();
		break;
	case MS_SPECIAL:
		break;
	case MS_TELE_TO:
	{
		monster_type *m_ptr;
		monster_race *r_ptr;
		char m_name[80];

		if (!target_set(TARGET_KILL)) return FALSE;
		if (!cave[target_row][target_col].m_idx) break;
		if (!player_has_los_bold(target_row, target_col)) break;
		if (!projectable(py, px, target_row, target_col)) break;
		m_ptr = &m_list[cave[target_row][target_col].m_idx];
		r_ptr = &r_info[m_ptr->r_idx];
		monster_desc(m_name, m_ptr, 0);
		if (r_ptr->flagsr & RFR_RES_TELE)
		{
			if ((r_ptr->flags1 & (RF1_UNIQUE)) || (r_ptr->flagsr & RFR_RES_ALL))
			{
				if (is_original_ap_and_seen(m_ptr)) r_ptr->r_flagsr |= RFR_RES_TELE;
                msg_format(_("%sˤϸ̤ʤä", "%s is unaffected!"), m_name);
				break;
			}
			else if (r_ptr->level > randint1(100))
			{
				if (is_original_ap_and_seen(m_ptr)) r_ptr->r_flagsr |= RFR_RES_TELE;
                msg_format(_("%sˤ롪", "%s resists!"), m_name);
				break;
			}
		}
        msg_format(_("%sᤷ", "You command %s to return."), m_name);
		teleport_monster_to(cave[target_row][target_col].m_idx, py, px, 100, TELEPORT_PASSIVE);
		break;
	}
	case MS_TELE_AWAY:
		if (!get_aim_dir(&dir)) return FALSE;

		(void)fire_beam(GF_AWAY_ALL, dir, 100);
		break;
	case MS_TELE_LEVEL:
	{
		int target_m_idx;
		monster_type *m_ptr;
		monster_race *r_ptr;
		char m_name[80];

		if (!target_set(TARGET_KILL)) return FALSE;
		target_m_idx = cave[target_row][target_col].m_idx;
		if (!target_m_idx) break;
		if (!player_has_los_bold(target_row, target_col)) break;
		if (!projectable(py, px, target_row, target_col)) break;
		m_ptr = &m_list[target_m_idx];
		r_ptr = &r_info[m_ptr->r_idx];
		monster_desc(m_name, m_ptr, 0);
        msg_format(_("%^s­ؤ", "You gesture at %^s's feet."), m_name);

		if ((r_ptr->flagsr & (RFR_EFF_RES_NEXU_MASK | RFR_RES_TELE)) ||
			(r_ptr->flags1 & RF1_QUESTOR) || (r_ptr->level + randint1(50) > plev + randint1(60)))
		{
            msg_format(_("̤ʤä", "%^s is unaffected!"), m_name);
		}
		else teleport_level(target_m_idx);
		break;
	}
	case MS_PSY_SPEAR:
		if (!get_aim_dir(&dir)) return FALSE;

        msg_print(_("ηä", "You throw a psycho-spear."));
        damage = monspell_bluemage_damage(monspell_num(RF6_SPELL_START, RF6_PSY_SPEAR), plev, DAM_ROLL);
		(void)fire_beam(GF_PSY_SPEAR, dir, damage);
		break;
	case MS_DARKNESS:

        msg_print(_("ŰǤǼ򿶤ä", "You gesture in shadow."));
		(void)unlite_area(10, 3);
		break;
	case MS_MAKE_TRAP:
		if (!target_set(TARGET_KILL)) return FALSE;

        msg_print(_("ʸ򾧤ƼٰФ", "You cast a spell and cackle evilly."));
		trap_creation(target_row, target_col);
		break;
	case MS_FORGET:
        msg_print(_("ⵯʤä", "Nothing happen."));
		break;
    case MS_RAISE_DEAD:
        msg_print(_("μʸ򾧤", "You cast a animate dead."));
		(void)animate_dead(0, py, px);
		break;
	case MS_S_KIN:
	{
		int k;

        msg_print(_("緳򾤴", "You summon minions."));
		for (k = 0;k < 1; k++)
		{
			if (summon_kin_player(summon_lev, py, px, (pet ? PM_FORCE_PET : 0L)))
			{
				if (!pet) msg_print(_("줿֤ܤäƤ롪", "Summoned fellows are angry!"));
			}
			else
			{
				no_trump = TRUE;
			}
		}
		break;
	}
	case MS_S_CYBER:
	{
		int k;

        msg_print(_("Сǡ򾤴", "You summon a Cyberdemon!"));
		for (k = 0 ;k < 1 ; k++)
			if (summon_specific((pet ? -1 : 0), py, px, summon_lev, SUMMON_CYBER, p_mode))
			{
                if (!pet)
                    msg_print(_("줿СǡܤäƤ롪", "The summoned Cyberdemon are angry!"));
			}
			else
			{
				no_trump = TRUE;
			}
		break;
	}
	case MS_S_MONSTER:
	{
		int k;
        msg_print(_("֤򾤴", "You summon help."));
		for (k = 0;k < 1; k++)
			if (summon_specific((pet ? -1 : 0), py, px, summon_lev, 0, p_mode))
			{
                if (!pet)
                    msg_print(_("줿󥹥ܤäƤ롪", "The summoned monster is angry!"));
			}
			else
			{
				no_trump = TRUE;
			}
		break;
	}
	case MS_S_MONSTERS:
	{
		int k;
        msg_print(_("󥹥򾤴", "You summon monsters!"));
		for (k = 0;k < plev / 15 + 2; k++)
			if(summon_specific((pet ? -1 : 0), py, px, summon_lev, 0, (p_mode | u_mode)))
			{
                if (!pet)
                    msg_print(_("줿󥹥ܤäƤ롪", "The summoned monsters are angry!"));
			}
			else
			{
				no_trump = TRUE;
			}
		break;
	}
	case MS_S_ANT:
	{
		int k;
        msg_print(_("򾤴", "You summon ants."));
		for (k = 0;k < 1; k++)
			if (summon_specific((pet ? -1 : 0), py, px, summon_lev, SUMMON_ANT, (PM_ALLOW_GROUP | p_mode)))
			{
                if (!pet)
                    msg_print(_("줿ܤäƤ롪", "The summoned ants are angry!"));
			}
			else
			{
				no_trump = TRUE;
			}
		break;
	}
	case MS_S_SPIDER:
	{
		int k;
        msg_print(_("򾤴", "You summon spiders."));
		for (k = 0;k < 1; k++)
			if (summon_specific((pet ? -1 : 0), py, px, summon_lev, SUMMON_SPIDER, (PM_ALLOW_GROUP | p_mode)))
			{
                if (!pet)
                    msg_print(_("줿ܤäƤ롪", "Summoned spiders are angry!"));
			}
			else
			{
				no_trump = TRUE;
			}
		break;
	}
	case MS_S_HOUND:
	{
		int k;
        msg_print(_("ϥɤ򾤴", "You summon hounds."));
		for (k = 0;k < 1; k++)
			if (summon_specific((pet ? -1 : 0), py, px, summon_lev, SUMMON_HOUND, (PM_ALLOW_GROUP | p_mode)))
			{
                if (!pet)
                    msg_print(_("줿ϥɤܤäƤ롪", "Summoned hounds are angry!"));
			}
			else
			{
				no_trump = TRUE;
			}
		break;
	}
	case MS_S_HYDRA:
	{
		int k;
        msg_print(_("ҥɥ򾤴", "You summon a hydras."));
		for (k = 0;k < 1; k++)
			if (summon_specific((pet ? -1 : 0), py, px, summon_lev, SUMMON_HYDRA, (g_mode | p_mode)))
			{
                if (!pet)
                    msg_print(_("줿ҥɥܤäƤ롪", "Summoned hydras are angry!"));
			}
			else
			{
				no_trump = TRUE;
			}
		break;
	}
	case MS_S_ANGEL:
	{
		int k;
        msg_print(_("ŷȤ򾤴", "You summon an angel!"));
		for (k = 0;k < 1; k++)
			if (summon_specific((pet ? -1 : 0), py, px, summon_lev, SUMMON_ANGEL, (g_mode | p_mode)))
			{
                if (!pet)
                    msg_print(_("줿ŷȤܤäƤ롪", "Summoned angels are angry!"));
			}
			else
			{
				no_trump = TRUE;
			}
		break;
	}
	case MS_S_DEMON:
	{
		int k;
        msg_print(_("٤ε鰭򾤴", "You summon a demon from the Courts of Chaos!"));
		for (k = 0;k < 1; k++)
			if (summon_specific((pet ? -1 : 0), py, px, summon_lev, SUMMON_DEMON, (g_mode | p_mode)))
			{
                if (!pet)
                    msg_print(_("줿ǡܤäƤ롪", "Summoned demons are angry!"));
			}
			else
			{
				no_trump = TRUE;
			}
		break;
	}
	case MS_S_UNDEAD:
	{
		int k;
        msg_print(_("ǥåɤζŨ򾤴", "You summon an undead adversary!"));
		for (k = 0;k < 1; k++)
			if (summon_specific((pet ? -1 : 0), py, px, summon_lev, SUMMON_UNDEAD, (g_mode | p_mode)))
			{
                if (!pet)
                    msg_print(_("줿ǥåɤܤäƤ롪", "Summoned undeads are angry!"));
			}
			else
			{
				no_trump = TRUE;
			}
		break;
	}
	case MS_S_DRAGON:
	{
		int k;
        msg_print(_("ɥ饴򾤴", "You summon a dragon!"));
		for (k = 0;k < 1; k++)
			if (summon_specific((pet ? -1 : 0), py, px, summon_lev, SUMMON_DRAGON, (g_mode | p_mode)))
			{
                if (!pet)
                    msg_print(_("줿ɥ饴ܤäƤ롪", "Summoned dragons are angry!"));
			}
			else
			{
				no_trump = TRUE;
			}
		break;
	}
	case MS_S_HI_UNDEAD:
	{
		int k;
        msg_print(_("Ϥʥǥåɤ򾤴", "You summon a greater undead!"));
		for (k = 0;k < 1; k++)
			if (summon_specific((pet ? -1 : 0), py, px, summon_lev, SUMMON_HI_UNDEAD, (g_mode | p_mode | u_mode)))
			{
                if (!pet)
                    msg_print(_("줿饢ǥåɤܤäƤ롪", "Summoned greater undeads are angry!"));
			}
			else
			{
				no_trump = TRUE;
			}
		break;
	}
	case MS_S_HI_DRAGON:
	{
		int k;
        msg_print(_("ɥ饴򾤴", "You summon an ancient dragon!"));
		for (k = 0;k < 1; k++)
			if (summon_specific((pet ? -1 : 0), py, px, summon_lev, SUMMON_HI_DRAGON, (g_mode | p_mode | u_mode)))
			{
                if (!pet)
                    msg_print(_("줿ɥ饴ܤäƤ롪", "Summoned ancient dragons are angry!"));
			}
			else
			{
				no_trump = TRUE;
			}
		break;
	}
	case MS_S_AMBERITE:
	{
		int k;
        msg_print(_("Сβ²򾤴", "You summon a Lord of Amber!"));
		for (k = 0;k < 1; k++)
			if (summon_specific((pet ? -1 : 0), py, px, summon_lev, SUMMON_AMBERITES, (g_mode | p_mode | u_mode)))
			{
                if (!pet)
                    msg_print(_("줿Сβ²ܤäƤ롪", "Summoned Lords of Amber are angry!"));
			}
			else
			{
				no_trump = TRUE;
			}
		break;
	}
	case MS_S_UNIQUE:
	{
		int k, count = 0;
        msg_print(_("̤ʶŨ򾤴", "You summon a special opponent!"));
		for (k = 0;k < 1; k++)
			if (summon_specific((pet ? -1 : 0), py, px, summon_lev, SUMMON_UNIQUE, (g_mode | p_mode | PM_ALLOW_UNIQUE)))
			{
				count++;
                if (!pet)
                    msg_print(_("줿ˡ󥹥ܤäƤ롪", "Summoned special opponents are angry!"));
			}
		for (k = count;k < 1; k++)
			if (summon_specific((pet ? -1 : 0), py, px, summon_lev, SUMMON_HI_UNDEAD, (g_mode | p_mode | PM_ALLOW_UNIQUE)))
			{
				count++;
                if (!pet)
                    msg_print(_("줿饢ǥåɤܤäƤ롪", "Summoned greater undeads are angry!"));
			}
		if (!count)
		{
			no_trump = TRUE;
		}
		break;
	}
	default:
		msg_print("hoge?");
	}
	if (no_trump)
    {
        msg_print(_("⸽ʤä", "No one have appeared."));
	}

	return TRUE;
}

/*!
 * @brief ˡޥɤΥᥤ롼 /
 * do_cmd_cast calls this function if the player's class is 'Blue-Mage'.
 * @return ¹ԤTRUE󥻥뤷FALSE֤
 */
bool do_cmd_cast_learned(void)
{
	int             n = 0;
	int             chance;
	int             minfail = 0;
	int             plev = p_ptr->lev;
	monster_power   spell;
	bool            cast;
	int             need_mana;


	/* not if confused */
	if (p_ptr->confused)
	{
#ifdef JP
msg_print("𤷤Ƥƾʤ");
#else
		msg_print("You are too confused!");
#endif

		return TRUE;
	}

	/* get power */
	if (!get_learned_power(&n)) return FALSE;

	spell = monster_powers[n];

	need_mana = mod_need_mana(spell.smana, 0, REALM_NONE);

	/* Verify "dangerous" spells */
	if (need_mana > p_ptr->csp)
	{
		/* Warning */
#ifdef JP
msg_print("ͣФ­ޤ");
#else
		msg_print("You do not have enough mana to use this power.");
#endif


		if (!over_exert) return FALSE;

		/* Verify */
#ifdef JP
if (!get_check("Ǥĩ路ޤ? ")) return FALSE;
#else
		if (!get_check("Attempt it anyway? ")) return FALSE;
#endif

	}

	/* Spell failure chance */
	chance = spell.fail;

	/* Reduce failure rate by "effective" level adjustment */
	if (plev > spell.level) chance -= 3 * (plev - spell.level);
	else chance += (spell.level - plev);

	/* Reduce failure rate by INT/WIS adjustment */
	chance -= 3 * (adj_mag_stat[p_ptr->stat_ind[A_INT]] - 1);

	chance = mod_spell_chance_1(chance);

	/* Not enough mana to cast */
	if (need_mana > p_ptr->csp)
	{
		chance += 5 * (need_mana - p_ptr->csp);
	}

	/* Extract the minimum failure rate */
	minfail = adj_mag_fail[p_ptr->stat_ind[A_INT]];

	/* Minimum failure rate */
	if (chance < minfail) chance = minfail;

	/* Stunning makes spells harder */
	if (p_ptr->stun > 50) chance += 25;
	else if (p_ptr->stun) chance += 15;

	/* Always a 5 percent chance of working */
	if (chance > 95) chance = 95;

	chance = mod_spell_chance_2(chance);

	/* Failed spell */
	if (randint0(100) < chance)
	{
		if (flush_failure) flush();
#ifdef JP
msg_print("ˡ򤦤ޤʤä");
#else
		msg_print("You failed to concentrate hard enough!");
#endif

		sound(SOUND_FAIL);

		if (n >= MS_S_KIN)
			/* Cast the spell */
			cast = cast_learned_spell(n, FALSE);
	}
	else
	{
		sound(SOUND_ZAP);

		/* Cast the spell */
		cast = cast_learned_spell(n, TRUE);

		if (!cast) return FALSE;
	}

	/* Sufficient mana */
	if (need_mana <= p_ptr->csp)
	{
		/* Use some mana */
		p_ptr->csp -= need_mana;
	}
	else
	{
		int oops = need_mana;

		/* No mana left */
		p_ptr->csp = 0;
		p_ptr->csp_frac = 0;

		/* Message */
#ifdef JP
msg_print("椷Ƶ򼺤äƤޤä");
#else
		msg_print("You faint from the effort!");
#endif


		/* Hack -- Bypass free action */
		(void)set_paralyzed(p_ptr->paralyzed + randint1(5 * oops + 1));

		chg_virtue(V_KNOWLEDGE, -10);

		/* Damage CON (possibly permanently) */
		if (randint0(100) < 50)
		{
			bool perm = (randint0(100) < 25);

			/* Message */
#ifdef JP
msg_print("Τ򰭤Ƥޤä");
#else
			msg_print("You have damaged your health!");
#endif


			/* Reduce constitution */
			(void)dec_stat(A_CON, 15 + randint1(10), perm);
		}
	}

	/* Take a turn */
	energy_use = 100;

	/* Window stuff */
	p_ptr->redraw |= (PR_MANA);
	p_ptr->window |= (PW_PLAYER);
	p_ptr->window |= (PW_SPELL);

	return TRUE;
}

/*!
 * @brief ˡΥ顼˥ȽΥ顼˥󥰽
 * @param monspell 顼˥󥰤ߤ󥹥ID
 * @return ʤ
 */
void learn_spell(int monspell)
{
	if (p_ptr->action != ACTION_LEARN) return;
	if (monspell < 0) return; /* Paranoia */
	if (p_ptr->magic_num2[monspell]) return;
	if (p_ptr->confused || p_ptr->blind || p_ptr->image || p_ptr->stun || p_ptr->paralyzed) return;
	if (randint1(p_ptr->lev + 70) > monster_powers[monspell].level + 40)
	{
		p_ptr->magic_num2[monspell] = 1;
#ifdef JP
		msg_format("%sؽ", monster_powers[monspell].name);
#else
		msg_format("You have learned %s!", monster_powers[monspell].name);
#endif
		gain_exp(monster_powers[monspell].level * monster_powers[monspell].smana);

		/* Sound */
		sound(SOUND_STUDY);

		new_mane = TRUE;
		p_ptr->redraw |= (PR_STATE);
	}
}


/*!
 * @brief 󥹥üǽϤΥե饰󤫤ˡȴФ
 * Extract monster spells mask for the given mode
 * @param f4 󥹥üǽϤ4ܤΥե饰
 * @param f5 󥹥üǽϤ5ܤΥե饰
 * @param f6 󥹥üǽϤ6ܤΥե饰
 * @param mode ȴФ
 * @return ʤ
 */
/*
 */
void set_rf_masks(s32b *f4, s32b *f5, s32b *f6, int mode)
{
	switch (mode)
	{
		case MONSPELL_TYPE_BOLT:
			*f4 = ((RF4_BOLT_MASK | RF4_BEAM_MASK) & ~(RF4_ROCKET));
			*f5 = RF5_BOLT_MASK | RF5_BEAM_MASK;
			*f6 = RF6_BOLT_MASK | RF6_BEAM_MASK;
			break;

		case MONSPELL_TYPE_BALL:
			*f4 = (RF4_BALL_MASK & ~(RF4_BREATH_MASK));
			*f5 = (RF5_BALL_MASK & ~(RF5_BREATH_MASK));
			*f6 = (RF6_BALL_MASK & ~(RF6_BREATH_MASK));
			break;

		case MONSPELL_TYPE_BREATH:
			*f4 = RF4_BREATH_MASK;
			*f5 = RF5_BREATH_MASK;
			*f6 = RF6_BREATH_MASK;
			break;

		case MONSPELL_TYPE_SUMMON:
			*f4 = RF4_SUMMON_MASK;
			*f5 = RF5_SUMMON_MASK;
			*f6 = RF6_SUMMON_MASK;
			break;

		case MONSPELL_TYPE_OTHER:
			*f4 = RF4_ATTACK_MASK & ~(RF4_BOLT_MASK | RF4_BEAM_MASK | RF4_BALL_MASK | RF4_INDIRECT_MASK);
			*f5 = RF5_ATTACK_MASK & ~(RF5_BOLT_MASK | RF5_BEAM_MASK | RF5_BALL_MASK | RF5_INDIRECT_MASK);
			*f6 = RF6_ATTACK_MASK & ~(RF6_BOLT_MASK | RF6_BEAM_MASK | RF6_BALL_MASK | RF6_INDIRECT_MASK);
			break;
	}

	return;
}
