/*!
 * @file monster1.c
 * @brief 󥹥ε / describe monsters (using monster memory)
 * @date 2013/12/11
 * @author
 * Copyright (c) 1997 Ben Harrison, James E. Wilson, Robert A. Koeneke
 * This software may be copied and distributed for educational, research,
 * and not for profit purposes provided that this copyright and statement
 * are included in all such copies.  Other copyrights may also apply.
 * 2014 Deskull rearranged comment for Doxygen.
 */

#include "angband.h"


/*
 * Pronoun arrays, by gender.
 */
static cptr wd_he[3] =
#ifdef JP
{ "", "", "" };
#else
{ "it", "he", "she" };
#endif

static cptr wd_his[3] =
#ifdef JP
{ "", "", "" };
#else
{ "its", "his", "her" };
#endif



/*!
 * Ѹʣϵѥޥ / Pluralizer.  Args(count, singular, plural)
 */
#define plural(c,s,p) \
    (((c) == 1) ? (s) : (p))



/*!
 * @brief 󥹥AC뤳ȤǤ뤫֤ / Determine if the "armor" is known
 * @param r_idx 󥹥μ²ID
 * @return ŨACΤ郎ƤʤTRUE֤
 * @details
 * The higher the level, the fewer kills needed.
 */
static bool know_armour(int r_idx)
{
	monster_race *r_ptr = &r_info[r_idx];

	s32b level = r_ptr->level;

	s32b kills = r_ptr->r_tkills;

	if (cheat_know) return (TRUE);

	/* Normal monsters */
	if (kills > 304 / (4 + level)) return (TRUE);

	/* Skip non-uniques */
	if (!(r_ptr->flags1 & RF1_UNIQUE)) return (FALSE);

	/* Unique monsters */
	if (kills > 304 / (38 + (5 * level) / 4)) return (TRUE);

	/* Assume false */
	return (FALSE);
}


/*!
 * @brief 󥹥ǷϤΤ뤳ȤǤ뤫ɤ֤
 * Determine if the "damage" of the given attack is known
 * @param r_idx 󥹥μ²ID
 * @param i ǧ
 * @return ŨΥ᡼Τ郎ƤʤTRUE֤
 * @details
 * <pre>
 * the higher the level of the monster, the fewer the attacks you need,
 * the more damage an attack does, the more attacks you need
 * </pre>
 */
static bool know_damage(int r_idx, int i)
{
	monster_race *r_ptr = &r_info[r_idx];

	s32b level = r_ptr->level;

	s32b a = r_ptr->r_blows[i];

	s32b d1 = r_ptr->blow[i].d_dice;
	s32b d2 = r_ptr->blow[i].d_side;

	s32b d = d1 * d2;

	if (d >= ((4+level)*MAX_UCHAR)/80) d = ((4+level)*MAX_UCHAR-1)/80;

	/* Normal monsters */
	if ((4 + level) * a > 80 * d) return (TRUE);

	/* Skip non-uniques */
	if (!(r_ptr->flags1 & RF1_UNIQUE)) return (FALSE);

	/* Unique monsters */
	if ((4 + level) * (2 * a) > 80 * d) return (TRUE);

	/* Assume false */
	return (FALSE);
}


/*
 * Prepare hook for c_roff(). It will be changed for spoiler generation in wizard1.c.
 */
void (*hook_c_roff)(byte attr, cptr str) = c_roff;

/*!
 * @brief 󥹥λפХå򤢤餫ꤵ줿ؿݥ󥿤˴ŤϤ
 * @param str ʸ
 * @return ʤ
 */
static void hooked_roff(cptr str)
{
	/* Spawn */
	hook_c_roff(TERM_WHITE, str);
}


/*!
 * @brief 󥹥λפоɽ
 * Hack -- display monster information using "hooked_roff()"
 * @param r_idx 󥹥μ²ID
 * @param mode ɽץ
 * @return ʤ
 * @details
 * This function should only be called with the cursor placed at the
 * left edge of the screen, on a cleared line, in which the recall is
 * to take place.  One extra blank line is left after the recall.
 */
static void roff_aux(int r_idx, int mode)
{
	monster_race    *r_ptr = &r_info[r_idx];

	bool            old = FALSE;

	int             m, n, r;

	cptr            p, q;

#ifdef JP
	char            jverb_buf[64];
#else
	bool            sin = FALSE;
#endif
	int             msex = 0;

	bool nightmare = ironman_nightmare && !(mode & 0x02);
	int speed = nightmare ? r_ptr->speed + 5 : r_ptr->speed;

	bool            breath = FALSE;
	bool            magic = FALSE;
	bool            reinforce = FALSE;

	u32b		flags1;
	u32b		flags2;
	u32b		flags3;
	u32b		flags4;
	u32b		flags5;
	u32b		flags6;
	u32b		flags7;
	u32b		flagsr;

	byte drop_gold, drop_item;

	int		vn = 0;
	byte		color[96];
	cptr		vp[96];
	char shoot_power[96];

	bool know_everything = FALSE;

	/* Obtain a copy of the "known" number of drops */
	drop_gold = r_ptr->r_drop_gold;
	drop_item = r_ptr->r_drop_item;

	/* Obtain a copy of the "known" flags */
	flags1 = (r_ptr->flags1 & r_ptr->r_flags1);
	flags2 = (r_ptr->flags2 & r_ptr->r_flags2);
	flags3 = (r_ptr->flags3 & r_ptr->r_flags3);
	flags4 = (r_ptr->flags4 & r_ptr->r_flags4);
	flags5 = (r_ptr->flags5 & r_ptr->r_flags5);
	flags6 = (r_ptr->flags6 & r_ptr->r_flags6);
	flags7 = (r_ptr->flags7 & r_ptr->flags7);
	flagsr = (r_ptr->flagsr & r_ptr->r_flagsr);

	for(n = 0; n < 6; n++)
	{
		if(r_ptr->reinforce_id[n] > 0) reinforce = TRUE;
	}

	/* cheat_know or research_mon() */
	if (cheat_know || (mode & 0x01))
		know_everything = TRUE;

	/* Cheat -- Know everything */
	if (know_everything)
	{
		/* Hack -- maximal drops */
		drop_gold = drop_item =
		(((r_ptr->flags1 & RF1_DROP_4D2) ? 8 : 0) +
		 ((r_ptr->flags1 & RF1_DROP_3D2) ? 6 : 0) +
		 ((r_ptr->flags1 & RF1_DROP_2D2) ? 4 : 0) +
		 ((r_ptr->flags1 & RF1_DROP_1D2) ? 2 : 0) +
		 ((r_ptr->flags1 & RF1_DROP_90)  ? 1 : 0) +
		 ((r_ptr->flags1 & RF1_DROP_60)  ? 1 : 0));

		/* Hack -- but only "valid" drops */
		if (r_ptr->flags1 & RF1_ONLY_GOLD) drop_item = 0;
		if (r_ptr->flags1 & RF1_ONLY_ITEM) drop_gold = 0;

		/* Hack -- know all the flags */
		flags1 = r_ptr->flags1;
		flags2 = r_ptr->flags2;
		flags3 = r_ptr->flags3;
		flags4 = r_ptr->flags4;
		flags5 = r_ptr->flags5;
		flags6 = r_ptr->flags6;
		flagsr = r_ptr->flagsr;
	}


	/* Extract a gender (if applicable) */
	if (r_ptr->flags1 & RF1_FEMALE) msex = 2;
	else if (r_ptr->flags1 & RF1_MALE) msex = 1;

	/* Assume some "obvious" flags */
	if (r_ptr->flags1 & RF1_UNIQUE)  flags1 |= (RF1_UNIQUE);
	if (r_ptr->flags1 & RF1_QUESTOR) flags1 |= (RF1_QUESTOR);
	if (r_ptr->flags1 & RF1_MALE)    flags1 |= (RF1_MALE);
	if (r_ptr->flags1 & RF1_FEMALE)  flags1 |= (RF1_FEMALE);

	/* Assume some "creation" flags */
	if (r_ptr->flags1 & RF1_FRIENDS) flags1 |= (RF1_FRIENDS);
	if (r_ptr->flags1 & RF1_ESCORT)  flags1 |= (RF1_ESCORT);
	if (r_ptr->flags1 & RF1_ESCORTS) flags1 |= (RF1_ESCORTS);

	/* Killing a monster reveals some properties */
	if (r_ptr->r_tkills || know_everything)
	{
		/* Know "race" flags */
		if (r_ptr->flags3 & RF3_ORC)      flags3 |= (RF3_ORC);
		if (r_ptr->flags3 & RF3_TROLL)    flags3 |= (RF3_TROLL);
		if (r_ptr->flags3 & RF3_GIANT)    flags3 |= (RF3_GIANT);
		if (r_ptr->flags3 & RF3_DRAGON)   flags3 |= (RF3_DRAGON);
		if (r_ptr->flags3 & RF3_DEMON)    flags3 |= (RF3_DEMON);
		if (r_ptr->flags3 & RF3_UNDEAD)   flags3 |= (RF3_UNDEAD);
		if (r_ptr->flags3 & RF3_EVIL)     flags3 |= (RF3_EVIL);
		if (r_ptr->flags3 & RF3_GOOD)     flags3 |= (RF3_GOOD);
		if (r_ptr->flags3 & RF3_ANIMAL)   flags3 |= (RF3_ANIMAL);
		if (r_ptr->flags3 & RF3_AMBERITE) flags3 |= (RF3_AMBERITE);
		if (r_ptr->flags2 & RF2_HUMAN)    flags2 |= (RF2_HUMAN);

		/* Know 'quantum' flag */
		if (r_ptr->flags2 & RF2_QUANTUM)  flags2 |= (RF2_QUANTUM);

		/* Know "forced" flags */
		if (r_ptr->flags1 & RF1_FORCE_DEPTH) flags1 |= (RF1_FORCE_DEPTH);
		if (r_ptr->flags1 & RF1_FORCE_MAXHP) flags1 |= (RF1_FORCE_MAXHP);
	}

	/* For output_monster_spoiler() */
	if (mode & 0x02)
	{
		/* Nothing to do */
	}
	else

	/* Treat uniques differently */
	if (flags1 & RF1_UNIQUE)
	{
		/* Hack -- Determine if the unique is "dead" */
		bool dead = (r_ptr->max_num == 0) ? TRUE : FALSE;

		/* We've been killed... */
		if (r_ptr->r_deaths)
		{
			/* Killed ancestors */
			hooked_roff(format(_("%^sϤʤĤ %d äƤ", "%^s has slain %d of your ancestors"),
					   wd_he[msex], r_ptr->r_deaths));

			/* But we've also killed it */
			if (dead)
			{
				hooked_roff(format(
					_("Ǥ˵Ƥϲ̤Ƥ롪", 
					 (", but you have avenged %s!  ", plural(r_ptr->r_deaths, "him", "them")))));
			}

			/* Unavenged (ever) */
			else
			{
				hooked_roff(format(
					_("ΤˡޤƤ̤Ƥʤ", 
					 (", who %s unavenged.  ", plural(r_ptr->r_deaths, "remains", "remain")))));
			}

			/* Start a new line */
			hooked_roff("\n");
		}

		/* Dead unique who never hurt us */
		else if (dead)
		{
			hooked_roff(_("ʤϤεŨ򤹤ǤäƤ롣", "You have slain this foe.  "));

			/* Start a new line */
			hooked_roff("\n");
		}
	}

	/* Not unique, but killed us */
	else if (r_ptr->r_deaths)
	{
		/* Dead ancestors */
		hooked_roff(
			_(format("Υ󥹥ϤʤĤ %d äƤ", r_ptr->r_deaths),
			  format("%d of your ancestors %s been killed by this creature, ", r_ptr->r_deaths, plural(r_ptr->r_deaths, "has", "have"))));

		/* Some kills this life */
		if (r_ptr->r_pkills)
		{
			hooked_roff(format(
				_("ʤϤΥ󥹥򾯤ʤȤ %d ΤݤƤ롣", 
				 "and you have exterminated at least %d of the creatures.  "), r_ptr->r_pkills));
		}

		/* Some kills past lives */
		else if (r_ptr->r_tkills)
		{
			hooked_roff(format(
				_("ʤĤϤΥ󥹥򾯤ʤȤ %d ΤݤƤ롣", 
				  "and your ancestors have exterminated at least %d of the creatures.  "), r_ptr->r_tkills));
		}

		/* No kills */
		else
		{
			hooked_roff(format(
				_("ޤ%sݤȤϤʤ", 
				  "and %s is not ever known to have been defeated.  "), wd_he[msex]));
		}

		/* Start a new line */
		hooked_roff("\n");
	}

	/* Normal monsters */
	else
	{
		/* Killed some this life */
		if (r_ptr->r_pkills)
		{
			hooked_roff(format(
				_("ʤϤΥ󥹥򾯤ʤȤ %d ΤϻƤ롣",
				  "You have killed at least %d of these creatures.  "), r_ptr->r_pkills));
		}

		/* Killed some last life */
		else if (r_ptr->r_tkills)
		{
			hooked_roff(format(
				_("ʤĤϤΥ󥹥򾯤ʤȤ %d ΤϻƤ롣", 
				  "Your ancestors have killed at least %d of these creatures.  "), r_ptr->r_tkills));
		}

		/* Killed none */
		else
		{
			hooked_roff(_("Υ󥹥ݤȤϤʤ", "No battles to the death are recalled.  "));
		}

		/* Start a new line */
		hooked_roff("\n");
	}

	/* Descriptions */
	{
		cptr tmp = r_text + r_ptr->text;

		if (tmp[0])
		{
			/* Dump it */
			hooked_roff(tmp);

			/* Start a new line */
			hooked_roff("\n");
		}
	}

	if (r_idx == MON_KAGE)
	{
		/* All done */
		hooked_roff("\n");

		return;
	}

	/* Nothing yet */
	old = FALSE;

	/* Describe location */
	if (r_ptr->level == 0)
	{
		hooked_roff(format(_("%^sĮ˽", "%^s lives in the town"), wd_he[msex]));
		old = TRUE;
	}
	else if (r_ptr->r_tkills || know_everything)
	{
		if (depth_in_feet)
		{
			hooked_roff(format(
				_("%^s̾ϲ %d եȤǽи", "%^s is normally found at depths of %d feet"),
				  wd_he[msex], r_ptr->level * 50));
		}
		else
		{
			hooked_roff(format(
				_("%^s̾ϲ %d ǽи", "%^s is normally found on dungeon level %d"),
				  wd_he[msex], r_ptr->level));
		}
		old = TRUE;
	}


	/* Describe movement */
	if (r_idx == MON_CHAMELEON)
	{
		hooked_roff(_("¾Υ󥹥˲롣", "and can take the shape of other monster."));
		return;
	}
	else
	{
		/* Introduction */
		if (old)
		{
			hooked_roff(_("", ", and "));
		}
		else
		{
			hooked_roff(format(_("%^s", "%^s "), wd_he[msex]));
			old = TRUE;
		}
#ifndef JP
		hooked_roff("moves");
#endif

		/* Random-ness */
		if ((flags1 & RF1_RAND_50) || (flags1 & RF1_RAND_25))
		{
			/* Adverb */
			if ((flags1 & RF1_RAND_50) && (flags1 & RF1_RAND_25))
			{
				hooked_roff(_("ʤ", " extremely"));
			}
			else if (flags1 & RF1_RAND_50)
			{
				hooked_roff(_("ʬ", " somewhat"));
			}
			else if (flags1 & RF1_RAND_25)
			{
				hooked_roff(_("", " a bit"));
			}

			/* Adjective */
			hooked_roff(_("Ե§", " erratically"));

			/* Hack -- Occasional conjunction */
			if (speed != 110) hooked_roff(_("", ", and"));
		}

		/* Speed */
		if (speed > 110)
		{
			if (speed > 139) hook_c_roff(TERM_RED, _("񤤤ۤ", " incredibly"));
			else if (speed > 134) hook_c_roff(TERM_ORANGE, _("", " extremely"));
			else if (speed > 129) hook_c_roff(TERM_ORANGE, _("", " very"));
			else if (speed > 124) hook_c_roff(TERM_UMBER, _("ʤ", " fairly"));
			else if (speed < 120) hook_c_roff(TERM_L_UMBER, _("", " somewhat"));
			hook_c_roff(TERM_L_RED, _("᤯", " quickly"));
		}
		else if (speed < 110)
		{
			if (speed < 90) hook_c_roff(TERM_L_GREEN, _("񤤤ۤ", " incredibly"));
			else if (speed < 95) hook_c_roff(TERM_BLUE, _("", " very"));
			else if (speed < 100) hook_c_roff(TERM_BLUE, _("ʤ", " fairly"));
			else if (speed > 104) hook_c_roff(TERM_GREEN, _("", " somewhat"));
			hook_c_roff(TERM_L_BLUE, _("ä", " slowly"));
		}
		else
		{
			hooked_roff(_("̤®", " at normal speed"));
		}
#ifdef JP
		hooked_roff("ưƤ");
#endif
	}

	/* The code above includes "attack speed" */
	if (flags1 & RF1_NEVER_MOVE)
	{
		/* Introduce */
		if (old)
		{
			hooked_roff(_("", ", but "));
		}
		else
		{
			hooked_roff(format(_("%^s", "%^s "), wd_he[msex]));
			old = TRUE;
		}

		/* Describe */
		hooked_roff(_("Ԥפʤ", "does not deign to chase intruders"));
	}

	/* End this sentence */
	if (old)
	{
		hooked_roff(_("", ".  "));
		old = FALSE;
	}


	/* Describe experience if known */
	if (r_ptr->r_tkills || know_everything)
	{
		/* Introduction */
#ifdef JP
		hooked_roff("");
#else
		if (flags1 & RF1_UNIQUE)
		{
			hooked_roff("Killing this");
		}
		else
		{
			hooked_roff("A kill of this");
		}
#endif


		/* Describe the "quality" */
		if (flags2 & RF2_ELDRITCH_HORROR) hook_c_roff(TERM_VIOLET, _("Ͷ", " sanity-blasting"));/*nuke me*/
		if (flags3 & RF3_ANIMAL)          hook_c_roff(TERM_L_GREEN, _("", " natural"));
		if (flags3 & RF3_EVIL)            hook_c_roff(TERM_L_DARK, _("ٰʤ", " evil"));
		if (flags3 & RF3_GOOD)            hook_c_roff(TERM_YELLOW, _("ɤ", " good"));
		if (flags3 & RF3_UNDEAD)          hook_c_roff(TERM_VIOLET, _("ǥåɤ", " undead"));
		if (flags3 & RF3_AMBERITE)        hook_c_roff(TERM_VIOLET, _("Сβ²", " Amberite"));

		if ((flags3 & (RF3_DRAGON | RF3_DEMON | RF3_GIANT | RF3_TROLL | RF3_ORC)) || (flags2 & (RF2_QUANTUM | RF2_HUMAN)))
		{
		/* Describe the "race" */
			if (flags3 & RF3_DRAGON)   hook_c_roff(TERM_ORANGE, _("ɥ饴", " dragon"));
			if (flags3 & RF3_DEMON)    hook_c_roff(TERM_VIOLET, _("ǡ", " demon"));
			if (flags3 & RF3_GIANT)    hook_c_roff(TERM_L_UMBER, _("㥤", " giant"));
			if (flags3 & RF3_TROLL)    hook_c_roff(TERM_BLUE, _("ȥ", " troll"));
			if (flags3 & RF3_ORC)      hook_c_roff(TERM_UMBER, _("", " orc"));
			if (flags2 & RF2_HUMAN)    hook_c_roff(TERM_L_WHITE, _("ʹ", " human"));
			if (flags2 & RF2_QUANTUM)  hook_c_roff(TERM_VIOLET, _("̻ʪ", " quantum creature"));
		}
		else
		{
			hooked_roff(_("󥹥", " creature"));
		}

#ifdef JP
		hooked_roff("ݤȤ");
#endif
		/* Group some variables */
		{
			long i, j;

#ifdef JP
			i = p_ptr->lev;
			hooked_roff(format(" %lu ٥Υ饯ˤȤä", (long)i));

			i = (long)r_ptr->mexp * r_ptr->level / (p_ptr->max_plv+2);
			j = ((((long)r_ptr->mexp * r_ptr->level % (p_ptr->max_plv+2)) *
			       (long)1000 / (p_ptr->max_plv+2) + 5) / 10);

			hooked_roff(format(" %ld.%02ld ݥȤηиȤʤ롣",
				(long)i, (long)j ));
#else
			/* calculate the integer exp part */
			i = (long)r_ptr->mexp * r_ptr->level / (p_ptr->max_plv+2);

			/* calculate the fractional exp part scaled by 100, */
			/* must use long arithmetic to avoid overflow  */
			j = ((((long)r_ptr->mexp * r_ptr->level % (p_ptr->max_plv+2)) *
			       (long)1000 / (p_ptr->max_plv+2) + 5) / 10);

			/* Mention the experience */
			hooked_roff(format(" is worth about %ld.%02ld point%s",
				    (long)i, (long)j,
				    (((i == 1) && (j == 0)) ? "" : "s")));

			/* Take account of annoying English */
			p = "th";
			i = p_ptr->lev % 10;
			if ((p_ptr->lev / 10) == 1) /* nothing */;
			else if (i == 1) p = "st";
			else if (i == 2) p = "nd";
			else if (i == 3) p = "rd";

			/* Take account of "leading vowels" in numbers */
			q = "";
			i = p_ptr->lev;
			if ((i == 8) || (i == 11) || (i == 18)) q = "n";

			/* Mention the dependance on the player's level */
			hooked_roff(format(" for a%s %lu%s level character.  ",
				    q, (long)i, p));
#endif

		}
	}

	if ((flags2 & RF2_AURA_FIRE) && (flags2 & RF2_AURA_ELEC) && (flags3 & RF3_AURA_COLD))
	{
		hook_c_roff(TERM_VIOLET, format(
			_("%^sϱɹȥѡޤƤ롣", "%^s is surrounded by flames, ice and electricity.  "), wd_he[msex]));
	}
	else if ((flags2 & RF2_AURA_FIRE) && (flags2 & RF2_AURA_ELEC))
	{
		hook_c_roff(TERM_L_RED, format(
			_("%^sϱȥѡޤƤ롣", "%^s is surrounded by flames and electricity.  "), wd_he[msex]));
	}
	else if ((flags2 & RF2_AURA_FIRE) && (flags3 & RF3_AURA_COLD))
	{
		hook_c_roff(TERM_BLUE, format(
			_("%^sϱɹޤƤ롣", "%^s is surrounded by flames and ice.  "), wd_he[msex]));
	}
	else if ((flags3 & RF3_AURA_COLD) && (flags2 & RF2_AURA_ELEC))
	{
		hook_c_roff(TERM_L_GREEN, format(
			_("%^sɹȥѡޤƤ롣", "%^s is surrounded by ice and electricity.  "), wd_he[msex]));
	}
	else if (flags2 & RF2_AURA_FIRE)
	{
		hook_c_roff(TERM_RED, format(
			_("%^sϱޤƤ롣", "%^s is surrounded by flames.  "), wd_he[msex]));
	}
	else if (flags3 & RF3_AURA_COLD)
	{
		hook_c_roff(TERM_BLUE, format(
			_("%^sɹޤƤ롣", "%^s is surrounded by ice.  "), wd_he[msex]));
	}
	else if (flags2 & RF2_AURA_ELEC)
	{
		hook_c_roff(TERM_L_BLUE, format(
			_("%^sϥѡޤƤ롣", "%^s is surrounded by electricity.  "), wd_he[msex]));
	}

	if (flags2 & RF2_REFLECTING)
		hooked_roff(format(_("%^sμʸķ֤", "%^s reflects bolt spells.  "), wd_he[msex]));

	/* Describe escorts */
	if ((flags1 & RF1_ESCORT) || (flags1 & RF1_ESCORTS) || reinforce)
	{
		hooked_roff(format(
			_("%^s̾ҤȼäƸ롣", "%^s usually appears with escorts.  "), wd_he[msex]));

		if(reinforce)
		{
			hooked_roff(_("Ҥι", "These escorts"));
			if((flags1 & RF1_ESCORT) || (flags1 & RF1_ESCORTS))
			{
				hooked_roff(_("ʤȤ", " at the least"));
			}
#ifndef JP
			hooked_roff(" contain ");
#endif			
			for(n = 0; n < 6; n++)
			{
				if(r_ptr->reinforce_id[n] && r_ptr->reinforce_dd[n] && r_ptr->reinforce_ds[n])
				{
					monster_race *rf_ptr = &r_info[r_ptr->reinforce_id[n]];
					if(rf_ptr->flags1 & RF1_UNIQUE)
					{
						hooked_roff(format(_("%s", ", %s"), r_name + rf_ptr->name));
					}
					else
					{
#ifdef JP
						hooked_roff(format(" %dd%d Τ%s", r_ptr->reinforce_dd[n], r_ptr->reinforce_ds[n],
							r_name + rf_ptr->name));
#else
						bool plural = (r_ptr->reinforce_dd[n] * r_ptr->reinforce_ds[n] > 1);
						char name[80];
						strcpy(name, r_name + rf_ptr->name);
						if(plural) plural_aux(name);
						hooked_roff(format(",%dd%d %s", r_ptr->reinforce_dd[n], r_ptr->reinforce_ds[n], name));
#endif
					}
				}
			}
			hooked_roff(_("ΩäƤ롣", "."));
		}
	}

	/* Describe friends */
	else if (flags1 & RF1_FRIENDS)
	{
		hooked_roff(format(_("%^s̾ｸĤǸ롣", "%^s usually appears in groups.  "), wd_he[msex]));
	}


	/* Collect inate attacks */
	vn = 0;
	if (flags4 & RF4_SHRIEK)  { vp[vn] = _("Ĥǽ", "shriek for help"); color[vn++] = TERM_L_WHITE; }
	if (flags4 & RF4_ROCKET)  { vp[vn] = _("åȤȯͤ", "shoot a rocket"); color[vn++] = TERM_UMBER; }
	if (flags4 & RF4_SHOOT)
	{ 
		for (r = 0, m = 0; m < 4; m++)
		{
			if (r_ptr->blow[m].method == RBM_SHOOT)
			{
				sprintf(shoot_power, _(" %dd%d μͷ򤹤","fire an arrow (Power:%dd%d)"), r_ptr->blow[m].d_side, r_ptr->blow[m].d_dice);
				vp[vn] = shoot_power; color[vn++] = TERM_UMBER;
				break;
			}
		}		
	}
	if (flags6 & (RF6_SPECIAL)) { vp[vn] = _("̤ʹư򤹤", "do something"); color[vn++] = TERM_VIOLET; }

	/* Describe inate attacks */
	if (vn)
	{
		/* Intro */
		hooked_roff(format(_("%^s", "%^s"), wd_he[msex]));


		/* Scan */
		for (n = 0; n < vn; n++)
		{
#ifdef JP
			if (n != vn - 1)
			{
				jverb(vp[n], jverb_buf, JVERB_OR);
				hook_c_roff(color[n], jverb_buf);
				hook_c_roff(color[n], "");
				hooked_roff("");
			}
			else hook_c_roff(color[n], vp[n]);
#else
			/* Intro */
			if (n == 0) hooked_roff(" may ");
			else if (n < vn - 1) hooked_roff(", ");
			else hooked_roff(" or ");

			/* Dump */
			hook_c_roff(color[n], vp[n]);
#endif

		}

		/* End */
		hooked_roff(_("Ȥ롣", ".  "));
	}


	/* Collect breaths */
	vn = 0;
	if (flags4 & (RF4_BR_ACID))		{ vp[vn] = _("", "acid"); color[vn++] = TERM_GREEN; }
	if (flags4 & (RF4_BR_ELEC))		{ vp[vn] = _("", "lightning"); color[vn++] = TERM_BLUE; }
	if (flags4 & (RF4_BR_FIRE))		{ vp[vn] = _("б", "fire"); color[vn++] = TERM_RED; }
	if (flags4 & (RF4_BR_COLD))		{ vp[vn] = _("䵤", "frost"); color[vn++] = TERM_L_WHITE; }
	if (flags4 & (RF4_BR_POIS))		{ vp[vn] = _("", "poison"); color[vn++] = TERM_L_GREEN; }
	if (flags4 & (RF4_BR_NETH))		{ vp[vn] = _("Ϲ", "nether"); color[vn++] = TERM_L_DARK; }
	if (flags4 & (RF4_BR_LITE))		{ vp[vn] = _("", "light"); color[vn++] = TERM_YELLOW; }
	if (flags4 & (RF4_BR_DARK))		{ vp[vn] = _("Ź", "darkness"); color[vn++] = TERM_L_DARK; }
	if (flags4 & (RF4_BR_CONF))		{ vp[vn] = _("", "confusion"); color[vn++] = TERM_L_UMBER; }
	if (flags4 & (RF4_BR_SOUN))		{ vp[vn] = _("첻", "sound"); color[vn++] = TERM_ORANGE; }
	if (flags4 & (RF4_BR_CHAO))		{ vp[vn] = _("", "chaos"); color[vn++] = TERM_VIOLET; }
	if (flags4 & (RF4_BR_DISE))		{ vp[vn] = _("", "disenchantment"); color[vn++] = TERM_VIOLET; }
	if (flags4 & (RF4_BR_NEXU))		{ vp[vn] = _("̺", "nexus"); color[vn++] = TERM_VIOLET; }
	if (flags4 & (RF4_BR_TIME))		{ vp[vn] = _("ֵž", "time"); color[vn++] = TERM_L_BLUE; }
	if (flags4 & (RF4_BR_INER))		{ vp[vn] = _("", "inertia"); color[vn++] = TERM_SLATE; }
	if (flags4 & (RF4_BR_GRAV))		{ vp[vn] = _("", "gravity"); color[vn++] = TERM_SLATE; }
	if (flags4 & (RF4_BR_SHAR))		{ vp[vn] = _("", "shards"); color[vn++] = TERM_L_UMBER; }
	if (flags4 & (RF4_BR_PLAS))		{ vp[vn] = _("ץ饺", "plasma"); color[vn++] = TERM_L_RED; }
	if (flags4 & (RF4_BR_WALL))		{ vp[vn] = _("ե", "force"); color[vn++] = TERM_UMBER; }
	if (flags4 & (RF4_BR_MANA))		{ vp[vn] = _("", "mana"); color[vn++] = TERM_L_BLUE; }
	if (flags4 & (RF4_BR_NUKE))		{ vp[vn] = _("Ѵʪ", "toxic waste"); color[vn++] = TERM_L_GREEN; }
	if (flags4 & (RF4_BR_DISI))		{ vp[vn] = _("ʬ", "disintegration"); color[vn++] = TERM_SLATE; }

	/* Describe breaths */
	if (vn)
	{
		/* Note breath */
		breath = TRUE;

		/* Intro */
		hooked_roff(format(_("%^s", "%^s"), wd_he[msex]));

		/* Scan */
		for (n = 0; n < vn; n++)
		{
			/* Intro */
#ifdef JP
			if ( n != 0 ) hooked_roff("");
#else
			if (n == 0) hooked_roff(" may breathe ");
			else if (n < vn-1) hooked_roff(", ");
			else hooked_roff(" or ");
#endif


			/* Dump */
			hook_c_roff(color[n], vp[n]);
		}
#ifdef JP
		hooked_roff("Υ֥쥹ǤȤ");
#endif
	}


	/* Collect spells */
	vn = 0;
	if (flags5 & (RF5_BA_ACID))         { vp[vn] = _("åɡܡ", "produce acid balls"); color[vn++] = TERM_GREEN; }
	if (flags5 & (RF5_BA_ELEC))         { vp[vn] = _("ܡ", "produce lightning balls"); color[vn++] = TERM_BLUE; }
	if (flags5 & (RF5_BA_FIRE))         { vp[vn] = _("եܡ", "produce fire balls"); color[vn++] = TERM_RED; }
	if (flags5 & (RF5_BA_COLD))         { vp[vn] = _("ܡ", "produce frost balls"); color[vn++] = TERM_L_WHITE; }
	if (flags5 & (RF5_BA_POIS))         { vp[vn] = _("", "produce poison balls"); color[vn++] = TERM_L_GREEN; }
	if (flags5 & (RF5_BA_NETH))         { vp[vn] = _("Ϲ", "produce nether balls"); color[vn++] = TERM_L_DARK; }
	if (flags5 & (RF5_BA_WATE))         { vp[vn] = _("ܡ", "produce water balls"); color[vn++] = TERM_BLUE; }
	if (flags4 & (RF4_BA_NUKE))         { vp[vn] = _("ǽ", "produce balls of radiation"); color[vn++] = TERM_L_GREEN; }
	if (flags5 & (RF5_BA_MANA))         { vp[vn] = _("Ϥ", "invoke mana storms"); color[vn++] = TERM_L_BLUE; }
	if (flags5 & (RF5_BA_DARK))         { vp[vn] = _("Ź", "invoke darkness storms"); color[vn++] = TERM_L_DARK; }
	if (flags5 & (RF5_BA_LITE))         { vp[vn] = _("С", "invoke starburst"); color[vn++] = TERM_YELLOW; }
	if (flags4 & (RF4_BA_CHAO))         { vp[vn] = _("륹", "invoke raw Logrus"); color[vn++] = TERM_VIOLET; }
	if (flags6 & (RF6_HAND_DOOM))       { vp[vn] = _("Ǥμ", "invoke the Hand of Doom"); color[vn++] = TERM_VIOLET; }
	if (flags6 & (RF6_PSY_SPEAR))       { vp[vn] = _("η", "psycho-spear"); color[vn++] = TERM_YELLOW; }
	if (flags5 & (RF5_DRAIN_MANA))      { vp[vn] = _("ϵۼ", "drain mana"); color[vn++] = TERM_SLATE; }
	if (flags5 & (RF5_MIND_BLAST))      { vp[vn] = _("", "cause mind blasting"); color[vn++] = TERM_L_RED; }
	if (flags5 & (RF5_BRAIN_SMASH))     { vp[vn] = _("Ǿ", "cause brain smashing"); color[vn++] = TERM_RED; }
	if (flags5 & (RF5_CAUSE_1))         { vp[vn] = _("ڽܼ", "cause light wounds and cursing"); color[vn++] = TERM_L_WHITE; }
	if (flags5 & (RF5_CAUSE_2))         { vp[vn] = _("Žܼ", "cause serious wounds and cursing"); color[vn++] = TERM_L_WHITE; }
	if (flags5 & (RF5_CAUSE_3))         { vp[vn] = _("ܼ̿", "cause critical wounds and cursing"); color[vn++] = TERM_L_WHITE; }
	if (flags5 & (RF5_CAUSE_4))         { vp[vn] = _("빦ͤ", "cause mortal wounds"); color[vn++] = TERM_L_WHITE; }
	if (flags5 & (RF5_BO_ACID))         { vp[vn] = _("åɡܥ", "produce acid bolts"); color[vn++] = TERM_GREEN; }
	if (flags5 & (RF5_BO_ELEC))         { vp[vn] = _("ܥ", "produce lightning bolts"); color[vn++] = TERM_BLUE; }
	if (flags5 & (RF5_BO_FIRE))         { vp[vn] = _("եܥ", "produce fire bolts"); color[vn++] = TERM_RED; }
	if (flags5 & (RF5_BO_COLD))         { vp[vn] = _("ܥ", "produce frost bolts"); color[vn++] = TERM_L_WHITE; }
	if (flags5 & (RF5_BO_NETH))         { vp[vn] = _("Ϲ", "produce nether bolts"); color[vn++] = TERM_L_DARK; }
	if (flags5 & (RF5_BO_WATE))         { vp[vn] = _("ܥ", "produce water bolts"); color[vn++] = TERM_BLUE; }
	if (flags5 & (RF5_BO_MANA))         { vp[vn] = _("Ϥ", "produce mana bolts"); color[vn++] = TERM_L_BLUE; }
	if (flags5 & (RF5_BO_PLAS))         { vp[vn] = _("ץ饺ޡܥ", "produce plasma bolts"); color[vn++] = TERM_L_RED; }
	if (flags5 & (RF5_BO_ICEE))         { vp[vn] = _("˴", "produce ice bolts"); color[vn++] = TERM_WHITE; }
	if (flags5 & (RF5_MISSILE))         { vp[vn] = _("ޥåߥ", "produce magic missiles"); color[vn++] = TERM_SLATE; }
	if (flags5 & (RF5_SCARE))           { vp[vn] = _("", "terrify"); color[vn++] = TERM_SLATE; }
	if (flags5 & (RF5_BLIND))           { vp[vn] = _("ܤޤ", "blind"); color[vn++] = TERM_L_DARK; }
	if (flags5 & (RF5_CONF))            { vp[vn] = _("", "confuse"); color[vn++] = TERM_L_UMBER; }
	if (flags5 & (RF5_SLOW))            { vp[vn] = _("®", "slow"); color[vn++] = TERM_UMBER; }
	if (flags5 & (RF5_HOLD))            { vp[vn] = _("", "paralyze"); color[vn++] = TERM_RED; }
	if (flags6 & (RF6_HASTE))           { vp[vn] = _("®", "haste-self"); color[vn++] = TERM_L_GREEN; }
	if (flags6 & (RF6_HEAL))            { vp[vn] = _("", "heal-self"); color[vn++] = TERM_WHITE; }
	if (flags6 & (RF6_INVULNER))        { vp[vn] = _("̵Ũ", "make invulnerable"); color[vn++] = TERM_WHITE; }
	if (flags4 & RF4_DISPEL)            { vp[vn] = _("Ͼõ", "dispel-magic"); color[vn++] = TERM_L_WHITE; }
	if (flags6 & (RF6_BLINK))           { vp[vn] = _("硼ȥƥݡ", "blink-self"); color[vn++] = TERM_UMBER; }
	if (flags6 & (RF6_TPORT))           { vp[vn] = _("ƥݡ", "teleport-self"); color[vn++] = TERM_ORANGE; }
	if (flags6 & (RF6_WORLD))           { vp[vn] = _("ߤ", "stop the time"); color[vn++] = TERM_L_BLUE; }
	if (flags6 & (RF6_TELE_TO))         { vp[vn] = _("ƥݡȥХå", "teleport to"); color[vn++] = TERM_L_UMBER; }
	if (flags6 & (RF6_TELE_AWAY))       { vp[vn] = _("ƥݡȥ", "teleport away"); color[vn++] = TERM_UMBER; }
	if (flags6 & (RF6_TELE_LEVEL))      { vp[vn] = _("ƥݡȡ٥", "teleport level"); color[vn++] = TERM_ORANGE; }

	if (flags6 & (RF6_DARKNESS))
	{
		if ((p_ptr->pclass != CLASS_NINJA) || (r_ptr->flags3 & (RF3_UNDEAD | RF3_HURT_LITE)) || (r_ptr->flags7 & RF7_DARK_MASK))
		{
			vp[vn] = _("Ű", "create darkness"); color[vn++] = TERM_L_DARK;
		}
		else
		{
			vp[vn] = _("", "create light"); color[vn++] = TERM_YELLOW;
		}
	}

	if (flags6 & (RF6_TRAPS))           { vp[vn] = _("ȥå", "create traps"); color[vn++] = TERM_BLUE; }
	if (flags6 & (RF6_FORGET))          { vp[vn] = _("õ", "cause amnesia"); color[vn++] = TERM_BLUE; }
	if (flags6 & (RF6_RAISE_DEAD))      { vp[vn] = _("", "raise dead"); color[vn++] = TERM_RED; }
	if (flags6 & (RF6_S_MONSTER))       { vp[vn] = _("󥹥ξ", "summon a monster"); color[vn++] = TERM_SLATE; }
	if (flags6 & (RF6_S_MONSTERS))      { vp[vn] = _("󥹥ʣ", "summon monsters"); color[vn++] = TERM_L_WHITE; }
	if (flags6 & (RF6_S_KIN))           { vp[vn] = _("߱群", "summon aid"); color[vn++] = TERM_ORANGE; }
	if (flags6 & (RF6_S_ANT))           { vp[vn] = _("꾤", "summon ants"); color[vn++] = TERM_RED; }
	if (flags6 & (RF6_S_SPIDER))        { vp[vn] = _("⾤", "summon spiders"); color[vn++] = TERM_L_DARK; }
	if (flags6 & (RF6_S_HOUND))         { vp[vn] = _("ϥɾ", "summon hounds"); color[vn++] = TERM_L_UMBER; }
	if (flags6 & (RF6_S_HYDRA))         { vp[vn] = _("ҥɥ龤", "summon hydras"); color[vn++] = TERM_L_GREEN; }
	if (flags6 & (RF6_S_ANGEL))         { vp[vn] = _("ŷȰξ", "summon an angel"); color[vn++] = TERM_YELLOW; }
	if (flags6 & (RF6_S_DEMON))         { vp[vn] = _("ǡξ", "summon a demon"); color[vn++] = TERM_L_RED; }
	if (flags6 & (RF6_S_UNDEAD))        { vp[vn] = _("ǥåɰξ", "summon an undead"); color[vn++] = TERM_L_DARK; }
	if (flags6 & (RF6_S_DRAGON))        { vp[vn] = _("ɥ饴ξ", "summon a dragon"); color[vn++] = TERM_ORANGE; }
	if (flags6 & (RF6_S_HI_UNDEAD))     { vp[vn] = _("Ϥʥǥåɾ", "summon Greater Undead"); color[vn++] = TERM_L_DARK; }
	if (flags6 & (RF6_S_HI_DRAGON))     { vp[vn] = _("ɥ饴󾤴", "summon Ancient Dragons"); color[vn++] = TERM_ORANGE; }	
	if (flags6 & (RF6_S_CYBER))         { vp[vn] = _("Сǡ󾤴", "summon Cyberdemons"); color[vn++] = TERM_UMBER; }
	if (flags6 & (RF6_S_AMBERITES))     { vp[vn] = _("Сβ²", "summon Lords of Amber"); color[vn++] = TERM_VIOLET; }
	if (flags6 & (RF6_S_UNIQUE))        { vp[vn] = _("ˡ󥹥", "summon Unique Monsters"); color[vn++] = TERM_VIOLET; }


	/* Describe spells */
	if (vn)
	{
		/* Note magic */
		magic = TRUE;

		/* Intro */
		if (breath)
		{
			hooked_roff(_("ʤ", ", and is also"));
		}
		else
		{
			hooked_roff(format(_("%^s", "%^s is"), wd_he[msex]));
		}

#ifdef JP
		/* Adverb */
		if (flags2 & (RF2_SMART)) hook_c_roff(TERM_YELLOW, "ŪΤ");

		/* Verb Phrase */
		hooked_roff("ˡȤȤǤ");
#else
		/* Verb Phrase */
		hooked_roff(" magical, casting spells");

		/* Adverb */
		if (flags2 & RF2_SMART) hook_c_roff(TERM_YELLOW, " intelligently");
#endif


		/* Scan */
		for (n = 0; n < vn; n++)
		{
			/* Intro */
#ifdef JP
			if ( n != 0 ) hooked_roff("");
#else
			if (n == 0) hooked_roff(" which ");
			else if (n < vn-1) hooked_roff(", ");
			else hooked_roff(" or ");
#endif


			/* Dump */
			hook_c_roff(color[n], vp[n]);
		}
#ifdef JP
		hooked_roff("μʸ򾧤뤳Ȥ");
#endif
	}


	/* End the sentence about inate/other spells */
	if (breath || magic)
	{
		/* Total casting */
		m = r_ptr->r_cast_spell;

		/* Average frequency */
		n = r_ptr->freq_spell;

		/* Describe the spell frequency */
		if (m > 100 || know_everything)
		{
			hooked_roff(format(
				_("(Ψ:1/%d)", "; 1 time in %d"), 100 / n));
		}

		/* Guess at the frequency */
		else if (m)
		{
			n = ((n + 9) / 10) * 10;
			hooked_roff(format(
				_("(Ψ:1/%d)", "; about 1 time in %d"), 100 / n));
		}

		/* End this sentence */
		hooked_roff(_("", ".  "));
	}

	/* Describe monster "toughness" */
	if (know_armour(r_idx))
	{
		/* Armor */
		hooked_roff(format(
			_("%^s AC%d ɸϤ", "%^s has an armor rating of %d"),
			    wd_he[msex], r_ptr->ac));

		/* Maximized hitpoints */
		if ((flags1 & RF1_FORCE_MAXHP) || (r_ptr->hside == 1))
		{
			u32b hp = r_ptr->hdice * (nightmare ? 2 : 1) * r_ptr->hside;
			hooked_roff(format(
				_(" %d Ϥ롣", " and a life rating of %d.  "),
				    (s16b)MIN(30000, hp)));
		}

		/* Variable hitpoints */
		else
		{
			hooked_roff(format(
				_(" %dd%d Ϥ롣", " and a life rating of %dd%d.  "),
				    r_ptr->hdice * (nightmare ? 2 : 1), r_ptr->hside));
		}
	}



	/* Collect special abilities. */
	vn = 0;
	if (flags7 & (RF7_HAS_LITE_1 | RF7_HAS_LITE_2)) { vp[vn] = _("󥸥Ȥ餹", "illuminate the dungeon");     color[vn++] = TERM_WHITE; }
	if (flags7 & (RF7_HAS_DARK_1 | RF7_HAS_DARK_2)) { vp[vn] = _("󥸥Ť", "darken the dungeon");   color[vn++] = TERM_L_DARK; }
	if (flags2 & RF2_OPEN_DOOR) { vp[vn] = _("ɥ򳫤", "open doors"); color[vn++] = TERM_WHITE; }
	if (flags2 & RF2_BASH_DOOR) { vp[vn] = _("ɥǤˤ", "bash down doors"); color[vn++] = TERM_WHITE; }
	if (flags7 & RF7_CAN_FLY)  { vp[vn] = _("", "fly"); color[vn++] = TERM_WHITE; }
	if (flags7 & RF7_CAN_SWIM)   { vp[vn] = _("Ϥ", "swim"); color[vn++] = TERM_WHITE; }
	if (flags2 & RF2_PASS_WALL) { vp[vn] = _("ɤ򤹤ȴ", "pass through walls"); color[vn++] = TERM_WHITE; }
	if (flags2 & RF2_KILL_WALL) { vp[vn] = _("ɤ򷡤ʤ", "bore through walls"); color[vn++] = TERM_WHITE; }
	if (flags2 & RF2_MOVE_BODY) { vp[vn] = _("夤󥹥򲡤Τ", "push past weaker monsters"); color[vn++] = TERM_WHITE; }
	if (flags2 & RF2_KILL_BODY) { vp[vn] = _("夤󥹥ݤ", "destroy weaker monsters"); color[vn++] = TERM_WHITE; }
	if (flags2 & RF2_TAKE_ITEM) { vp[vn] = _("ƥ򽦤", "pick up objects"); color[vn++] = TERM_WHITE; }
	if (flags2 & RF2_KILL_ITEM) { vp[vn] = _("ƥ", "destroy objects"); color[vn++] = TERM_WHITE; }


	/* Describe special abilities. */
	if (vn)
	{
		/* Intro */
		hooked_roff(format(_("%^s", "%^s"), wd_he[msex]));

		/* Scan */
		for (n = 0; n < vn; n++)
		{
			/* Intro */
#ifdef JP
			if (n != vn - 1)
			{
				jverb(vp[n], jverb_buf, JVERB_AND);
				hook_c_roff(color[n], jverb_buf);
				hooked_roff("");
			}
			else hook_c_roff(color[n], vp[n]);
#else
			if (n == 0) hooked_roff(" can ");
			else if (n < vn - 1) hooked_roff(", ");
			else hooked_roff(" and ");

			/* Dump */
			hook_c_roff(color[n], vp[n]);
#endif

		}

		/* End */
		hooked_roff(_("ȤǤ롣", ".  "));

	}
	
	/* Aquatic */
	if (flags7 & RF7_AQUATIC)
	{
		hooked_roff(format(_("%^sϿǤ롣", "%^s lives in water.  "), wd_he[msex]));
	}

	/* Describe special abilities. */
	if (flags7 & (RF7_SELF_LITE_1 | RF7_SELF_LITE_2))
	{
		hooked_roff(format(_("%^sϸäƤ롣", "%^s is shining.  "), wd_he[msex]));
	}
	if (flags7 & (RF7_SELF_DARK_1 | RF7_SELF_DARK_2))
	{
		hook_c_roff(TERM_L_DARK, format(_("%^sϰŹޤƤ롣", "%^s is surrounded by darkness.  "), wd_he[msex]));
	}
	if (flags2 & RF2_INVISIBLE)
	{
		hooked_roff(format(_("%^sƩܤ˸ʤ", "%^s is invisible.  "), wd_he[msex]));
	}
	if (flags2 & RF2_COLD_BLOOD)
	{
		hooked_roff(format(_("%^sưʪǤ롣", "%^s is cold blooded.  "), wd_he[msex]));
	}
	if (flags2 & RF2_EMPTY_MIND)
	{
		hooked_roff(format(_("%^sϥƥѥǤϴΤǤʤ", "%^s is not detected by telepathy.  "), wd_he[msex]));
	}
	else if (flags2 & RF2_WEIRD_MIND)
	{
		hooked_roff(format(_("%^sϤޤ˥ƥѥǴΤǤ롣", "%^s is rarely detected by telepathy.  "), wd_he[msex]));
	}
	if (flags2 & RF2_MULTIPLY)
	{
		hook_c_roff(TERM_L_UMBER, format(_("%^sȯŪ롣", "%^s breeds explosively.  "), wd_he[msex]));
	}
	if (flags2 & RF2_REGENERATE)
	{
		hook_c_roff(TERM_L_WHITE, format(_("%^s᤯Ϥ롣", "%^s regenerates quickly.  "), wd_he[msex]));
	}
	if (flags7 & RF7_RIDING)
	{
		hook_c_roff(TERM_SLATE, format(_("%^s˾뤳ȤǤ롣", "%^s is suitable for riding.  "), wd_he[msex]));
	}


	/* Collect susceptibilities */
	vn = 0;
	if (flags3 & RF3_HURT_ROCK) { vp[vn] = _("", "rock remover"); color[vn++] = TERM_UMBER; }
	if (flags3 & RF3_HURT_LITE) { vp[vn] = _("뤤", "bright light"); color[vn++] = TERM_YELLOW; }
	if (flags3 & RF3_HURT_FIRE) { vp[vn] = _("", "fire"); color[vn++] = TERM_RED; }
	if (flags3 & RF3_HURT_COLD) { vp[vn] = _("䵤", "cold"); color[vn++] = TERM_L_WHITE; }


	/* Describe susceptibilities */
	if (vn)
	{
		/* Intro */
		hooked_roff(format(_("%^sˤ", "%^s"), wd_he[msex]));

		/* Scan */
		for (n = 0; n < vn; n++)
		{
			/* Intro */
#ifdef JP
			if ( n != 0 ) hooked_roff("");
#else
			if (n == 0) hooked_roff(" is hurt by ");
			else if (n < vn-1) hooked_roff(", ");
			else hooked_roff(" and ");
#endif


			/* Dump */
			hook_c_roff(color[n], vp[n]);
		}

		/* End */
		hooked_roff(_("ǥ᡼Ϳ롣", ".  "));
	}


	/* Collect immunities */
	vn = 0;
	if (flagsr & RFR_IM_ACID) { vp[vn] = _("", "acid"); color[vn++] = TERM_GREEN; }
	if (flagsr & RFR_IM_ELEC) { vp[vn] = _("", "lightning"); color[vn++] = TERM_BLUE; }
	if (flagsr & RFR_IM_FIRE) { vp[vn] = _("", "fire"); color[vn++] = TERM_RED; }
	if (flagsr & RFR_IM_COLD) { vp[vn] = _("䵤", "cold"); color[vn++] = TERM_L_WHITE; }
	if (flagsr & RFR_IM_POIS) { vp[vn] = _("", "poison"); color[vn++] = TERM_L_GREEN; }


	/* Collect resistances */
	if (flagsr & RFR_RES_LITE) { vp[vn] = _("", "light"); color[vn++] = TERM_YELLOW; }
	if (flagsr & RFR_RES_DARK) { vp[vn] = _("Ź", "dark"); color[vn++] = TERM_L_DARK; }
	if (flagsr & RFR_RES_NETH) { vp[vn] = _("Ϲ", "nether"); color[vn++] = TERM_L_DARK; }
	if (flagsr & RFR_RES_WATE) { vp[vn] = _("", "water"); color[vn++] = TERM_BLUE; }
	if (flagsr & RFR_RES_PLAS) { vp[vn] = _("ץ饺", "plasma"); color[vn++] = TERM_L_RED; }
	if (flagsr & RFR_RES_SHAR) { vp[vn] = _("", "shards"); color[vn++] = TERM_L_UMBER; }
	if (flagsr & RFR_RES_SOUN) { vp[vn] = _("첻", "sound"); color[vn++] = TERM_ORANGE; }
	if (flagsr & RFR_RES_CHAO) { vp[vn] = _("", "chaos"); color[vn++] = TERM_VIOLET; }
	if (flagsr & RFR_RES_NEXU) { vp[vn] = _("̺", "nexus"); color[vn++] = TERM_VIOLET; }
	if (flagsr & RFR_RES_DISE) { vp[vn] = _("", "disenchantment"); color[vn++] = TERM_VIOLET; }
	if (flagsr & RFR_RES_WALL) { vp[vn] = _("ե", "force"); color[vn++] = TERM_UMBER; }
	if (flagsr & RFR_RES_INER) { vp[vn] = _("", "inertia"); color[vn++] = TERM_SLATE; }
	if (flagsr & RFR_RES_TIME) { vp[vn] = _("ֵž", "time"); color[vn++] = TERM_L_BLUE; }
	if (flagsr & RFR_RES_GRAV) { vp[vn] = _("", "gravity"); color[vn++] = TERM_SLATE; }
	if (flagsr & RFR_RES_ALL) { vp[vn] = _("빶", "all"); color[vn++] = TERM_YELLOW; }
	if ((flagsr & RFR_RES_TELE) && !(r_ptr->flags1 & RF1_UNIQUE)) { vp[vn] = _("ƥݡ", "teleportation"); color[vn++] = TERM_ORANGE; }

	/* Describe immunities and resistances */
	if (vn)
	{
		/* Intro */
		hooked_roff(format(_("%^s", "%^s"), wd_he[msex]));

		/* Scan */
		for (n = 0; n < vn; n++)
		{
			/* Intro */
#ifdef JP
			if ( n != 0 ) hooked_roff("");
#else
			if (n == 0) hooked_roff(" resists ");
			else if (n < vn-1) hooked_roff(", ");
			else hooked_roff(" and ");
#endif


			/* Dump */
			hook_c_roff(color[n], vp[n]);
		}

		/* End */
		hooked_roff(_("äƤ롣", ".  "));
	}


	if ((r_ptr->r_xtra1 & MR1_SINKA) || know_everything)
	{
		if (r_ptr->next_r_idx)
		{
			hooked_roff(format(_("%^sϷиѤȡ", "%^s will evolve into "), wd_he[msex]));
			hook_c_roff(TERM_YELLOW, format("%s", r_name+r_info[r_ptr->next_r_idx].name));
			hooked_roff(format(
				_(("˿ʲ롣"), 
				  (" when %s gets enugh experience.  ", wd_he[msex]))));
		}
		else if (!(r_ptr->flags1 & RF1_UNIQUE))
		{
			hooked_roff(format(_("%sϿʲʤ", "%s won't evolve.  "), wd_he[msex]));
		}
	}

	/* Collect non-effects */
	vn = 0;
	if (flags3 & RF3_NO_STUN)  { vp[vn] = _("ۯ۰Ȥʤ", "stunned"); color[vn++] = TERM_ORANGE; }
	if (flags3 & RF3_NO_FEAR)  { vp[vn] = _("ݤ򴶤ʤ", "frightened"); color[vn++] = TERM_SLATE; }
	if (flags3 & RF3_NO_CONF)  { vp[vn] = _("𤷤ʤ", "confused"); color[vn++] = TERM_L_UMBER; }
	if (flags3 & RF3_NO_SLEEP) { vp[vn] = _("̲餵ʤ", "slept"); color[vn++] = TERM_BLUE; }
	if ((flagsr & RFR_RES_TELE) && (r_ptr->flags1 & RF1_UNIQUE)) { vp[vn] = _("ƥݡȤʤ", "teleported"); color[vn++] = TERM_ORANGE; }

	/* Describe non-effects */
	if (vn)
	{
		/* Intro */
		hooked_roff(format(
			_("%^s", "%^s"), wd_he[msex]));

		/* Scan */
		for (n = 0; n < vn; n++)
		{
			/* Intro */
#ifdef JP
			if ( n != 0 ) hooked_roff("");
#else
			if (n == 0) hooked_roff(" cannot be ");
			else if (n < vn - 1) hooked_roff(", ");
			else hooked_roff(" or ");
#endif


			/* Dump */
			hook_c_roff(color[n], vp[n]);
		}

		/* End */
		hooked_roff(_("", ".  "));
	}


	/* Do we know how aware it is? */
	if ((((int)r_ptr->r_wake * (int)r_ptr->r_wake) > r_ptr->sleep) ||
		  (r_ptr->r_ignore == MAX_UCHAR) ||
	    (r_ptr->sleep == 0 && r_ptr->r_tkills >= 10) || know_everything)
	{
		cptr act;

		if (r_ptr->sleep > 200)
		{
			act = _("̵뤷Ǥ뤬", "prefers to ignore");
		}
		else if (r_ptr->sleep > 95)
		{
			act = _("ФƤۤȤդʧʤ", "pays very little attention to");
		}
		else if (r_ptr->sleep > 75)
		{
			act = _("ФƤޤդʧʤ", "pays little attention to");
		}
		else if (r_ptr->sleep > 45)
		{
			act = _("򸫲ᤴǤ뤬", "tends to overlook");
		}
		else if (r_ptr->sleep > 25)
		{
			act = _("ۤξϸƤ", "takes quite a while to see");
		}
		else if (r_ptr->sleep > 10)
		{
			act = _("򤷤Ф餯ϸƤ", "takes a while to see");
		}
		else if (r_ptr->sleep > 5)
		{
			act = _("ʬտƤ", "is fairly observant of");
		}
		else if (r_ptr->sleep > 3)
		{
			act = _("տƤ", "is observant of");
		}
		else if (r_ptr->sleep > 1)
		{
			act = _("򤫤ʤտƤ", "is very observant of");
		}
		else if (r_ptr->sleep > 0)
		{
			act = _("ٲƤ", "is vigilant for");
		}
		else
		{
			act = _("򤫤ʤٲƤ", "is ever vigilant for");
		}

		hooked_roff(
			_(format("%^sϿ%s %d ե褫鿯Ԥ˵դȤ롣", wd_he[msex], act, 10 * r_ptr->aaf),
			  format("%^s %s intruders, which %s may notice from %d feet.  ", wd_he[msex], act, wd_he[msex], 10 * r_ptr->aaf)));
	}


	/* Drops gold and/or items */
	if (drop_gold || drop_item)
	{
		/* Intro */
		hooked_roff(format(
			_("%^s", "%^s may carry"), wd_he[msex]));
#ifndef JP
		/* No "n" needed */
		sin = FALSE;
#endif


		/* Count maximum drop */
		n = MAX(drop_gold, drop_item);

		/* One drop (may need an "n") */
		if (n == 1)
		{
			hooked_roff(_("Ĥ", " a"));
#ifndef JP
			sin = TRUE;
#endif
		}

		/* Two drops */
		else if (n == 2)
		{
			hooked_roff(
				_("ĤĤ", " one or two"));
		}

		/* Many drops */
		else
		{
			hooked_roff(format(
				_(" %d ĤޤǤ", " up to %d"), n));
		}


		/* Great */
		if (flags1 & RF1_DROP_GREAT)
		{
			p = _("̤", " exceptional");
		}

		/* Good (no "n" needed) */
		else if (flags1 & RF1_DROP_GOOD)
		{
			p = _("", " good");
#ifndef JP
			sin = FALSE;
#endif
		}

		/* Okay */
		else
		{
			p = NULL;
		}


		/* Objects */
		if (drop_item)
		{
			/* Handle singular "an" */
#ifndef JP
			if (sin) hooked_roff("n");
			sin = FALSE;
#endif

			/* Dump "object(s)" */
			if (p) hooked_roff(p);
			hooked_roff(
				_("ƥ", " object"));

#ifndef JP
			if (n != 1) hooked_roff("s");
#endif

			/* Conjunction replaces variety, if needed for "gold" below */
			p = _("", " or");
		}

		/* Treasures */
		if (drop_gold)
		{
#ifndef JP
			/* Cancel prefix */
			if (!p) sin = FALSE;

			/* Handle singular "an" */
			if (sin) hooked_roff("n");
			sin = FALSE;
#endif

			/* Dump "treasure(s)" */
			if (p) hooked_roff(p);
			hooked_roff(_("", " treasure"));
#ifndef JP
			if (n != 1) hooked_roff("s");
#endif

		}

		/* End this sentence */
		hooked_roff(_("äƤ뤳Ȥ롣", ".  "));
	}


	/* Count the number of "known" attacks */
	for (n = 0, m = 0; m < 4; m++)
	{
		/* Skip non-attacks */
		if (!r_ptr->blow[m].method) continue;
		if (r_ptr->blow[m].method == RBM_SHOOT) continue;

		/* Count known attacks */
		if (r_ptr->r_blows[m] || know_everything) n++;
	}

	/* Examine (and count) the actual attacks */
	for (r = 0, m = 0; m < 4; m++)
	{
		int method, effect, d1, d2;

		/* Skip non-attacks */
		if (!r_ptr->blow[m].method) continue;
		if (r_ptr->blow[m].method == RBM_SHOOT) continue;

		/* Skip unknown attacks */
		if (!r_ptr->r_blows[m] && !know_everything) continue;

		/* Extract the attack info */
		method = r_ptr->blow[m].method;
		effect = r_ptr->blow[m].effect;
		d1 = r_ptr->blow[m].d_dice;
		d2 = r_ptr->blow[m].d_side;

		/* No method yet */
		p = NULL;

		/* Acquire the method */
		switch (method)
		{
			case RBM_HIT:		p = _("", "hit"); break;
			case RBM_TOUCH:		p = _("", "touch"); break;
			case RBM_PUNCH:		p = _("ѥ", "punch"); break;
			case RBM_KICK:		p = _("", "kick"); break;
			case RBM_CLAW:		p = _("Ҥä", "claw"); break;
			case RBM_BITE:		p = _("", "bite"); break;
			case RBM_STING:		p = _("ɤ", "sting"); break;
			case RBM_SLASH:		p = _("¤", "slash"); break;
			case RBM_BUTT:		p = _("Ѥͤ", "butt"); break;
			case RBM_CRUSH:		p = _("ꤹ", "crush"); break;
			case RBM_ENGULF:	p = _("߹", "engulf"); break;
			case RBM_CHARGE: 	p = _("褳", "charge"); break;
			case RBM_CRAWL:		p = _("Τξ礤", "crawl on you"); break;
			case RBM_DROOL:		p = _("򤿤餹", "drool on you"); break;
			case RBM_SPIT:		p = _("ĤФǤ", "spit"); break;
			case RBM_EXPLODE:	p = _("ȯ", "explode"); break;
			case RBM_GAZE:		p = _("ˤ", "gaze"); break;
			case RBM_WAIL:		p = _("㤭", "wail"); break;
			case RBM_SPORE:		p = _("˦ҤФ", "release spores"); break;
			case RBM_XXX4:		break;
			case RBM_BEG:		p = _("򤻤", "beg"); break;
			case RBM_INSULT:	p = _("", "insult"); break;
			case RBM_MOAN:		p = _("᤯", "moan"); break;
			case RBM_SHOW:  	p = _("Τ", "sing"); break;
		}


		/* Default effect */
		q = NULL;

		/* Acquire the effect */
		switch (effect)
		{
			case RBE_SUPERHURT:
			case RBE_HURT:    	q = _("⤹", "attack"); break;
			case RBE_POISON:  	q = _("Ǥ򤯤魯", "poison"); break;
			case RBE_UN_BONUS:	q = _("", "disenchant"); break;
			case RBE_UN_POWER:	q = _("ŶϤۼ", "drain charges"); break;
			case RBE_EAT_GOLD:	q = _("", "steal gold"); break;
			case RBE_EAT_ITEM:	q = _("ƥ", "steal items"); break;
			case RBE_EAT_FOOD:	q = _("ʤο򿩤٤", "eat your food"); break;
			case RBE_EAT_LITE:	q = _("ۼ", "absorb light"); break;
			case RBE_ACID:    	q = _("Ф", "shoot acid"); break;
			case RBE_ELEC:    	q = _("Ť", "electrocute"); break;
			case RBE_FIRE:    	q = _("ǳ䤹", "burn"); break;
			case RBE_COLD:    	q = _("餻", "freeze"); break;
			case RBE_BLIND:   	q = _("ܤˤ", "blind"); break;
			case RBE_CONFUSE: 	q = _("𤵤", "confuse"); break;
			case RBE_TERRIFY: 	q = _("ݤ", "terrify"); break;
			case RBE_PARALYZE:	q = _("㤵", "paralyze"); break;
			case RBE_LOSE_STR:	q = _("Ϥ򸺾", "reduce strength"); break;
			case RBE_LOSE_INT:	q = _("ǽ򸺾", "reduce intelligence"); break;
			case RBE_LOSE_WIS:	q = _("򸺾", "reduce wisdom"); break;
			case RBE_LOSE_DEX:	q = _("Ѥ򸺾", "reduce dexterity"); break;
			case RBE_LOSE_CON:	q = _("ѵϤ򸺾", "reduce constitution"); break;
			case RBE_LOSE_CHR:	q = _("̥Ϥ򸺾", "reduce charisma"); break;
			case RBE_LOSE_ALL:	q = _("ơ򸺾", "reduce all stats"); break;
			case RBE_SHATTER:	q = _("ʴդ", "shatter"); break;
			case RBE_EXP_10:	q = _("иͤ򸺾(10d6+)", "lower experience (by 10d6+)"); break;
			case RBE_EXP_20:	q = _("иͤ򸺾(20d6+)", "lower experience (by 20d6+)"); break;
			case RBE_EXP_40:	q = _("иͤ򸺾(40d6+)", "lower experience (by 40d6+)"); break;
			case RBE_EXP_80:	q = _("иͤ򸺾(80d6+)", "lower experience (by 80d6+)"); break;
			case RBE_DISEASE:	q = _("µˤ", "disease"); break;
			case RBE_TIME:      q = _("֤ꤵ", "time"); break;
			case RBE_DR_LIFE:   q = _("̿Ϥۼ", "drain life"); break;
			case RBE_DR_MANA:   q = _("Ϥå", "drain mana force"); break;
			case RBE_INERTIA:   q = _("®", "slow"); break;
			case RBE_STUN:      q = _("ۯ۰Ȥ", "stun"); break;
		}


#ifdef JP
		if ( r == 0 ) hooked_roff( format("%^s", wd_he[msex]) );

		/***㴳ɽѹ ita ***/

			/* Describe damage (if known) */
		if (d1 && d2 && (know_everything || know_damage(r_idx, m)))
		  {
		    
		    /* Display the damage */
		    hooked_roff(format(" %dd%d ", d1, d2));
		    hooked_roff("Υ᡼");
		  }
		/* Hack -- force a method */
		if (!p) p = "̯ʤȤ򤹤";

		/* Describe the method */
		/* XXYY/XXYY/XX/XX */
		if(q) jverb( p ,jverb_buf, JVERB_TO);
		else if(r!=n-1) jverb( p ,jverb_buf, JVERB_AND);
		else strcpy(jverb_buf, p);

		hooked_roff(jverb_buf);

		/* Describe the effect (if any) */
		if (q)
		{
		  if(r!=n-1) jverb( q,jverb_buf, JVERB_AND);
		  else strcpy(jverb_buf,q); 
		  hooked_roff(jverb_buf);
		}
		if(r!=n-1) hooked_roff("");
#else
		/* Introduce the attack description */
		if (!r)
		{
			hooked_roff(format("%^s can ", wd_he[msex]));
		}
		else if (r < n-1)
		{
			hooked_roff(", ");
		}
		else
		{
			hooked_roff(", and ");
		}


		/* Hack -- force a method */
		if (!p) p = "do something weird";

		/* Describe the method */
		hooked_roff(p);


		/* Describe the effect (if any) */
		if (q)
		{
			/* Describe the attack type */
			hooked_roff(" to ");
			hooked_roff(q);

			/* Describe damage (if known) */
			if (d1 && d2 && (know_everything || know_damage(r_idx, m)))
			{
				/* Display the damage */
				hooked_roff(" with damage");
				hooked_roff(format(" %dd%d", d1, d2));
			}
		}
#endif



		/* Count the attacks as printed */
		r++;
	}

	/* Finish sentence above */
	if (r)
	{
		hooked_roff(_("", ".  "));
	}

	/* Notice lack of attacks */
	else if (flags1 & RF1_NEVER_BLOW)
	{
		hooked_roff(format(
			_("%^sʪŪʹˡʤ",
			  "%^s has no physical attacks.  "), wd_he[msex]));
	}

	/* Or describe the lack of knowledge */
	else
	{
		hooked_roff(format(
			_("%sˤĤƤϲΤʤ",
			  "Nothing is known about %s attack.  "), wd_his[msex]));
	}


	/*
	 * Notice "Quest" monsters, but only if you
	 * already encountered the monster.
	 */
	if ((flags1 & RF1_QUESTOR) && ((r_ptr->r_sights) && (r_ptr->max_num) && ((r_idx == MON_OBERON) || (r_idx == MON_SERPENT))))
	{
		hook_c_roff(TERM_VIOLET, 
			_("ʤϤΥ󥹥򻦤Ȥ˾򴶤Ƥ...",
			  "You feel an intense desire to kill this monster...  "));
	}

	else if (flags7 & RF7_GUARDIAN)
	{
		hook_c_roff(TERM_L_RED, 
			_("Υ󥹥ϥ󥸥μǤ롣",
			  "This monster is the master of a dungeon."));
	}


	/* All done */
	hooked_roff("\n");

}


/*!
 * @brief 󥹥Υإå򵭽Ҥ
 * Hack -- Display the "name" and "attr/chars" of a monster race
 * @param r_idx 󥹥μ²ID
 * @return ʤ
 */
void roff_top(int r_idx)
{
	monster_race	*r_ptr = &r_info[r_idx];

	byte		a1, a2;
	char		c1, c2;


	/* Access the chars */
	c1 = r_ptr->d_char;
	c2 = r_ptr->x_char;

	/* Access the attrs */
	a1 = r_ptr->d_attr;
	a2 = r_ptr->x_attr;


	/* Clear the top line */
	Term_erase(0, 0, 255);

	/* Reset the cursor */
	Term_gotoxy(0, 0);

#ifndef JP
	/* A title (use "The" for non-uniques) */
	if (!(r_ptr->flags1 & RF1_UNIQUE))
	{
		Term_addstr(-1, TERM_WHITE, "The ");
	}
#endif

	/* Dump the name */
	Term_addstr(-1, TERM_WHITE, (r_name + r_ptr->name));

	/* Append the "standard" attr/char info */
	Term_addstr(-1, TERM_WHITE, " ('");
	Term_add_bigch(a1, c1);
	Term_addstr(-1, TERM_WHITE, "')");

	/* Append the "optional" attr/char info */
	Term_addstr(-1, TERM_WHITE, "/('");
	Term_add_bigch(a2, c2);
	Term_addstr(-1, TERM_WHITE, "'):");

	/* Wizards get extra info */
	if (p_ptr->wizard)
	{
		char buf[6];

		sprintf(buf, "%d", r_idx);

		Term_addstr(-1, TERM_WHITE, " (");
		Term_addstr(-1, TERM_L_BLUE, buf);
		Term_addch(TERM_WHITE, ')');
	}
}



/*!
 * @brief  󥹥ɽȶ˲̤õ륵֥롼 /
 * Hack -- describe the given monster race at the top of the screen
 * @param r_idx 󥹥μ²ID
 * @param mode ɽץ
 * @return ʤ
 */
void screen_roff(int r_idx, int mode)
{
	/* Flush messages */
	msg_print(NULL);

	/* Begin recall */
	Term_erase(0, 1, 255);

	hook_c_roff = c_roff;

	/* Recall monster */
	roff_aux(r_idx, mode);

	/* Describe monster */
	roff_top(r_idx);
}




/*!
 * @brief 󥹥θߤΥɥɽ /
 * Hack -- describe the given monster race in the current "term" window
 * @param r_idx 󥹥μ²ID
 * @return ʤ
 */
void display_roff(int r_idx)
{
	int y;

	/* Erase the window */
	for (y = 0; y < Term->hgt; y++)
	{
		/* Erase the line */
		Term_erase(0, y, 255);
	}

	/* Begin recall */
	Term_gotoxy(0, 1);

	hook_c_roff = c_roff;

	/* Recall monster */
	roff_aux(r_idx, 0);

	/* Describe monster */
	roff_top(r_idx);
}


/*!
 * @brief 󥹥ܺپưݥ顼˽Ϥ /
 * Hack -- output description of the given monster race
 * @param r_idx 󥹥μ²ID
 * @param roff_func ϽԤؿݥ
 * @return ʤ
 */
void output_monster_spoiler(int r_idx, void (*roff_func)(byte attr, cptr str))
{
	hook_c_roff = roff_func;

	/* Recall monster */
	roff_aux(r_idx, 0x03);
}


/*!
 * @brief 󥹥󥸥˽и뤫ɤ֤
 * @param r_idx Ƚꤹ󥹥μ²ID
 * @return 󥸥˽иʤTRUE֤
 */
bool mon_hook_dungeon(int r_idx)
{
	monster_race *r_ptr = &r_info[r_idx];

	if (!(r_ptr->flags8 & RF8_WILD_ONLY))
		return TRUE;
	else
	{
		dungeon_info_type *d_ptr = &d_info[dungeon_type];
		if ((d_ptr->mflags8 & RF8_WILD_MOUNTAIN) &&
		    (r_ptr->flags8 & RF8_WILD_MOUNTAIN)) return TRUE;
		return FALSE;
	}
}


/*!
 * @brief 󥹥Τ˽и뤫ɤ֤
 * @param r_idx Ƚꤹ󥹥μ²ID
 * @return Τ˽иʤTRUE֤
 */
static bool mon_hook_ocean(int r_idx)
{
	monster_race *r_ptr = &r_info[r_idx];

	if (r_ptr->flags8 & RF8_WILD_OCEAN)
		return TRUE;
	else
		return FALSE;
}


/*!
 * @brief 󥹥ߤ˽и뤫ɤ֤
 * @param r_idx Ƚꤹ󥹥μ²ID
 * @return ߤ˽иʤTRUE֤
 */
static bool mon_hook_shore(int r_idx)
{
	monster_race *r_ptr = &r_info[r_idx];

	if (r_ptr->flags8 & RF8_WILD_SHORE)
		return TRUE;
	else
		return FALSE;
}


/*!
 * @brief 󥹥Ϥ˽и뤫ɤ֤
 * @param r_idx Ƚꤹ󥹥μ²ID
 * @return Ϥ˽иʤTRUE֤
 */
static bool mon_hook_waste(int r_idx)
{
	monster_race *r_ptr = &r_info[r_idx];

	if (r_ptr->flags8 & (RF8_WILD_WASTE | RF8_WILD_ALL))
		return TRUE;
	else
		return FALSE;
}


/*!
 * @brief 󥹥Į˽и뤫ɤ֤
 * @param r_idx Ƚꤹ󥹥μ²ID
 * @return Ϥ˽иʤTRUE֤
 */
static bool mon_hook_town(int r_idx)
{
	monster_race *r_ptr = &r_info[r_idx];

	if (r_ptr->flags8 & (RF8_WILD_TOWN | RF8_WILD_ALL))
		return TRUE;
	else
		return FALSE;
}


/*!
 * @brief 󥹥Ӥ˽и뤫ɤ֤
 * @param r_idx Ƚꤹ󥹥μ²ID
 * @return Ӥ˽иʤTRUE֤
 */
static bool mon_hook_wood(int r_idx)
{
	monster_race *r_ptr = &r_info[r_idx];

	if (r_ptr->flags8 & (RF8_WILD_WOOD | RF8_WILD_ALL))
		return TRUE;
	else
		return FALSE;
}


/*!
 * @brief 󥹥л˽и뤫ɤ֤
 * @param r_idx Ƚꤹ󥹥μ²ID
 * @return л˽иʤTRUE֤
 */
static bool mon_hook_volcano(int r_idx)
{
	monster_race *r_ptr = &r_info[r_idx];

	if (r_ptr->flags8 & RF8_WILD_VOLCANO)
		return TRUE;
	else
		return FALSE;
}

/*!
 * @brief 󥹥Ϥ˽и뤫ɤ֤
 * @param r_idx Ƚꤹ󥹥μ²ID
 * @return Ϥ˽иʤTRUE֤
 */
static bool mon_hook_mountain(int r_idx)
{
	monster_race *r_ptr = &r_info[r_idx];

	if (r_ptr->flags8 & RF8_WILD_MOUNTAIN)
		return TRUE;
	else
		return FALSE;
}


/*!
 * @brief 󥹥𸶤˽и뤫ɤ֤
 * @param r_idx Ƚꤹ󥹥μ²ID
 * @return Ӥ˽иʤTRUE֤
 */
static bool mon_hook_grass(int r_idx)
{
	monster_race *r_ptr = &r_info[r_idx];

	if (r_ptr->flags8 & (RF8_WILD_GRASS | RF8_WILD_ALL))
		return TRUE;
	else
		return FALSE;
}

/*!
 * @brief 󥹥Ϸ˽и뤫ɤ֤
 * @param r_idx Ƚꤹ󥹥μ²ID
 * @return Ϸ˽иʤTRUE֤
 */
static bool mon_hook_deep_water(int r_idx)
{
	monster_race *r_ptr = &r_info[r_idx];

	if (!mon_hook_dungeon(r_idx)) return FALSE;

	if (r_ptr->flags7 & RF7_AQUATIC)
		return TRUE;
	else
		return FALSE;
}


/*!
 * @brief 󥹥Ϸ˽и뤫ɤ֤
 * @param r_idx Ƚꤹ󥹥μ²ID
 * @return Ϸ˽иʤTRUE֤
 */
static bool mon_hook_shallow_water(int r_idx)
{
	monster_race *r_ptr = &r_info[r_idx];

	if (!mon_hook_dungeon(r_idx)) return FALSE;

	if (r_ptr->flags2 & RF2_AURA_FIRE)
		return FALSE;
	else
		return TRUE;
}


/*!
 * @brief 󥹥ϴϷ˽и뤫ɤ֤
 * @param r_idx Ƚꤹ󥹥μ²ID
 * @return ϴϷ˽иʤTRUE֤
 */
static bool mon_hook_lava(int r_idx)
{
	monster_race *r_ptr = &r_info[r_idx];

	if (!mon_hook_dungeon(r_idx)) return FALSE;

	if (((r_ptr->flagsr & RFR_EFF_IM_FIRE_MASK) ||
	     (r_ptr->flags7 & RF7_CAN_FLY)) &&
	    !(r_ptr->flags3 & RF3_AURA_COLD))
		return TRUE;
	else
		return FALSE;
}


/*!
 * @brief 󥹥̾ξϷ˽и뤫ɤ֤
 * @param r_idx Ƚꤹ󥹥μ²ID
 * @return ̾ξϷ˽иʤTRUE֤
 */
static bool mon_hook_floor(int r_idx)
{
	monster_race *r_ptr = &r_info[r_idx];

	if (!(r_ptr->flags7 & RF7_AQUATIC) ||
	    (r_ptr->flags7 & RF7_CAN_FLY))
		return TRUE;
	else
		return FALSE;
}


/*!
 * @brief ץ쥤䡼θߤιޥå׺ɸ򸵤˥󥹥ؿ֤
 * @return ˤä󥹥ؿ
 */
monster_hook_type get_monster_hook(void)
{
	if (!dun_level && !p_ptr->inside_quest)
	{
		switch (wilderness[p_ptr->wilderness_y][p_ptr->wilderness_x].terrain)
		{
		case TERRAIN_TOWN:
			return (monster_hook_type)mon_hook_town;
		case TERRAIN_DEEP_WATER:
			return (monster_hook_type)mon_hook_ocean;
		case TERRAIN_SHALLOW_WATER:
		case TERRAIN_SWAMP:
			return (monster_hook_type)mon_hook_shore;
		case TERRAIN_DIRT:
		case TERRAIN_DESERT:
			return (monster_hook_type)mon_hook_waste;
		case TERRAIN_GRASS:
			return (monster_hook_type)mon_hook_grass;
		case TERRAIN_TREES:
			return (monster_hook_type)mon_hook_wood;
		case TERRAIN_SHALLOW_LAVA:
		case TERRAIN_DEEP_LAVA:
			return (monster_hook_type)mon_hook_volcano;
		case TERRAIN_MOUNTAIN:
			return (monster_hook_type)mon_hook_mountain;
		default:
			return (monster_hook_type)mon_hook_dungeon;
		}
	}
	else
	{
		return (monster_hook_type)mon_hook_dungeon;
	}
}

/*!
 * @brief ꤵ줿ޥå׺ɸ򸵤˥󥹥ؿ֤
 * @return ˤä󥹥ؿ
 */
monster_hook_type get_monster_hook2(int y, int x)
{
	feature_type *f_ptr = &f_info[cave[y][x].feat];

	/* Set the monster list */

	/* Water */
	if (have_flag(f_ptr->flags, FF_WATER))
	{
		/* Deep water */
		if (have_flag(f_ptr->flags, FF_DEEP))
		{
			return (monster_hook_type)mon_hook_deep_water;
		}

		/* Shallow water */
		else
		{
			return (monster_hook_type)mon_hook_shallow_water;
		}
	}

	/* Lava */
	else if (have_flag(f_ptr->flags, FF_LAVA))
	{
		return (monster_hook_type)mon_hook_lava;
	}

	else return (monster_hook_type)mon_hook_floor;
}

/*!
 * @brief 󥹥ͧŪˤ
 * @param m_ptr 󥹥¤Τλȥݥ
 * @return ʤ
 */
void set_friendly(monster_type *m_ptr)
{
	m_ptr->smart |= SM_FRIENDLY;
}

/*!
 * @brief 󥹥ڥåȤˤ
 * @param m_ptr 󥹥¤Τλȥݥ
 * @return ʤ
 */
void set_pet(monster_type *m_ptr)
{
	if (!is_pet(m_ptr)) check_pets_num_and_align(m_ptr, TRUE);

	/* Check for quest completion */
	check_quest_completion(m_ptr);

	m_ptr->smart |= SM_PET;
	if (!(r_info[m_ptr->r_idx].flags3 & (RF3_EVIL | RF3_GOOD)))
		m_ptr->sub_align = SUB_ALIGN_NEUTRAL;
}

/*!
 * @brief 󥹥Ũ˲
 * Makes the monster hostile towards the player
 * @param m_ptr 󥹥¤Τλȥݥ
 * @return ʤ
 */
void set_hostile(monster_type *m_ptr)
{
	if (p_ptr->inside_battle) return;

	if (is_pet(m_ptr)) check_pets_num_and_align(m_ptr, FALSE);

	m_ptr->smart &= ~SM_PET;
	m_ptr->smart &= ~SM_FRIENDLY;
}


/*!
 * @brief 󥹥ܤ餻
 * Anger the monster
 * @param m_ptr 󥹥¤Τλȥݥ
 * @return ʤ
 */
void anger_monster(monster_type *m_ptr)
{
	if (p_ptr->inside_battle) return;
	if (is_friendly(m_ptr))
	{
		char m_name[80];

		monster_desc(m_name, m_ptr, 0);
#ifdef JP
msg_format("%^sܤä", m_name);
#else
		msg_format("%^s gets angry!", m_name);
#endif

		set_hostile(m_ptr);

		chg_virtue(V_INDIVIDUALISM, 1);
		chg_virtue(V_HONOUR, -1);
		chg_virtue(V_JUSTICE, -1);
		chg_virtue(V_COMPASSION, -1);
	}
}


/*!
 * @brief 󥹥ϷƧˤǤ뤫ɤ֤
 * Check if monster can cross terrain
 * @param feat ϷID
 * @param r_ptr 󥹥²¤Τλȥݥ
 * @param mode ץ
 * @return Ƨ˲ǽʤTRUE֤
 */
bool monster_can_cross_terrain(s16b feat, monster_race *r_ptr, u16b mode)
{
	feature_type *f_ptr = &f_info[feat];

	/* Pattern */
	if (have_flag(f_ptr->flags, FF_PATTERN))
	{
		if (!(mode & CEM_RIDING))
		{
			if (!(r_ptr->flags7 & RF7_CAN_FLY)) return FALSE;
		}
		else
		{
			if (!(mode & CEM_P_CAN_ENTER_PATTERN)) return FALSE;
		}
	}

	/* "CAN" flags */
	if (have_flag(f_ptr->flags, FF_CAN_FLY) && (r_ptr->flags7 & RF7_CAN_FLY)) return TRUE;
	if (have_flag(f_ptr->flags, FF_CAN_SWIM) && (r_ptr->flags7 & RF7_CAN_SWIM)) return TRUE;
	if (have_flag(f_ptr->flags, FF_CAN_PASS))
	{
		if ((r_ptr->flags2 & RF2_PASS_WALL) && (!(mode & CEM_RIDING) || p_ptr->pass_wall)) return TRUE;
	}

	if (!have_flag(f_ptr->flags, FF_MOVE)) return FALSE;

	/* Some monsters can walk on mountains */
	if (have_flag(f_ptr->flags, FF_MOUNTAIN) && (r_ptr->flags8 & RF8_WILD_MOUNTAIN)) return TRUE;

	/* Water */
	if (have_flag(f_ptr->flags, FF_WATER))
	{
		if (!(r_ptr->flags7 & RF7_AQUATIC))
		{
			/* Deep water */
			if (have_flag(f_ptr->flags, FF_DEEP)) return FALSE;

			/* Shallow water */
			else if (r_ptr->flags2 & RF2_AURA_FIRE) return FALSE;
		}
	}

	/* Aquatic monster into non-water? */
	else if (r_ptr->flags7 & RF7_AQUATIC) return FALSE;

	/* Lava */
	if (have_flag(f_ptr->flags, FF_LAVA))
	{
		if (!(r_ptr->flagsr & RFR_EFF_IM_FIRE_MASK)) return FALSE;
	}

	return TRUE;
}


/*!
 * @brief ꤵ줿ɸϷ󥹥ƧˤǤ뤫ɤ֤
 * Strictly check if monster can enter the grid
 * @param y ϷYɸ
 * @param x ϷXɸ
 * @param r_ptr 󥹥²¤Τλȥݥ
 * @param mode ץ
 * @return Ƨ˲ǽʤTRUE֤
 */
bool monster_can_enter(int y, int x, monster_race *r_ptr, u16b mode)
{
	cave_type *c_ptr = &cave[y][x];

	/* Player or other monster */
	if (player_bold(y, x)) return FALSE;
	if (c_ptr->m_idx) return FALSE;

	return monster_can_cross_terrain(c_ptr->feat, r_ptr, mode);
}


/*!
 * @brief 󥹥°δŤŨдط̵֤ͭʥ֥롼
 * Check if this monster has "hostile" alignment (aux)
 * @param sub_align1 󥹥1Υ֥ե饰
 * @param sub_align2 󥹥2Υ֥ե饰
 * @return ŨдطˤʤTRUE֤
 */
static bool check_hostile_align(byte sub_align1, byte sub_align2)
{
	if (sub_align1 != sub_align2)
	{
		if (((sub_align1 & SUB_ALIGN_EVIL) && (sub_align2 & SUB_ALIGN_GOOD)) ||
			((sub_align1 & SUB_ALIGN_GOOD) && (sub_align2 & SUB_ALIGN_EVIL)))
			return TRUE;
	}

	/* Non-hostile alignment */
	return FALSE;
}


/*!
 * @brief 󥹥°δŤŨдط̵֤ͭ
 * Check if two monsters are enemies
 * @param m_ptr 󥹥1ι¤λȥݥ
 * @param n_ptr 󥹥2ι¤λȥݥ
 * @return ŨдطˤʤTRUE֤
 */
bool are_enemies(monster_type *m_ptr, monster_type *n_ptr)
{
	monster_race *r_ptr = &r_info[m_ptr->r_idx];
	monster_race *s_ptr = &r_info[n_ptr->r_idx];

	if (p_ptr->inside_battle)
	{
		if (is_pet(m_ptr) || is_pet(n_ptr)) return FALSE;
		return TRUE;
	}

	if ((r_ptr->flags8 & (RF8_WILD_TOWN | RF8_WILD_ALL))
	    && (s_ptr->flags8 & (RF8_WILD_TOWN | RF8_WILD_ALL)))
	{
		if (!is_pet(m_ptr) && !is_pet(n_ptr)) return FALSE;
	}

	/* Friendly vs. opposite aligned normal or pet */
	if (check_hostile_align(m_ptr->sub_align, n_ptr->sub_align))
	{
		if (!(m_ptr->mflag2 & MFLAG2_CHAMELEON) || !(n_ptr->mflag2 & MFLAG2_CHAMELEON)) return TRUE;
	}

	/* Hostile vs. non-hostile */
	if (is_hostile(m_ptr) != is_hostile(n_ptr))
	{
		return TRUE;
	}

	/* Default */
	return FALSE;
}


/*!
 * @brief 󥹥ץ쥤䡼ФŨդɤ֤
 * Check if this monster race has "hostile" alignment
 * @param m_ptr 󥹥¤Τλȥݥ
 * @param pa_good ץ쥤䡼
 * @param pa_evil ץ쥤䡼ΰ
 * @param r_ptr 󥹥²ι¤λȥݥ
 * @return ץ쥤䡼ŨդĤʤTRUE֤
 * @details
 * If user is player, m_ptr == NULL.
 */
bool monster_has_hostile_align(monster_type *m_ptr, int pa_good, int pa_evil, monster_race *r_ptr)
{
	byte sub_align1 = SUB_ALIGN_NEUTRAL;
	byte sub_align2 = SUB_ALIGN_NEUTRAL;

	if (m_ptr) /* For a monster */
	{
		sub_align1 = m_ptr->sub_align;
	}
	else /* For player */
	{
		if (p_ptr->align >= pa_good) sub_align1 |= SUB_ALIGN_GOOD;
		if (p_ptr->align <= pa_evil) sub_align1 |= SUB_ALIGN_EVIL;
	}

	/* Racial alignment flags */
	if (r_ptr->flags3 & RF3_EVIL) sub_align2 |= SUB_ALIGN_EVIL;
	if (r_ptr->flags3 & RF3_GOOD) sub_align2 |= SUB_ALIGN_GOOD;

	if (check_hostile_align(sub_align1, sub_align2)) return TRUE;

	/* Non-hostile alignment */
	return FALSE;
}


/*!
 * @brief 󥹥̿Τɤ֤
 * Is the monster "alive"?
 * @param r_ptr Ƚꤹ󥹥μ²¤λȥݥ
 * @return ̿ΤʤTRUE֤
 * @details
 * Used to determine the message to print for a killed monster.
 * ("dies", "destroyed")
 */
bool monster_living(monster_race *r_ptr)
{
	/* Non-living, undead, or demon */
	if (r_ptr->flags3 & (RF3_DEMON | RF3_UNDEAD | RF3_NONLIVING))
		return FALSE;
	else
		return TRUE;
}


/*!
 * @brief 󥹥üǽϾ塢޶󤫤ӽɬפ뤫ɤ֤
 * Is the monster "alive"? / Is this monster declined to be questor or bounty?
 * @param r_idx 󥹥μ²ID
 * @return ޶˲äʤʤTRUE֤
 * @details
 * ¼СΡѡѡ
 */
bool no_questor_or_bounty_uniques(int r_idx)
{
	switch (r_idx)
	{
	/*
	 * Decline them to be questor or bounty because they use
	 * special motion "split and combine"
	 */
	case MON_BANORLUPART:
	case MON_BANOR:
	case MON_LUPART:
		return TRUE;
	default:
		return FALSE;
	}
}
