﻿#pragma once

#include "system/angband.h"

bool wall_stone(player_type *caster_ptr);
bool speed_monsters(player_type* caster_ptr);
bool slow_monsters(player_type* caster_ptr, int power);
bool sleep_monsters(player_type* caster_ptr, int power);
void aggravate_monsters(player_type* caster_ptr, MONSTER_IDX who);
bool genocide_aux(player_type* caster_ptr, MONSTER_IDX m_idx, int power, bool player_cast, int dam_side, concptr spell_name);
bool symbol_genocide(player_type* caster_ptr, int power, bool player_cast);
bool mass_genocide(player_type* caster_ptr, int power, bool player_cast);
bool mass_genocide_undead(player_type* caster_ptr, int power, bool player_cast);
bool probing(player_type* caster_ptr);
bool banish_evil(player_type* caster_ptr, int dist);
bool dispel_evil(player_type* caster_ptr, HIT_POINT dam);
bool dispel_good(player_type* caster_ptr, HIT_POINT dam);
bool dispel_undead(player_type* caster_ptr, HIT_POINT dam);
bool dispel_monsters(player_type* caster_ptr, HIT_POINT dam);
bool dispel_living(player_type* caster_ptr, HIT_POINT dam);
bool dispel_demons(player_type* caster_ptr, HIT_POINT dam);
bool cleansing_nova(player_type* creature_ptr, bool magic, bool powerful);
bool unleash_mana_storm(player_type* creature_ptr, bool powerful);
bool crusade(player_type* caster_ptr);
bool turn_undead(player_type* caster_ptr);
void lite_room(player_type* caster_ptr, POSITION y1, POSITION x1);
bool starlight(player_type* caster_ptr, bool magic);
void unlite_room(player_type* caster_ptr, POSITION y1, POSITION x1);
bool lite_area(player_type* caster_ptr, HIT_POINT dam, POSITION rad);
bool unlite_area(player_type* caster_ptr, HIT_POINT dam, POSITION rad);
bool fire_ball(player_type* caster_ptr, EFFECT_ID typ, DIRECTION dir, HIT_POINT dam, POSITION rad);
bool fire_breath(player_type* caster_ptr, EFFECT_ID typ, DIRECTION dir, HIT_POINT dam, POSITION rad);
bool fire_rocket(player_type* caster_ptr, EFFECT_ID typ, DIRECTION dir, HIT_POINT dam, POSITION rad);
bool fire_ball_hide(player_type* caster_ptr, EFFECT_ID typ, DIRECTION dir, HIT_POINT dam, POSITION rad);
bool fire_meteor(player_type* caster_ptr, MONSTER_IDX who, EFFECT_ID typ, POSITION x, POSITION y, HIT_POINT dam, POSITION rad);
bool fire_bolt(player_type* caster_ptr, EFFECT_ID typ, DIRECTION dir, HIT_POINT dam);
bool fire_blast(player_type* caster_ptr, EFFECT_ID typ, DIRECTION dir, DICE_NUMBER dd, DICE_SID ds, int num, int dev);
void call_chaos(player_type* caster_ptr);
bool fire_beam(player_type* caster_ptr, EFFECT_ID typ, DIRECTION dir, HIT_POINT dam);
bool fire_bolt_or_beam(player_type* caster_ptr, PERCENTAGE prob, EFFECT_ID typ, DIRECTION dir, HIT_POINT dam);
bool lite_line(player_type* caster_ptr, DIRECTION dir, HIT_POINT dam);
bool hypodynamic_bolt(player_type* caster_ptr, DIRECTION dir, HIT_POINT dam);
bool death_ray(player_type* caster_ptr, DIRECTION dir, PLAYER_LEVEL plev);
bool wall_to_mud(player_type* caster_ptr, DIRECTION dir, HIT_POINT dam);
bool destroy_door(player_type* caster_ptr, DIRECTION dir);
bool disarm_trap(player_type* caster_ptr, DIRECTION dir);
bool wizard_lock(player_type* caster_ptr, DIRECTION dir);
bool teleport_monster(player_type* caster_ptr, DIRECTION dir, int distance);
bool door_creation(player_type* caster_ptr, POSITION y, POSITION x);
bool trap_creation(player_type* caster_ptr, POSITION y, POSITION x);
bool tree_creation(player_type* caster_ptr, POSITION y, POSITION x);
bool glyph_creation(player_type* caster_ptr, POSITION y, POSITION x);
bool destroy_doors_touch(player_type* caster_ptr);
bool disarm_traps_touch(player_type* caster_ptr);
bool animate_dead(player_type* caster_ptr, MONSTER_IDX who, POSITION y, POSITION x);
bool sleep_monsters_touch(player_type* caster_ptr);
bool activate_ty_curse(player_type* target_ptr, bool stop_ty, int* count);
int activate_hi_summon(player_type* caster_ptr, POSITION y, POSITION x, bool can_pet);
void wall_breaker(player_type* caster_ptr);
bool confuse_monsters(player_type* caster_ptr, HIT_POINT dam);
bool charm_monsters(player_type* caster_ptr, HIT_POINT dam);
bool charm_animals(player_type* caster_ptr, HIT_POINT dam);
bool stun_monsters(player_type* caster_ptr, HIT_POINT dam);
bool stasis_monsters(player_type* caster_ptr, HIT_POINT dam);
bool banish_monsters(player_type* caster_ptr, int dist);
bool turn_monsters(player_type* caster_ptr, HIT_POINT dam);
bool turn_evil(player_type* caster_ptr, HIT_POINT dam);
bool deathray_monsters(player_type* caster_ptr);
bool charm_monster(player_type* caster_ptr, DIRECTION dir, PLAYER_LEVEL plev);
bool control_one_undead(player_type* caster_ptr, DIRECTION dir, PLAYER_LEVEL plev);
bool control_one_demon(player_type* caster_ptr, DIRECTION dir, PLAYER_LEVEL plev);
bool charm_animal(player_type* caster_ptr, DIRECTION dir, PLAYER_LEVEL plev);
bool mindblast_monsters(player_type* caster_ptr, HIT_POINT dam);
bool teleport_swap(player_type* caster_ptr, DIRECTION dir);
bool project_hook(player_type* caster_ptr, EFFECT_ID typ, DIRECTION dir, HIT_POINT dam, BIT_FLAGS flg);
bool project_all_los(player_type* caster_ptr, EFFECT_ID typ, HIT_POINT dam);
bool eat_magic(player_type* caster_ptr, int power);
void discharge_minion(player_type* caster_ptr);
bool kawarimi(player_type* caster_ptr, bool success);
bool rush_attack(player_type* attacker_ptr, bool* mdeath);
void remove_all_mirrors(player_type* caster_ptr, bool explode);
void ring_of_power(player_type* caster_ptr, DIRECTION dir);
void wild_magic(player_type* caster_ptr, int spell);
void cast_meteor(player_type* caster_ptr, HIT_POINT dam, POSITION rad);
bool cast_wrath_of_the_god(player_type* caster_ptr, HIT_POINT dam, POSITION rad);
void cast_wonder(player_type* caster_ptr, DIRECTION dir);
void cast_invoke_spirits(player_type* caster_ptr, DIRECTION dir);
void cast_shuffle(player_type* caster_ptr);
bool vampirism(player_type* caster_ptr);
bool hit_and_away(player_type* caster_ptr);
bool psychometry(player_type* caster_ptr);
bool draconian_breath(player_type* creature_ptr);
bool android_inside_weapon(player_type* creature_ptr);
bool create_ration(player_type* crature_ptr);
void hayagake(player_type* creature_ptr);
bool double_attack(player_type* creature_ptr);
bool comvert_hp_to_mp(player_type* creature_ptr);
bool comvert_mp_to_hp(player_type* creature_ptr);
bool demonic_breath(player_type* creature_ptr);
bool mirror_concentration(player_type* creature_ptr);
bool sword_dancing(player_type* creature_ptr);
bool confusing_light(player_type* creature_ptr);
bool rodeo(player_type* creature_ptr);
bool clear_mind(player_type* creature_ptr);
bool vanish_dungeon(player_type* caster_ptr);
