﻿/*!
 * @brief 生い立ちメッセージテーブル / Forward declare
 * @date 2002/01/12
 * @author mogami
 */

#include "birth/history.h"

/*!
* 生い立ちテーブルの定義 / Background information (see below)\n
*\n
* Chart progression by race:\n
*   Human         -->  1 -->  2 -->  3 --> 50 --> 51 --> 52 --> 53\n
*   Half-Elf      -->  4 -->  1 -->  2 -->  3 --> 50 --> 51 --> 52 --> 53\n
*   Elf/High-Elf  -->  7 -->  8 -->  9 --> 54 --> 55 --> 56\n
*   Hobbit        --> 10 --> 11 -->  3 --> 50 --> 51 --> 52 --> 53\n
*   Gnome         --> 13 --> 14 -->  3 --> 50 --> 51 --> 52 --> 53\n
*   Dwarf         --> 16 --> 17 --> 18 --> 57 --> 58 --> 59 --> 60 --> 61\n
*   Half-Orc      --> 19 --> 20 -->  2 -->  3 --> 50 --> 51 --> 52 --> 53\n
*   Half-Troll    --> 22 --> 23 --> 62 --> 63 --> 64 --> 65 --> 66\n
*\n
* This table *must* be correct or drastic errors may occur!\n
*/
hist_type bg[MAX_BACKGROUNDS] = {
#ifdef JP
{ "妾腹の子で認知すらされていません。",			 10, 2, 3, 25 },
{ "妾腹の子ですが認知はされています。",			 20, 2, 3, 35 },
{ "幾人かの子供のうちの一人です。",			 95, 2, 3, 45 },
{ "長子です。",						100, 2, 3, 50 },
#else
{ "You are the illegitimate and unacknowledged child ",   10, 1, 2, 25 },
{ "You are the illegitimate but acknowledged child ",     20, 1, 2, 35 },
{ "You are one of several children ",                     95, 1, 2, 45 },
{ "You are the first child ",                            100, 1, 2, 50 },
#endif


#ifdef JP
{ "あなたは農奴の",					 40, 1, 2, 65 },
{ "あなたは自作農の",					 65, 1, 2, 80 },
{ "あなたは町人の",					 80, 1, 2, 90 },
{ "あなたは職人の",					 90, 1, 2,105 },
{ "あなたは土着の騎士の",				 96, 1, 2,120 },
{ "あなたは混沌の宮廷の爵位ある貴族の",				 99, 1, 2,130 },
{ "あなたはアンバーの王家の血を引く者の",				100, 1, 2,140 },
#else
{ "of a Serf.  ",                                         40, 2, 3, 65 },
{ "of a Yeoman.  ",                                       65, 2, 3, 80 },
{ "of a Townsman.  ",                                     80, 2, 3, 90 },
{ "of a Guildsman.  ",                                    90, 2, 3, 105 },
{ "of a Landed Knight.  ",                                96, 2, 3, 120 },
{ "of a Noble Family in the Courts of Chaos.  ",          99, 2, 3, 130 },
{ "of the Royal Blood Line of Amber.  ",                 100, 2, 3, 140 },
#endif


#ifdef JP
{ "あなたは一家のお荷物です。",				 20, 3,50, 20 },
{ "あなたは一家の誇りです。",				 80, 3,50, 55 },
{ "あなたは家族に大切にされています。",			100, 3,50, 60 },
#else
{ "You are the black sheep of the family.  ",             20, 3, 50, 20 },
{ "You are a credit to the family.  ",                    80, 3, 50, 55 },
{ "You are a well liked child.  ",                       100, 3, 50, 60 },
#endif


#ifdef JP
{ "あなたの母はテレリ族のエルフでした。",		 40, 4, 1, 50 },
{ "あなたの父はテレリ族のエルフでした。",		 75, 4, 1, 55 },
{ "あなたの母はノルドール族のエルフでした。",		 90, 4, 1, 55 },
{ "あなたの父はノルドール族のエルフでした。",		 95, 4, 1, 60 },
{ "あなたの母はヴァンヤール族のエルフでした。",		 98, 4, 1, 65 },
{ "あなたの父はヴァンヤール族のエルフでした。",				100, 4, 1, 70 },
#else
{ "Your mother was of the Teleri.  ",			 40, 4, 1, 50 },
{ "Your father was of the Teleri.  ",			 75, 4, 1, 55 },
{ "Your mother was of the Noldor.  ",		 	 90, 4, 1, 55 },
{ "Your father was of the Noldor.  ",		 	 95, 4, 1, 60 },
{ "Your mother was of the Vanyar.  ",			 98, 4, 1, 65 },
{ "Your father was of the Vanyar.  ",			100, 4, 1, 70 },
#endif


#ifdef JP
{ "幾人かの子供のうちの一人です。",			 60, 9, 54, 50 },
{ "一粒種です。",					100, 9, 54, 55 },
#else
{ "You are one of several children ",			 60, 7, 8, 50 },
{ "You are the only child ",					100, 7, 8, 55 },
#endif


#ifdef JP
{ "あなたはテレリ族のエルフの",				 75, 7, 8, 50 },
{ "あなたはノルドール族のエルフの",			 95, 7, 8, 55 },
{ "あなたはヴァンヤール族のエルフの",			100, 7, 8, 60 },
#else
{ "of a Teleri ",						 75, 8, 9, 50 },
{ "of a Noldor ",						 95, 8, 9, 55 },
{ "of a Vanyar ",						100, 8, 9, 60 },
#endif


#ifdef JP
{ "レンジャーの",					 40, 8,9, 80 },
{ "アーチャーの",					 70, 8,9, 90 },
{ "戦士の",						 87, 8,9,110 },
{ "メイジの",						 95, 8,9,125 },
{ "王子の",						 99, 8,9,140 },
{ "王の",						100, 8,9,145 },
#else
{ "Ranger.  ",						 40, 9, 54, 80 },
{ "Archer.  ",						 70, 9, 54, 90 },
{ "Warrior.  ",						 87, 9, 54, 110 },
{ "Mage.  ",							 95, 9, 54, 125 },
{ "Prince.  ",						 99, 9, 54, 140 },
{ "King.  ",							100, 9, 54, 145 },
#endif


#ifdef JP
{ "ホビットの何人かの子供のうちの一人です。",		 85,11,3, 45 },
{ "ホビットの一粒種です。",			        100,11,3, 55 },
#else
{ "You are one of several children of a Hobbit ",		 85, 10, 11, 45 },
{ "You are the only child of a Hobbit ",		        100, 10, 11, 55 },
#endif


#ifdef JP
{ "あなたは乞食の",							 20,10,11, 55 },
{ "あなたは酒場の店主の",						 30,10,11, 80 },
{ "あなたは粉屋の",							 40,10,11, 90 },
{ "あなたは家主の",							 50,10,11,100 },
{ "あなたは忍びの者の",							 80,10,11,110 },
{ "あなたは戦士の",							 95,10,11,115 },
{ "あなたはメイジの",							 99,10,11,125 },
{ "あなたは一族の長の",							100,10,11,140 },
#else
{ "Bum.  ",							 20, 11, 3, 55 },
{ "Tavern Owner.  ",						 30, 11, 3, 80 },
{ "Miller.  ",						 40, 11, 3, 90 },
{ "Home Owner.  ",						 50, 11, 3, 100 },
{ "Burglar.  ",						 80, 11, 3, 110 },
{ "Warrior.  ",						 95, 11, 3, 115 },
{ "Mage.  ",							 99, 11, 3, 125 },
{ "Clan Elder.  ",						100, 11, 3, 140 },
#endif


#ifdef JP
{ "ノームの幾人かの子供のうちの一人です。",		 85,14,3, 45 },
{ "ノームの一粒種です。",			        100,14,3, 55 },
#else
{ "You are one of several children of a Gnome ",		 85, 13, 14, 45 },
{ "You are the only child of a Gnome ",			100, 13, 14, 55 },
#endif


#ifdef JP
{ "あなたは物乞いの",							 20,13,14, 55 },
{ "あなたはホラ吹きの",							 50,13,14, 70 },
{ "あなたはお調子者の",							 75,13,14, 85 },
{ "あなたは戦士の",							 95,13,14,100 },
{ "あなたはメイジの",							100,13,14,125 },
#else
{ "Beggar.  ",						 20, 14, 3, 55 },
{ "Braggart.  ",						 50, 14, 3, 70 },
{ "Prankster.  ",						 75, 14, 3, 85 },
{ "Warrior.  ",						 95, 14, 3, 100 },
{ "Mage.  ",							100, 14, 3, 125 },
#endif


#ifdef JP
{ "ドワーフの二人の子供のうちの一人です。",		 25,17,18, 40 },
{ "ドワーフの一粒種です。",			        100,17,18, 50 },
#else
{ "You are one of two children of a Dwarven ",		 25, 16, 17, 40 },
{ "You are the only child of a Dwarven ",			100, 16, 17, 50 },
#endif


#ifdef JP
{ "あなたは泥棒の",							 10,16,17, 60 },
{ "あなたは牢番の",							 25,16,17, 75 },
{ "あなたは坑夫の",							 75,16,17, 90 },
{ "あなたは戦士の",							 90,16,17,110 },
{ "あなたはプリーストの",					 99,16,17,130 },
{ "あなたは王の",							100,16,17,150 },
#else
{ "Thief.  ",						 10, 17, 18, 60 },
{ "Prison Guard.  ",						 25, 17, 18, 75 },
{ "Miner.  ",						 75, 17, 18, 90 },
{ "Warrior.  ",						 90, 17, 18, 110 },
{ "Priest.  ",						 99, 17, 18, 130 },
{ "King.  ",							100, 17, 18, 150 },
#endif


#ifdef JP
{ "あなたは一家のお荷物です。",						 15,18,57,10 },
{ "あなたは一家の誇りです。",						 85,18,57, 50 },
{ "あなたは家族に大切にされています。",				100,18,57, 55 },
#else
{ "You are the black sheep of the family.  ",		 15, 18, 57, 10 },
{ "You are a credit to the family.  ",			 85, 18, 57, 50 },
{ "You are a well liked child.  ",				100, 18, 57, 55 },
#endif


#ifdef JP
{ "あなたの母はオークでしたが、それは秘密にされています。",	 25,19,20, 25 },
{ "あなたの父はオークでしたが、それは秘密にされています。",	100,19,20, 25 },
#else
{ "Your mother was an Orc, but it is unacknowledged.  ",	 25, 19, 20, 25 },
{ "Your father was an Orc, but it is unacknowledged.  ",	100, 19, 20, 25 },
#endif


#ifdef JP
{ "あなたは農奴の養子です。",						 40,20, 3, 65 },
{ "あなたは自作農の養子です。",						 65,20, 3, 80 },
{ "あなたは町人の養子です。",						 80,20, 3, 90 },
{ "あなたは職人の養子です。",						 90,20, 3,105 },
{ "あなたは土着の騎士の養子です。",					 96,20, 3,120 },
{ "あなたは爵位ある貴族の養子です。",				 99,20, 3,130 },
{ "あなたは王家の血を引く者の養子です。",			100,20, 3,140 },
#else
{ "You are the adopted child ",				100, 20, 2, 50 },
#endif


#ifdef JP
{ "あなたの母は洞窟トロルの",				 30,22,23, 20 },
{ "あなたの父は洞窟トロルの",				 60,22,23, 25 },
{ "あなたの母は丘トロルの",					 75,22,23, 30 },
{ "あなたの父は丘トロルの",					 90,22,23, 35 },
{ "あなたの母は水トロルの",					 95,22,23, 40 },
{ "あなたの父は水トロルの",					100,22,23, 45 },
#else
{ "Your mother was a Cave-Troll ",				 30, 22, 23, 20 },
{ "Your father was a Cave-Troll ",				 60, 22, 23, 25 },
{ "Your mother was a Hill-Troll ",				 75, 22, 23, 30 },
{ "Your father was a Hill-Troll ",				 90, 22, 23, 35 },
{ "Your mother was a Water-Troll ",				 95, 22, 23, 40 },
{ "Your father was a Water-Troll ",				100, 22, 23, 45 },
#endif


#ifdef JP
{ "コックでした。",							  5,23,62, 60 },
{ "戦士でした。",							 95,23,62, 55 },
{ "呪術師でした。",							 99,23,62, 65 },
{ "一族の長でした。",						100,23,62, 80 },
#else
{ "Cook.  ",							  5, 23, 62, 60 },
{ "Warrior.  ",						 95, 23, 62, 55 },
{ "Shaman.  ",						 99, 23, 62, 65 },
{ "Clan Chief.  ",						100, 23, 62, 80 },
#endif


#ifdef JP
{ "あなたは深いブラウンの瞳と",				 20,50,51, 50 },
{ "あなたはブラウンの瞳と",					 60,50,51, 50 },
{ "あなたは淡い色の瞳と",					 70,50,51, 50 },
{ "あなたはグリーンの瞳と",					 80,50,51, 50 },
{ "あなたは青い瞳と",						 90,50,51, 50 },
{ "あなたはブルーグレイの瞳と",				100,50,51, 50 },
#else
{ "You have dark brown eyes, ",				 20, 50, 51, 50 },
{ "You have brown eyes, ",					 60, 50, 51, 50 },
{ "You have hazel eyes, ",					 70, 50, 51, 50 },
{ "You have green eyes, ",					 80, 50, 51, 50 },
{ "You have blue eyes, ",					 90, 50, 51, 50 },
{ "You have blue-gray eyes, ",				100, 50, 51, 50 },
#endif


#ifdef JP
{ "なめらかな",							 70,51,52, 50 },
{ "波打った",							 90,51,52, 50 },
{ "カールした",							100,51,52, 50 },
#else
{ "straight ",						 70, 51, 52, 50 },
{ "wavy ",							 90, 51, 52, 50 },
{ "curly ",							100, 51, 52, 50 },
#endif


#ifdef JP
{ "黒髪を持ち、",						 30,52,53, 50 },
{ "茶髪を持ち、",						 70,52,53, 50 },
{ "とび色の髪を持ち、",					 80,52,53, 50 },
{ "赤い髪を持ち、",						 90,52,53, 50 },
{ "ブロンドの髪を持ち、",				100,52,53, 50 },
#else
{ "black hair, ",						 30, 52, 53, 50 },
{ "brown hair, ",						 70, 52, 53, 50 },
{ "auburn hair, ",						 80, 52, 53, 50 },
{ "red hair, ",						 90, 52, 53, 50 },
{ "blond hair, ",						100, 52, 53, 50 },
#endif


#ifdef JP
{ "漆黒の肌をしています。",					 10,53, 0, 50 },
{ "黒い肌をしています。",					 30,53, 0, 50 },
{ "普通の肌色をしています。",				 80,53, 0, 50 },
{ "白い肌をしています。",					 90,53, 0, 50 },
{ "透き通るような白い肌をしています。",		100,53, 0, 50 },
#else
{ "and a very dark complexion.",				 10, 53, 0, 50 },
{ "and a dark complexion.",					 30, 53, 0, 50 },
{ "and an average complexion.",				 80, 53, 0, 50 },
{ "and a fair complexion.",					 90, 53, 0, 50 },
{ "and a very fair complexion.",				100, 53, 0, 50 },
#endif


#ifdef JP
{ "あなたは明るいグレーの瞳と",					 85,54,55, 50 },
{ "あなたは明るいブルーの瞳と",					 95,54,55, 50 },
{ "あなたは明るいグリーンの瞳と",					100,54,55, 50 },
#else
{ "You have light grey eyes, ",				 85, 54, 55, 50 },
{ "You have light blue eyes, ",				 95, 54, 55, 50 },
{ "You have light green eyes, ",				100, 54, 55, 50 },
#endif


#ifdef JP
{ "なめらかな",							 75,55,56, 50 },
{ "波打った",							100,55,56, 50 },
#else
{ "straight ",						 75, 55, 56, 50 },
{ "wavy ",							100, 55, 56, 50 },
#endif


#ifdef JP
{ "黒髪を持ち、白い肌をしています。",				 75,56, 0, 50 },
{ "茶髪を持ち、白い肌をしています。",				 85,56, 0, 50 },
{ "ブロンドの髪を持ち、白い肌をしています。",				 95,56, 0, 50 },
{ "銀髪を持ち、白い肌をしています。",				100,56, 0, 50 },
#else
{ "black hair, and a fair complexion.",			 75, 56, 0, 50 },
{ "brown hair, and a fair complexion.",			 85, 56, 0, 50 },
{ "blond hair, and a fair complexion.",			 95, 56, 0, 50 },
{ "silver hair, and a fair complexion.",			100, 56, 0, 50 },
#endif


#ifdef JP
{ "あなたは深いブラウンの瞳と",					 99,57,58, 50 },
{ "あなたは輝く赤い瞳と",					100,57,58, 60 },
#else
{ "You have dark brown eyes, ",				 99, 57, 58, 50 },
{ "You have glowing red eyes, ",				100, 57, 58, 60 },
#endif


#ifdef JP
{ "なめらかな",							 90,58,59, 50 },
{ "波打った",							100,58,59, 50 },
#else
{ "straight ",						 90, 58, 59, 50 },
{ "wavy ",							100, 58, 59, 50 },
#endif


#ifdef JP
{ "黒髪、そして",						 75,59,60, 50 },
{ "茶髪、そして",						100,59,60, 50 },
#else
{ "black hair, ",						 75, 59, 60, 50 },
{ "brown hair, ",						100, 59, 60, 50 },
#endif


#ifdef JP
{ " 30cm ほどのヒゲを持ち、",						 25,60,61, 50 },
{ " 60cm ほどのヒゲを持ち、",						 60,60,61, 51 },
{ " 90cm ほどのヒゲを持ち、",					 90,60,61, 53 },
{ " 1m20cm ほどのヒゲを持ち、 ",						100,60,61, 55 },
#else
{ "a one foot beard, ",					 25, 60, 61, 50 },
{ "a two foot beard, ",					 60, 60, 61, 51 },
{ "a three foot beard, ",					 90, 60, 61, 53 },
{ "a four foot beard, ",					100, 60, 61, 55 },
#endif


#ifdef JP
{ "黒い肌をしています。",					100,61, 0, 50 },
#else
{ "and a dark complexion.",					100, 61, 0, 50 },
#endif


#ifdef JP
{ "あなたはベトつくような緑の瞳と",					 60,62,63, 50 },
{ "あなたは汚物のような黄色い瞳と",					 85,62,63, 50 },
{ "あなたは青く血走った瞳と",				 99,62,63, 50 },
{ "あなたは輝く赤い瞳と",					100,62,63, 55 },
#else
{ "You have slime green eyes, ",				 60, 62, 63, 50 },
{ "You have puke yellow eyes, ",				 85, 62, 63, 50 },
{ "You have blue-bloodshot eyes, ",				 99, 62, 63, 50 },
{ "You have glowing red eyes, ",				100, 62, 63, 55 },
#endif


#ifdef JP
{ "汚らしい",							 33,63,64, 50 },
{ "不潔な",							 66,63,64, 50 },
{ "脂ぎった",							100,63,64, 50 },
#else
{ "dirty ",							 33, 63, 64, 50 },
{ "mangy ",							 66, 63, 64, 50 },
{ "oily ",							100, 63, 64, 50 },
#endif


#ifdef JP
{ "ワカメの様な髪を持ち、",					 33,64,65, 50 },
{ "明るい赤色の髪を持ち、",						 66,64,65, 50 },
{ "暗い紫色の髪を持ち、",						100,64,65, 50 },
#else
{ "sea-weed green hair, ",					 33, 64, 65, 50 },
{ "bright red hair, ",					 66, 64, 65, 50 },
{ "dark purple hair, ",					100, 64, 65, 50 },
#endif


#ifdef JP
{ "緑色の",							 25,65,66, 50 },
{ "青い",							 50,65,66, 50 },
{ "白い",							 75,65,66, 50 },
{ "黒い",							100,65,66, 50 },
#else
{ "and green ",						 25, 65, 66, 50 },
{ "and blue ",						 50, 65, 66, 50 },
{ "and white ",						 75, 65, 66, 50 },
{ "and black ",						100, 65, 66, 50 },
#endif


#ifdef JP
{ "ブツブツした肌をしています。",						 33,66, 0, 50 },
{ "カサブタだらけの肌をしています。",						 66,66, 0, 50 },
{ "ガサガサの肌をしています。",						100,66, 0, 50 },
#else
{ "ulcerous skin.",						 33, 66, 0, 50 },
{ "scabby skin.",						 66, 66, 0, 50 },
{ "leprous skin.",                       100, 66, 0, 50 },
#endif


#ifdef JP
{ "認知されていない子供です。",          50, 68, 50, 45 },
{ "勘当された子供です。",           80, 68, 50, 65 },
{ "早くして生き別れた子供です。",      100, 68, 50, 55 },
#else
{ "You are an unacknowledged child of ", 50, 67, 68, 45 },
{ "You are a rebel child of ",         80, 67, 68, 65 },
{ "You are a long lost child of ",     100, 67, 68, 55 },
#endif


#ifdef JP
{ "あなたは名の知れぬアンバーの王族の",               50, 67, 68, 80 },
{ "あなたは第三世代のアンバー王族の", 65, 67, 68, 90 },
{ "あなたは第二世代のアンバー王族の", 79, 67, 68, 100 },
{ "あなたはオベロンの",       80, 67, 68, 130 },
{ "あなたはオズリックの",        83, 67, 68, 105 },
{ "あなたはフィンドーの",       84, 67, 68, 105 },
{ "あなたはブランドの",        85, 67, 68, 90 },
{ "あなたはフローラの",        87, 67, 68, 100 },
{ "あなたはジェラードの",       88, 67, 68, 125 },
{ "あなたはディアドラの",      89, 67, 68, 120 },
{ "あなたはランダムの",       90, 67, 68, 140 },
{ "あなたはベネディクトの",     91, 67, 68, 115 },
{ "あなたはコーウィンの",       92, 67, 68, 110 },
{ "あなたはジュリアンの",       93, 67, 68, 105 },
{ "あなたはケインの",        94, 67, 68, 95 },
{ "あなたはブレイズの",        95, 67, 68, 115 },
{ "あなたはフィオナの",        96, 67, 68, 110 },
{ "あなたはエリックの",         97, 67, 68, 135 },
{ "あなたはリナルドの",      98, 67, 68, 90 },
{ "あなたはマーリンの",       99, 67, 68, 105 },
{ "あなたはマーティンの",       100, 67,68, 80 },
#else
{ "an unknown Amberite.  ",               50, 68, 50, 80 },
{ "an unknown third generation Amberite.  ", 65, 68, 50, 90 },
{ "an unknown second generation Amberite.  ", 79, 68, 50, 100 },
{ "Oberon.  ",       80, 68, 50, 130 },
{ "Osric.  ",        83, 68, 50, 105 },
{ "Finndo.  ",       84, 68, 50, 105 },
{ "Brand.  ",        85, 68, 50, 90 },
{ "Flora.  ",        87, 68, 50, 100 },
{ "Gerard.  ",       88, 68, 50, 125 },
{ "Deirdre.  ",      89, 68, 50, 120 },
{ "Random.  ",       90, 68, 50, 140 },
{ "Benedict.  ",     91, 68, 50, 115 },
{ "Corwin.  ",       92, 68, 50, 110 },
{ "Julian.  ",       93, 68, 50, 105 },
{ "Caine.  ",        94, 68, 50, 95 },
{ "Bleys.  ",        95, 68, 50, 115 },
{ "Fiona.  ",        96, 68, 50, 110 },
{ "Eric.  ",         97, 68, 50, 135 },
{ "Rinaldo.  ",      98, 68, 50, 90 },
{ "Merlin.  ",       99, 68, 50, 105 },
{ "Martin.  ",       100, 68, 50, 80 },
#endif



#ifdef JP
{ "何人かの子供のうちの一人です。",      85, 70, 71, 45 },
{ "一粒種です。",         	 100, 70, 71, 55 },

{ "あなたはダークエルフの戦士の", 50, 69, 70, 60 },
{ "あなたはダークエルフの魔術士の", 80, 69, 70, 75 },
{ "あなたはダークエルフの貴族の", 100,  69, 70, 95 },
#else
{ "You are one of several children of a Dark Elven ",      85, 69, 70, 45 },
{ "You are the only child of a Dark Elven ",          100, 69, 70, 55 },

{ "Warrior.  ", 50, 70, 71, 60 },
{ "Warlock.  ", 80, 70, 71, 75 },
{ "Noble.  ", 100, 70, 71, 95 },
#endif


#ifdef JP
{ "あなたは黒い瞳と", 100, 71, 72, 50 },
#else
{ "You have black eyes, ", 100, 71, 72, 50 },
#endif


#ifdef JP
{ "なめらかな",                        70, 72, 73, 50 },
{ "波打った",                            90, 72, 73, 50 },
{ "カールした",                          100, 72, 73, 50 },

{ "黒い髪、そしてとても暗い色の肌をしています。", 100, 73, 0, 50 },
#else
{ "straight ",                        70, 72, 73, 50 },
{ "wavy ",                            90, 72, 73, 50 },
{ "curly ",                          100, 72, 73, 50 },

{ "black hair and a very dark complexion.", 100, 73, 0, 50 },
#endif


#ifdef JP
{ "あなたの母親はオーガでしたが、それは秘密にされています。", 25, 74, 20, 25 },
{ "あなたの父親はオーガでしたが、それは秘密にされています。", 100, 74, 20, 25 },
#else
{ "Your mother was an Ogre, but it is unacknowledged.  ", 25, 74, 20, 25 },
{ "Your father was an Ogre, but it is unacknowledged.  ", 100, 74, 20, 25 },
#endif


#ifdef JP
{ "あなたの母親は丘ジャイアントでした。", 10, 75, 20, 50 },
{ "あなたの母親はファイアー・ジャイアントでした。", 12, 75, 20, 55 },
{ "あなたの母親はフロスト・ジャイアントでした。", 20, 75, 20, 60 },
{ "あなたの母親はクラウド・ジャイアントでした。", 23, 75, 20, 65 },
{ "あなたの母親はストーム・ジャイアントでした。", 25, 75, 20, 70 },
{ "あなたの父親は丘ジャイアントでした。",  60, 75, 20, 50 },
{ "あなたの父親はファイアー・ジャイアントでした。",  70, 75, 20, 55 },
{ "あなたの父親はフロスト・ジャイアントでした。",  80, 75, 20, 60 },
{ "あなたの父親はクラウド・ジャイアントでした。",  90, 75, 20, 65 },
{ "あなたの父親はストーム・ジャイアントでした。", 100, 75, 20, 70 },
#else
{ "Your mother was a Hill Giant.  ", 10, 75, 20, 50 },
{ "Your mother was a Fire Giant.  ", 12, 75, 20, 55 },
{ "Your mother was a Frost Giant.  ", 20, 75, 20, 60 },
{ "Your mother was a Cloud Giant.  ", 23, 75, 20, 65 },
{ "Your mother was a Storm Giant.  ", 25, 75, 20, 70 },
{ "Your father was a Hill Giant.  ",  60, 75, 20, 50 },
{ "Your father was a Fire Giant.  ",  70, 75, 20, 55 },
{ "Your father was a Frost Giant.  ",  80, 75, 20, 60 },
{ "Your father was a Cloud Giant.  ",  90, 75, 20, 65 },
{ "Your father was a Storm Giant.  ", 100, 75, 20, 70 },
#endif


#ifdef JP
{ "あなたの父親は名の知れぬタイタンでした。", 75, 76, 20, 50 },
{ "あなたの母親はテミスでした。",        80, 76, 20, 100 },
{ "あなたの母親はメノシンでした。",     85, 76, 20, 100 },
{ "あなたの父親はオケアノスでした。",      90, 76, 20, 100 },
{ "あなたの父親はクリウスでした。",         95, 76, 20, 100 },
{ "あなたの父親はハイペリオンでした。",      98, 76, 20, 125 },
{ "あなたの父親はクロノスでした。",       100, 76, 20, 150 },
#else
{ "Your father was an unknown Titan.  ", 75, 76, 20, 50 },
{ "Your mother was Themis.  ",        80, 76, 20, 100 },
{ "Your mother was Mnemosyne.  ",     85, 76, 20, 100 },
{ "Your father was Okeanoas.  ",      90, 76, 20, 100 },
{ "Your father was Crius.  ",         95, 76, 20, 100 },
{ "Your father was Hyperion.  ",      98, 76, 20, 125 },
{ "Your father was Kronos.  ",       100, 76, 20, 150 },
#endif


#ifdef JP
{ "あなたは名の知れぬサイクロプスの子孫です。", 90, 77, 109, 50 },
{ "あなたはポリフェモスの子供です。", 98, 77, 109, 80 },
{ "あなたはウラノスの子供です。", 100, 77, 109, 135 },
#else
{ "You are the offspring of an unknown Cyclops.  ", 90, 77, 109, 50 },
{ "You are Polyphemos's child.  ", 98, 77, 109, 80 },
{ "You are Uranos's child.  ", 100, 77, 109, 135 },
#endif


#ifdef JP
{ "何人かの子供のうちの一人です。", 100, 79, 80, 50 },

{ "あなたはブラウン・イークの", 		50, 78, 79, 50 },
{ "あなたはブルー・イークの", 		75, 78, 79, 50 },
{ "あなたはマスター・イークの", 		95, 78, 79, 85 },
{ "あなたはイークの王『ボルドール』の", 100, 78, 79, 120 },
#else
{ "You are one of several children of ", 100, 78, 79, 50 },

{ "a Brown Yeek. ", 50, 79, 80, 50 },
{ "a Blue Yeek.  ", 75, 79, 80, 50 },
{ "a Master Yeek.  ", 95, 79, 80, 85 },
{ "Boldor, the King of the Yeeks.  ", 100, 79, 80, 120 },
#endif


#ifdef JP
{ "あなたは青い瞳と",    25, 80, 81, 50 },
{ "あなたは光る瞳と",    50, 80, 81, 50 },
{ "あなたは小さな黒い瞳と",    75, 80, 81, 50 },
{ "あなたは黒く輝く瞳と",    100, 80, 81, 50 },

{ "髪のない頭、",        20, 81, 65, 50 },
{ "黒く短い髪、",        40, 81, 65, 50 },
{ "黒く長い髪、",        60, 81, 65, 50 },
{ "燃えるような赤い髪、",        80, 81, 65, 50 },
{ "色のない白い髪、",        100, 81, 65, 50 },
#else
{ "You have pale eyes, ",    25, 80, 81, 50 },
{ "You have glowing eyes, ",    50, 80, 81, 50 },
{ "You have tiny black eyes, ",    75, 80, 81, 50 },
{ "You have shining black eyes, ",    100, 80, 81, 50 },

{ "no hair at all, ",        20, 81, 65, 50 },
{ "short black hair, ",        40, 81, 65, 50 },
{ "long black hair, ",        60, 81, 65, 50 },
{ "bright red hair, ",        80, 81, 65, 50 },
{ "colourless albino hair, ",        100, 81, 65, 50 },
#endif


#ifdef JP
{ "の何人かの子供のうちの一人です。 ", 100, 83, 80, 50 },

{ "あなたはスモール・コボルド",   	40, 82, 83, 50 },
{ "あなたはコボルド",         		75, 82, 83, 55 },
{ "あなたはラージ・コボルド",   		95, 82, 83, 65 },
{ "あなたはコボルドの王『ムガッシュ』",   100, 82, 83, 100 },
#else
{ "You are one of several children of ", 100, 82, 83, 50 },

{ "a Small Kobold.  ",   40, 83, 80, 50 },
{ "a Kobold.  ",         75, 83, 80, 55 },
{ "a Large Kobold.  ",   95, 83, 80, 65 },
{ "Mughash, the Kobold Lord.  ",     100, 83, 80, 100 },
#endif


#ifdef JP
{ "あなたは女王クラッコンの何人かの子供のうちの一人です。"
, 100, 84, 85, 50 },

{ "あなたは赤い肌と", 40, 85, 86, 50 },
{ "あなたは黒い肌と", 90, 85, 86, 50 },
{ "あなたは黄色い肌と", 100, 85, 86, 50 },

{ "黒い目をしています。", 100, 86, 0, 50 },
#else
{ "You are one of several children of a Klackon hive queen.  "
, 100, 84, 85, 50 },

{ "You have red skin, ", 40, 85, 86, 50 },
{ "You have black skin, ", 90, 85, 86, 50 },
{ "You have yellow skin, ", 100, 85, 86, 50 },

{ "and black eyes.", 100, 86, 0, 50 },
#endif


#ifdef JP
{ "の何人かの子供のうちの一人です。", 100, 88, 18, 89 },

{ "あなたはニーベルングの奴隷", 30,	87, 88, 20 },
{ "あなたはニーベルングの盗賊", 50, 	87, 88, 40 },
{ "あなたはニーベルングの鍛冶屋", 70, 	87, 88, 60 },
{ "あなたはニーベルングの坑夫", 90, 	87, 88, 75 },
{ "あなたはニーベルングのシャーマン", 95,87, 88, 100 },
{ "あなたはニーベルングの王『ミーメ』", 100,87, 88, 100 },/*nuke me*/
#else
{ "You are one of several children of ", 100, 87, 88, 89 },

{ "a Nibelung Slave.  ", 30, 88, 18, 20 },
{ "a Nibelung Thief.  ", 50, 88, 18, 40 },
{ "a Nibelung Smith.  ", 70, 88, 18, 60 },
{ "a Nibelung Miner.  ", 90, 88, 18, 75 },
{ "a Nibelung Shaman.  ", 95, 88, 18, 100 },
{ "Mime, the Nibelung.  ", 100, 88, 18, 100 },
#endif

#ifdef JP
{ "あなたはドラコニアンの", 100, 89, 90, 50 },

{ "の長子です。", 30, 135, 91, 55 },
{ "の末子です。", 50, 135, 91, 50 },
{ "の養子です。", 55, 135, 91, 50 },
{ "の孤児です。", 60, 135, 91, 45 },
{ "の幾人かの子供のうちの一人です。", 85, 135, 91, 50 },
{ "の一粒種です。", 100, 135, 91, 55 },

{ "乞食", 10, 90, 135, 20 },
{ "盗賊", 21, 90, 135, 30 },
{ "水夫", 26, 90, 135, 45 },
{ "傭兵", 42, 90, 135, 45 },
{ "戦士", 73, 90, 135, 50 },
{ "商人", 78, 90, 135, 50 },
{ "職人", 85, 90, 135, 55 },
{ "治療家", 89, 90, 135, 60 },
{ "僧侶", 94, 90, 135, 65 },
{ "魔術師", 97, 90, 135, 70 },
{ "学者", 99, 90, 135, 80 },
{ "貴族", 100, 90, 135, 100 },

{ "あなたは", 100, 91, 136, 50 },

{ "は黒灰色の翼と肌、そして灰色の腹をしています。", 11, 136, 0, 50 },
{ "ブロンズ色の翼と肌、そして銅色の腹をしています。", 16, 136, 0, 50 },
{ "黄金の翼を持ち、黄金の肌をしています。", 24, 136, 0, 50 },
{ "白い翼を持ち、白い肌をしています。", 26, 136, 0, 60 },
{ "青い翼と肌、そして水色の腹をしています。", 32, 136, 0, 50 },
{ "万色の翼を持ち、肌も万色です。", 33, 136, 0, 70 },
{ "茶色の翼を持ち、茶色の肌をしています。", 37, 136, 0, 45 },
{ "黒い翼と肌、そして白い腹をしています。", 41, 136, 0, 50 },
{ "薄紫色の翼と肌、そして白い腹をしています。", 48, 136, 0, 50 },
{ "緑色の翼と肌、そして黄色い腹をしています。", 65, 136, 0, 50 },
{ "緑色の翼を持ち、緑色の肌をしています。", 75, 136, 0, 50 },
{ "赤い翼を持ち、赤い肌をしています。", 88, 136, 0, 50 },
{ "黒い翼を持ち、黒い肌をしています。", 94, 136, 0, 50 },
{ "きらめく翼を持ち、金属的な肌をしています。", 100, 136, 0, 55 },
#else
{ "You are ", 100, 89, 135, 50 },

{ "the oldest child of a Draconian ", 30, 135, 90, 55 },
{ "the youngest child of a Draconian ", 50, 135, 90, 50 },
{ "the adopted child of a Draconian ", 55, 135, 90, 50 },
{ "an orphaned child of a Draconian ", 60, 135, 90, 45 },
{ "one of several children of a Draconian ", 85, 135, 90, 50 },
{ "the only child of a Draconian ", 100, 135, 90, 55 },

{ "Beggar.  ", 10, 90, 91, 20 },
{ "Thief.  ", 21, 90, 91, 30 },
{ "Sailor.  ", 26, 90, 91, 45 },
{ "Mercenary.  ", 42, 90, 91, 45 },
{ "Warrior.  ", 73, 90, 91, 50 },
{ "Merchant.  ", 78, 90, 91, 50 },
{ "Artisan.  ", 85, 90, 91, 55 },
{ "Healer.  ", 89, 90, 91, 60 },
{ "Priest.  ", 94, 90, 91, 65 },
{ "Mage.  ", 97, 90, 91, 70 },
{ "Scholar.  ", 99, 90, 91, 80 },
{ "Noble.  ", 100, 90, 91, 100 },

{ "You have ", 100, 91, 136, 50 },

{ "charcoal wings, charcoal skin and a smoke-gray belly.", 11, 136, 0, 50 },
{ "bronze wings, bronze skin, and a copper belly.", 16, 136, 0, 50 },
{ "golden wings, and golden skin.", 24, 136, 0, 50 },
{ "white wings, and white skin.", 26, 136, 0, 60 },
{ "blue wings, blue skin, and a cyan belly.", 32, 136, 0, 50 },
{ "multi-hued wings, and multi-hued skin.", 33, 136, 0, 70 },
{ "brown wings, and brown skin.", 37, 136, 0, 45 },
{ "black wings, black skin, and a white belly.", 41, 136, 0, 50 },
{ "lavender wings, lavender skin, and a white belly.", 48, 136, 0, 50 },
{ "green wings, green skin and yellow belly.", 65, 136, 0, 50 },
{ "green wings, and green skin.", 75, 136, 0, 50 },
{ "red wings, and red skin.", 88, 136, 0, 50 },
{ "black wings, and black skin.", 94, 136, 0, 50 },
{ "metallic skin, and shining wings.", 100, 136, 0, 55 },
#endif



#ifdef JP
{ "あなたは偉大なる長老たちの脳味噌が浮かんでいる母なる池でオタマジャクシとして生まれました。あなたはヌルヌルした肌と輝く空虚な目をしていて、", 100, 92, 93, 80 },
{ "口の周りに三本の触手が生えています。", 20, 93, 0, 45 },
{ "口の周りに四本の触手が生えています。", 80, 93, 0, 50 },
{ "口の周りに五本の触手が生えています。", 100, 93, 0, 55 },
#else
{ "You have slimy skin, empty glowing eyes, and ", 100, 92, 93, 80 },
{ "three tentacles around your mouth.", 20, 93, 0, 45 },
{ "four tentacles around your mouth.", 80, 93, 0, 50 },
{ "five tentacles around your mouth.", 100, 93, 0, 55 },
#endif


#ifdef JP
{ "あなたの祖先は", 100, 94, 95, 50 },

{ "心を持たない地獄の低級な生物でした。", 30, 95, 96, 20 },
{ "下級悪魔でした。", 60, 95, 96, 50 },
{ "上級悪魔でした。", 90, 95, 96, 75 },
{ "魔王でした。", 100, 95, 96, 99 },

{ "あなたは赤い肌と", 50, 96, 97, 50 },
{ "あなたは茶色い肌と", 100, 96, 97, 50 },

{ "赤く燃える瞳をしていて、鉤爪と牙と刺が生えています。", 40, 97, 0, 50 },
{ "赤く燃える瞳をしていて、鉤爪と牙が生えています。", 70, 97, 0, 50 },
{ "赤く燃える瞳をしていて、鉤爪が生えています。", 100, 97, 0, 50 },
#else
{ "You ancestor was ", 100, 94, 95, 50 },

{ "a mindless demonic spawn.  ", 30, 95, 96, 20 },
{ "a minor demon.  ", 60, 95, 96, 50 },
{ "a major demon.  ", 90, 95, 96, 75 },
{ "a demon lord.  ", 100, 95, 96, 99 },

{ "You have red skin, ", 50, 96, 97, 50 },
{ "You have brown skin, ", 100, 96, 97, 50 },

{ "claws, fangs, spikes, and glowing red eyes.", 40, 97, 0, 50 },
{ "claws, fangs, and glowing red eyes.", 70, 97, 0, 50 },
{ "claws, and glowing red eyes.", 100, 97, 0, 50 },
#endif


#ifdef JP
{ "あなたはカバラの秘術によって", 40,	98, 99, 50 },
{ "あなたは魔法使いによって", 65, 	98, 99, 50 },
{ "あなたは錬金術師によって",	     90,	98, 99, 50 },
{ "あなたは僧侶によって", 100,	98, 99, 60 },

{ "悪と戦うために", 10, 99, 100, 65 },
{ "",		 100,  99, 100, 50 },

{ "粘土から", 40, 100, 101, 50 },
{ "岩石から", 80, 100, 101, 50 },
{ "木から", 85, 100, 101, 40 },
{ "鉄から", 99, 100, 101, 50 },
{ "純金から", 100, 100, 101, 100 },

{ "作り出されました。", 100,101, 0, 50 },
#else
{ "You were shaped from ", 100, 98, 99, 50 },

{ "clay ", 40, 99, 100, 50 },
{ "stone ", 80, 99, 100, 50 },
{ "wood ", 85, 99, 100, 40 },
{ "iron ", 99, 99, 100, 50 },
{ "pure gold ", 100, 99, 100, 100 },

{ "by a Kabbalist", 40, 100, 101, 50 },
{ "by a Wizard", 65, 100, 101, 50 },
{ "by an Alchemist", 90, 100, 101, 50 },
{ "by a Priest", 100, 100, 101, 60 },

{ " to fight evil.", 10, 101, 0, 65 },
{ ".", 100, 101, 0, 50 },
#endif


#ifdef JP
{ "あなたは", 100, 102, 103, 50 },

{ "死霊術士により作り出されました。", 30, 103, 104, 50 },
{ "魔法の実験により作り出されました。", 50, 103, 104, 50 },
{ "邪悪な僧侶により作り出されました。", 70, 103, 104, 50 },
{ "悪魔との契約により生み出されました。", 75, 103, 104, 50 },
{ "怨霊から生まれました。", 85, 103, 104, 50 },
{ "呪いから生まれました。", 95, 103, 104, 30 },
{ "神名濫用により生み出されました。", 100, 103, 104, 50 },

{ "あなたは", 100, 104, 105, 50 },
{ "古く汚れた骨で出来ていて、", 40, 105, 106, 50 },
{ "腐った黒い骨で出来ていて、", 60, 105, 106, 50 },
{ "うす汚れた茶色い骨で出来ていて、", 80, 105, 106, 50 },
{ "白く輝く骨で出来ていて、", 100, 105, 106, 50 },

{ "光る目をしています。", 30, 106, 0, 50 },
{ "地獄の劫火が燃えさかる目をしています。", 50, 106, 0, 50 },
{ "眼窩はからっぽです。", 100, 106, 0, 50 },
#else
{ "You were created by ", 100, 102, 103, 50 },

{ "a Necromancer.  ", 30, 103, 104, 50 },
{ "a magical experiment.  ", 50, 103, 104, 50 },
{ "an Evil Priest.  ", 70, 103, 104, 50 },
{ "a pact with the demons.  ", 75, 103, 104, 50 },
{ "a restless spirit.  ", 85, 103, 104, 50 },
{ "a curse.  ", 95, 103, 104, 30 },
{ "an oath.  ", 100, 103, 104, 50 },

{ "You have ", 100, 104, 105, 50 },
{ "dirty, dry bones, ", 40, 105, 106, 50 },
{ "rotten black bones, ", 60, 105, 106, 50 },
{ "filthy, brown bones, ", 80, 105, 106, 50 },
{ "shining white bones, ", 100, 105, 106, 50 },

{ "and glowing eyes.", 30, 106, 0, 50 },
{ "and eyes which burn with hellfire.", 50, 106, 0, 50 },
{ "and empty eyesockets.", 100, 106, 0, 50 },
#endif


#ifdef JP
{ "あなたは", 100, 107, 108, 50 },

{ "死霊術士により生み出されました。", 30, 108, 62, 50 },
{ "魔法使いにより生み出されました。", 50, 108, 62, 50 },
{ "怨霊から生まれました。",60, 108, 62, 50 },
{ "邪悪な僧侶により生み出されました。", 70, 108, 62, 50 },
{ "悪魔との契約により生み出されました。", 80, 108, 62, 50 },
{ "呪いから生まれました。", 95, 108, 62, 30 },
{ "神名濫用により生み出されました。", 100, 108, 62, 50 },

{ "あなたは暗褐色の瞳、",               20, 109, 110, 50 },
{ "あなたは褐色の瞳、",                    60, 109, 110, 50 },
{ "あなたは薄茶色の瞳、",                    70, 109, 110, 50 },
{ "あなたは緑色の瞳、",                    80, 109, 110, 50 },
{ "あなたは青い瞳、",                     90, 109, 110, 50 },
{ "あなたは淡青色の瞳、",               100, 109, 110, 50 }, /*tansei.cc.u-tokyoの由来 */

{ "なめらかな",                        70, 110, 111, 50 },
{ "波打った",                            90, 110, 111, 50 },
{ "カールした",                          100, 110, 111, 50 },

{ "黒い髪、",                         30, 111, 112, 50 },
{ "茶色い髪、",                         70, 111, 112, 50 },
{ "赤茶色の髪、",                        80, 111, 112, 50 },
{ "赤い髪、",                       90, 111, 112, 50 },
{ "金髪、",                        100, 111, 112, 50 },

{ "そしてとても暗い肌をしています。",              10, 112, 0, 50 },
{ "そして暗い肌をしています。",                   30, 112, 0, 50 },
{ "そして平均的な肌の色をしています。",               80, 112, 0, 50 },
{ "そして血色のいい肌をしています。",                   90, 112, 0, 50 },
{ "そしてとても血色のいい肌をしています。",             100, 112, 0, 50 },
#else
{ "You were created by ", 100, 107, 108, 50 },

{ "a Necromancer.  ", 30, 108, 62, 50 },
{ "a Wizard.  ", 50, 108, 62, 50 },
{ "a restless spirit.  ",60, 108, 62, 50 },
{ "an Evil Priest.  ", 70, 108, 62, 50 },
{ "a pact with the demons.  ", 80, 108, 62, 50 },
{ "a curse.  ", 95, 108, 62, 30 },
{ "an oath.  ", 100, 108, 62, 50 },

{ "You have a dark brown eye, ",               20, 109, 110, 50 },
{ "You have a brown eye, ",                    60, 109, 110, 50 },
{ "You have a hazel eye, ",                    70, 109, 110, 50 },
{ "You have a green eye, ",                    80, 109, 110, 50 },
{ "You have a blue eye, ",                     90, 109, 110, 50 },
{ "You have a blue-gray eye, ",               100, 109, 110, 50 },

{ "straight ",                        70, 110, 111, 50 },
{ "wavy ",                            90, 110, 111, 50 },
{ "curly ",                          100, 110, 111, 50 },

{ "black hair, ",                         30, 111, 112, 50 },
{ "brown hair, ",                         70, 111, 112, 50 },
{ "auburn hair, ",                        80, 111, 112, 50 },
{ "red hair, ",                       90, 111, 112, 50 },
{ "blond hair, ",                        100, 111, 112, 50 },

{ "and a very dark complexion.",              10, 112, 0, 50 },
{ "and a dark complexion.",                   30, 112, 0, 50 },
{ "and an average complexion.",               80, 112, 0, 50 },
{ "and a fair complexion.",                   90, 112, 0, 50 },
{ "and a very fair complexion.",             100, 112, 0, 50 },
#endif


#ifdef JP
{ "あなたは銘のない墓の中から甦りました。", 20, 113, 114, 50 },
{ "あなたは生前ただの百姓でしたが、強大なバンパイア・ロードの餌食となってしまいました。", 40, 113, 114, 50 },
{ "あなたは生前はバンパイア・ハンターでしたが、彼らの餌食となってしまいました。", 60, 113, 114, 50 },
{ "あなたは生前は死霊術士でした。", 80, 113, 114, 50 },
{ "あなたは生前は強大な貴族でした。", 95, 113, 114, 50 },
{ "あなたは生前は強大で残忍な専制君主でした。", 100, 113, 114, 50 },
#else
{ "You arose from an unmarked grave.  ", 20, 113, 114, 50 },
{ "In life you were a simple peasant, the victim of a powerful Vampire Lord.  ", 40, 113, 114, 50 },
{ "In life you were a Vampire Hunter, but they got you.  ", 60, 113, 114, 50 },
{ "In life you were a Necromancer.  ", 80, 113, 114, 50 },
{ "In life you were a powerful noble.  ", 95, 113, 114, 50 },
{ "In life you were a powerful and cruel tyrant.  ", 100, 113, 114, 50 },
#endif


#ifdef JP
{ "あなたは", 100, 114, 115, 50 },

{ "漆黒の髪、", 25, 115, 116, 50 },
{ "もつれたブラウンの髪、", 50, 115, 116, 50 },
{ "白い髪、", 75, 115, 116, 50 },
{ "髪のない頭、", 100, 115, 116, 50 },
#else
{ "You have ", 100, 114, 115, 50 },

{ "jet-black hair, ", 25, 115, 116, 50 },
{ "matted brown hair, ", 50, 115, 116, 50 },
{ "white hair, ", 75, 115, 116, 50 },
{ "a hairless head, ", 100, 115, 116, 50 },
#endif


#ifdef JP
{ "燃える石炭のような瞳、", 25, 116, 117, 50 },
{ "瞳のない目、", 50, 116, 117, 50 },
{ "凶暴な黄色い瞳、", 75, 116, 117, 50 },
{ "血走った赤い瞳、", 100, 116, 117, 50 },

{ "そして死人のように青ざめた肌をしています。", 100, 117, 0, 50 },
#else
{ "eyes like red coals, ", 25, 116, 117, 50 },
{ "blank white eyes, ", 50, 116, 117, 50 },
{ "feral yellow eyes, ", 75, 116, 117, 50 },
{ "bloodshot red eyes, ", 100, 116, 117, 50 },

{ "and a deathly pale complexion.", 100, 117, 0, 50 },
#endif


#ifdef JP
{ "あなたは", 100, 118, 119, 50 },

{ "死霊術士により作り出されました。", 30, 119, 134, 50 },
{ "魔法の実験により作り出されました。", 50, 119, 134, 50 },
{ "邪悪な僧侶により作り出されました。", 70, 119, 134, 50 },
{ "悪魔との契約により生み出されました。", 75, 119, 134, 50 },
{ "怨霊から生まれました。", 85, 119, 134, 50 },
{ "呪いから生まれました。", 95, 119, 134, 30 },
{ "神名濫用により生み出されました。", 100, 119, 134, 50 },
#else
{ "You were created by ", 100, 118, 119, 50 },

{ "a Necromancer.  ", 30, 119, 134, 50 },
{ "a magical experiment.  ", 50, 119, 134, 50 },
{ "an Evil Priest.  ", 70, 119, 134, 50 },
{ "a pact with the demons.  ", 75, 119, 134, 50 },
{ "a restless spirit.  ", 85, 119, 134, 50 },
{ "a curse.  ", 95, 119, 134, 30 },
{ "an oath.  ", 100, 119, 134, 50 },
#endif


#ifdef JP
{ "漆黒の髪、", 25, 120, 121, 50 },
{ "もつれたブラウンの髪、", 50, 120, 121, 50 },
{ "白い髪、", 75, 120, 121, 50 },
{ "髪のない頭、", 100, 120, 121, 50 },
#else
{ "jet-black hair, ", 25, 120, 121, 50 },
{ "matted brown hair, ", 50, 120, 121, 50 },
{ "white hair, ", 75, 120, 121, 50 },
{ "a hairless head, ", 100, 120, 121, 50 },
#endif


#ifdef JP
{ "燃える石炭のような瞳、", 25, 121, 122, 50 },
{ "瞳のない目、", 50, 121, 122, 50 },
{ "凶暴な黄色い瞳、", 75, 121, 122, 50 },
{ "血走った赤い瞳、", 100, 121, 122, 50 },
#else
{ "eyes like red coals, ", 25, 121, 122, 50 },
{ "blank white eyes, ", 50, 121, 122, 50 },
{ "feral yellow eyes, ", 75, 121, 122, 50 },
{ "bloodshot red eyes, ", 100, 121, 122, 50 },
#endif


#ifdef JP
{ "そして死人のような土色の肌をしています。", 100, 122, 123, 50 },
{ "あなたの周りには不気味な緑色のオーラがただよっています。", 100, 123, 0, 50 },
#else
{ " and a deathly gray complexion. ", 100, 122, 123, 50 },
{ "An eerie green aura surrounds you.", 100, 123, 0, 50 },
#endif


#ifdef JP
{ "あなたの両親は", 100, 124, 125, 50 },

{ "ピクシーでした。", 20, 125, 126, 35 },
{ "ニクシーでした。", 30, 125, 126, 25 },
{ "森の妖精でした。", 75, 125, 126, 50 },
{ "森の精霊でした。", 90, 125, 126, 75 },
{ "妖精の貴族でした。", 100, 125, 126, 85 }, /*nuke me カタカナのほうがいいかも */
#else
{ "Your parents were ", 100, 124, 125, 50 },

{ "pixies.  ", 20, 125, 126, 35 },
{ "nixies.  ", 30, 125, 126, 25 },
{ "wood sprites.  ", 75, 125, 126, 50 },
{ "wood spirits.  ", 90, 125, 126, 75 },
{ "noble faerie folk.  ", 100, 125, 126, 85 },
#endif


#ifdef JP
{ "あなたは背中にライトブルーの羽根が生えていて、", 100, 126, 127, 50 },

{ "なめらかな金髪、",                        80, 127, 128, 50 },
{ "波打った金髪、",                            100, 127, 128, 50 },

{ "青い瞳、そして非常に生き生きとした肌をしています。", 100, 128, 0, 50 },
#else
{ "You have light blue wings attached to your back, ", 100, 126, 127, 50 },

{ "straight blond hair, ",                        80, 127, 128, 50 },
{ "wavy blond hair, ",                            100, 127, 128, 50 },

{ "blue eyes, and a very fair complexion.", 100, 128, 0, 50 },
#endif


#ifdef JP
{ "あなたは魔法の実験により生み出されました。", 30, 129, 130, 40 },
{ "あなたは子供時代、愚かにも純ログルスに頭を突っ込んでしまいました。",
50, 129, 130, 50 }, /*nuke me*/
{ "あるカオスの魔王が遊びであなたを作り上げました。",
60, 129, 130, 60 },
{ "あなたは魔法により掛け合わされた動物と人間の子供です。", 75, 129, 130, 50 },
{ "あなたは言うもおぞましいカオスの生物の冒涜的な掛け合わせにより生まれました。", 100, 129, 130, 30 },
#else
{ "You were produced by a magical experiment.  ", 30, 129, 130, 40 },
{ "In your childhood, you were stupid enough to stick your head in raw Logrus.  ",
50, 129, 130, 50 },
{ "A Demon Lord of Chaos decided to have some fun, and so he created you.  ",
60, 129, 130, 60 },
{ "You are the magical crossbreed of an animal and a man.  ", 75, 129, 130, 50 },
{ "You are the blasphemous crossbreed of unspeakable creatures of chaos.  ", 100, 129, 130, 30 },
#endif



#ifdef JP
{ "あなたは緑色の爬虫類の目",              60, 130, 131, 50 },
{ "あなたは黒い鳥の目",                    85, 130, 131, 50 },
{ "あなたはオレンジ色の猫の目",            99, 130, 131, 50 },
{ "あなたは燃えるような悪魔の目",          100, 130, 131, 55 },
#else
{ "You have green reptilian eyes, ",              60, 130, 131, 50 },
{ "You have the black eyes of a bird, ",              85, 130, 131, 50 },
{ "You have the orange eyes of a cat, ",               99, 130, 131, 50 },
{ "You have the fiery eyes of a demon, ",             100, 130, 131, 55 },
#endif


#ifdef JP

{ "と髪のない頭を持ち、",                 10, 131, 133, 50 },
{ "をしていて、汚い",                     33, 131, 132, 50 },
{ "をしていて、みすぼらしい",             66, 131, 132, 50 },
{ "をしていて、てかった",                100, 131, 132, 50 },
#else
{ "no hair at all, ",                 10, 131, 133, 50 },
{ "dirty ",                           33, 131, 132, 50 },
{ "mangy ",                           66, 131, 132, 50 },
{ "oily ",                           100, 131, 132, 50 },
#endif


#ifdef JP

{ "茶色の毛皮と",                    33, 132, 133, 50 },
{ "灰色の毛皮と",                    66, 132, 133, 50 },
{ "白い毛皮と",                     100, 132, 133, 50 },
#else
{ "brown fur, ",                    33, 132, 133, 50 },
{ "gray fur, ",                    66, 132, 133, 50 },
{ "albino fur, ",                  100, 132, 133, 50 },
#endif


#ifdef JP
{ "山羊の蹄があります。",      50, 133, 0, 50 },
{ "人間の足が生えています。",  75, 133, 0, 50 },
{ "鳥の足が生えています。",    85, 133, 0, 50 },
{ "爬虫類の足が生えています。",90, 133, 0, 50 },
{ "牛の足が生えています。",    95, 133, 0, 50 },
{ "猫の足が生えています。",    97, 133, 0, 50 },
{ "犬の足が生えています。",   100, 133, 0, 50 },

{ "あなたは", 100, 134, 120, 50 },
#else
{ "and the hooves of a goat.",      50, 133, 0, 50 },
{ "and human feet.",        75, 133, 0, 50 },
{ "and bird's feet.",       85, 133, 0, 50 },
{ "and reptilian feet.",    90, 133, 0, 50 },
{ "and bovine feet.",       95, 133, 0, 50 },
{ "and feline feet.",       97, 133, 0, 50 },
{ "and canine feet.",       100, 133, 0, 50 },

{ "You have ", 100, 134, 120, 50 },
#endif


#ifdef JP
{ "行方不明の子です。", 25, 138, 139, 40 },
{ "さまよう子です。", 50, 138, 139, 50 },
{ "唯一の子です。", 75, 138, 139, 60 },
{ "愛されている子です。", 100, 138, 139, 70 },
#else
{ "You are the lost offspring of ", 25, 137, 138, 40 },
{ "You are the wandering offspring of ", 50, 137, 138, 50 },
{ "You are the only offspring of ", 75, 137, 138, 60 },
{ "You are the beloved offspring of ", 100, 137, 138, 70 },
#endif


#ifdef JP
{ "あなたは名も知れぬエントの", 10, 137, 138, 35 },
{ "あなたは孤独なエントの", 35, 137, 138, 50 },
{ "あなたはエントの一団の一員の", 55, 137, 138, 60 },
{ "あなたは繁栄しているエントの社会のリーダーの", 70, 137, 138, 70 },
{ "あなたはエントの森の長の", 81, 137, 138, 80 },
{ "あなたは尊敬されているエントの賢者の", 91, 137, 138, 90 },
{ "あなたは今では追憶の中にしかいないエント女の", 96, 137, 138, 100 },
{ "あなたはファンゴルンその人の", 100, 137, 138, 110 },
#else
{ "an Ent whose name you have no recollection of.  ", 10, 138, 139, 35 },
{ "a solitary Ent.  ", 35, 138, 139, 50 },
{ "a member of a farflung Entish band.  ", 55, 138, 139, 60 },
{ "a leader of a prosperous community of Ents.  ", 70, 138, 139, 70 },
{ "an Entish Forestwarden.  ", 81, 138, 139, 80 },
{ "a respected Entish sage.  ", 91, 138, 139, 90 },
{ "an Entwife whose memory men cherish.  ", 96, 138, 139, 100 },
{ "Fangorn himself.  ", 100, 138, 139, 110 },
#endif

#ifdef JP
{ "あなたは", 100, 139, 140, 50 },
#else
{ "You have ", 100, 139, 140, 50 },
#endif

#ifdef JP
{ "三本の指を持ち、", 5, 140, 141, 50 },
{ "四本の指を持ち、", 20, 140, 141, 50 },
{ "五本の指を持ち、", 40, 140, 141, 50 },
{ "六本の指を持ち、", 60, 140, 141, 50 },
{ "七本の指を持ち、", 80, 140, 141, 50 },
{ "八本の指を持ち、", 95, 140, 141, 50 },
{ "九本の指を持ち、", 100, 140, 141, 50 },
#else
{ "three fingers and toes, and are covered in ", 5, 140, 141, 50 },
{ "four fingers and toes, and are covered in ", 20, 140, 141, 50 },
{ "five fingers and toes, and are covered in ", 40, 140, 141, 50 },
{ "six fingers and toes, and are covered in ", 60, 140, 141, 50 },
{ "seven fingers and toes, and are covered in ", 80, 140, 141, 50 },
{ "eight fingers and toes, and are covered in ", 95, 140, 141, 50 },
{ "nine fingers and toes, and are covered in ", 100, 140, 141, 50 },
#endif
#ifdef JP
{ "茶色い鱗状の肌に覆われています。", 10, 141, 0, 50 },
{ "茶色の荒い肌に覆われています。", 20, 141, 0, 50 },
{ "灰色のなめらかな肌に覆われています。", 30, 141, 0, 50 },
{ "深いグリーンの肌に覆われています。", 40, 141, 0, 50 },
{ "苔で覆われた肌をしています。", 50, 141, 0, 50 },
{ "深いブラウンの肌に覆われています。", 60, 141, 0, 50 },
{ "パールブラウンのパサパサの肌に覆われています。", 70, 141, 0, 50 },
{ "チョコレート色の豊かな肌に覆われています。", 80, 141, 0, 50 },
{ "黒い筋状の肌に覆われています。", 90, 141, 0, 50 },
{ "ほとんどひからびた、厚い肌に覆われています。", 100, 141, 0, 50 },
#else
{ "scaly brown skin.", 10, 141, 0, 50 },
{ "rough brown skin.", 20, 141, 0, 50 },
{ "smooth grey skin.", 30, 141, 0, 50 },
{ "dark green skin.", 40, 141, 0, 50 },
{ "mossy skin.", 50, 141, 0, 50 },
{ "deep brown skin.", 60, 141, 0, 50 },
{ "pale brown, flaky skin.", 70, 141, 0, 50 },
{ "rich chocolate-colored skin.", 80, 141, 0, 50 },
{ "ridged black skin.", 90, 141, 0, 50 },
{ "thick, almost corky skin.", 100, 141, 0, 50 },
#endif

#ifdef JP
{ "あなたは天界の主人です。", 100, 142, 143, 80 },
{ "あなたは悪を滅ぼすためにこの地に送られてきました。", 100, 143, 144, 80 },
{ "この目的を成し遂げるまでは休むことは許されません。", 100, 144, 0, 80 },
#else
{ "You are of the blessed host of heaven.  ", 100, 142, 143, 80 },
{ "You have been sent to earth to eradicate the wicked, ", 100, 143, 144, 80 },
{ "and shall not rest until you have succeeded.", 100, 144, 0, 80 },
#endif

#ifdef JP
{ "あなたは地獄の呪われた子です。", 100, 145, 146, 20 },
{ "あなたはグレーター・デーモンの気まぐれによって生まれました。", 100, 146, 147, 20 },
{ "あなたは復讐の機会をうかがっています。", 100, 147, 0, 20 },
#else
{ "You are of the cursed spawn of hell. ", 100, 145, 146, 20 },
{ "You have been cast out by the whim of the greater demons, ", 100, 146, 147, 20 },
{ "and now seek revenge.", 100, 147, 0, 20 },
#endif



#ifdef JP
{ "あなたは素性の知れない",  5, 148, 149, 25 },
{ "あなたは捕虜の", 20, 148, 149, 35 },
{ "あなたは戦士の", 40, 148, 149, 45 },
{ "あなたはレンジャーの", 50, 148, 149, 50 },
{ "あなたは書記の", 70, 148, 149, 65 },
{ "あなたは魔女の", 83, 148, 149, 75 },
{ "あなたは錬金術師の", 93, 148, 149, 90 },
{ "あなたは貴族の女性の", 98, 148, 149, 110 },
{ "あなたは女王の", 100, 148, 149, 140 },
#else
{ "whose identity you are uncertain of.",  5, 149, 8, 25 },
{ "Captive.  ", 20, 149, 150, 35 },
{ "Fighter.  ", 40, 149, 150, 45 },
{ "Ranger.  ", 50, 149, 150, 50 },
{ "Scribe.  ", 70, 149, 150, 65 },
{ "Witch.  ", 83, 149, 150, 75 },
{ "Alchemist.  ", 93, 149, 150, 90 },
{ "Lady.  ", 98, 149, 150, 110 },
{ "Queen.  ", 100, 149, 150, 140 },
#endif
#ifdef JP
{ "影フェアリーの私生児です。", 10, 149, 150, 35 },
{ "影フェアリーの幾人かの子供のうちの一人です。", 30, 149, 150, 45 },
{ "影フェアリーの第二子です。", 55, 149, 150, 50 },
{ "影フェアリーの長子です。", 80, 149, 150, 55 },
{ "影フェアリーの一粒種です。", 100, 149, 150, 60 },
#else
{ "You are the bastard child of a Shadow-Fairy ", 10, 148, 149, 35 },
{ "You are one of several children of a Shadow-Fairy ", 30, 148, 149, 45 },
{ "You are the second child of a Shadow-Fairy ", 55, 148, 149, 50 },
{ "You are the first child of a Shadow-Fairy ", 80, 148, 149, 55 },
{ "You are the only child of a Shadow-Fairy ", 100, 148, 149, 60 },
#endif


#ifdef JP
{ "あなたは黒い瞳と", 10, 150, 151, 50 },
{ "あなたは深いブラウンの瞳と", 25, 50, 151, 50 },
{ "あなたはブラウンの瞳と", 60, 150, 151, 50 },
{ "あなたは淡い色の瞳と", 70, 150, 151, 50 },
{ "あなたはグリーンの瞳と", 80, 150, 151, 50 },
{ "あなたは青い瞳と", 90, 150, 151, 50 },
{ "あなたはブルーグレイの瞳と", 100, 150, 151, 50 },
#else
{ "You have black eyes, straight ", 10, 150, 151, 50 },
{ "You have dark brown eyes, straight ", 25, 50, 151, 50 },
{ "You have brown eyes, straight ", 60, 150, 151, 50 },
{ "You have hazel eyes, straight ", 70, 150, 151, 50 },
{ "You have green eyes, straight ", 80, 150, 151, 50 },
{ "You have blue eyes, straight ", 90, 150, 151, 50 },
{ "You have blue-gray eyes, straight ", 100, 150, 151, 50 },
#endif

#ifdef JP
{ "グレーの髪を持ち、", 30, 152, 153, 50 },
{ "純白の髪を持ち、", 70, 152, 153, 50 },
{ "パールイエローの髪を持ち、", 80, 152, 153, 50 },
{ "白がかった灰色の髪を持ち、", 90, 152, 153, 50 },
{ "パールブラウンの髪を持ち、", 100, 152, 153, 50 },
#else
{ "grey hair ", 30, 151, 152, 50 },
{ "pure white hair ", 70, 151, 152, 50 },
{ "pale yellow hair ", 80, 151, 152, 50 },
{ "grey-white hair ", 90, 151, 152, 50 },
{ "pale brown hair ", 100, 151, 152, 50 },
#endif

#ifdef JP
{ "わずかに肩にかかるくらいのなめらかな", 30, 151, 152, 50 },
{ "腕まで届くくらいのなめらかな", 60, 151, 152, 55 },
{ "腰まであるなめらかな", 90, 151, 152, 60 },
{ "頭から足まで輝く滝のようになめらかな", 100, 151, 152, 75 },
#else
{ "that barely covers your shoulders, ", 30, 152, 153, 50 },
{ "that reaches to your arms, ", 60, 152, 153, 55 },
{ "that flows down to your waist, ", 90, 152, 153, 60 },
{ "that forms a shining waterfall from head to foot, ", 100, 152, 153, 75 },
#endif

#ifdef JP
{ "透き通るような白い肌をしています。", 20, 153, 0, 50 },
{ "ミルク色の肌をしています。", 35, 153, 0, 50 },
{ "真珠色の肌をしています。", 50, 153, 0, 50 },
{ "青白い肌をしています。", 85, 153, 0, 50 },
{ "白い肌をしています。", 100, 153, 0, 50 },
#else
{ "and an extremely fair complexion.", 20, 153, 0, 50 },
{ "and a milky complexion.", 35, 153, 0, 50 },
{ "and a pearly complexion.", 50, 153, 0, 50 },
{ "and a pale complexion.", 85, 153, 0, 50 },
{ "and an utterly white complexion.", 100, 153, 0, 50 },
#endif

#ifdef JP
{ "あなたは普段ザクザクデザートで遊んでいる、", 4, 154, 159, 50 },
{ "あなたは普段グラグラタワーで遊んでいる、", 8, 154, 159, 50 },
{ "あなたは普段ホヘホヘ峡谷で遊んでいる、", 12, 154, 159, 50 },
{ "あなたは普段ドプドプ池で遊んでいる、", 16, 154, 159, 50 },
{ "あなたは普段テクテク雑技場で遊んでいる、", 20, 154, 159, 50 },
{ "あなたは普段フムフム畑で遊んでいる、", 24, 154, 159, 50 },
{ "あなたは普段クノクノ滝で遊んでいる、", 28, 154, 159, 50 },
{ "あなたは普段クリクリ川で遊んでいる、", 32, 154, 159, 50 },
{ "あなたは普段テリテリキャンプ場で遊んでいる、", 36, 154, 159, 50 },
{ "あなたは普段クター像前で遊んでいる、", 40, 154, 159, 50 },
{ "あなたは普段テクノ湯で遊んでいる、", 44, 154, 159, 50 },
{ "あなたは普段テクノアイランドで遊んでいる、", 48, 154, 159, 50 },
{ "あなたは普段テクノマリンで遊んでいる、", 52, 154, 159, 50 },
{ "あなたは普段テクノドームで遊んでいる、", 56, 154, 159, 50 },
{ "あなたは普段テクノホールで遊んでいる、", 60, 154, 159, 50 },
{ "あなたは普段テクノ高原で遊んでいる、", 64, 154, 159, 50 },
{ "あなたは普段テクノ市民会館で遊んでいる、", 68, 154, 159, 50 },
{ "あなたは普段テクノ公園で遊んでいる、", 72, 154, 159, 50 },
{ "あなたは普段スイスイアルプスで遊んでいる、", 76, 154, 159, 65 },
{ "あなたは普段ヒソヒソ森で遊んでいる、", 80, 154, 159, 65 },
{ "あなたは普段テクノ生態研究所で遊んでいる、", 84, 154, 159, 65 },
{ "あなたは普段テクノロケット発射台で遊んでいる、", 88, 154, 159, 65 },
{ "あなたは普段チャイナウォールで遊んでいる、", 92, 154, 159, 65 },
{ "あなたは普段スペースウォールで遊んでいる、", 96, 154, 159, 70 },
{ "あなたは普段テクノリゾートホテルで遊んでいる、", 100, 154, 159, 75 },

{ "普通のクターです。", 70, 159, 160, 50 },
{ "みんなが頼りにしている親クターです。", 85, 159, 160, 65 },
{ "笹が大好物なパンダクターです。", 92, 159, 161, 75 },
{ "とても珍しいトラクターです。", 96, 159, 162, 80 },
{ "とても珍しいピカクターです。", 100, 159, 163, 90 },

{ "あなたは赤色の毛をもち、", 6, 160, 164, 50 },
{ "あなたはクリーム色の毛をもち、", 12, 160, 164, 50 },
{ "あなたは黄土色の毛をもち、", 18, 160, 164, 50 },
{ "あなたは黄色の毛をもち、", 24, 160, 164, 50 },
{ "あなたは黄緑色の毛をもち、", 30, 160, 164, 50 },
{ "あなたは抹茶色の毛をもち、", 36, 160, 164, 50 },
{ "あなたは濃い緑色の毛をもち、", 42, 160, 164, 50 },
{ "あなたは青緑色の毛をもち、", 48, 160, 164, 50 },
{ "あなたは水色の毛をもち、", 54, 160, 164, 50 },
{ "あなたは薄い紫色の毛をもち、", 60, 160, 164, 50 },
{ "あなたは紫色の毛をもち、", 65, 160, 164, 50 },
{ "あなたは茜色の毛をもち、", 70, 160, 164, 60 },
{ "あなたはピンク色の毛をもち、", 75, 160, 164, 60 },
{ "あなたは白色の毛をもち、", 80, 160, 164, 60 },
{ "あなたは青色の毛をもち、", 85, 160, 164, 65 },
{ "あなたは黒色の毛をもち、", 90, 160, 164, 65 },
{ "あなたは緑色の毛をもち、", 95, 160, 164, 65 },
{ "あなたは橙色の毛をもち、", 100, 160, 164, 70 },
{ "あなたはパンダのような白と黒の斑模様の毛をもち、", 100, 161, 164, 70 },
{ "あなたはトラのような黄と黒の縞模様の毛をもち、", 100, 162, 164, 70 },
{ "あなたは明るく輝いていて、", 100, 163, 164, 70 },

{ "マフラーを宝物にしています。", 4, 164, 0, 50 },
{ "ライターを宝物にしています。", 8, 164, 0, 50 },
{ "リモコンを宝物にしています。", 12, 164, 0, 50 },
{ "手ぬぐいを宝物にしています。", 16, 164, 0, 50 },
{ "牛乳ビンを宝物にしています。", 20, 164, 0, 50 },
{ "ビンのふたを宝物にしています。", 24, 164, 0, 50 },
{ "野球帽を宝物にしています。", 28, 164, 0, 50 },
{ "浮き輪を宝物にしています。", 32, 164, 0, 50 },
{ "バットを宝物にしています。", 36, 164, 0, 50 },
{ "大根を宝物にしています。", 40, 164, 0, 50 },
{ "リュックサックを宝物にしています。", 44, 164, 0, 50 },
{ "将棋盤を宝物にしています。", 48, 164, 0, 50 },
{ "将棋の駒を宝物にしています。", 52, 164, 0, 50 },
{ "傘を宝物にしています。", 56, 164, 0, 50 },
{ "やかんを宝物にしています。", 60, 164, 0, 50 },
{ "ほうきを宝物にしています。", 64, 164, 0, 50 },
{ "ティッシュ箱を宝物にしています。", 68, 164, 0, 50 },
{ "ダルマを宝物にしています。", 71, 164, 0, 50 },
{ "ニンジンを宝物にしています。", 75, 164, 0, 60 },
{ "ホルンを宝物にしています。", 79, 164, 0, 60 },
{ "みかん箱を宝物にしています。", 83, 164, 0, 60 },
{ "宝箱を宝物にしています。", 86, 164, 0, 60 },
{ "テンガロンハットを宝物にしています。", 90, 164, 0, 60 },
{ "アフロを宝物にしています。", 94, 164, 0, 65 },
{ "しゃけを宝物にしています。", 97, 164, 0, 65 },
{ "39ボウヤを宝物にしています。", 100, 164, 0, 70 },

#else
{ "You are a normal Kutar.  You have orange colored fur.", 65, 154, 0, 55 },
{ "You are a father Kutar, the patriarch of many normal Kutars.  You have green colored fur.", 95, 154, 0, 65 },
{ "You are a very rare type of Kutar, famed for the yellow and black stripes on your body.", 100, 154, 0, 80 },
#endif

#ifdef JP
{ "あなたはあるプロジェクトの試作品として", 10, 155, 156, 50 },
{ "あなたは子供を教育するために", 30, 155, 156, 60 },
{ "あなたは身の回りの世話をするために", 50, 155, 156, 70 },
{ "あなたは亡くなった子供の身代わりとして", 60, 155, 156, 10 },
{ "あなたは戦闘用アンドロイドとして", 90, 155, 156, 20 },
{ "あなたは世界征服のための道具として", 100, 155, 156, 10 },

{ "気の狂った科学者によって作られました。", 20, 156, 157, 10 },
{ "企業の研究所で作られました。", 50, 156, 157, 80 },
{ "平和を願う科学者によって作られました。", 85, 156, 157, 50 },
{ "一人の天才少年によって作られました。", 90, 156, 157, 30 },
{ "22世紀からやって来ました。", 100, 156, 157, 100 },

{ "ネコのような形をして", 15, 157, 158, 40 },
{ "イヌのような形をして", 30, 157, 158, 30 },
{ "クターのような形をして", 45, 157, 158, 20 },
{ "人間のような形をして", 70, 157, 158, 60 },
{ "ドワーフのような形をして", 80, 157, 158, 70 },
{ "ホビットのような形をして", 90, 157, 158, 70 },
{ "エルフのような形をして", 100, 157, 158,  80 },

{ "いますが、耳はネズミにかじられてなくなっています。", 5, 158, 0, 20 },
{ "いると作者は主張していますが、とてもそうは見えません。", 20, 158, 0, 30 },
{ "います。", 85, 158, 0, 50 },
{ "いて、本人は自分のことを本物だと信じています。", 95, 158, 0, 50 },
{ "いて、非常によくできているので本物と見分けがつきません。", 100, 158, 0, 100 },
#else
{ "You were created by a mad scientist ", 20, 155, 156, 10 },
{ "You were created in a corporate laboratory ", 50, 155, 156, 80 },
{ "You were created by a peace-loving scientist ", 85, 155, 156, 50 },
{ "You were created by a boy genius ", 90, 155, 156, 30 },
{ "You have come from the twenty-second century ", 100, 155, 156, 100 },

{ "as a project prototype. ", 10, 156, 157, 50 },
{ "to educate children. ", 30, 156, 157, 60 },
{ "to look after someone. ", 50, 156, 157, 70 },
{ "as a substitute for a dead child. ", 60, 156, 157, 10 },
{ "as a combat trooper. ", 90, 156, 157, 20 },
{ "as a tool for conquest of the world. ", 100, 156, 157, 10 },

{ "You have a cat-like appearance", 15, 157, 158, 40 },
{ "You have a dog-like appearance", 30, 157, 158, 30 },
{ "You have a Kutar-like appearance", 45, 157, 158, 20 },
{ "You have a human-like appearance", 70, 157, 158, 60 },
{ "You have a dwarf-like appearance", 80, 157, 158, 70 },
{ "You have a hobbit-like appearance", 90, 157, 158, 70 },
{ "You have a elf-like appearance", 100, 157, 158,  80 },

{ ", but your ears have been eaten by mice, and no trace of them remains.", 5, 158, 0, 20 },
{ "... at least your creator thinks so.  Most people disagree.", 20, 158, 0, 30 },
{ ".", 85, 158, 0, 50 },
{ ", and you firmly believe that you are a real one.", 95, 158, 0, 50 },
{ ", and you are almost indistinguishable from a real one.", 100, 158, 0, 100 },
#endif

#ifdef JP
{ "あなたはマーフォークの乞食の",			  5, 170, 171,  30 },
{ "あなたはマーフォークの物あさりの",			  10, 170, 171,  50 },
{ "あなたはマーフォークのペテン師の",		 15, 170, 171,  70 },
{ "あなたはマーフォークの平民の",		 60, 170, 171,  90 },
{ "あなたは川守りの",							 70, 170, 171,  80 },
{ "あなたはメロウの",							 80, 170, 171,  80 },
{ "あなたはセルキーの",							 85, 170, 171,  80 },
{ "あなたはトリトンの",							 90, 170, 171,  80 },
{ "あなたはマーフォークの交易商人の",			 95, 170, 171, 100 },
{ "あなたはマーフォークの君主の",				100, 170, 171, 130 },
{ "何人かの子供のうちの一人です。",      80, 171, 172, 45 },
{ "一粒種です。",         	 100, 171, 172, 55 },
#else
{ "a Merfolk Begger. ",               5 , 171, 172, 30 },
{ "a Merfolk Looter. ",			  10, 171, 172, 50 },
{ "a Merfolk Trickster. ",		      15, 171, 172, 70 },
{ "a Merfolk Citizen. ",		        60, 171, 172,  90 },
{ "a River Herald. ",							 70, 171, 172,  80 },
{ "a Merrow. ",							 80, 171, 172,  80 },
{ "a Selkie. ",							 85, 171, 172,  80 },
{ "a Triton. ",							 90, 171, 172,  80 },
{ "a Merfolk Traders. ",			 95, 171, 172, 100 },
{ "a Merfolk Sovereign. ",				100, 171, 172, 130 },
{ "You are one of several children of ",      80, 170, 171, 45 },
{ "You are the only child of ",         	 100, 170, 171, 55 },
#endif

#ifdef JP
{ "あなたの下半身は一本の尾で、", 50, 172, 173, 50},
{ "あなたの下半身は二股の尾で、", 60, 172, 173, 50},
{ "あなたの下半身は陸上の種族とあまり変わりなく、", 100, 172, 173, 50 },
#else
{ "Your lower body is a tail, ", 50, 172, 173, 50 },
{ "Your lower body are two tails, ", 60, 172, 173, 50 },
{ "Your lower body is not much different from a land race, ", 100, 172, 173, 50 },
#endif


#ifdef JP
{ "全身のほとんどが鱗に覆われています。", 20, 173, 174, 50 },
{ "主に上半身が鱗に覆われています。", 30, 173, 174, 50 },
{ "主に下半身が鱗に覆われています。", 40, 173, 174, 50 },
{ "全身の半分が鱗に覆われています。", 60, 173, 174, 50 },
{ "全身のいくらかが鱗に覆われています。", 80, 173, 174, 50 },
{ "鱗はほとんど見られません。", 100, 173, 174, 50 },
#else
{ "and most of your whole body is covered with scales. ", 20, 173, 174, 50 },
{ "and mainly your upper body is covered with scales. ", 30, 173, 174, 50 },
{ "and mainly your lower body is covered with scales. ", 40, 173, 174, 50 },
{ "and half of your body is covered with scales. ", 60, 173, 174, 50 },
{ "and some of your body is covered with scales. ", 80, 173, 174, 50 },
{ "and there are few scales on your body. ", 100, 173, 174, 50 },

#endif

#ifdef JP
{ "あなたは黒の瞳と",					 20, 174, 175, 50 },
{ "あなたは緑の瞳と",					 40, 174, 175, 50 },
{ "あなたは黄色い瞳と",					 60, 174, 175, 50 },
{ "あなたは青い瞳と",					 80, 174, 175, 50 },
{ "あなたは赤い瞳と",					100, 174, 175, 50 },
#else
{ "You have black eyes, ",				 20, 174, 175, 50 },
{ "You have green eyes, ",				 40, 174, 175, 50 },
{ "You have yellow eyes, ",				 60, 174, 175, 50 },
{ "You have blue eyes, ",				 80, 174, 175, 50 },
{ "You have red eyes, ",				100, 174, 175, 55 },
#endif

#ifdef JP
{ "海藻の様な髪を持っています。",			 25, 175, 0, 50 },
{ "珊瑚のような角を持っています。",			 50, 175, 0, 50 },
{ "地上人に似た髪を持っています。",			 75, 175, 0, 50 },
{ "大きく発達した鰓を持っています。",		100, 175, 0, 50 },
#else
{ "hair like seaweed.",			 25, 175, 0, 50 },
{ "coral-like horns.",			 50, 175, 0, 50 },
{ "hair similar to land races.",	 75, 175, 0, 50 },
{ "large gills.",		        100, 175, 0, 50 },
#endif

};
