#include <pixqt_common.h>
#include <piximg_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include <piximglib.h>
using namespace _pix_plot_img_framework;

#include "sampler_common.h" 
#include "sampler_panes.h"

#include "image_ctrl.h"
#include "ui_image_ctrl.h"

#include "sampler_monitor.h"
#include "sampler_window.h"

ImageCtrl::ImageCtrl(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::ImageCtrl)
{
    ui->setupUi(this);
    _pParent = NULL;
}

ImageCtrl::~ImageCtrl()
{
    delete ui;
}

void ImageCtrl::setCurrentPage( int iPageType ) 
{
   bool bOK, bFound;
   int iPage, nPages, i;
   QWidget *pPage;
   QString strName;
   SamplerDock *pDock = GetParent( );

   // find a widget(page) to match this page type and show it!

   nPages = ui->_pagesWidget->count( );
   bFound = false;
   for( i = 0 ; !bFound && i < nPages ; i++ ) {
      pPage = ui->_pagesWidget->widget( i );
      iPage = (pPage->property( "type" )).toInt( &bOK );
      if( !bOK ) continue;

      if( iPage == iPageType ) {
         // this is the page!
         ui->_pagesWidget->setCurrentWidget( pPage );
         
         strName = (pPage->property( "name" )).toString( );
         //ui->ImageCtrl_label->setText( strName );
         if( pDock ) {
            pDock->setWindowTitle( strName );
         }
         bFound = true;
      }
   }

   // set curent data

   update( );

   return;
}

void ImageCtrl::AddPropPage( QWidget *pPage,
                            QString strName,
                            int iPageType ) 
{
   int iPage = ui->_pagesWidget->count( );
   ui->_pagesWidget->addWidget( (QWidget*)pPage );
   
   pPage->setProperty( "page", QVariant( iPage ) );
   pPage->setProperty( "name", QVariant( strName ) );
   pPage->setProperty( "type", QVariant( iPageType ) );

   return;
}

void ImageCtrl::showEvent( QShowEvent * /*eve*/ )
{
   return;
}

void ImageCtrl::Init( void )
{
   QDialogButtonBox::StandardButtons btn;
   bool bOK;
   QWidget *pPage;
   int i, iPageType, nPages;
   sampler_window *pMain = (sampler_window*)GetMainWindow( );
   pixq_Properties *pEnv = pMain->GetEnv( ); 
   
   // reset "type" of existing stacked widgets to 0

   nPages = ui->_pagesWidget->count( );
   for( i = 0 ; i < nPages ; i++ ) {
      pPage = ui->_pagesWidget->widget( i );
      iPageType = (pPage->property( "type" )).toInt( &bOK );
      iPageType = 0;
      pPage->setProperty( "type", QVariant( iPageType ) );
   }

   // 

   AddPropPage( &_opPropDftFilter, "DFT Filter",
      (int)property_page::value_prop_page_op_dft_filter );

   //


   _opPropDftFilter.Init( pEnv );  

   // select the first page

   setCurrentPage( (int)property_page::value_prop_page_op_dft_filter );  

   return;
}

bool ImageCtrl::CheckPageIndex( int iPageIndex )
{
   bool bRetCode = false;
   bool bFound;
   int nPages, iPage, i, iPageType;
   bool bOK;
   QWidget *pPage;

   nPages = ui->_pagesWidget->count( );
   bFound = false;
   for( i = 0 ; !bFound && i < nPages ; i++ ) {
      pPage = ui->_pagesWidget->widget( i );
      iPage = (pPage->property( "page" )).toInt( &bOK );
      if( iPageIndex != iPage ) continue;

      iPageType = (pPage->property( "type" )).toInt( &bOK );
      bFound = true;
   }

   if( !bFound ) {
      goto PIX_EXIT;
   }

   if( !CheckPageType( iPageType ) ) {
      goto PIX_EXIT;
   }

   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

//
// get page type of the index
// returns one of value_property_page
// returns property_page::value_prop_page_none if the index doesn't match\
//
int ImageCtrl::GetPageType( int iPageIndex )
{
   bool bFound;
   int nPages, iPage, i, iPageType;
   bool bOK;
   QWidget *pPage;

   iPageType = property_page::value_prop_page_none;

   nPages = ui->_pagesWidget->count( );
   bFound = false;
   for( i = 0 ; !bFound && i < nPages ; i++ ) {
      pPage = ui->_pagesWidget->widget( i );
      iPage = (pPage->property( "page" )).toInt( &bOK );
      if( iPageIndex != iPage ) continue;

      iPageType = (pPage->property( "type" )).toInt( &bOK );
      bFound = true;
   }

   // --- Done ---
//PIX_EXIT:
   return iPageType;
}

bool ImageCtrl::CheckPageType( int iPageType )
{
   bool bRetCode = false;
   
   // check the data of the last page

   switch( iPageType ) {

   case property_page::value_prop_page_op_dft_filter:   
      if( !_opPropDftFilter.Check( ) ) {
         goto PIX_EXIT;
      }
      break;
            
   }

   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

//
// set default value for the currently selected page
//
bool ImageCtrl::DefaultPageIndex( int iPageIndex )
{
   bool bRetCode = false;
   bool bFound;
   int nPages, iPage, i, iPageType;
   bool bOK;
   QWidget *pPage;

   nPages = ui->_pagesWidget->count( );
   bFound = false;
   for( i = 0 ; !bFound && i < nPages ; i++ ) {
      pPage = ui->_pagesWidget->widget( i );
      iPage = (pPage->property( "page" )).toInt( &bOK );
      if( iPageIndex != iPage ) continue;

      iPageType = (pPage->property( "type" )).toInt( &bOK );
      bFound = true;
   }

   if( !bFound ) {
      goto PIX_EXIT;
   }

   if( !DefaultPageType( iPageType ) ) {
      goto PIX_EXIT;
   }

   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

bool ImageCtrl::DefaultPageType( int iPageType )
{
   bool bRetCode = false;
   sampler_window *pMain = (sampler_window*)GetMainWindow( );
   pixq_Properties *pEnv = pMain->GetEnv( ); 
   
   // check the data of the last page

   switch( iPageType ) {
            
   case property_page::value_prop_page_op_dft_filter:   
      pEnv->InitDftFilter( );
      break;      

   default:
      goto PIX_EXIT;
      break;
   }

   if( !SetPageType( iPageType ) ) {
      goto PIX_EXIT;
   }

   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

bool ImageCtrl::SetPageIndex( int iPageIndex )
{
   bool bRetCode = false;
   bool bFound;
   int nPages, iPage, i, iPageType;
   bool bOK;
   QWidget *pPage;

   nPages = ui->_pagesWidget->count( );
   bFound = false;
   for( i = 0 ; !bFound && i < nPages ; i++ ) {
      pPage = ui->_pagesWidget->widget( i );
      iPage = (pPage->property( "page" )).toInt( &bOK );
      if( iPageIndex != iPage ) continue;

      iPageType = (pPage->property( "type" )).toInt( &bOK );
      bFound = true;
   }

   if( !bFound ) {
      goto PIX_EXIT;
   }

   if( !SetPageType( iPageType ) ) {
      goto PIX_EXIT;
   }

   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

bool ImageCtrl::SetPageType( int iPageType )
{
   bool bRetCode = false;
   
   // check the data of the last page

   switch( iPageType ) {
           
   case property_page::value_prop_page_op_dft_filter:  
      _opPropDftFilter.SetData( );
      break;      

   default:
      goto PIX_EXIT;
      break;
   }

   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}


void ImageCtrl::EnableCtrlButtons( bool bEnabled )
{
   ui->apply_button->setEnabled( bEnabled );
   ui->close_Button->setEnabled( bEnabled );
   ui->default_button->setEnabled( bEnabled );

   ui->_pagesWidget->setEnabled( bEnabled );

   return;
}

void ImageCtrl::on_apply_button_clicked()
{
   sampler_window *pMain = (sampler_window*)GetMainWindow( );
   int iPageIndex, iPageType;

   // check the data in the current page
   
   iPageIndex = ui->_pagesWidget->currentIndex( );
   if( !CheckPageIndex( iPageIndex ) ) {
      goto PIX_EXIT;
   }

   iPageType = GetPageType( iPageIndex );

   // store the properties

   pMain->StoreEnv( );

   // start the program

  pMain->SelectFrame( );

PIX_EXIT:
   return;
}

void ImageCtrl::on_default_button_clicked()
{
   int iPageIndex;

   // check the data in the current page
   
   iPageIndex = ui->_pagesWidget->currentIndex( );
   if( !DefaultPageIndex( iPageIndex ) ) {
      goto PIX_EXIT;
   }

PIX_EXIT:
   return;
}

void ImageCtrl::on_close_Button_clicked()
{
   sampler_window *pMain = (sampler_window*)GetMainWindow( );
   
   pMain->HideImageProp( );
   
   return;
}
