#include <pixqt_common.h>
#include <piximg_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include <piximglib.h>
using namespace _pix_plot_img_framework;

#include "sampler_common.h"

//
// display single(first or second texture) on the pane
//
void RefreshTexture_WON( unsigned int uiImgTexture,
                        pixq_FlipPara *pFlip )
{
   int nScreenWidth, nScreenHeight;
   double dOrthoX[2], dOrthoY[2], dTexCooX[2], dTexCooY[2];
   double dScreenPosX[2], dScreenPosY[2];

	dOrthoX[0] = pFlip->GetOrthoX( 0 );
   dOrthoX[1] = pFlip->GetOrthoX( 1 ); 
   dOrthoY[0] = pFlip->GetOrthoY( 0 );
   dOrthoY[1] = pFlip->GetOrthoY( 1 );
   
   dTexCooX[0] = pFlip->GetTexCooX( 0 );
   dTexCooX[1] = pFlip->GetTexCooX( 1 );
   dTexCooY[0] = pFlip->GetTexCooY( 0 );
   dTexCooY[1] = pFlip->GetTexCooY( 1 );

   dScreenPosX[0] = pFlip->GetScreenPosX( 0 );
   dScreenPosX[1] = pFlip->GetScreenPosX( 1 );
   dScreenPosY[0] = pFlip->GetScreenPosY( 0 );
   dScreenPosY[1] = pFlip->GetScreenPosY( 1 );

   nScreenWidth = pFlip->GetScreenWidth( );
   nScreenHeight = pFlip->GetScreenHeight( );
   glViewport( 0, 0, nScreenWidth, nScreenHeight );

   //glFlush( );
   glDrawBuffer( GL_BACK ); 
   glClearColor( 0.0f, 0.0f, 0.0f, 0.0f );  // non-black bkgr, less ghosting
   glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );

   glMatrixMode( GL_PROJECTION );
   glLoadIdentity( );
	glOrtho( dOrthoX[0], dOrthoX[1], dOrthoY[0], dOrthoY[1], -1.0, 1.0 );

   glMatrixMode( GL_MODELVIEW );
   glLoadIdentity( );
   
   // --- get dimension ---

   glDisable( GL_DEPTH_TEST ); 
   glDisable( GL_DEPTH );
   glEnable( GL_TEXTURE_RECTANGLE_ARB );

   glBindTexture( GL_TEXTURE_RECTANGLE_ARB, uiImgTexture ); 
   
   //glColor4f( 1.0f, 1.0f, 1.0f, 1.0f );
 
   glBegin( GL_QUADS );
      glTexCoord2d( dTexCooX[0], dTexCooY[1] );
      glVertex3d( dScreenPosX[0], dScreenPosY[1], 0 );

      glTexCoord2d( dTexCooX[0], dTexCooY[0] );
      glVertex3d( dScreenPosX[0], dScreenPosY[0], 0 );

      glTexCoord2d( dTexCooX[1], dTexCooY[0] );
      glVertex3d( dScreenPosX[1], dScreenPosY[0], 0 );

      glTexCoord2d( dTexCooX[1], dTexCooY[1] );
      glVertex3d( dScreenPosX[1], dScreenPosY[1], 0 );
   glEnd( );  
   
   return;
}

//
// wiper-stype line, two textures
//
void RefreshWiper_WON(  unsigned int uiLeftTexture,
                       unsigned int uiRightTexture,
                       bool bVertical, // [i] true for vertical wiper
                       int nWiperX, // [i] wiper position on screen
                       int nWiperY, // [i] wiper position on screen
                        pixq_FlipPara *pFlip )
{
   unsigned int uiImgTexture[2];
   int nScreenWidth, nScreenHeight;
   double dScreenWiperX, dScreenWiperY, dOrthoX[2], dOrthoY[2];
   double dTexWiperX, dTexWiperY, dTexWidth, dTexHeight;
   double dTexCooX[2], dTexCooY[2];
   double dScreenPosX[2], dScreenPosY[2];

   // --- get texture ID ---

   uiImgTexture[0] = uiLeftTexture;
   uiImgTexture[1] = uiRightTexture;

   // *** wiper poosition in viewport/texture ***

   pFlip->ViewportToPixelCoo( nWiperX, nWiperY, &dTexWiperX, &dTexWiperY );
   pFlip->ViewportToScreenCoo( nWiperX, nWiperY, &dScreenWiperX, &dScreenWiperY );

	dOrthoX[0] = pFlip->GetOrthoX( 0 );
   dOrthoX[1] = pFlip->GetOrthoX( 1 ); 
   dOrthoY[0] = pFlip->GetOrthoY( 0 );
   dOrthoY[1] = pFlip->GetOrthoY( 1 );
   
   dTexCooX[0] = pFlip->GetTexCooX( 0 );
   dTexCooX[1] = pFlip->GetTexCooX( 1 );
   dTexCooY[0] = pFlip->GetTexCooY( 0 );
   dTexCooY[1] = pFlip->GetTexCooY( 1 );

   dScreenPosX[0] = pFlip->GetScreenPosX( 0 );
   dScreenPosX[1] = pFlip->GetScreenPosX( 1 );
   dScreenPosY[0] = pFlip->GetScreenPosY( 0 );
   dScreenPosY[1] = pFlip->GetScreenPosY( 1 );

   nScreenWidth = pFlip->GetScreenWidth( );
   nScreenHeight = pFlip->GetScreenHeight( );
   glViewport( 0, 0, nScreenWidth, nScreenHeight );

   //glFlush( );
   glDrawBuffer( GL_BACK ); 
   glClearColor( 0.0f, 0.0f, 0.0f, 0.0f );  // non-black bkgr, less ghosting
   glClear( GL_COLOR_BUFFER_BIT);// | GL_DEPTH_BUFFER_BIT );

   glDisable( GL_DEPTH_TEST ); 
   glDisable( GL_DEPTH );
   glEnable( GL_TEXTURE_RECTANGLE_ARB );

   //glColor4f( 1.0f, 1.0f, 1.0f, 1.0f );

   // display

   glMatrixMode( GL_PROJECTION );
   glLoadIdentity( );
	glOrtho( dOrthoX[0], dOrthoX[1], dOrthoY[0], dOrthoY[1], -1.0, 1.0 );
   
   glMatrixMode( GL_MODELVIEW );
   glLoadIdentity( );
   
   // --- wiper position on the texture original image ---
   // --- display original image ---
   
   glDisable( GL_DEPTH_TEST ); 
   glDisable( GL_DEPTH );

   glEnable( GL_TEXTURE_RECTANGLE_ARB );

   if( bVertical ) {   

      // *** vertical wiper ***
      dTexWidth = pFlip->GetImageWidth( );

      if( 0.0 <= dTexWiperX && dTexWiperX <= dTexWidth ) {
         // --- display the first image ---
         
         glBindTexture( GL_TEXTURE_RECTANGLE_ARB, uiImgTexture[0] );         
         glBegin( GL_QUADS );
            glTexCoord2d( dTexCooX[0], dTexCooY[1] );
            glVertex3d( dScreenPosX[0], dScreenPosY[1], 0 );
            glTexCoord2d( dTexCooX[0], dTexCooY[0] );
            glVertex3d( dScreenPosX[0], dScreenPosY[0], 0 );
            glTexCoord2d( dTexWiperX, dTexCooY[0] );
            glVertex3d( dScreenWiperX, dScreenPosY[0], 0 );
            glTexCoord2d( dTexWiperX, dTexCooY[1] );
            glVertex3d( dScreenWiperX, dScreenPosY[1], 0 );
         glEnd( );  
      
         glBindTexture( GL_TEXTURE_RECTANGLE_ARB, uiImgTexture[1] );         
         glBegin( GL_QUADS );
            glTexCoord2d( dTexWiperX, dTexCooY[1] );
            glVertex3d( dScreenWiperX, dScreenPosY[1], 0 );
            glTexCoord2d( dTexWiperX, dTexCooY[0] );
            glVertex3d( dScreenWiperX, dScreenPosY[0], 0 );
            glTexCoord2d( dTexCooX[1], dTexCooY[0] );
            glVertex3d( dScreenPosX[1], dScreenPosY[0], 0 );
            glTexCoord2d( dTexCooX[1], dTexCooY[1] );
            glVertex3d( dScreenPosX[1], dScreenPosY[1], 0 );
         glEnd( );
      } else if( 0.0 > dTexWiperX ) { 
         
         // wiper left of the whole image, just show the second
         glBindTexture( GL_TEXTURE_RECTANGLE_ARB, uiImgTexture[1] );         
         glBegin( GL_QUADS );
            glTexCoord2d( dTexCooX[0], dTexCooY[1] );
            glVertex3d( dScreenPosX[0], dScreenPosY[1], 0 );
            glTexCoord2d( dTexCooX[0], dTexCooY[0] );
            glVertex3d( dScreenPosX[0], dScreenPosY[0], 0 );
            glTexCoord2d( dTexCooX[1], dTexCooY[0] );
            glVertex3d( dScreenPosX[1], dScreenPosY[0], 0 );
            glTexCoord2d( dTexCooX[1], dTexCooY[1] );
            glVertex3d( dScreenPosX[1], dScreenPosY[1], 0 );
         glEnd( );

      } else {
         
         // wiper right of the whole image, just show the first
         glBindTexture( GL_TEXTURE_RECTANGLE_ARB, uiImgTexture[0] );         
         glBegin( GL_QUADS );
            glTexCoord2d( dTexCooX[0], dTexCooY[1] );
            glVertex3d( dScreenPosX[0], dScreenPosY[1], 0 );
            glTexCoord2d( dTexCooX[0], dTexCooY[0] );
            glVertex3d( dScreenPosX[0], dScreenPosY[0], 0 );
            glTexCoord2d( dTexCooX[1], dTexCooY[0] );
            glVertex3d( dScreenPosX[1], dScreenPosY[0], 0 );
            glTexCoord2d( dTexCooX[1], dTexCooY[1] );
            glVertex3d( dScreenPosX[1], dScreenPosY[1], 0 );
         glEnd( );

      }

   } else {

      // *** horizontal wiper ***
      dTexHeight = pFlip->GetImageHeight( );
      
      if( 0.0 <= dTexWiperY && dTexWiperY <= dTexHeight ) {
      
         // --- display the first image ---
         
         glBindTexture( GL_TEXTURE_RECTANGLE_ARB, uiImgTexture[0] );
         glBegin( GL_QUADS );
            glTexCoord2d( dTexCooX[0], dTexCooY[1] );
            glVertex3d( dScreenPosX[0], dScreenPosY[1], 0.0 );
            glTexCoord2d( dTexCooX[0], dTexWiperY );
            glVertex3d( dScreenPosX[0], dScreenWiperY, 0.0 );
            glTexCoord2d( dTexCooX[1], dTexWiperY );
            glVertex3d( dScreenPosX[1], dScreenWiperY, 0.0 );
            glTexCoord2d( dTexCooX[1], dTexCooY[1] );
            glVertex3d( dScreenPosX[1], dScreenPosY[1], 0.0 );
         glEnd( );  
      
         // --- display the second image ---

         glBindTexture( GL_TEXTURE_RECTANGLE_ARB, uiImgTexture[1] );
         glBegin( GL_QUADS );
            glTexCoord2d( dTexCooX[0], dTexWiperY );
            glVertex3d( dScreenPosX[0], dScreenWiperY, 0.0 );
            glTexCoord2d( dTexCooX[0], dTexCooY[0] );
            glVertex3d( dScreenPosX[0], dScreenPosY[0], 0.0 );
            glTexCoord2d( dTexCooX[1], dTexCooY[0] );
            glVertex3d( dScreenPosX[1], dScreenPosY[0], 0.0 );
            glTexCoord2d( dTexCooX[1], dTexWiperY );
            glVertex3d( dScreenPosX[1], dScreenWiperY, 0.0 );
         glEnd( );

      } else if( 0.0 > dTexWiperY ) {
         
         // --- display the first image ---

         glBindTexture( GL_TEXTURE_RECTANGLE_ARB, uiImgTexture[0] );
         glBegin( GL_QUADS );
            glTexCoord2d( dTexCooX[0], dTexCooY[1] );
            glVertex3d( dScreenPosX[0], dScreenPosY[1], 0.0 );
            glTexCoord2d( dTexCooX[0], dTexCooY[0] );
            glVertex3d( dScreenPosX[0], dScreenPosY[0], 0.0 );
            glTexCoord2d( dTexCooX[1], dTexCooY[0] );
            glVertex3d( dScreenPosX[1], dScreenPosY[0], 0.0 );
            glTexCoord2d( dTexCooX[1], dTexCooY[1] );
            glVertex3d( dScreenPosX[1], dScreenPosY[1], 0.0 );
         glEnd( );  

      } else {

         // --- display the second image ---

         glBindTexture( GL_TEXTURE_RECTANGLE_ARB, uiImgTexture[1] );
         glBegin( GL_QUADS );
            glTexCoord2d( dTexCooX[0], dTexCooY[1] );
            glVertex3d( dScreenPosX[0], dScreenPosY[1], 0.0 );
            glTexCoord2d( dTexCooX[0], dTexCooY[0] );
            glVertex3d( dScreenPosX[0], dScreenPosY[0], 0.0 );
            glTexCoord2d( dTexCooX[1], dTexCooY[0] );
            glVertex3d( dScreenPosX[1], dScreenPosY[0], 0.0 );
            glTexCoord2d( dTexCooX[1], dTexCooY[1] );
            glVertex3d( dScreenPosX[1], dScreenPosY[1], 0.0 );
         glEnd( );

      }
   }

   // --- draw wiper line ---

   glDisable( GL_TEXTURE_RECTANGLE_ARB );         
   glLineWidth( 1.0 );   
   glColor3f( 1.0f, 1.0f, 0.0f );

   glBegin( GL_LINES );
   if( bVertical ) {            
      glVertex3d( dScreenWiperX, dOrthoY[0], 0.1 ); 
      glVertex3d( dScreenWiperX, dOrthoY[1], 0.1 );  
   } else {
      glVertex3d( dOrthoX[0], dScreenWiperY, 0.1 );  
      glVertex3d( dOrthoX[1], dScreenWiperY, 0.1 );  
   }
   glEnd( );

   // --- Done ---
   return;
}


void RefreshTexture_WON( unsigned int uiImgTexture,
                        int nWidth,
                        int nHeight )
{
   int nScreenWidth, nScreenHeight;
   double dOrthoX[2], dOrthoY[2], dTexCooX[2], dTexCooY[2];
   double dScreenPosX[2], dScreenPosY[2];

   nScreenWidth = nWidth;
   nScreenHeight = nHeight;
   glViewport( 0, 0, nScreenWidth, nScreenHeight );

	dOrthoX[0] = - (double)nWidth / 2.0;
   dOrthoX[1] = (double)nWidth / 2.0;
   dOrthoY[0] = - (double)nHeight / 2.0;
   dOrthoY[1] = (double)nHeight / 2.0;
      
   dTexCooX[0] = 0.0;
   dTexCooX[1] = (double)nWidth;
   dTexCooY[0] = 0.0;
   dTexCooY[1] = (double)nHeight;

   dScreenPosX[0] = dOrthoX[0];
   dScreenPosX[1] = dOrthoX[1];
   dScreenPosY[0] = dOrthoY[0];
   dScreenPosY[1] = dOrthoY[1];

   //glFlush( );
   glDrawBuffer( GL_BACK ); 
   glClearColor( 0.0f, 0.0f, 0.0f, 0.0f );  // non-black bkgr, less ghosting
   glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );

   glMatrixMode( GL_PROJECTION );
   glLoadIdentity( );
	glOrtho( dOrthoX[0], dOrthoX[1], dOrthoY[0], dOrthoY[1], -1.0, 1.0 );

   glMatrixMode( GL_MODELVIEW );
   glLoadIdentity( );
   
   // --- get dimension ---

   glDisable( GL_DEPTH_TEST ); 
   glDisable( GL_DEPTH );
   glEnable( GL_TEXTURE_RECTANGLE_ARB );

   glBindTexture( GL_TEXTURE_RECTANGLE_ARB, uiImgTexture ); 
   
   //glColor4f( 1.0f, 1.0f, 1.0f, 1.0f );
 
   glBegin( GL_QUADS );
      glTexCoord2d( dTexCooX[0], dTexCooY[1] );
      glVertex3d( dScreenPosX[0], dScreenPosY[1], 0 );

      glTexCoord2d( dTexCooX[0], dTexCooY[0] );
      glVertex3d( dScreenPosX[0], dScreenPosY[0], 0 );

      glTexCoord2d( dTexCooX[1], dTexCooY[0] );
      glVertex3d( dScreenPosX[1], dScreenPosY[0], 0 );

      glTexCoord2d( dTexCooX[1], dTexCooY[1] );
      glVertex3d( dScreenPosX[1], dScreenPosY[1], 0 );
   glEnd( );  
      
   return;
}



