#pragma once

#include <pixqt_common.h>
#include <piximg_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include <piximglib.h>
using namespace _pix_plot_img_framework;

class sampler_window;
class SamplerMonitor;

class SamplerPane : public QGLWidget
{
   Q_OBJECT
  
public:
   // image display mode for the second(right) pane
   enum {
      // no image loaded   
      SamplerPaneShowNone = 0,
      //
      SamplerPaneShowFirst, 
      SamplerPaneShowSecond, 
      //
      // wiper style view
      SamplerPaneShowWiper, 
   } SamplerPaneShowMode;

   enum {
      SamplerPaneUnknown = 0,
      SamplerPaneSplitLeft, 
      SamplerPaneSplitRight, 
      SamplerPaneIndex,
   } SamplerPaneType;

public:
   SamplerPane(QWidget *parent = 0);
   ~SamplerPane();

protected:   
   void showEvent( QShowEvent *eve );

private:
   // what kind of pane is this? one of SamplerPaneType
   short _sPaneType;

   // pointer to the main window
   sampler_window *_pMainWindow;
         
   // wiper position on texture coordinate
   int _nWiperX; 
   int _nWiperY; 

   QPoint _MousePoint;
   	      
   // true if mouse is dragging
   bool _bMouseDragging;

   // check if this is Opengl 2.0 or higher
   bool _bOpenGL2;
   
   // --- OpenGL texture for image ---

   pixq_PaneTexture _PaneTexture;

   // how image(s) are displayed on the second(right) pane
   // one of SamplerPaneShowMode
   short _sPaneShowMode;

   // line width to draw tag/wiper line
   float _fMinLineWidth;
   float _fMaxLineWidth;
   float _fSelectedLineWidth;

   // true if wiper direction is vertical, false for horizontal wiper
   bool _bWiperVertical;


   // displa image color mode, one of PixTOPOImageDisplayColor
   short _sDisplayColor;
 

public:
   // draw chapters
   void RefreshClear( void ) ;

   // --- OpenGL finctions ---
   void RefreshTexture( void );
   void RefreshWiperDouble( void );

   void Init( short sSide );
   void DeInit( void );
   void RefreshSingle( void );
   void DrawIndexArea( void );

   void SetModeCursor( void );

   bool ValidPaneDisplayMode( void );

   void ResetPane( void );
   
   void SetCurrentViewport( void );
   void ChangeScreenSize(void);

   void SetMainWindow( sampler_window *pMain ) { _pMainWindow = pMain; }
   sampler_window *GetMainWindow( void ) { return _pMainWindow; }

   void SetWiperVertical( bool bMode ) { _bWiperVertical = bMode; } 

   void InitWiperPos( void );

   short GetDisplayColor( void ) { return _sDisplayColor; }
   void SetDisplayColor( short sDisplayColor ) { _sDisplayColor = sDisplayColor; }

   // how image(s) are displayed on the second(right) pane
   short GetPaneShowMode( void ) { return _sPaneShowMode; }
   void SetPaneShowMode( short sMode )  { _sPaneShowMode = sMode; };
   void ResetPaneShowMode( void ) { _sPaneShowMode = SamplerPaneShowNone; }

   void SwitchPaneMode( void );

   bool GetWiperVertical( void ) { return _bWiperVertical; }
   
   pixq_FlipPara *GetFlipPara( void );
   
   void InitTexture( void );

   unsigned int GetColorModeTexture( void ); 
   unsigned int GetColorModeTexture( bool bSource ); 
   void SetColorModeTexture( bool bSource, bool bSet ); 
   
   bool InitializeOpenGL( void );
   
   bool CreateImageTexture( pix_ImageMatrix *usRed, 
                           pix_ImageMatrix *usGrn, 
                           pix_ImageMatrix *usBlu,
                           bool bSource );
      
protected:
   void closeEvent(QCloseEvent *eve);

   void initializeGL( void );
   void paintGL( void );

   void keyPressEvent( QKeyEvent *eve );
   void mousePressEvent( QMouseEvent *eve );
   void mouseReleaseEvent( QMouseEvent *eve );
   void mouseMoveEvent( QMouseEvent *eve );
   void wheelEvent ( QWheelEvent *eve  ); 
   void resizeEvent( QResizeEvent* );
 
   //
   // GLSL test
   //
   public:
      GLuint _program;
};
