#include <pixqt_common.h>
#include <piximg_common.h>

#include <pixqtlib.h> 
using namespace _pix_plot_qt_framework;

#include <piximglib.h>
using namespace _pix_plot_img_framework;

#include "sampler_common.h"
#include "sampler_panes.h"
#include "sampler_monitor.h"
#include "sampler_window.h"

void SamplerPane::Init( short sSide )
{
   _sPaneType = sSide;

   setBackgroundRole( QPalette::Base );
   setSizePolicy( QSizePolicy::Ignored, QSizePolicy::Ignored );

   setMinimumSize( 50, 50 );

   setFocusPolicy( Qt::StrongFocus );
   setMouseTracking( true );

   _PaneTexture.Init( );

   _bMouseDragging = false;

   ResetPane( );

   //
   // pane parameters
   //

   InitializeOpenGL( );

   return;
}

void SamplerPane::DeInit( void )
{   
   ResetPane( );
}

void SamplerPane::ResetPane( void )
{   
   pixq_FlipPara *pFlip = GetFlipPara( );

   ResetPaneShowMode( );

   switch( _sPaneType ) {
   case SamplerPaneSplitLeft: 
   case SamplerPaneSplitRight: 
   case SamplerPaneIndex: 
      pFlip->DeInit( );
      break;

   default:
      break;
   }

   makeCurrent( );

   _PaneTexture.Delete( ); 

   _sDisplayColor = PixImageDisplayColorRgb;

   // --- DOne ---
   return;
}

bool SamplerPane::ValidPaneDisplayMode( void )
{
   bool bRetCode = false;
   
   switch( _sPaneShowMode ) {
   case SamplerPaneShowFirst:
   case SamplerPaneShowSecond:
   case SamplerPaneShowWiper: 
      break;

   case SamplerPaneShowNone: 
   default:
      goto PIX_EXIT;
      break;
   }

   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}


//
// initialize wiper positon to the center of the pane
//
void SamplerPane::InitWiperPos( void )
{
   QSize rect = size( );

   _bWiperVertical = true;
   _nWiperX = rect.width( ) / 2; 
   _nWiperY = rect.height( ) / 2;

   return;
}

void SamplerPane::SetCurrentViewport( void )
{
   QSize rect = size( );
   
   glClearColor( 0.0, 0.0, 0.0, 1.0 );
	//glViewport( rect.left, rect.top, rect.right, rect.bottom );
	glViewport( 0, 0, rect.width( ), rect.height( ) );

   return;
}

void SamplerPane::ChangeScreenSize(void)
{
   pixq_FlipPara *pFlip = GetFlipPara( );    
   QSize rect = size( );

   if( !ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

   // --- initialize texture copy parameters ---
   // --- initialize view point parameters ---   
  
   SetCurrentViewport( );
   
   // --- set current screen size ---

   if( pFlip->GetWholeExtent( ) ) {
      pFlip->SetFlipRatio( rect );
      pFlip->FlipRecenter( );
      pFlip->SetSingleViewports( rect );
      pFlip->SetSingleConversion( );
   } else {
      //pFlip->SetFlipRatio( nScreenWidth, nScreenHeight );
      //pFlip->SetSingleViewports( nScreenWidth, nScreenHeight );
      pFlip->ReshapeFlipImageRect( rect ); 
   }

   RefreshSingle( );

PIX_EXIT:
   return;
}
                                 
pixq_FlipPara *SamplerPane::GetFlipPara( void ) 
{ 
   sampler_window *pMain = (sampler_window*)GetMainWindow( );
   return pMain->GetFlipPara( _sPaneType );
}

//
// create opengl texture from rgb matrix
//
// notes:
// 
bool SamplerPane::CreateImageTexture( pix_ImageMatrix *usRed, // [i] image data in matrix
                                    pix_ImageMatrix *usGrn, // [i] image data in matrix
                                    pix_ImageMatrix *usBlu, // [i] image data in matrix
                                    bool bSource ) // [i] source or derived texture
{
	bool bRetCode = false;
   bool bTexBuffer;
   sampler_window *pMain = (sampler_window*)GetMainWindow( );
   pixq_TextureBuffer *pTexBuffer = pMain->GetTextureBuffer( ); 
   pixq_Properties *pEnv = pMain->GetEnv( ); 

   int iTexPara, iTexFilter;
   short sDisplayColor;
   unsigned int uiTexture;

   int nWidth = usRed->GetWidth( );
   int nHeight = usRed->GetHeight( );
   int nColors = 4; 
   short sType = pixq_TextureBuffer::BufferVariableUnsignedShortType;

#ifdef _DEBUG
unsigned short usMin[3], usMax[3], usMean[3];
#endif // _DEBUG

   // get the current mag filter

   iTexFilter = pEnv->_ImageTextureFilter.GetInt( );
   if( pixq_Properties::TextureFilterNearest == iTexFilter ) {
      iTexPara = GL_NEAREST;
   } else {
      iTexPara = GL_LINEAR;
   }

   // --- flop texture ---	

   makeCurrent( ); 

	glEnable( GL_TEXTURE_RECTANGLE_ARB );   

   // bind the texture

   uiTexture = GetColorModeTexture( bSource );
   glBindTexture( GL_TEXTURE_RECTANGLE_ARB, uiTexture );      
   
   // !!! THIS HAS TO BE DONE AFTER glBindTexture !!!
	glTexParameteri( GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_WRAP_S, GL_CLAMP );
	glTexParameteri( GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_WRAP_T, GL_CLAMP );
	glTexParameteri( GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_MAG_FILTER, iTexPara );
	glTexParameteri( GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_MIN_FILTER, iTexPara );
	glTexEnvi( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL );

   // allocate/check working buffer to create texture

   bTexBuffer = pTexBuffer->CheckAlloc( nWidth, nHeight, nColors, sType );
   
   // opengl 2.X -> create texture with any size!
   
   sDisplayColor = _sDisplayColor;

#ifdef _DEBUG
usRed->Statistics( &usMin[0], &usMax[0], &usMean[0] );
usGrn->Statistics( &usMin[1], &usMax[1], &usMean[1] );
usBlu->Statistics( &usMin[2], &usMax[2], &usMean[2] );
#endif // _DEBUG

   if( !CreateFreeTexture_PI( usRed, usGrn, usBlu, pTexBuffer, sDisplayColor ) ) {
      SetColorModeTexture( bSource, false ); 
      goto PIX_EXIT; 
   }
  
   // set the texture flag

   SetColorModeTexture( bSource, true ); 

   // --- Done ---
   bRetCode = true;
PIX_EXIT:   
   return bRetCode;
}

void SamplerPane::InitTexture( void )
{  
   _PaneTexture.InitTexture( ); 
   
   return;
}

void SamplerPane::SetModeCursor( void )
{
   // TODO: Add your message handler code here and/or call default

   sampler_window *pMain = (sampler_window*)GetMainWindow( );
   short sLeftMode = pMain->sGetLeftMouseMode( );

   if( _bMouseDragging ) {
      setCursor( Qt::ClosedHandCursor );
      goto PIX_EXIT;
   }

   switch( sLeftMode ) {
   case sampler_window::MouseLeftClickNone: 
   default:
      setCursor( Qt::ArrowCursor );
      break;
   }

PIX_EXIT:
   QApplication::processEvents( );
   return;
}

//
// mouse button pressed
//
void SamplerPane::SwitchPaneMode( void )
{
   sampler_window *pMain = (sampler_window*)GetMainWindow( );
   bool bConsumed = false;

   // switch viewing method according to the mode

   switch( _sPaneShowMode ) {
   
   case SamplerPaneShowFirst: 
      // toggle first/second image
      pMain->SetPanesShowMode( (short)SamplerPaneShowSecond );
      bConsumed = true;
      break;

   case SamplerPaneShowSecond: 
      // toggle first/second image
      pMain->SetPanesShowMode( (short)SamplerPaneShowFirst );
      bConsumed = true;
      break;

   case SamplerPaneShowWiper: 
      _bWiperVertical = !_bWiperVertical;
      bConsumed = true;
      break;

   default:
      break;
   }

   if( bConsumed ) {
      RefreshSingle( );
   }
   
//PIX_EXIT:
   return;
}
