#include <pixqt_common.h>
#include <piximg_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include <piximglib.h>
using namespace _pix_plot_img_framework;

#include "sampler_common.h"
#include "sampler_panes.h"
#include "sampler_window.h"
#include "sampler_monitor.h"
#include "ui_sampler_window.h"

QString sampler_window::_strOrganisation = "PixTOPO";
QString sampler_window::_strApplication = "QtSsampler";

sampler_window::sampler_window(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::sampler_window)
{
   int k;

    ui->setupUi(this);

   _bInitialized = false;

   // init all widgets

   _ImageSplitter = (ImageSplitter*)NULL;

   for( k = 0 ; k < 2 ; k++ ) {
      _Image_Pane[k] = (SamplerPane*)NULL; 
      _Image_Label[k] = (ImageSideLabel*)NULL;
   }
   
   _Index_Pane = (SamplerPane*)NULL; 
   _Image_Props = (ImageCtrl*)NULL;
   _Sampler_Monitor = (SamplerMonitor*)NULL;

   // init all data

   _pImageDataSet  = (pixq_ImageSingleSet*)NULL; 

   for( k = 0 ; k < 2 ; k++ ) {
      _pImgTexture[k]  = (pixq_DepthTexture*)NULL;
   }

   _pDepthEnv = (pixq_Properties*)NULL;
   _MainTexBuffer = (pixq_TextureBuffer*)NULL;

   _SplitPara = (pixq_FlipPara*)NULL; 
   _IndexPara = (pixq_FlipPara*)NULL; 

   // *** initialize all data ***

   InitData( );

   // create window

   CreateMain( );

   // create status bar

   for( k = 0 ; k < 3 ; k++ ) {
      _statusLabel[k] = new QLabel( "Sampler", this );
      _statusLabel[k]->setFrameStyle( QFrame::Sunken );
   }
   _statusProgress = new QProgressBar( this );
   _statusProgress->setFormat( "%v" );

   statusBar()->addPermanentWidget( _statusLabel[0], 1 );
   statusBar()->addPermanentWidget( _statusLabel[1], 1 );
   statusBar()->addPermanentWidget( _statusLabel[2], 1 );
   statusBar()->addPermanentWidget( _statusProgress, 1 );

   _Image_Pane[0]->Init( SamplerPane::SamplerPaneSplitLeft ); 
   _Image_Pane[1]->Init( SamplerPane::SamplerPaneSplitRight ); 

   _Index_Pane->Init( SamplerPane::SamplerPaneIndex );
   _Image_Props->Init( );

   // report about opengl version

   OpenGlHigherThanTwo( );


   return;
}

sampler_window::~sampler_window()
{
   delete ui;
}

void sampler_window::closeEvent( QCloseEvent * /*eve*/ )
{
   int i;

   StoreWindowPosition( );

   for( i = 0 ; i < 2 ; i++ ) {
      _Image_Pane[i]->DeInit( ); 
   }

   return;
}

void sampler_window::resizeEvent( QResizeEvent * /*eve*/ )
{
   if( !_bInitialized ) {
      goto PIX_EXIT;
   }

  // fixSamplerPanes( );

PIX_EXIT:
   return;
}

void sampler_window::showEvent( QShowEvent * /*eve*/ )
{
   if( !_bInitialized ) {
      RestoreWindowPosition( );
      //fixSamplerPanes( );
      _bInitialized = true;
   }

   return;
}

//
// *** Menu - File ***
//

void sampler_window::on_action_file_select_files_triggered()
{
    return;
}

void sampler_window::on_action_file_select_sequence_triggered()
{
   if( !SelectSingleSequence( ) ) {
      goto PIX_EXIT;
   }

 PIX_EXIT:
    return;
}

void sampler_window::on_action_file_properties_triggered()
{
   if( !SetProperties( ) ) {
      goto PIX_EXIT;
   }

PIX_EXIT:
    return;
}

void sampler_window::on_action_file_list_supported_formats_triggered()
{
   //
   // list of supported image formats
   //

   int i, nFormats;
   QStringList strFormats;
   QString strMessage;
   SamplerMonitor *pMonitor = (SamplerMonitor*)GetMonitorPane( );

   ListSupportedFormat_PI( &strFormats );
   
   nFormats = (int)strFormats.size();
   for( i = 0 ; i < nFormats ; i++ ) {
      strMessage.sprintf( "%03d/%03d: ", i+1, nFormats );
      strMessage = strMessage + strFormats.at( i );
      pMonitor->DisplayMessage( strMessage );
   }

   return;
}

void sampler_window::on_action_file_exit_triggered()
{
   close( );
}

//
// *** Menu - Basic Conversion ***
//

void sampler_window::on_action_basic_original_triggered()
{
   if( !CheckLoadSequence( ) ) {
      goto PIX_EXIT;
   }

   SetDerivedImage( pixq_Properties::SamplerDerivedOriginal );
   SelectFrame( );

   SetFrameStatusBar( );

   SetPanesShowMode( SamplerPane::SamplerPaneShowSecond );
   RefreshPanes( );   

PIX_EXIT:
   return;
}

void sampler_window::on_action_basic_grayscale_triggered( )
{
    if( !CheckLoadSequence( ) ) {
       goto PIX_EXIT;
    }

    SetDerivedImage( pixq_Properties::SamplerDerivedGrayscale );
    SelectFrame( );

    SetFrameStatusBar( );

    SetPanesShowMode( SamplerPane::SamplerPaneShowSecond );
    RefreshPanes( );

 PIX_EXIT:
    return;
}

void sampler_window::on_action_basic_revert_triggered()
{
   if( !CheckLoadSequence( ) ) {
       goto PIX_EXIT;
    }

    SetDerivedImage( pixq_Properties::SamplerDerivedRevert );
    SelectFrame( );

    SetFrameStatusBar( );

    SetPanesShowMode( SamplerPane::SamplerPaneShowSecond );
    RefreshPanes( );

 PIX_EXIT:
   return;
}


void sampler_window::on_action_basic_dft_value_triggered()
{
   SamplerMonitor *pMonitor = (SamplerMonitor*)GetMonitorPane( );

   if( !CheckLoadSequence( ) ) {
      goto PIX_EXIT;
   }

   // check image dimension must be power of two

   if( !CheckImagePowerOfTwo( ) ) {
      pMonitor->DisplayMessage( "Image Size must be a power of two." );
      goto PIX_EXIT;
   }

   pMonitor->DisplayMessage( "Select properties and press \"Apply\" button." );

   ShowImagePropPage( (int)property_page::value_prop_page_op_dft_filter );
   _Image_Props->update( );

   SetDerivedImage( pixq_Properties::SamplerDerivedVisualDftValue );
   //SelectFrame( );

   SetFrameStatusBar( );

   SetPanesShowMode( SamplerPane::SamplerPaneShowSecond );
   RefreshPanes( );  
   
PIX_EXIT:
   return;
}

void sampler_window::on_action_basic_dft_filter_shape_triggered()
{
   SamplerMonitor *pMonitor = (SamplerMonitor*)GetMonitorPane( );

   if( !CheckLoadSequence( ) ) {
      goto PIX_EXIT;
   }

   // check image dimension must be power of two

   if( !CheckImagePowerOfTwo( ) ) {
      pMonitor->DisplayMessage( "Image Size must be a power of two." );
      goto PIX_EXIT;
   }

   pMonitor->DisplayMessage( "Select properties and press \"Apply\" button." );

   ShowImagePropPage( (int)property_page::value_prop_page_op_dft_filter );
   _Image_Props->update( );

   SetDerivedImage( pixq_Properties::SamplerDerivedVisualDftShape ); 
   //SelectFrame( );

   SetFrameStatusBar( );

   SetPanesShowMode( SamplerPane::SamplerPaneShowSecond );
   RefreshPanes( );

PIX_EXIT:
   return;
}

void sampler_window::on_action_basic_dft_filtered_image_triggered()
{
   SamplerMonitor *pMonitor = (SamplerMonitor*)GetMonitorPane( );

   if( !CheckLoadSequence( ) ) {
      goto PIX_EXIT;
   }

   // check image dimension must be power of two

   if( !CheckImagePowerOfTwo( ) ) {
      pMonitor->DisplayMessage( "Image Size must be a power of two." );
      goto PIX_EXIT;
   }

   pMonitor->DisplayMessage( "Select properties and press \"Apply\" button." );

   ShowImagePropPage( (int)property_page::value_prop_page_op_dft_filter );
   _Image_Props->update( );

   SetDerivedImage( pixq_Properties::SamplerDerivedVisualDftFilter ); 
   //SelectFrame( );

   SetFrameStatusBar( );

   SetPanesShowMode( SamplerPane::SamplerPaneShowSecond );
   RefreshPanes( );

PIX_EXIT:
   return;
}

//
// *** Menu - Data ***
//

void sampler_window::on_action_data_statistics_triggered()
{
   if( !GetStatistics( ) ) {  
      goto PIX_EXIT;
   }

PIX_EXIT:
   return;
}

//
// *** Menu - View ***
//

void sampler_window::on_action_view_first_image_triggered()
{
   if( !CheckLoadSequence( ) ) {
      _Sampler_Monitor->DisplayMessage( "ERROR! Sequence is not selected." );
      goto PIX_EXIT;
   }

   SetPanesShowMode( SamplerPane::SamplerPaneShowFirst );

   RefreshPanes( );

   _Image_Pane[0]->setFocusPolicy( Qt::StrongFocus ); 
   _Image_Pane[0]->setMouseTracking( true ); 

   SetMenuState( );

PIX_EXIT:
   return;
}

void sampler_window::on_action_view_second_image_triggered()
{
   if( !CheckLoadSequence( ) ) {
      _Sampler_Monitor->DisplayMessage( "ERROR! Sequence is not selected." );
      goto PIX_EXIT;
   }

   SetPanesShowMode( SamplerPane::SamplerPaneShowSecond );

   RefreshPanes( );
   _Image_Pane[0]->setFocusPolicy( Qt::StrongFocus ); 
   _Image_Pane[0]->setMouseTracking( true ); 

   SetMenuState( );

PIX_EXIT:
   return;
}

void sampler_window::on_action_view_wiper_triggered()
{
   if( !CheckLoadSequence( ) ) {
      goto PIX_EXIT;
   }

   _Image_Pane[1]->InitWiperPos( ); 
   SetPanesShowMode( SamplerPane::SamplerPaneShowWiper );

   RefreshPanes( );  

   SetMenuState( );

PIX_EXIT:
   return;
}

void sampler_window::on_action_view_rgb_triggered()
{
   if( !CheckLoadSequence( ) ) {
      goto PIX_EXIT;
   }

   SetDisplayColor( PixImageDisplayColorRgb );

   if( !CreateLoadedTexture( ) ) {
      goto PIX_EXIT;
   }

   if( !CreateDerivedTexture( ) ) {
      goto PIX_EXIT;
   }

   RefreshPanes( );

   SetMenuState( );

PIX_EXIT:
   return;
}

void sampler_window::on_action_view_red_channel_triggered()
{
   if( !CheckLoadSequence( ) ) {
      goto PIX_EXIT;
   }

   SetDisplayColor( PixImageDisplayColorRed );

   if( !CreateLoadedTexture( ) ) {
      goto PIX_EXIT;
   }

   if( !CreateDerivedTexture( ) ) {
      goto PIX_EXIT;
   }

   RefreshPanes( );
   SetMenuState( );

PIX_EXIT:
   return;
}

void sampler_window::on_action_view_green_channel_triggered()
{
   if( !CheckLoadSequence( ) ) {
      goto PIX_EXIT;
   }

   SetDisplayColor( PixImageDisplayColorGreen );

   if( !CreateLoadedTexture( ) ) {
      goto PIX_EXIT;
   }

   if( !CreateDerivedTexture( ) ) {
      goto PIX_EXIT;
   }

   RefreshPanes( );
   SetMenuState( );

PIX_EXIT:
   return;
}

void sampler_window::on_action_view_blue_channel_triggered()
{
   if( !CheckLoadSequence( ) ) {
      goto PIX_EXIT;
   }

   SetDisplayColor( PixImageDisplayColorBlue );

   if( !CreateLoadedTexture( ) ) {
      goto PIX_EXIT;
   }

   if( !CreateDerivedTexture( ) ) {
      goto PIX_EXIT;
   }

   RefreshPanes( );
   SetMenuState( );

PIX_EXIT:
   return;
}

//
// *** Menu - Frame ***
//

void sampler_window::on_action_frame_next_triggered()
{
   if( !CheckLoadSequence( ) ) {
      goto PIX_EXIT;
   }

   ShiftFrame( 1 );

   DisplayFrameInfo( );
   
   _ImageSplitter->setOrientation( Qt::Horizontal );

PIX_EXIT:
   return;
}

void sampler_window::on_action_frame_previous_triggered()
{
   if( !CheckLoadSequence( ) ) {
      goto PIX_EXIT;
   }

   ShiftFrame( -1 );

   DisplayFrameInfo( );

PIX_EXIT:
   return;
}

void sampler_window::on_action_frame_first_triggered()
{
   if( !CheckLoadSequence( ) ) {
      goto PIX_EXIT;
   }

   if( !FirstFrame( ) ) {
      goto PIX_EXIT;
   }

PIX_EXIT:
   return;
}

void sampler_window::on_action_frame_last_triggered()
{
   if( !CheckLoadSequence( ) ) {
      goto PIX_EXIT;
   }
   
   if( !LastFrame( ) ) {
      goto PIX_EXIT;
   }

PIX_EXIT:
   return;
}

void sampler_window::on_action_frame_reload_triggered()
{
   if( !CheckLoadSequence( ) ) {
      goto PIX_EXIT;
   }
   
   if( !ReloadFrame( ) ) {
      goto PIX_EXIT;
   }

PIX_EXIT:
   return;
}

void sampler_window::on_action_frame_select_frame_triggered()
{
   if( !CheckLoadSequence( ) ) {
      goto PIX_EXIT;
   }
   
PIX_EXIT:
   return;
}

//
// *** Menu - Help ***
//

void sampler_window::on_action_help_about_triggered()
{
   pixq_Version ver = Version( );
   ShowPixAbout_PC( &ver );

   return;
}
