#include <pixqt_common.h>
#include <piximg_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include <piximglib.h>
using namespace _pix_plot_img_framework;

#include "sampler_common.h"
#include "sampler_panes.h"
#include "sampler_monitor.h"
#include "sampler_window.h"

bool sampler_window::GetStatistics( void ) 
{
   bool bRetCode = false;
   
   unsigned short usMin[2], usMax[2], usMean[2], usStd[2];
   int iSide, k, nWidth[2], nHeight[2];

   SamplerMonitor *pMonitor = (SamplerMonitor*)GetMonitorPane( );
   QString strMessage;

   strMessage = "**** Image Statistics ****";
   pMonitor->DisplayMessage( strMessage );

   if( CheckLoadSequence( ) ) {

      iSide = 0;
      nWidth[iSide] = _ImageInMtx[0].GetWidth( );
      nHeight[iSide] = _ImageInMtx[0].GetHeight( );
   
      strMessage.sprintf( "**** Size: %dW * %dH", nWidth[iSide], nHeight[iSide] );
      pMonitor->DisplayMessage( strMessage );

      for( k = 0 ; k < 3 ; k++ ) {
         _ImageInMtx[k].Statistics( &usMin[iSide], &usMax[iSide], &usMean[iSide], &usStd[iSide] );
         strMessage.sprintf( "**** Channel %1d: Range=%05d-%05d: Avr.=%05d: StDev=%05d", k+1,
            usMin[iSide], usMax[iSide], usMean[iSide], usStd[iSide] );
         pMonitor->DisplayMessage( strMessage );
      }

   } else {      
      strMessage = "ERROR! Image Sequence  is not Loaded.";
      pMonitor->DisplayMessage( strMessage );
      goto PIX_EXIT;
   }

   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

//
// redo the current image converson to the current frame
//
bool sampler_window::SelectFrame( void )
{
   bool bRetCode = false;   

QApplication::setOverrideCursor( Qt::BusyCursor );

   // --- check conditions --- 

   if( !CheckLoadSequence( ) ) {
      goto PIX_EXIT;
   }

   // --- start to draw! ---  

   if( !CreateDerivedBitmap( _sDerivedImage ) )  { 
      QMessageBox::warning( this, _strApplication, "Failed to Load Image Files" );
      goto PIX_EXIT;
   }
   
   SetFrameStatusBar( );

   SetPanesShowMode( SamplerPane::SamplerPaneShowSecond );
   RefreshPanes( ); 

   // *** get image statistics and show *** 
   
   // --- Done ---
   bRetCode = true;
PIX_EXIT: 
QApplication::restoreOverrideCursor();
   return bRetCode;
}

//
// select new frame, load the image and apply the current image conversion
//
bool sampler_window::SelectFrame( int iNewFrame ) // [i] new frame number
{ 
   bool bRetCode = false;   
   pixq_ImageSingleSet *pData = GetImageData( );

QApplication::setOverrideCursor( Qt::BusyCursor );
SetImageLoaded( false );

   // disable signals on the panes

   // --- check conditions --- 

   if( !CheckLoadSequence( ) ) {
      goto PIX_EXIT;
   }

   // --- move to the frame ---
   
   if( !pData->CheckFrame( iNewFrame ) ) {
      goto PIX_EXIT;
   }

   // --- start selection ---

   pData->SetCurrentFrame( iNewFrame );
   
   // load input image
   if( !CreateSingleBitmap( ) )  {
      QMessageBox::warning( this, _strApplication, "ERROR! Failed to Load Image Files" );
      goto PIX_EXIT;
   }     
   
   // create derived image 

   if( !CreateDerivedBitmap( _sDerivedImage ) )  {
      QMessageBox::warning( this, _strApplication, "ERROR! Failed to Load Image Files" );
      goto PIX_EXIT;
   }

   // don't do this as it cause abort in thread
   //SetFrameStatusBar( );
   
   RefreshPanes( );

   // --- Done ---
   bRetCode = true;
PIX_EXIT: 
QApplication::restoreOverrideCursor();
SetImageLoaded( true );
   return bRetCode;
}
