/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.conf.repository;

import com.clustercontrol.bean.FacilityInfo;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import com.clustercontrol.util.PropertyUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.StringListComparator;
import jp.co.intellilink.hinemos.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportNodeScope {
    private static Log log = LogFactory.getLog(ExportNodeScope.class);

    public void exportNodeScope() {
        log.info((Object)Messages.getMsg("NodeScope.Start", new String[]{Messages.getMsg("ExportTool.Export")}));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        FacilityTreeItem facilityTreeItem = this.getFacilityTree();
        this.getFacilityTreeItem(facilityTreeItem, arrayList);
        Collections.sort(arrayList, new StringListComparator(0));
        String string = "";
        if (Config.getConfig("file.timestamp").equalsIgnoreCase("on")) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
            string = "_" + simpleDateFormat.format(new Date());
        }
        WriteCsvFile.writeCsvFile(Config.getConfig("Export.Dir") + "/NODE_SCOPE" + string + ".csv", arrayList);
        log.info((Object)Messages.getMsg("NodeScope.End", new String[]{Messages.getMsg("ExportTool.Export")}));
    }

    public void getFacilityTreeItem(FacilityTreeItem facilityTreeItem, ArrayList<ArrayList<String>> arrayList) {
        FacilityTreeItem[] facilityTreeItemArray;
        if (facilityTreeItem.getData() instanceof FacilityInfo && (facilityTreeItemArray = facilityTreeItem.getData()).getType() == 1 && facilityTreeItemArray.getFacilityId() != null && facilityTreeItemArray.getFacilityId().compareTo("") != 0) {
            FacilityInfo facilityInfo;
            Object[] objectArray = new Object[]{facilityTreeItemArray.getFacilityId()};
            log.info((Object)Messages.getMsg("FacilityID", objectArray));
            Property property = this.getNode(facilityTreeItemArray.getFacilityId());
            ArrayList<String> arrayList2 = this.createCsvFormat(property);
            Object object = "";
            if (facilityTreeItem.getParent() != null && facilityTreeItem.getParent().getData() instanceof FacilityInfo && (facilityInfo = facilityTreeItem.getParent().getData()).getFacilityId() != null && facilityInfo.getFacilityId().compareTo("") != 0) {
                object = facilityInfo.getFacilityId();
            }
            arrayList2.add(0, (String)object);
            arrayList.add(arrayList2);
        }
        facilityTreeItemArray = facilityTreeItem.getChildren();
        for (Object object : facilityTreeItemArray) {
            this.getFacilityTreeItem((FacilityTreeItem)object, arrayList);
        }
    }

    public ArrayList<String> createCsvFormat(Property property) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = null;
        arrayList2 = PropertyUtil.getPropertyValue((Property)property, (String)"facilityId");
        arrayList.add(this.getStringValue(arrayList2));
        arrayList2 = PropertyUtil.getPropertyValue((Property)property, (String)"facilityName");
        arrayList.add(this.getStringValue(arrayList2));
        return arrayList;
    }

    public String getStringValue(ArrayList arrayList) {
        if (arrayList.size() > 0 && arrayList.get(0) instanceof String) {
            return (String)arrayList.get(0);
        }
        return "";
    }

    public String getIntegerValue(ArrayList arrayList) {
        if (arrayList.size() > 0 && arrayList.get(0) instanceof Integer) {
            return ((Integer)arrayList.get(0)).toString();
        }
        return "";
    }

    public String getBooleanValue(ArrayList arrayList) {
        if (arrayList.size() > 0 && arrayList.get(0) instanceof Boolean) {
            if (((Boolean)arrayList.get(0)).booleanValue()) {
                return YesNoConstant.typeToString((int)1);
            }
            return YesNoConstant.typeToString((int)0);
        }
        return "";
    }

    protected Property getNode(String string) {
        RepositoryController repositoryController = EjbConnectionManager.getConnectionManager().getRepositoryController();
        Property property = null;
        try {
            property = repositoryController.getNodeProperty(string, 2, Locale.getDefault());
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return property;
    }

    protected FacilityTreeItem getFacilityTree() {
        RepositoryController repositoryController = EjbConnectionManager.getConnectionManager().getRepositoryController();
        FacilityTreeItem facilityTreeItem = null;
        try {
            facilityTreeItem = repositoryController.getFacilityTree(Locale.getDefault());
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return facilityTreeItem;
    }
}

