/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.importtool.conf.monitor;

import com.clustercontrol.bean.RunIntervalConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.hinemosagent.bean.AgentCheckInfo;
import com.clustercontrol.http.bean.HttpCheckInfo;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.notify.bean.NotifyRelationInfo;
import com.clustercontrol.performance.monitor.bean.PerfCheckInfo;
import com.clustercontrol.ping.bean.PingCheckInfo;
import com.clustercontrol.port.bean.PortCheckInfo;
import com.clustercontrol.process.bean.ProcessCheckInfo;
import com.clustercontrol.snmp.bean.SnmpCheckInfo;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapInfo;
import com.clustercontrol.sql.bean.SqlCheckInfo;
import com.clustercontrol.syslogng.bean.LogFilterInfo;
import java.util.ArrayList;
import java.util.List;
import jp.co.intellilink.hinemos.util.CheckString;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.NotifyUtil;
import jp.co.intellilink.hinemos.util.RepositoryUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportMonitor {
    private static Log log = LogFactory.getLog(ImportMonitor.class);

    protected MonitorInfo createMonitorInfo(ArrayList<String> arrayList) {
        MonitorInfo monitorInfo = new MonitorInfo();
        return monitorInfo;
    }

    protected void createMonitorBase(List<String> list, MonitorInfo monitorInfo) {
        Object[] objectArray;
        Object[] objectArray2;
        String string = CheckString.checkLength(list.get(0), 64);
        if (!string.equals(list.get(0))) {
            objectArray2 = new String[]{com.clustercontrol.util.Messages.getString((String)"monitor.id"), "64"};
            log.error((Object)Messages.getMsg("ImportTool.Common.2", objectArray2));
            System.exit(20);
        }
        monitorInfo.setMonitorId(string);
        objectArray2 = CheckString.checkLength(list.get(1), 256);
        if (!objectArray2.equals(list.get(1))) {
            objectArray = new String[]{com.clustercontrol.util.Messages.getString((String)"description"), "256"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray));
        }
        monitorInfo.setDescription((String)objectArray2);
        monitorInfo.setFacilityId(list.get(2));
        if (!RepositoryUtil.findFacilityId(list.get(2))) {
            objectArray = new String[]{monitorInfo.getMonitorId(), list.get(2)};
            log.error((Object)Messages.getMsg("ImportTool.Repository.1", objectArray));
            System.exit(20);
        }
    }

    protected void createMonitorBlock(List<String> list, MonitorInfo monitorInfo) {
        if (list.get(0).compareTo(com.clustercontrol.util.Messages.getString((String)"scope")) == 0) {
            monitorInfo.setMonitorBlock(1);
        } else {
            monitorInfo.setMonitorBlock(0);
        }
    }

    protected void createMonitorRule(List<String> list, MonitorInfo monitorInfo) {
        monitorInfo.setRunInterval(RunIntervalConstant.stringToType((String)list.get(0)));
        if (list.get(1) != null && !"".equals(list.get(1))) {
            monitorInfo.setCalendarId(list.get(1));
        } else {
            monitorInfo.setCalendarId(null);
        }
    }

    protected void createMonitorCheck(List<String> list, MonitorInfo monitorInfo) {
        monitorInfo.setMonitorTypeId(this.instanceToTypeId(monitorInfo));
    }

    protected void createMonitorNotify(List<String> list, MonitorInfo monitorInfo) {
        monitorInfo.setNotifyGroupId(NotifyRelationInfo.createNotifyGroupId((String)this.instanceToTypeId(monitorInfo), (String)monitorInfo.getMonitorId()));
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        for (int i = 0; i < 5; ++i) {
            Object[] objectArray;
            if (!(list.get(i) instanceof String) || list.get(i).length() <= 0) continue;
            if (!NotifyUtil.findNotifyId(list.get(i))) {
                objectArray = new String[]{monitorInfo.getMonitorId(), list.get(i)};
                log.error((Object)Messages.getMsg("ImportTool.Notify.1", objectArray));
                System.exit(20);
            }
            objectArray = new NotifyRelationInfo();
            objectArray.setNotifyId(list.get(i));
            objectArray.setNotifyGroupId(monitorInfo.getNotifyGroupId());
            objectArray.setNotifyFlg(Integer.valueOf(0));
            if (i == 0) {
                objectArray.setNotifyType(Integer.valueOf(0));
            } else if (i == 1) {
                objectArray.setNotifyType(Integer.valueOf(1));
            } else if (i == 2) {
                objectArray.setNotifyType(Integer.valueOf(2));
            } else if (i == 3) {
                objectArray.setNotifyType(Integer.valueOf(3));
            } else if (i == 4) {
                objectArray.setNotifyType(Integer.valueOf(4));
            } else if (i == 5) {
                objectArray.setNotifyType(Integer.valueOf(5));
            }
            arrayList.add(objectArray);
        }
        monitorInfo.setNotifyId(arrayList);
    }

    protected void createMonitorApplication(List<String> list, MonitorInfo monitorInfo) {
        String string = CheckString.checkLength(list.get(0), 64);
        if (!string.equals(list.get(0))) {
            Object[] objectArray = new String[]{com.clustercontrol.util.Messages.getString((String)"application"), "64"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray));
        }
        monitorInfo.setApplication(string);
    }

    protected void createMonitorVaild(List<String> list, MonitorInfo monitorInfo) {
        monitorInfo.setValid(ValidConstant.stringToType((String)list.get(0)));
    }

    protected MonitorInfo checkMonitorList(String string, ArrayList arrayList) {
        if (arrayList instanceof ArrayList) {
            for (MonitorInfo monitorInfo : arrayList) {
                if (monitorInfo.getMonitorId().compareTo(string) != 0) continue;
                return monitorInfo;
            }
        }
        return null;
    }

    protected String instanceToTypeId(MonitorInfo monitorInfo) {
        if (monitorInfo.getAgentCheckInfo() instanceof AgentCheckInfo) {
            return "MON_AGT";
        }
        if (monitorInfo.getHttpCheckInfo() instanceof HttpCheckInfo) {
            return "MON_HTP";
        }
        if (monitorInfo.getPingCheckInfo() instanceof PingCheckInfo) {
            return "MON_PNG";
        }
        if (monitorInfo.getProcessCheckInfo() instanceof ProcessCheckInfo) {
            return "MON_PRC";
        }
        if (monitorInfo.getSnmpCheckInfo() instanceof SnmpCheckInfo) {
            return "MON_SNMP";
        }
        if (monitorInfo instanceof MonitorSnmpTrapInfo) {
            return "MON_SNMP_TRP";
        }
        if (monitorInfo.getSqlCheckInfo() instanceof SqlCheckInfo) {
            return "MON_SQL";
        }
        if (monitorInfo.getPerfCheckInfo() instanceof PerfCheckInfo) {
            return "MON_PRF";
        }
        if (monitorInfo.getPortCheckInfo() instanceof PortCheckInfo) {
            return "MON_PRT";
        }
        if (monitorInfo instanceof LogFilterInfo) {
            return "MON_LOG";
        }
        return "";
    }
}

