/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool.conf.monitor;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.ejb.DuplicateKeyException;

import jp.co.intellilink.hinemos.util.CheckString;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.ReadCsvFile;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.DataRangeConstant;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorTabelDefine;
import com.clustercontrol.process.bean.MonitorProcessInfo;
import com.clustercontrol.process.ejb.session.MonitorProcessController;

/**
 * プロセス監視情報をインポートするクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ImportMonitorProcess extends ImportMonitorNumeric {

	// ログ出力
	private static Log log = LogFactory.getLog(ImportMonitorProcess.class);

	@SuppressWarnings("unchecked")
	private ArrayList monitorList = null;

	private ArrayList<ArrayList<String>> monitorInfos = null;

	/**
	 * プロセス監視情報をインポートする。<br>
	 */
	public void importProcess() {
		log.info(Messages.getMsg("Process.Start", new String[]{Messages.getMsg("ImportTool.Import")}));

		//プロセス監視情報のCSVファイルを読み込む
		monitorInfos = ReadCsvFile.readCsvFile(Config.getConfig("Import.Dir") + "/PROCESS.csv");

		//監視項目リスト取得
		monitorList = getMonitorList();

		for(ArrayList<String> info : monitorInfos){
			MonitorInfo monitorInfo = createMonitorInfo(info);
			registerMonitorInfo(monitorInfo);
		}

		log.info(Messages.getMsg("Process.End", new String[]{Messages.getMsg("ImportTool.Import")}));
	}

	/**
	 * 監視情報オブジェクトを作成する。<br>
	 * 
	 * @see jp.co.intellilink.hinemos.importtool.conf.monitor.ImportMonitor#createMonitorInfo(java.util.ArrayList)
	 */
	@Override
	protected MonitorInfo createMonitorInfo(ArrayList<String> info){
		MonitorInfo monitorInfo = new MonitorInfo();

		//監視基本情報
		createMonitorBase(info, monitorInfo);

		//監視条件情報
		createMonitorRule(info.subList(3, 5), monitorInfo);

		//監視情報
		createMonitorCheck(info.subList(5, 7), monitorInfo);

		//監視単位情報
		createMonitorBlock(info.subList(7, 8), monitorInfo);

		//監視判定情報
		createMonitorJudgement(info.subList(8, 13), monitorInfo);

		//監視通知情報
		createMonitorNotify(info.subList(13, 18), monitorInfo);

		//アプリケーション
		createMonitorApplication(info.subList(18, 19), monitorInfo);

		//有効/無効
		createMonitorVaild(info.subList(19, 20), monitorInfo);

		return monitorInfo;
	}

	/**
	 * プロセス監視情報を設定する。<br>
	 * 
	 * @param info 監視情報配列
	 * @param monitorInfo 監視情報オブジェクト
	 * 
	 * @see jp.co.intellilink.hinemos.importtool.conf.monitor.ImportMonitor#createMonitorCheck(java.util.List, com.clustercontrol.monitor.run.bean.MonitorInfo)
	 */
	@Override
	protected void createMonitorCheck(List<String> info, MonitorInfo monitorInfo) {
		MonitorProcessInfo processInfo = new MonitorProcessInfo();

		//コマンド
		String command = CheckString.checkLength(info.get(0), DataRangeConstant.VARCHAR_256);
		if(!command.equals(info.get(0))){
			String[] args = { com.clustercontrol.util.Messages.getString("command"), "256" };
			log.warn(Messages.getMsg("ImportTool.Common.2", args));
		}
		processInfo.setCommand(command);
		//引数
		String param = CheckString.checkLength(info.get(1), DataRangeConstant.VARCHAR_256);
		if(!param.equals(info.get(1))){
			String[] args = { com.clustercontrol.util.Messages.getString("param"), "256" };
			log.warn(Messages.getMsg("ImportTool.Common.2", args));
		}
		processInfo.setParam(param);

		monitorInfo.setCheckInfo(processInfo);

		super.createMonitorCheck(info, monitorInfo);
	}

	/**
	 * 監視情報を登録する。<br>
	 * 
	 * @param info 監視情報オブジェクト
	 */
	protected void registerMonitorInfo(MonitorInfo info) {
		MonitorProcessController process = EjbConnectionManager.getConnectionManager().getMonitorProcessController();

		try {
			@SuppressWarnings("unchecked")
			ArrayList list = checkMonitorList(info.getMonitorId(), monitorList);
			if(list instanceof ArrayList){
				Date createTime = (Date)list.get(MonitorTabelDefine.CREATE_TIME);
				String createUser = (String)list.get(MonitorTabelDefine.CREATE_USER);
				info.setRegDate(new Timestamp(createTime.getTime()));
				info.setRegUser(createUser);

				Object[] args = {info.getMonitorId()};
				log.info(Messages.getMsg("MonitorID", args) + 
						" (" + Messages.getMsg("modify") + ")");

				process.modifyProcess(info);
			}
			else{
				Object[] args = {info.getMonitorId()};
				log.info(Messages.getMsg("MonitorID", args) + 
						" (" + Messages.getMsg("add") + ")");

				process.addProcess(info);
			}
		} catch (DuplicateKeyException e) {
			String args[] = {info.getMonitorId()};
			log.error(Messages.getMsg("ImportTool.Common.1", args));
			System.exit(20);
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
	}

	/**
	 * 監視項目リストを取得する。<br>
	 * 
	 * @return 監視項目一覧
	 */
	@SuppressWarnings("unchecked")
	protected ArrayList getMonitorList() {

		MonitorProcessController process = EjbConnectionManager.getConnectionManager().getMonitorProcessController();

		ArrayList records = null;
		try {
			records = process.getProcessList();
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
		return records;
	}
}