/*
 
Copyright (C) 2008 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package jp.co.intellilink.hinemos.importtool.master.mib;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibSymbol;

import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterData;

/**
 * Create SnmpTrapMibMasterData
 * 
 * @version 2.3.0
 * @since 2.3.0
 */
public class MibFactory {
	
	private static final int OEDER_NO = 10;

	/**
	 * Create SnmpTrapMibMasterData
	 * 
	 */
	public SnmpTrapMibMasterData create(Mib mib) {
		if(mib == null)
			return null;
		
		SnmpTrapMibMasterData data = new SnmpTrapMibMasterData();
		data.setMib(mib.getName());
		data.setOrderNo(OEDER_NO);
		
		// set description
		StringBuilder description = new StringBuilder();
		if(mib.getHeaderComment() != null){
			description.append(mib.getHeaderComment());
		}
		List list = (ArrayList)mib.getAllSymbols();
		if(list.size() > 0){
			MibSymbol symbol = (MibSymbol)list.get(0);
			if(symbol.getComment() != null){
				if(description.length() > 0)
					description.append("; ");
				description.append(symbol.getComment());
			}
		}
		if(mib.getFooterComment() != null){
			if(description.length() > 0)
				description.append("; ");
			description.append(mib.getFooterComment());
		}
		
		String desc = description.toString().replaceAll("(\\*)+", "");
		
		try {
			byte[] tmpByte = desc.toString().getBytes("UTF-8");
			if(tmpByte.length > 256)
				data.setDescription(new String(tmpByte, 0, 256, "UTF-8"));
		} catch (UnsupportedEncodingException e) {
		}
		
		return data;
	}
}