/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.importtool.conf.notify;

import com.clustercontrol.bean.EventConfirmConstant;
import com.clustercontrol.bean.ExclusionConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.StatusValidPeriodConstant;
import com.clustercontrol.bean.SyslogFacilityConstant;
import com.clustercontrol.bean.SyslogSeverityConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.notify.bean.NotifyEventInfo;
import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.notify.bean.NotifyJobInfo;
import com.clustercontrol.notify.bean.NotifyLogEscalateInfo;
import com.clustercontrol.notify.bean.NotifyMailInfo;
import com.clustercontrol.notify.bean.NotifyStatusInfo;
import com.clustercontrol.notify.ejb.session.NotifyController;
import java.util.ArrayList;
import javax.ejb.DuplicateKeyException;
import jp.co.intellilink.hinemos.util.CheckString;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.MailTemplateUtil;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.ReadCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportNotify {
    private static Log log = LogFactory.getLog(ImportNotify.class);
    private ArrayList notifyList = null;
    private ArrayList<ArrayList<String>> notifyStatusInfos = null;
    private ArrayList<ArrayList<String>> notifyEventInfos = null;
    private ArrayList<ArrayList<String>> notifyMailInfos = null;
    private ArrayList<ArrayList<String>> notifyJobInfos = null;
    private ArrayList<ArrayList<String>> notifyLogEscalateInfos = null;

    public void importNotify() {
        NotifyInfo notifyInfo;
        log.info((Object)Messages.getMsg("Nofity.Start", new String[]{Messages.getMsg("ImportTool.Import")}));
        this.notifyStatusInfos = ReadCsvFile.readCsvFile(Config.getConfig("Import.Dir") + "/NOTIFY_STATUS.csv");
        this.notifyEventInfos = ReadCsvFile.readCsvFile(Config.getConfig("Import.Dir") + "/NOTIFY_EVENT.csv");
        this.notifyMailInfos = ReadCsvFile.readCsvFile(Config.getConfig("Import.Dir") + "/NOTIFY_MAIL.csv");
        this.notifyJobInfos = ReadCsvFile.readCsvFile(Config.getConfig("Import.Dir") + "/NOTIFY_JOB.csv");
        this.notifyLogEscalateInfos = ReadCsvFile.readCsvFile(Config.getConfig("Import.Dir") + "/NOTIFY_LOG_ESCALATE.csv");
        this.notifyList = this.getNotifyList();
        for (ArrayList<String> arrayList : this.notifyStatusInfos) {
            notifyInfo = this.createNotifyInfo(arrayList, 0);
            this.registerNotifyInfo(notifyInfo);
        }
        for (ArrayList<String> arrayList : this.notifyEventInfos) {
            notifyInfo = this.createNotifyInfo(arrayList, 1);
            this.registerNotifyInfo(notifyInfo);
        }
        for (ArrayList<String> arrayList : this.notifyMailInfos) {
            notifyInfo = this.createNotifyInfo(arrayList, 2);
            this.registerNotifyInfo(notifyInfo);
        }
        for (ArrayList<String> arrayList : this.notifyJobInfos) {
            notifyInfo = this.createNotifyInfo(arrayList, 3);
            this.registerNotifyInfo(notifyInfo);
        }
        for (ArrayList<String> arrayList : this.notifyLogEscalateInfos) {
            notifyInfo = this.createNotifyInfo(arrayList, 4);
            this.registerNotifyInfo(notifyInfo);
        }
        log.info((Object)Messages.getMsg("Nofity.End", new String[]{Messages.getMsg("ImportTool.Import")}));
    }

    public NotifyInfo createNotifyInfo(ArrayList<String> arrayList, int n) {
        Object[] objectArray;
        NotifyInfo notifyInfo = new NotifyInfo();
        String string = CheckString.checkLength(arrayList.get(0), 64);
        if (!string.equals(arrayList.get(0))) {
            objectArray = new String[]{com.clustercontrol.util.Messages.getString((String)"notify.id"), "64"};
            log.error((Object)Messages.getMsg("ImportTool.Common.2", objectArray));
            System.exit(20);
        }
        notifyInfo.setNotifyId(string);
        objectArray = CheckString.checkLength(arrayList.get(1), 256);
        if (!objectArray.equals(arrayList.get(1))) {
            Object[] objectArray2 = new String[]{com.clustercontrol.util.Messages.getString((String)"description"), "256"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray2));
        }
        notifyInfo.setDescription((String)objectArray);
        notifyInfo.setInhibitionFlg(Integer.valueOf(ExclusionConstant.stringToType((String)arrayList.get(2))));
        if (notifyInfo.getInhibitionFlg() == 1) {
            notifyInfo.setInhibitionFrequency(Integer.valueOf(Integer.parseInt(arrayList.get(3))));
        } else if (notifyInfo.getInhibitionFlg() == 2) {
            notifyInfo.setInhibitionPeriod(Integer.valueOf(Integer.parseInt(arrayList.get(3))));
        }
        notifyInfo.setValidFlg(Integer.valueOf(ValidConstant.stringToType((String)arrayList.get(4))));
        notifyInfo.setNotifyType(Integer.valueOf(n));
        if (notifyInfo.getNotifyType() == 0) {
            this.createStatusNotifyInfo(arrayList, notifyInfo);
        } else if (notifyInfo.getNotifyType() == 1) {
            this.createEventNotifyInfo(arrayList, notifyInfo);
        } else if (notifyInfo.getNotifyType() == 2) {
            this.createMailNotifyInfo(arrayList, notifyInfo);
        } else if (notifyInfo.getNotifyType() == 3) {
            this.createJobNotifyInfo(arrayList, notifyInfo);
        } else if (notifyInfo.getNotifyType() == 4) {
            this.createSyslogNotifyInfo(arrayList, notifyInfo);
        }
        return notifyInfo;
    }

    protected void createStatusNotifyInfo(ArrayList<String> arrayList, NotifyInfo notifyInfo) {
        ArrayList<NotifyStatusInfo> arrayList2 = new ArrayList<NotifyStatusInfo>();
        int n = StatusValidPeriodConstant.stringToType((String)arrayList.get(13));
        int n2 = 11;
        n2 = arrayList.get(14).equals(com.clustercontrol.util.Messages.getString((String)"notify.status.invalid.period.delete")) ? 11 : 12;
        int n3 = PriorityConstant.stringToType((String)arrayList.get(15));
        for (int i = 0; i < 4; ++i) {
            NotifyStatusInfo notifyStatusInfo = new NotifyStatusInfo();
            notifyStatusInfo.setNotifyId(notifyInfo.getNotifyId());
            if (i == 0) {
                notifyStatusInfo.setPriority(Integer.valueOf(3));
            } else if (i == 1) {
                notifyStatusInfo.setPriority(Integer.valueOf(2));
            } else if (i == 2) {
                notifyStatusInfo.setPriority(Integer.valueOf(0));
            } else if (i == 3) {
                notifyStatusInfo.setPriority(Integer.valueOf(1));
            }
            notifyStatusInfo.setValidFlg(Integer.valueOf(ValidConstant.stringToType((String)arrayList.get(i * 2 + 5))));
            notifyStatusInfo.setInhibitionFlg(Integer.valueOf(ValidConstant.stringToType((String)arrayList.get(i * 2 + 6))));
            notifyStatusInfo.setStatusValidPeriod(Integer.valueOf(n));
            notifyStatusInfo.setStatusInvalidFlg(Integer.valueOf(n2));
            notifyStatusInfo.setStatusUpdatePriority(Integer.valueOf(n3));
            arrayList2.add(notifyStatusInfo);
        }
        notifyInfo.setNotifyInfoDetail(arrayList2);
    }

    protected void createEventNotifyInfo(ArrayList<String> arrayList, NotifyInfo notifyInfo) {
        ArrayList<NotifyEventInfo> arrayList2 = new ArrayList<NotifyEventInfo>();
        for (int i = 0; i < 4; ++i) {
            NotifyEventInfo notifyEventInfo = new NotifyEventInfo();
            notifyEventInfo.setNotifyId(notifyInfo.getNotifyId());
            if (i == 0) {
                notifyEventInfo.setPriority(Integer.valueOf(3));
            } else if (i == 1) {
                notifyEventInfo.setPriority(Integer.valueOf(2));
            } else if (i == 2) {
                notifyEventInfo.setPriority(Integer.valueOf(0));
            } else if (i == 3) {
                notifyEventInfo.setPriority(Integer.valueOf(1));
            }
            notifyEventInfo.setValidFlg(Integer.valueOf(ValidConstant.stringToType((String)arrayList.get(i * 4 + 5))));
            notifyEventInfo.setEventNormalState(Integer.valueOf(EventConfirmConstant.stringToType((String)arrayList.get(i * 4 + 6))));
            notifyEventInfo.setInhibitionFlg(Integer.valueOf(ValidConstant.stringToType((String)arrayList.get(i * 4 + 7))));
            notifyEventInfo.setEventInhibitionState(Integer.valueOf(EventConfirmConstant.stringToType((String)arrayList.get(i * 4 + 8))));
            arrayList2.add(notifyEventInfo);
        }
        notifyInfo.setNotifyInfoDetail(arrayList2);
    }

    protected void createMailNotifyInfo(ArrayList<String> arrayList, NotifyInfo notifyInfo) {
        ArrayList<NotifyMailInfo> arrayList2 = new ArrayList<NotifyMailInfo>();
        String string = arrayList.get(5);
        if (!MailTemplateUtil.findMailTemplateId(string)) {
            Object[] objectArray = new String[]{notifyInfo.getNotifyId(), string};
            log.error((Object)Messages.getMsg("ImportTool.MailTemplate.1", objectArray));
            System.exit(20);
        }
        for (int i = 0; i < 4; ++i) {
            NotifyMailInfo notifyMailInfo = new NotifyMailInfo();
            notifyMailInfo.setNotifyId(notifyInfo.getNotifyId());
            if (i == 0) {
                notifyMailInfo.setPriority(Integer.valueOf(3));
            } else if (i == 1) {
                notifyMailInfo.setPriority(Integer.valueOf(2));
            } else if (i == 2) {
                notifyMailInfo.setPriority(Integer.valueOf(0));
            } else if (i == 3) {
                notifyMailInfo.setPriority(Integer.valueOf(1));
            }
            notifyMailInfo.setValidFlg(Integer.valueOf(ValidConstant.stringToType((String)arrayList.get(i * 3 + 6))));
            String string2 = CheckString.checkLength(arrayList.get(i * 3 + 7), 1024);
            if (!string2.equals(arrayList.get(i * 3 + 7))) {
                Object[] objectArray = new String[]{com.clustercontrol.util.Messages.getString((String)"email.address.ssv"), "1024"};
                log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray));
            }
            notifyMailInfo.setMailAddress(string2);
            notifyMailInfo.setInhibitionFlg(Integer.valueOf(ValidConstant.stringToType((String)arrayList.get(i * 3 + 8))));
            notifyMailInfo.setMailTemplateId(string);
            arrayList2.add(notifyMailInfo);
        }
        notifyInfo.setNotifyInfoDetail(arrayList2);
    }

    protected void createJobNotifyInfo(ArrayList<String> arrayList, NotifyInfo notifyInfo) {
        ArrayList<NotifyJobInfo> arrayList2 = new ArrayList<NotifyJobInfo>();
        int n = 0;
        n = arrayList.get(5).equals(com.clustercontrol.util.Messages.getString((String)"notify.node.generation")) ? 0 : 1;
        String string = arrayList.get(6);
        for (int i = 0; i < 4; ++i) {
            NotifyJobInfo notifyJobInfo = new NotifyJobInfo();
            notifyJobInfo.setNotifyId(notifyInfo.getNotifyId());
            if (i == 0) {
                notifyJobInfo.setPriority(Integer.valueOf(3));
            } else if (i == 1) {
                notifyJobInfo.setPriority(Integer.valueOf(2));
            } else if (i == 2) {
                notifyJobInfo.setPriority(Integer.valueOf(0));
            } else if (i == 3) {
                notifyJobInfo.setPriority(Integer.valueOf(1));
            }
            notifyJobInfo.setValidFlg(Integer.valueOf(ValidConstant.stringToType((String)arrayList.get(i * 4 + 7))));
            notifyJobInfo.setJobId(arrayList.get(i * 4 + 8));
            notifyJobInfo.setInhibitionFlg(Integer.valueOf(ValidConstant.stringToType((String)arrayList.get(i * 4 + 9))));
            notifyJobInfo.setJobFailurePriority(Integer.valueOf(PriorityConstant.stringToType((String)arrayList.get(i * 4 + 10))));
            notifyJobInfo.setJobExecFacilityFlg(Integer.valueOf(n));
            notifyJobInfo.setJobExecFacility(string);
            arrayList2.add(notifyJobInfo);
        }
        notifyInfo.setNotifyInfoDetail(arrayList2);
    }

    protected void createSyslogNotifyInfo(ArrayList<String> arrayList, NotifyInfo notifyInfo) {
        ArrayList<NotifyLogEscalateInfo> arrayList2 = new ArrayList<NotifyLogEscalateInfo>();
        int n = 0;
        n = arrayList.get(5).equals(com.clustercontrol.util.Messages.getString((String)"notify.node.generation")) ? 0 : 1;
        String string = arrayList.get(6);
        int n2 = Integer.parseInt(arrayList.get(7));
        for (int i = 0; i < 4; ++i) {
            NotifyLogEscalateInfo notifyLogEscalateInfo = new NotifyLogEscalateInfo();
            notifyLogEscalateInfo.setNotifyId(notifyInfo.getNotifyId());
            if (i == 0) {
                notifyLogEscalateInfo.setPriority(Integer.valueOf(3));
            } else if (i == 1) {
                notifyLogEscalateInfo.setPriority(Integer.valueOf(2));
            } else if (i == 2) {
                notifyLogEscalateInfo.setPriority(Integer.valueOf(0));
            } else if (i == 3) {
                notifyLogEscalateInfo.setPriority(Integer.valueOf(1));
            }
            notifyLogEscalateInfo.setValidFlg(Integer.valueOf(ValidConstant.stringToType((String)arrayList.get(i * 5 + 8))));
            notifyLogEscalateInfo.setSyslogFacility(Integer.valueOf(SyslogFacilityConstant.stringToType((String)arrayList.get(i * 5 + 9))));
            notifyLogEscalateInfo.setSyslogPriority(Integer.valueOf(SyslogSeverityConstant.stringToType((String)arrayList.get(i * 5 + 10))));
            String string2 = CheckString.checkLength(arrayList.get(i * 5 + 11), 1024);
            if (!string2.equals(arrayList.get(i * 5 + 11))) {
                Object[] objectArray = new String[]{com.clustercontrol.util.Messages.getString((String)"message"), "1024"};
                log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray));
            }
            notifyLogEscalateInfo.setEscalateMessage(string2);
            notifyLogEscalateInfo.setInhibitionFlg(Integer.valueOf(ValidConstant.stringToType((String)arrayList.get(i * 5 + 12))));
            notifyLogEscalateInfo.setEscalateFacilityFlg(Integer.valueOf(n));
            notifyLogEscalateInfo.setEscalateFacility(string);
            notifyLogEscalateInfo.setEscalatePort(Integer.valueOf(n2));
            arrayList2.add(notifyLogEscalateInfo);
        }
        notifyInfo.setNotifyInfoDetail(arrayList2);
    }

    protected ArrayList checkNotifyList(String string) {
        if (this.notifyList instanceof ArrayList) {
            for (ArrayList arrayList : this.notifyList) {
                String string2 = (String)arrayList.get(2);
                if (string2.compareTo(string) != 0) continue;
                return arrayList;
            }
        }
        return null;
    }

    protected void registerNotifyInfo(NotifyInfo notifyInfo) {
        NotifyController notifyController = EjbConnectionManager.getConnectionManager().getNotifyController();
        try {
            ArrayList arrayList = this.checkNotifyList(notifyInfo.getNotifyId());
            if (arrayList instanceof ArrayList) {
                Object[] objectArray = new Object[]{notifyInfo.getNotifyId()};
                log.info((Object)(Messages.getMsg("NotifyID", objectArray) + " (" + Messages.getMsg("modify") + ")"));
                notifyController.modifyNotify(notifyInfo);
            } else {
                Object[] objectArray = new Object[]{notifyInfo.getNotifyId()};
                log.info((Object)(Messages.getMsg("NotifyID", objectArray) + " (" + Messages.getMsg("add") + ")"));
                notifyController.addNotify(notifyInfo);
            }
        }
        catch (DuplicateKeyException duplicateKeyException) {
            Object[] objectArray = new String[]{notifyInfo.getNotifyId()};
            log.error((Object)Messages.getMsg("ImportTool.Common.1", objectArray));
            System.exit(20);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
    }

    protected ArrayList getNotifyList() {
        NotifyController notifyController = EjbConnectionManager.getConnectionManager().getNotifyController();
        ArrayList arrayList = null;
        try {
            arrayList = notifyController.getNotifyList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

