/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.browser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import uk.co.westhawk.snmp.pdu.BlockPdu;
import uk.co.westhawk.snmp.stack.varbind;

public class SnmpResponse {
    public int errorStatus;
    public String errorStatusString;
    public int errorIndex;
    public ArrayList oids = new ArrayList();
    private HashMap values = new HashMap();

    public SnmpResponse(BlockPdu pdu, varbind[] variables) {
        this.errorStatus = pdu.getErrorStatus();
        this.errorStatusString = pdu.getErrorStatusString();
        this.errorIndex = pdu.getErrorIndex();
        if (variables != null) {
            for (int i = 0; i < variables.length; ++i) {
                this.oids.add(variables[i].getOid().toString());
                this.values.put(variables[i].getOid().toString(), variables[i].getValue().toString());
            }
        }
    }

    public int getCount() {
        return this.oids.size();
    }

    public String getOid(int index) {
        if (index < 0 || index >= this.oids.size()) {
            return null;
        }
        return this.oids.get(index).toString();
    }

    public Iterator getOids() {
        return this.oids.iterator();
    }

    public String getValue(int index) {
        return this.getValue(this.getOid(index));
    }

    public String getValue(String oid) {
        return (String)this.values.get(oid);
    }

    public String getOidsAndValues() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.oids.size(); ++i) {
            String oid = this.oids.get(i).toString();
            buffer.append(oid);
            buffer.append(": ");
            buffer.append(this.getValue(oid));
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getOidsAndValues());
        buffer.append("Error status: ");
        buffer.append(this.errorStatus);
        buffer.append("\n");
        buffer.append("Error index: ");
        buffer.append(this.errorIndex);
        buffer.append("\n");
        buffer.append("Error status message: ");
        buffer.append(this.errorStatusString);
        buffer.append("\n");
        return buffer.toString();
    }
}

