/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.snmp.SnmpAccess;
import net.percederberg.mibble.snmp.SnmpType;

public class SnmpCompliance {
    private boolean group;
    private MibValue value;
    private MibType syntax;
    private MibType writeSyntax;
    private SnmpAccess access;
    private String description;
    private String comment = null;

    public SnmpCompliance(boolean group, MibValue value, MibType syntax, MibType writeSyntax, SnmpAccess access, String description) {
        this.group = group;
        this.value = value;
        this.syntax = syntax;
        this.writeSyntax = writeSyntax;
        this.access = access;
        this.description = description;
    }

    void initialize(MibLoaderLog log) throws MibException {
        this.value = this.value.initialize(log, null);
        if (this.syntax != null) {
            this.syntax = this.syntax.initialize(null, log);
        }
        if (this.writeSyntax != null) {
            this.writeSyntax = this.writeSyntax.initialize(null, log);
        }
    }

    public boolean isGroup() {
        return this.group;
    }

    public boolean isObject() {
        return !this.group;
    }

    public MibValue getValue() {
        return this.value;
    }

    public MibType getSyntax() {
        return this.syntax;
    }

    public MibType getWriteSyntax() {
        return this.writeSyntax;
    }

    public SnmpAccess getAccess() {
        return this.access;
    }

    public String getDescription() {
        return SnmpType.removeIndent(this.description);
    }

    public String getUnformattedDescription() {
        return this.description;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.value);
        if (this.syntax != null) {
            buffer.append("\n      Syntax: ");
            buffer.append(this.syntax);
        }
        if (this.writeSyntax != null) {
            buffer.append("\n      Write-Syntax: ");
            buffer.append(this.writeSyntax);
        }
        if (this.access != null) {
            buffer.append("\n      Access: ");
            buffer.append(this.access);
        }
        buffer.append("\n      Description: ");
        buffer.append(this.description);
        return buffer.toString();
    }
}

