/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.type;

import java.util.ArrayList;
import net.percederberg.mibble.FileLocation;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.type.CompoundConstraint;
import net.percederberg.mibble.type.Constraint;
import net.percederberg.mibble.type.IntegerType;
import net.percederberg.mibble.type.SequenceOfType;
import net.percederberg.mibble.type.StringType;
import net.percederberg.mibble.type.ValueConstraint;
import net.percederberg.mibble.type.ValueRangeConstraint;
import net.percederberg.mibble.value.NumberValue;
import net.percederberg.mibble.value.StringValue;

public class SizeConstraint
implements Constraint {
    private FileLocation location;
    private Constraint values;

    public SizeConstraint(FileLocation location, Constraint values) {
        this.location = location;
        this.values = values;
    }

    public void initialize(MibType type, MibLoaderLog log) throws MibException {
        this.values.initialize(new IntegerType(), log);
        if (this.location != null && !this.isCompatible(type)) {
            String message = "Size constraint not compatible with this type";
            log.addWarning(this.location, message);
        }
        this.location = null;
    }

    public boolean isCompatible(MibType type) {
        return type instanceof SequenceOfType || type instanceof StringType;
    }

    public boolean isCompatible(MibValue value) {
        if (value instanceof StringValue) {
            Integer size = new Integer(value.toString().length());
            return this.values.isCompatible(new NumberValue(size));
        }
        return false;
    }

    public ArrayList getValues() {
        if (this.values instanceof CompoundConstraint) {
            return ((CompoundConstraint)this.values).getConstraintList();
        }
        ArrayList<Constraint> list = new ArrayList<Constraint>();
        list.add(this.values);
        return list;
    }

    public int nextValue(int start) {
        ArrayList list = this.getValues();
        Object obj = null;
        for (int i = 0; i < list.size(); ++i) {
            Constraint c = (Constraint)list.get(i);
            if (c instanceof ValueConstraint) {
                obj = ((ValueConstraint)c).getValue().toObject();
            } else if (c instanceof ValueRangeConstraint) {
                if (((ValueRangeConstraint)c).isCompatible(new Integer(start))) {
                    return start;
                }
                obj = ((ValueRangeConstraint)c).getLowerBound().toObject();
            }
            if (!(obj instanceof Number) || start > ((Number)obj).intValue()) continue;
            return ((Number)obj).intValue();
        }
        return -1;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SIZE (");
        buffer.append(this.values);
        buffer.append(")");
        return buffer.toString();
    }
}

