/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.conf.calendar;

import com.clustercontrol.calendar.ejb.session.CalendarController;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import jp.co.intellilink.hinemos.export.conf.calendar.ExportDate;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportCalendarSchedule {
    private static Log log = LogFactory.getLog(ExportCalendarSchedule.class);

    public void exportSchedule() {
        log.info((Object)Messages.getMsg("Calendar.Schedule.Start", new String[]{Messages.getMsg("ExportTool.Export")}));
        ArrayList<ArrayList<String>> arrayList = new ArrayList();
        ArrayList arrayList2 = this.getCalendarList();
        if (arrayList2 instanceof ArrayList) {
            for (ArrayList arrayList3 : arrayList2) {
                String string = (String)arrayList3.get(0);
                Object[] objectArray = new Object[]{string};
                log.info((Object)Messages.getMsg("CalendarID", objectArray));
                arrayList = this.createScheduleCsvFormat(arrayList3);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
                WriteCsvFile.writeCsvFile(Config.getConfig("Export.Dir") + "/CALENDAR_(" + string + ")_" + simpleDateFormat.format(new Date()) + ".csv", arrayList);
            }
        }
        log.info((Object)Messages.getMsg("Calendar.Schedule.End", new String[]{Messages.getMsg("ExportTool.Export")}));
    }

    protected ArrayList<ArrayList<String>> createScheduleCsvFormat(ArrayList arrayList) {
        ArrayList<ArrayList<String>> arrayList2 = new ArrayList<ArrayList<String>>();
        String string = (String)arrayList.get(0);
        ArrayList arrayList3 = this.getRuleList(string);
        ArrayList arrayList4 = this.getExceptionList(string);
        ExportDate exportDate = new ExportDate(arrayList, arrayList3, arrayList4);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(5, 1);
        calendar.add(5, (calendar.get(7) - 1) * -1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(calendar.getTime());
        calendar.add(1, 1);
        Date date = calendar.getTime();
        ArrayList<ArrayList<String>> arrayList5 = null;
        while (calendar2.getTime().before(date)) {
            int n = calendar2.get(7);
            if (n == 1) {
                arrayList2.add(this.createHeaderFormat(calendar2.getTime()));
                arrayList5 = new ArrayList<ArrayList<String>>();
                for (int i = 0; i < 5; ++i) {
                    arrayList5.add(this.createEmptyFormat());
                }
            }
            ArrayList<String> arrayList6 = exportDate.exportDate(calendar2.getTime());
            int n2 = 0;
            for (String string2 : arrayList6) {
                ArrayList arrayList7 = (ArrayList)arrayList5.get(n2);
                arrayList7.set(n - 1, string2);
                if (++n2 <= 5) continue;
                break;
            }
            if (n == 7) {
                arrayList2.addAll(arrayList5);
                arrayList5 = null;
            }
            calendar2.add(5, 1);
        }
        if (arrayList5 != null) {
            arrayList2.addAll(arrayList5);
        }
        return arrayList2;
    }

    protected ArrayList<String> createHeaderFormat(Date date) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        for (int i = 0; i < 7; ++i) {
            arrayList.add(DateFormat.getDateInstance().format(calendar.getTime()));
            calendar.add(5, 1);
        }
        return arrayList;
    }

    protected ArrayList<String> createEmptyFormat() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < 7; ++i) {
            arrayList.add("");
        }
        return arrayList;
    }

    protected ArrayList getExceptionList(String string) {
        CalendarController calendarController = EjbConnectionManager.getConnectionManager().getCalendarController();
        ArrayList arrayList = null;
        try {
            arrayList = calendarController.getAddList(string);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }

    protected ArrayList getRuleList(String string) {
        CalendarController calendarController = EjbConnectionManager.getConnectionManager().getCalendarController();
        ArrayList arrayList = null;
        try {
            arrayList = calendarController.getWeekdayList(string);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }

    protected ArrayList getCalendarList() {
        CalendarController calendarController = EjbConnectionManager.getConnectionManager().getCalendarController();
        ArrayList arrayList = null;
        try {
            arrayList = calendarController.getCalendarList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

