/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.history;

import com.clustercontrol.bean.CommonTableTreeItem;
import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.JobConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.bean.ViewListInfo;
import com.clustercontrol.jobmanagement.ejb.session.JobController;
import com.clustercontrol.util.PropertyUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import jp.co.intellilink.hinemos.util.CheckString;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.StringListComparator;
import jp.co.intellilink.hinemos.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportJob {
    private static Log log = LogFactory.getLog(ExportJob.class);

    public void export(Date date) {
        log.info((Object)Messages.getMsg("ExportTool.Job.Start"));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList<ArrayList<String>> arrayList2 = new ArrayList<ArrayList<String>>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date date2 = calendar.getTime();
        calendar.add(5, 1);
        calendar.add(14, -1);
        Date date3 = calendar.getTime();
        ViewListInfo viewListInfo = this.getSessionList(date2, date3);
        if (viewListInfo.getList() instanceof ArrayList) {
            for (ArrayList arrayList3 : viewListInfo.getList()) {
                String string = (String)arrayList3.get(3);
                Object[] objectArray = new Object[]{string};
                log.info((Object)Messages.getMsg("SessionID", objectArray));
                CommonTableTreeItem commonTableTreeItem = this.getJobDetail(string);
                this.getJobDetailData(arrayList3, commonTableTreeItem, arrayList);
                this.getJobNodeData(arrayList3, commonTableTreeItem, arrayList2);
            }
        }
        Collections.sort(arrayList, new StringListComparator(4));
        Collections.sort(arrayList, new StringListComparator(3));
        arrayList.add(0, this.createDetailCsvHeader());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        WriteCsvFile.writeCsvFile(Config.getConfig("History.Dir") + "/JOB_" + simpleDateFormat.format(date2) + ".csv", arrayList);
        Collections.sort(arrayList2, new StringListComparator(3));
        Collections.sort(arrayList2, new StringListComparator(2));
        arrayList2.add(0, this.createNodeCsvHeader());
        WriteCsvFile.writeCsvFile(Config.getConfig("History.Dir") + "/JOB_NODE_" + simpleDateFormat.format(date2) + ".csv", arrayList2);
        log.info((Object)Messages.getMsg("ExportTool.Job.End"));
    }

    public ArrayList<String> createDetailCsvHeader() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"run.status"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"end.status"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"end.value"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"session.id"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"job.id"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"job.name"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"type"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"facility.id"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"scope"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"scheduled.start.time"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"time"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"start.rerun.time"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"end.suspend.time"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"trigger.type"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"trigger.info"));
        return arrayList;
    }

    public void getJobDetailData(ArrayList arrayList, CommonTableTreeItem commonTableTreeItem, ArrayList<ArrayList<String>> arrayList2) {
        CommonTableTreeItem[] commonTableTreeItemArray;
        if (commonTableTreeItem.getData() instanceof ArrayList) {
            commonTableTreeItemArray = commonTableTreeItem.getData();
            String object = (String)commonTableTreeItemArray.get(4);
            Object[] objectArray = new Object[]{object};
            log.info((Object)Messages.getMsg("JobID", objectArray));
            ArrayList<String> arrayList3 = new ArrayList<String>();
            arrayList3.add(StatusConstant.typeToString((int)((Number)commonTableTreeItemArray.get(1)).intValue()));
            if (commonTableTreeItemArray.get(2) instanceof Number) {
                arrayList3.add(EndStatusConstant.typeToString((int)((Number)commonTableTreeItemArray.get(2)).intValue()));
            } else {
                arrayList3.add("");
            }
            if (commonTableTreeItemArray.get(3) instanceof Number) {
                arrayList3.add(((Number)commonTableTreeItemArray.get(3)).toString());
            } else {
                arrayList3.add("");
            }
            arrayList3.add((String)arrayList.get(3));
            arrayList3.add((String)commonTableTreeItemArray.get(4));
            arrayList3.add((String)commonTableTreeItemArray.get(5));
            arrayList3.add(JobConstant.typeToString((int)((Number)commonTableTreeItemArray.get(6)).intValue()));
            if (commonTableTreeItemArray.get(7) instanceof String) {
                arrayList3.add((String)commonTableTreeItemArray.get(7));
            } else {
                arrayList3.add("");
            }
            if (commonTableTreeItemArray.get(8) instanceof String) {
                arrayList3.add((String)commonTableTreeItemArray.get(8));
            } else {
                arrayList3.add("");
            }
            if (commonTableTreeItem.getParent().getData() == null) {
                arrayList3.add(DateFormat.getDateTimeInstance().format((Date)arrayList.get(9)));
            } else {
                arrayList3.add("");
            }
            if (commonTableTreeItemArray.get(9) != null) {
                Class<?> clazz = commonTableTreeItemArray.get(9).getClass();
                if (clazz == Date.class) {
                    arrayList3.add(new SimpleDateFormat("HH:mm").format((Date)commonTableTreeItemArray.get(9)));
                } else if (clazz == String.class) {
                    arrayList3.add((String)commonTableTreeItemArray.get(9));
                } else if (clazz.getSuperclass() == Number.class) {
                    arrayList3.add(((Number)commonTableTreeItemArray.get(9)).toString());
                } else {
                    arrayList3.add("");
                }
            } else {
                arrayList3.add("");
            }
            if (commonTableTreeItemArray.get(10) instanceof Date) {
                arrayList3.add(DateFormat.getDateTimeInstance().format((Date)commonTableTreeItemArray.get(10)));
            } else {
                arrayList3.add("");
            }
            if (commonTableTreeItemArray.get(11) instanceof Date) {
                arrayList3.add(DateFormat.getDateTimeInstance().format((Date)commonTableTreeItemArray.get(11)));
            } else {
                arrayList3.add("");
            }
            if (commonTableTreeItem.getParent().getData() == null) {
                arrayList3.add((String)arrayList.get(12));
                arrayList3.add((String)arrayList.get(13));
            } else {
                arrayList3.add("");
                arrayList3.add("");
            }
            arrayList2.add(arrayList3);
        }
        for (CommonTableTreeItem commonTableTreeItem2 : commonTableTreeItemArray = commonTableTreeItem.getChildren()) {
            this.getJobDetailData(arrayList, commonTableTreeItem2, arrayList2);
        }
    }

    protected ViewListInfo getSessionList(Date date, Date date2) {
        JobController jobController = EjbConnectionManager.getConnectionManager().getJobController();
        ViewListInfo viewListInfo = null;
        try {
            ArrayList arrayList = null;
            Property property = jobController.getHistoryFilterProperty(Locale.getDefault());
            if (date instanceof Date) {
                arrayList = PropertyUtil.getProperty((Property)property, (String)"startFromDate");
                ((Property)arrayList.get(0)).setValue((Object)date);
            }
            if (date2 instanceof Date) {
                arrayList = PropertyUtil.getProperty((Property)property, (String)"startToDate");
                ((Property)arrayList.get(0)).setValue((Object)date2);
            }
            int n = Integer.parseInt(Config.getConfig("history.job.max.list"));
            viewListInfo = jobController.getHistoryList(property, n);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return viewListInfo;
    }

    protected CommonTableTreeItem getJobDetail(String string) {
        JobController jobController = EjbConnectionManager.getConnectionManager().getJobController();
        CommonTableTreeItem commonTableTreeItem = null;
        try {
            commonTableTreeItem = jobController.getDetailList(string);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return commonTableTreeItem;
    }

    protected ArrayList getNodeList(String string, String string2) {
        JobController jobController = EjbConnectionManager.getConnectionManager().getJobController();
        ArrayList arrayList = null;
        try {
            arrayList = jobController.getNodeDetailList(string, string2, Locale.getDefault());
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }

    public void getJobNodeData(ArrayList arrayList, CommonTableTreeItem commonTableTreeItem, ArrayList<ArrayList<String>> arrayList2) {
        CommonTableTreeItem[] commonTableTreeItemArray;
        if (commonTableTreeItem.getData() instanceof ArrayList && ((Number)(commonTableTreeItemArray = commonTableTreeItem.getData()).get(6)).intValue() == 2) {
            String object = (String)arrayList.get(3);
            String string = (String)commonTableTreeItemArray.get(4);
            String string2 = (String)commonTableTreeItemArray.get(5);
            ArrayList arrayList3 = this.getNodeList(object, string);
            if (arrayList3 instanceof ArrayList) {
                for (ArrayList arrayList4 : arrayList3) {
                    ArrayList<String> arrayList5 = new ArrayList<String>();
                    arrayList5.add(StatusConstant.typeToString((int)((Number)arrayList4.get(0)).intValue()));
                    if (arrayList4.get(1) instanceof Number) {
                        arrayList5.add(((Number)arrayList4.get(1)).toString());
                    } else {
                        arrayList5.add("");
                    }
                    arrayList5.add(object);
                    arrayList5.add(string);
                    arrayList5.add(string2);
                    if (arrayList4.get(2) instanceof String) {
                        arrayList5.add((String)arrayList4.get(2));
                    } else {
                        arrayList5.add("");
                    }
                    if (arrayList4.get(3) instanceof String) {
                        arrayList5.add((String)arrayList4.get(3));
                    } else {
                        arrayList5.add("");
                    }
                    if (arrayList4.get(4) instanceof Date) {
                        arrayList5.add(DateFormat.getDateTimeInstance().format((Date)arrayList4.get(4)));
                    } else {
                        arrayList5.add("");
                    }
                    if (arrayList4.get(5) instanceof Date) {
                        arrayList5.add(DateFormat.getDateTimeInstance().format((Date)arrayList4.get(5)));
                    } else {
                        arrayList5.add("");
                    }
                    if (arrayList4.get(6) instanceof String) {
                        arrayList5.add(CheckString.checkReturn((String)arrayList4.get(6)));
                    } else {
                        arrayList5.add("");
                    }
                    arrayList2.add(arrayList5);
                }
            }
        }
        for (CommonTableTreeItem commonTableTreeItem2 : commonTableTreeItemArray = commonTableTreeItem.getChildren()) {
            this.getJobNodeData(arrayList, commonTableTreeItem2, arrayList2);
        }
    }

    public ArrayList<String> createNodeCsvHeader() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"run.status"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"return.value"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"session.id"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"job.id"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"job.name"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"facility.id"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"facility.name"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"start.rerun.time"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"end.suspend.time"));
        arrayList.add(com.clustercontrol.util.Messages.getString((String)"message"));
        return arrayList;
    }
}

