/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.importtool.conf.job;

import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.JobConstant;
import com.clustercontrol.bean.JobParamTypeConstant;
import com.clustercontrol.bean.JudgmentObjectConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.jobmanagement.bean.ConditionTypeConstant;
import com.clustercontrol.jobmanagement.bean.JobCommandInfo;
import com.clustercontrol.jobmanagement.bean.JobEndStatusInfo;
import com.clustercontrol.jobmanagement.bean.JobFileInfo;
import com.clustercontrol.jobmanagement.bean.JobInfo;
import com.clustercontrol.jobmanagement.bean.JobNotificationsInfo;
import com.clustercontrol.jobmanagement.bean.JobObjectInfo;
import com.clustercontrol.jobmanagement.bean.JobParameterInfo;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.bean.JobWaitRuleInfo;
import com.clustercontrol.jobmanagement.bean.OperationConstant;
import com.clustercontrol.jobmanagement.ejb.session.JobController;
import com.clustercontrol.notify.bean.NotifyRelationInfo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;
import jp.co.intellilink.hinemos.util.CheckString;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.JobUtil;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.ReadCsvFile;
import jp.co.intellilink.hinemos.util.SelectArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportJob {
    private static Log log = LogFactory.getLog(ImportJob.class);
    private ArrayList<ArrayList<String>> jobInfo = null;
    private ArrayList<ArrayList<String>> waitInfo = null;
    private ArrayList<ArrayList<String>> notifyInfo = null;
    private ArrayList<ArrayList<String>> delayInfo = null;
    private ArrayList<ArrayList<String>> paramInfo = null;
    private SimpleDateFormat formatTime1 = new SimpleDateFormat("HH:mm:ss");
    private SimpleDateFormat formatTime2 = new SimpleDateFormat("HH:mm");

    public void importJob() {
        log.info((Object)Messages.getMsg("Job.Start", new String[]{Messages.getMsg("ImportTool.Import")}));
        this.jobInfo = ReadCsvFile.readCsvFile(Config.getConfig("Import.Dir") + "/JOB.csv");
        this.waitInfo = ReadCsvFile.readCsvFile(Config.getConfig("Import.Dir") + "/JOB_WAIT.csv");
        this.notifyInfo = ReadCsvFile.readCsvFile(Config.getConfig("Import.Dir") + "/JOB_NOTIFY.csv");
        this.delayInfo = ReadCsvFile.readCsvFile(Config.getConfig("Import.Dir") + "/JOB_DELAY.csv");
        this.paramInfo = ReadCsvFile.readCsvFile(Config.getConfig("Import.Dir") + "/JOB_PARAM.csv");
        JobTreeItem jobTreeItem = this.createJobTree();
        log.info((Object)Messages.getMsg("Job.Check.WaitRule"));
        if (JobUtil.checkWaitRule(jobTreeItem)) {
            log.info((Object)Messages.getMsg("Job.Check.FacilityID"));
            if (JobUtil.checkFacilityId(jobTreeItem)) {
                log.info((Object)Messages.getMsg("Job.Check.NotifyID"));
                if (JobUtil.checkNotifyId(jobTreeItem)) {
                    this.registerJob(jobTreeItem);
                }
            }
        }
        log.info((Object)Messages.getMsg("Job.End", new String[]{Messages.getMsg("ImportTool.Import")}));
    }

    public JobTreeItem createJobTree() {
        JobInfo jobInfo = new JobInfo("", "", -1);
        JobTreeItem jobTreeItem = new JobTreeItem(null, jobInfo);
        jobInfo = new JobInfo("", com.clustercontrol.util.Messages.getString((String)"job", (Locale)Locale.getDefault()), -1);
        JobTreeItem jobTreeItem2 = new JobTreeItem(jobTreeItem, jobInfo);
        ArrayList<ArrayList<String>> arrayList = SelectArrayList.select(this.jobInfo, 3, com.clustercontrol.util.Messages.getString((String)"jobunit", (Locale)Locale.getDefault()));
        for (ArrayList<String> arrayList2 : arrayList) {
            this.createJobTree(arrayList2, jobTreeItem2);
        }
        return jobTreeItem;
    }

    protected void createJobTree(ArrayList<String> arrayList, JobTreeItem jobTreeItem) {
        JobTreeItem jobTreeItem2 = JobUtil.getTopJobTreeItem(jobTreeItem);
        if (JobUtil.findJobId(arrayList.get(0), jobTreeItem2)) {
            log.error((Object)Messages.getMsg("ImportTool.Job.3", new String[]{arrayList.get(0)}));
            System.exit(14);
        }
        JobInfo jobInfo = this.createJobData(arrayList);
        JobTreeItem jobTreeItem3 = new JobTreeItem(jobTreeItem, jobInfo);
        ArrayList<ArrayList<String>> arrayList2 = SelectArrayList.select(this.jobInfo, 4, arrayList.get(0));
        for (ArrayList<String> arrayList3 : arrayList2) {
            this.createJobTree(arrayList3, jobTreeItem3);
        }
    }

    protected JobInfo createJobData(ArrayList<String> arrayList) {
        Object[] objectArray;
        Object[] objectArray2;
        log.info((Object)Messages.getMsg("JobID", new String[]{arrayList.get(0)}));
        JobInfo jobInfo = new JobInfo(arrayList.get(0), arrayList.get(1), JobConstant.stringToType((String)arrayList.get(3)));
        String string = CheckString.checkLength(arrayList.get(0), 64);
        if (!string.equals(arrayList.get(0))) {
            objectArray2 = new String[]{com.clustercontrol.util.Messages.getString((String)"job.id"), "64"};
            log.error((Object)Messages.getMsg("ImportTool.Common.2", objectArray2));
            System.exit(20);
        }
        jobInfo.setName(string);
        objectArray2 = CheckString.checkLength(arrayList.get(1), 64);
        if (!objectArray2.equals(arrayList.get(1))) {
            objectArray = new String[]{com.clustercontrol.util.Messages.getString((String)"job.name"), "64"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray));
        }
        jobInfo.setName((String)objectArray2);
        objectArray = CheckString.checkLength(arrayList.get(2), 256);
        if (!objectArray.equals(arrayList.get(2))) {
            Object[] objectArray3 = new String[]{com.clustercontrol.util.Messages.getString((String)"description"), "256"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray3));
        }
        jobInfo.setDescription((String)objectArray);
        jobInfo.setWaitRule(this.createJobWaitRuleData(arrayList, jobInfo));
        jobInfo.setCommand(this.createJobCommandData(arrayList, jobInfo));
        jobInfo.setFile(this.createJobFileData(arrayList, jobInfo));
        jobInfo.setNotifications(this.createJobNotificationsData(arrayList));
        jobInfo.setEndStatus(this.createJobEndStatusData(arrayList));
        jobInfo.setParam(this.createJobParameterData(arrayList, jobInfo));
        return jobInfo;
    }

    protected ArrayList<JobParameterInfo> createJobParameterData(ArrayList<String> arrayList, JobInfo jobInfo) {
        ArrayList<JobParameterInfo> arrayList2 = null;
        ArrayList<ArrayList<String>> arrayList3 = SelectArrayList.select(this.paramInfo, 0, arrayList.get(0));
        if (jobInfo.getType() == 0 && arrayList3.size() > 0) {
            arrayList2 = new ArrayList<JobParameterInfo>();
            for (ArrayList<String> arrayList4 : arrayList3) {
                JobParameterInfo jobParameterInfo = new JobParameterInfo();
                jobParameterInfo.setParamId(arrayList4.get(1));
                jobParameterInfo.setType(JobParamTypeConstant.stringToType((String)arrayList4.get(2)));
                jobParameterInfo.setValue(arrayList4.get(3));
                jobParameterInfo.setDescription(arrayList4.get(4));
                arrayList2.add(jobParameterInfo);
            }
        }
        return arrayList2;
    }

    protected ArrayList<JobEndStatusInfo> createJobEndStatusData(ArrayList<String> arrayList) {
        ArrayList<JobEndStatusInfo> arrayList2 = new ArrayList<JobEndStatusInfo>();
        JobEndStatusInfo jobEndStatusInfo = new JobEndStatusInfo();
        jobEndStatusInfo.setType(0);
        jobEndStatusInfo.setValue(Integer.parseInt(arrayList.get(5)));
        jobEndStatusInfo.setStartRangeValue(Integer.parseInt(arrayList.get(6)));
        jobEndStatusInfo.setEndRangeValue(Integer.parseInt(arrayList.get(7)));
        arrayList2.add(jobEndStatusInfo);
        jobEndStatusInfo = new JobEndStatusInfo();
        jobEndStatusInfo.setType(1);
        jobEndStatusInfo.setValue(Integer.parseInt(arrayList.get(8)));
        jobEndStatusInfo.setStartRangeValue(Integer.parseInt(arrayList.get(9)));
        jobEndStatusInfo.setEndRangeValue(Integer.parseInt(arrayList.get(10)));
        arrayList2.add(jobEndStatusInfo);
        jobEndStatusInfo = new JobEndStatusInfo();
        jobEndStatusInfo.setType(2);
        jobEndStatusInfo.setValue(Integer.parseInt(arrayList.get(11)));
        jobEndStatusInfo.setStartRangeValue(0);
        jobEndStatusInfo.setEndRangeValue(0);
        arrayList2.add(jobEndStatusInfo);
        return arrayList2;
    }

    protected ArrayList<JobNotificationsInfo> createJobNotificationsData(ArrayList<String> arrayList) {
        ArrayList<JobNotificationsInfo> arrayList2 = null;
        ArrayList<ArrayList<String>> arrayList3 = SelectArrayList.select(this.notifyInfo, 0, arrayList.get(0));
        if (arrayList3.size() > 0) {
            JobNotificationsInfo jobNotificationsInfo;
            int n;
            ArrayList<String> arrayList4 = arrayList3.get(0);
            String string = NotifyRelationInfo.createNotifyGroupIdJob((String)arrayList.get(0), (Integer)0);
            ArrayList<JobNotificationsInfo> arrayList5 = new ArrayList<JobNotificationsInfo>();
            for (n = 5; n < 10; ++n) {
                if (arrayList4.size() <= n || !(arrayList4.get(n) instanceof String) || arrayList4.get(n).length() <= 0) continue;
                jobNotificationsInfo = new NotifyRelationInfo();
                jobNotificationsInfo.setNotifyId(arrayList4.get(n));
                jobNotificationsInfo.setNotifyGroupId(string);
                jobNotificationsInfo.setNotifyFlg(Integer.valueOf(0));
                if (n == 5) {
                    jobNotificationsInfo.setNotifyType(Integer.valueOf(0));
                } else if (n == 6) {
                    jobNotificationsInfo.setNotifyType(Integer.valueOf(1));
                } else if (n == 7) {
                    jobNotificationsInfo.setNotifyType(Integer.valueOf(2));
                } else if (n == 8) {
                    jobNotificationsInfo.setNotifyType(Integer.valueOf(3));
                } else if (n == 9) {
                    jobNotificationsInfo.setNotifyType(Integer.valueOf(4));
                }
                arrayList5.add(jobNotificationsInfo);
            }
            arrayList2 = new ArrayList<JobNotificationsInfo>();
            for (n = 0; n < 4; ++n) {
                jobNotificationsInfo = new JobNotificationsInfo();
                if (n == 0) {
                    jobNotificationsInfo.setType(0);
                    jobNotificationsInfo.setPriority(PriorityConstant.stringToType((String)arrayList4.get(2)));
                } else if (n == 1) {
                    jobNotificationsInfo.setType(1);
                    jobNotificationsInfo.setPriority(PriorityConstant.stringToType((String)arrayList4.get(3)));
                } else if (n == 2) {
                    jobNotificationsInfo.setType(2);
                    jobNotificationsInfo.setPriority(PriorityConstant.stringToType((String)arrayList4.get(4)));
                } else if (n == 3) {
                    jobNotificationsInfo.setType(3);
                    jobNotificationsInfo.setPriority(PriorityConstant.stringToType((String)arrayList4.get(1)));
                }
                jobNotificationsInfo.setNotifyGroupId(string);
                if (jobNotificationsInfo.getType() == 0) {
                    jobNotificationsInfo.setNotifyId(arrayList5);
                }
                arrayList2.add(jobNotificationsInfo);
            }
        }
        return arrayList2;
    }

    protected JobFileInfo createJobFileData(ArrayList<String> arrayList, JobInfo jobInfo) {
        JobFileInfo jobFileInfo = null;
        if (jobInfo.getType() == 3 && arrayList.size() > 29) {
            jobFileInfo = new JobFileInfo();
            if (com.clustercontrol.util.Messages.getString((String)"scope.process.all.nodes").compareTo(arrayList.get(32)) == 0) {
                jobFileInfo.setProcessingMethod(0);
            } else {
                jobFileInfo.setProcessingMethod(1);
            }
            jobFileInfo.setSrcFacilityID(arrayList.get(29));
            jobFileInfo.setDestFacilityID(arrayList.get(31));
            jobFileInfo.setSrcFile(arrayList.get(30));
            jobFileInfo.setSrcWorkDir("");
            jobFileInfo.setDestDirectory(arrayList.get(33));
            jobFileInfo.setDestWorkDir("");
            jobFileInfo.setCompressionFlg(YesNoConstant.stringToType((String)arrayList.get(34)));
            jobFileInfo.setCheckFlg(YesNoConstant.stringToType((String)arrayList.get(35)));
            jobFileInfo.setUser(arrayList.get(36));
        }
        return jobFileInfo;
    }

    protected JobCommandInfo createJobCommandData(ArrayList<String> arrayList, JobInfo jobInfo) {
        JobCommandInfo jobCommandInfo = null;
        if (jobInfo.getType() == 2 && arrayList.size() >= 29) {
            jobCommandInfo = new JobCommandInfo();
            if (com.clustercontrol.util.Messages.getString((String)"fixed.value").compareTo(arrayList.get(21)) == 0) {
                jobCommandInfo.setFacilityID(arrayList.get(22));
            } else {
                jobCommandInfo.setFacilityID("${FACILITY_ID}");
            }
            if (com.clustercontrol.util.Messages.getString((String)"scope.process.all.nodes").compareTo(arrayList.get(23)) == 0) {
                jobCommandInfo.setProcessingMethod(0);
            } else {
                jobCommandInfo.setProcessingMethod(1);
            }
            jobCommandInfo.setStartCommand(arrayList.get(24));
            jobCommandInfo.setStopCommand(arrayList.get(25));
            jobCommandInfo.setUser(arrayList.get(26));
            jobCommandInfo.setErrorEndFlg(YesNoConstant.stringToType((String)arrayList.get(27)));
            jobCommandInfo.setErrorEndValue(Integer.parseInt(arrayList.get(28)));
        }
        return jobCommandInfo;
    }

    protected JobWaitRuleInfo createJobWaitRuleData(ArrayList<String> arrayList, JobInfo jobInfo) {
        JobWaitRuleInfo jobWaitRuleInfo = null;
        ArrayList<ArrayList<String>> arrayList2 = SelectArrayList.select(this.delayInfo, 0, arrayList.get(0));
        if (jobInfo.getType() != 0) {
            ArrayList<Object> arrayList3;
            jobWaitRuleInfo = new JobWaitRuleInfo();
            if (arrayList.size() > 20) {
                if (arrayList.get(18) instanceof String && arrayList.get(18).length() > 0) {
                    jobWaitRuleInfo.setSuspend(YesNoConstant.stringToType((String)arrayList.get(18)));
                }
                if (arrayList.get(12) instanceof String && arrayList.get(12).length() > 0) {
                    jobWaitRuleInfo.setCondition(ConditionTypeConstant.stringToType((String)arrayList.get(12)));
                }
                if (arrayList.get(13) instanceof String && arrayList.get(13).length() > 0) {
                    jobWaitRuleInfo.setEndCondition(YesNoConstant.stringToType((String)arrayList.get(13)));
                }
                if (arrayList.get(14) instanceof String && arrayList.get(14).length() > 0) {
                    jobWaitRuleInfo.setEndValue(Integer.parseInt(arrayList.get(14)));
                }
                if (arrayList.get(19) instanceof String && arrayList.get(19).length() > 0) {
                    jobWaitRuleInfo.setSkip(YesNoConstant.stringToType((String)arrayList.get(19)));
                }
                if (arrayList.get(20) instanceof String && arrayList.get(20).length() > 0) {
                    jobWaitRuleInfo.setSkipEndValue(Integer.parseInt(arrayList.get(20)));
                }
                if (arrayList.get(15) instanceof String && arrayList.get(15).length() > 0) {
                    jobWaitRuleInfo.setCalendar(YesNoConstant.stringToType((String)arrayList.get(15)));
                }
                if (arrayList.get(16) instanceof String && arrayList.get(16).length() > 0) {
                    jobWaitRuleInfo.setCalendarId(arrayList.get(16));
                }
                if (arrayList.get(17) instanceof String && arrayList.get(17).length() > 0) {
                    jobWaitRuleInfo.setCalendarEndValue(Integer.parseInt(arrayList.get(17)));
                }
            }
            if (arrayList2.size() > 0) {
                arrayList3 = arrayList2.get(0);
                jobWaitRuleInfo.setStart_delay(YesNoConstant.stringToType((String)arrayList3.get(1)));
                jobWaitRuleInfo.setStart_delay_session(YesNoConstant.stringToType((String)((String)arrayList3.get(2))));
                jobWaitRuleInfo.setStart_delay_session_value(Integer.parseInt((String)arrayList3.get(3)));
                jobWaitRuleInfo.setStart_delay_time(YesNoConstant.stringToType((String)((String)arrayList3.get(4))));
                try {
                    jobWaitRuleInfo.setStart_delay_time_value(this.formatTime1.parse((String)arrayList3.get(5)));
                }
                catch (ParseException parseException) {
                    try {
                        jobWaitRuleInfo.setStart_delay_time_value(this.formatTime2.parse((String)arrayList3.get(5)));
                    }
                    catch (ParseException parseException2) {
                        // empty catch block
                    }
                }
                jobWaitRuleInfo.setStart_delay_condition_type(ConditionTypeConstant.stringToType((String)((String)arrayList3.get(6))));
                jobWaitRuleInfo.setStart_delay_notify(YesNoConstant.stringToType((String)((String)arrayList3.get(7))));
                jobWaitRuleInfo.setStart_delay_notify_priority(PriorityConstant.stringToType((String)((String)arrayList3.get(8))));
                jobWaitRuleInfo.setStart_delay_operation(YesNoConstant.stringToType((String)((String)arrayList3.get(9))));
                jobWaitRuleInfo.setStart_delay_operation_type(OperationConstant.stringToType((String)((String)arrayList3.get(10))));
                jobWaitRuleInfo.setStart_delay_operation_end_value(Integer.parseInt((String)arrayList3.get(11)));
                jobWaitRuleInfo.setEnd_delay(YesNoConstant.stringToType((String)((String)arrayList3.get(12))));
                jobWaitRuleInfo.setEnd_delay_session(YesNoConstant.stringToType((String)((String)arrayList3.get(13))));
                jobWaitRuleInfo.setEnd_delay_session_value(Integer.parseInt((String)arrayList3.get(14)));
                jobWaitRuleInfo.setEnd_delay_job(YesNoConstant.stringToType((String)((String)arrayList3.get(15))));
                jobWaitRuleInfo.setEnd_delay_job_value(Integer.parseInt((String)arrayList3.get(16)));
                jobWaitRuleInfo.setEnd_delay_time(YesNoConstant.stringToType((String)((String)arrayList3.get(17))));
                try {
                    jobWaitRuleInfo.setEnd_delay_time_value(this.formatTime1.parse((String)arrayList3.get(18)));
                }
                catch (ParseException parseException) {
                    try {
                        jobWaitRuleInfo.setEnd_delay_time_value(this.formatTime2.parse((String)arrayList3.get(18)));
                    }
                    catch (ParseException parseException3) {
                        // empty catch block
                    }
                }
                jobWaitRuleInfo.setEnd_delay_condition_type(ConditionTypeConstant.stringToType((String)((String)arrayList3.get(19))));
                jobWaitRuleInfo.setEnd_delay_notify(YesNoConstant.stringToType((String)((String)arrayList3.get(20))));
                jobWaitRuleInfo.setEnd_delay_notify_priority(PriorityConstant.stringToType((String)((String)arrayList3.get(21))));
                jobWaitRuleInfo.setEnd_delay_operation(YesNoConstant.stringToType((String)((String)arrayList3.get(22))));
                jobWaitRuleInfo.setEnd_delay_operation_type(OperationConstant.stringToType((String)((String)arrayList3.get(23))));
                jobWaitRuleInfo.setEnd_delay_operation_end_value(Integer.parseInt((String)arrayList3.get(24)));
            }
            arrayList3 = SelectArrayList.select(this.waitInfo, 0, arrayList.get(0));
            ArrayList<JobObjectInfo> arrayList4 = new ArrayList<JobObjectInfo>();
            if (arrayList3.size() > 0) {
                for (ArrayList arrayList5 : arrayList3) {
                    JobObjectInfo jobObjectInfo = new JobObjectInfo();
                    jobObjectInfo.setType(JudgmentObjectConstant.stringToType((String)((String)arrayList5.get(1))));
                    if (jobObjectInfo.getType() == 0) {
                        jobObjectInfo.setJobId((String)arrayList5.get(2));
                        jobObjectInfo.setValue(EndStatusConstant.stringToType((String)((String)arrayList5.get(3))));
                    } else if (jobObjectInfo.getType() == 1) {
                        jobObjectInfo.setJobId((String)arrayList5.get(2));
                        jobObjectInfo.setValue(Integer.parseInt((String)arrayList5.get(3)));
                    } else if (jobObjectInfo.getType() == 2) {
                        try {
                            jobObjectInfo.setTime(this.formatTime1.parse((String)arrayList5.get(3)));
                        }
                        catch (ParseException parseException) {
                            try {
                                jobObjectInfo.setTime(this.formatTime2.parse((String)arrayList5.get(3)));
                            }
                            catch (ParseException parseException4) {
                                // empty catch block
                            }
                        }
                    }
                    arrayList4.add(jobObjectInfo);
                }
            }
            jobWaitRuleInfo.setObject(arrayList4);
        }
        return jobWaitRuleInfo;
    }

    protected void registerJob(JobTreeItem jobTreeItem) {
        log.info((Object)Messages.getMsg("Job.Register.Start"));
        JobController jobController = EjbConnectionManager.getConnectionManager().getJobController();
        try {
            jobController.registerJob(jobTreeItem);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        log.info((Object)Messages.getMsg("Job.Register.End"));
    }
}

