/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.util;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WriteCsvFile {
    private static Log log = LogFactory.getLog(WriteCsvFile.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCsvFile(String string, ArrayList<ArrayList<String>> arrayList, boolean bl) {
        FileOutputStream fileOutputStream = null;
        FilterOutputStream filterOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        FileChannel fileChannel = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            fileOutputStream = new FileOutputStream(string, bl);
            fileChannel = fileOutputStream.getChannel();
            if (fileChannel.tryLock() == null) {
                log.error((Object)Messages.getMsg("JMXTool.LockFileFailed"));
                System.exit(51);
            }
            filterOutputStream = new BufferedOutputStream(fileOutputStream);
            outputStreamWriter = new OutputStreamWriter((OutputStream)filterOutputStream, Config.getConfig("output.charset"));
            for (ArrayList<String> arrayList2 : arrayList) {
                stringBuffer.delete(0, stringBuffer.length());
                int n = 0;
                for (String string2 : arrayList2) {
                    if (n > 0) {
                        stringBuffer.append("\t");
                    }
                    stringBuffer.append(string2);
                    ++n;
                }
                stringBuffer.append("\n");
                outputStreamWriter.write(stringBuffer.toString());
            }
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("JMXTool.WriteFileFailed"), (Throwable)exception);
            System.exit(51);
        }
        finally {
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.flush();
                    outputStreamWriter.close();
                }
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
            }
            catch (IOException iOException) {
                log.error((Object)Messages.getMsg("JMXTool.WriteFileFailed"), (Throwable)iOException);
                System.exit(51);
            }
        }
    }

    public static void writeCsvFile(String string, ArrayList<ArrayList<String>> arrayList) {
        WriteCsvFile.writeCsvFile(string, arrayList, false);
    }
}

