/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.check.conf;

import java.util.ArrayList;

import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.syslogng.bean.LogFilterInfo;
import com.clustercontrol.syslogng.ejb.session.SyslogNGController;

/**
 * Syslog-ng監視情報を取得するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class CheckMonitorSyslogng extends CheckMonitor {

	// ログ出力
	private static Log log = LogFactory.getLog(CheckMonitorSyslogng.class);

	/**
	 * Syslog-ng監視の監視項目数、ノード数、通知数を取得する。<br>
	 */
	public ArrayList<String> checkSyslogng() {
		log.info(Messages.getMsg("Syslogng.Start", new String[]{""}));

		//監視項目リスト取得
		ArrayList<LogFilterInfo> infoList = getSyslogngList();
		setIdList(infoList);

		if(infoList instanceof ArrayList){
			for(LogFilterInfo info : infoList){
				Object[] args = {info.getMonitorId()};
				log.info(Messages.getMsg("MonitorID", args));

				int nodeCount = getNodeCount(info);
				int notifyCount = getNotifyCount(info);

				addNodeTotalCount(nodeCount);
				addNotifyTotalCount(nodeCount * notifyCount);
			}
		}

		log.info(Messages.getMsg("Syslogng.End", new String[]{""}));

		return createOutput("Syslogng");
	}
	
	/* (non-Javadoc)
	 * @see jp.co.intellilink.hinemos.status.ExportMonitor#getNodeCount(com.clustercontrol.monitor.run.bean.MonitorInfo)
	 */
	@Override
	public int getNodeCount(MonitorInfo monitorInfo) {
		return 1;
	}

	/**
	 * 監視項目リストを取得する。<br>
	 * 
	 * @return 監視項目一覧
	 */
	@SuppressWarnings("unchecked")
	protected ArrayList<LogFilterInfo> getSyslogngList() {

		SyslogNGController syslog = EjbConnectionManager.getConnectionManager().getMonitorSyslogNGController();

		ArrayList<LogFilterInfo> records = null;
		try {
			records = syslog.getFilterInfoList();
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
		return records;
	}
}