/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool.conf.monitor;

import java.util.ArrayList;
import java.util.List;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorTruthValueInfo;
import com.clustercontrol.monitor.run.bean.TruthConstant;

/**
 * 監視情報を取得するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ImportMonitorTruth extends ImportMonitor {

	/**
	 * 監視判定情報を設定する。<br>
	 * 
	 * @param info 監視情報配列
	 * @param monitorInfo 監視情報オブジェクト
	 */
	protected void createMonitorJudgement(List<String> info, MonitorInfo monitorInfo) {
		ArrayList<MonitorTruthValueInfo> list = new ArrayList<MonitorTruthValueInfo>();

		if(info.get(0) instanceof String && info.get(0).length() > 0){
			MonitorTruthValueInfo truthValueInfo = new MonitorTruthValueInfo();
			truthValueInfo.setMonitorId(monitorInfo.getMonitorId());
			truthValueInfo.setMonitorTypeId(monitorInfo.getMonitorTypeId());
			truthValueInfo.setPriority(PriorityConstant.stringToType(info.get(0)));
			truthValueInfo.setTruthValue(TruthConstant.TYPE_TRUE);
			list.add(truthValueInfo);
		}
		if(info.get(1) instanceof String && info.get(1).length() > 0){
			MonitorTruthValueInfo truthValueInfo = new MonitorTruthValueInfo();
			truthValueInfo.setMonitorId(monitorInfo.getMonitorId());
			truthValueInfo.setMonitorTypeId(monitorInfo.getMonitorTypeId());
			truthValueInfo.setPriority(PriorityConstant.stringToType(info.get(1)));
			truthValueInfo.setTruthValue(TruthConstant.TYPE_FALSE);
			list.add(truthValueInfo);
		}
		if(info.get(2) instanceof String && info.get(2).length() > 0){
			monitorInfo.setFailurePriority(PriorityConstant.stringToType(info.get(2)));
		}
		
		monitorInfo.setJudgementInfo(list);
	}
}