/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool.conf.notify;

import java.util.ArrayList;
import java.util.Iterator;

import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.notify.bean.NotifyTableDefine;
import com.clustercontrol.notify.ejb.session.NotifyController;

/**
 * 通知情報の有効・無効を設定するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ChangeValidNotify {

	// ログ出力
	private static Log log = LogFactory.getLog(ChangeValidNotify.class);

	/**
	 * 通知情報の有効・無効を設定する<br>
	 * 
	 * @param valid 有効/無効
	 */
	@SuppressWarnings("unchecked")
	public void changeValid(boolean valid) {
		log.info(Messages.getMsg("Nofity.Start", new String[]{Messages.getMsg("ImportTool.Change.Valid")}));

		//監視項目リスト取得
		ArrayList idList = getNotifyList();

		if(idList instanceof ArrayList){
			Iterator itr = idList.iterator();
			while(itr.hasNext()){
				ArrayList line = (ArrayList)itr.next();

				NotifyInfo info = getNotify((String)line.get(NotifyTableDefine.NOTIFY_ID));
				info.setValidFlg(ValidConstant.booleanToType(valid));
				changeNotifyInfo(info);
			}
		}

		log.info(Messages.getMsg("Nofity.End", new String[]{Messages.getMsg("ImportTool.Change.Valid")}));
	}

	/**
	 * 通知情報の有効・無効を変更する。<br>
	 * 
	 * @param notifyInfo 通知情報
	 */
	protected void changeNotifyInfo(NotifyInfo notifyInfo) {

		NotifyController notify = EjbConnectionManager.getConnectionManager().getNotifyController();

		try {
			Object[] args = {notifyInfo.getNotifyId()};
			log.info(Messages.getMsg("NotifyID", args) + 
					" (" + Messages.getMsg("modify") + ")");

			notify.modifyNotify(notifyInfo);
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
	}

	/**
	 * 通知情報を取得する。<br>
	 * 
	 * @param notifyId 取得対象の通知ID
	 * @return 通知情報
	 */
	protected NotifyInfo getNotify(String notifyId) {

		NotifyController notify = EjbConnectionManager.getConnectionManager()
		.getNotifyController();

		NotifyInfo info = null;
		try {
			info = notify.getNotify(notifyId);
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
		return info;
	}

	/**
	 * 通知リストを取得する。<br>
	 * 
	 * @return 通知一覧
	 */
	@SuppressWarnings("unchecked")
	protected ArrayList getNotifyList() {

		NotifyController notify = EjbConnectionManager.getConnectionManager().getNotifyController();

		ArrayList records = null;
		try {
			records = notify.getNotifyList();
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
		return records;
	}
}