/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool.conf.job;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.Schedule;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.jobmanagement.bean.ScheduleInfo;
import com.clustercontrol.jobmanagement.bean.ScheduleTableDefine;
import com.clustercontrol.jobmanagement.ejb.session.JobController;

/**
 * スケジュール情報の有効・無効を設定するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ChangeValidSchedule {

	// ログ出力
	private static Log log = LogFactory.getLog(ChangeValidSchedule.class);

	/**
	 * スケジュール情報の有効・無効を設定する<br>
	 * 
	 * @param valid 有効/無効
	 */
	@SuppressWarnings("unchecked")
	public void changeValid(boolean valid) {
		log.info(Messages.getMsg("Job.Schedule.Start", new String[]{Messages.getMsg("ImportTool.Change.Valid")}));

		//監視項目リスト取得
		ArrayList idList = getScheduleList();

		if(idList instanceof ArrayList){
			Iterator itr = idList.iterator();
			while(itr.hasNext()){
				ArrayList line = (ArrayList)itr.next();

				ScheduleInfo scheduleInfo = createScheduleInfo(line, valid);
				changeSchedule(scheduleInfo);
			}
		}

		log.info(Messages.getMsg("Job.Schedule.End", new String[]{Messages.getMsg("ImportTool.Change.Valid")}));
	}

	/**
	 * スケジュール情報を作成する。<br>
	 * 
	 * @param info メンテナンス情報配列
	 * @return スケジュール情報
	 */
	@SuppressWarnings("unchecked")
	public ScheduleInfo createScheduleInfo(ArrayList info, boolean valid) {
		ScheduleInfo scheduleInfo = new ScheduleInfo();

		//スケジュールID
		scheduleInfo.setId((String)info.get(ScheduleTableDefine.SCHE_ID));
		//スケジュール名
		scheduleInfo.setName((String)info.get(ScheduleTableDefine.SCHE_NAME));
		//ジョブID
		scheduleInfo.setJobId((String)info.get(ScheduleTableDefine.JOB_ID));
		//ジョブ名
		scheduleInfo.setJobName((String)info.get(ScheduleTableDefine.JOB_NAME));
		//カレンダID
		scheduleInfo.setCalendarId((String)info.get(ScheduleTableDefine.CALENDAR_ID));
		//スケジュール
		scheduleInfo.setSchedule((Schedule)info.get(ScheduleTableDefine.SCHEDULE));
		//有効/無効
		scheduleInfo.setValid(ValidConstant.booleanToType(valid));

		//登録者、登録日時を設定
		scheduleInfo.setCreateUser((String)info.get(ScheduleTableDefine.CREATE_USER));
		scheduleInfo.setCreateTime((Date)info.get(ScheduleTableDefine.CREATE_TIME));

		return scheduleInfo;
	}

	/**
	 * スケジュールの有効・無効を変更する。<br>
	 * 
	 * @param info スケジュール情報
	 */
	protected void changeSchedule(ScheduleInfo info) {

		JobController job = EjbConnectionManager.getConnectionManager().getJobController();

		try {
			Object[] args = {info.getId()};
			log.info(Messages.getMsg("ScheduleID", args) + 
					" (" + Messages.getMsg("modify") + ")");

			job.modifySchedule(info);
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
	}

	/**
	 * スケジュール一覧を取得する。<br>
	 * 
	 * @return スケジュール一覧
	 */
	@SuppressWarnings("unchecked")
	protected ArrayList getScheduleList() {

		JobController job = EjbConnectionManager.getConnectionManager().getJobController();

		ArrayList list = null;
		try {
			list = job.getScheduleList();
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
		return list;
	}
}