/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool;

import java.util.Arrays;

import javax.naming.NamingException;

import jp.co.intellilink.hinemos.importtool.conf.job.ChangeValidSchedule;
import jp.co.intellilink.hinemos.importtool.conf.logtransfer.ChangeValidLogTransfer;
import jp.co.intellilink.hinemos.importtool.conf.maintenance.ChangeValidMaintenance;
import jp.co.intellilink.hinemos.importtool.conf.monitor.ChangeValidMonitorAgent;
import jp.co.intellilink.hinemos.importtool.conf.monitor.ChangeValidMonitorHttp;
import jp.co.intellilink.hinemos.importtool.conf.monitor.ChangeValidMonitorPerformance;
import jp.co.intellilink.hinemos.importtool.conf.monitor.ChangeValidMonitorPing;
import jp.co.intellilink.hinemos.importtool.conf.monitor.ChangeValidMonitorPort;
import jp.co.intellilink.hinemos.importtool.conf.monitor.ChangeValidMonitorProcess;
import jp.co.intellilink.hinemos.importtool.conf.monitor.ChangeValidMonitorSnmp;
import jp.co.intellilink.hinemos.importtool.conf.monitor.ChangeValidMonitorSnmpTrap;
import jp.co.intellilink.hinemos.importtool.conf.monitor.ChangeValidMonitorSql;
import jp.co.intellilink.hinemos.importtool.conf.monitor.ChangeValidMonitorSyslogng;
import jp.co.intellilink.hinemos.importtool.conf.notify.ChangeValidNotify;
import jp.co.intellilink.hinemos.importtool.conf.repository.ChangeValidNode;
import jp.co.intellilink.hinemos.util.LoginManager;
import jp.co.intellilink.hinemos.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * ChangeValidConf メインクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ChangeValidConf {
	// main関数に与えられる引数
	private static String mode = "all";
	// main関数に与えられる引数
	private static boolean valid = true;

	// ログ出力
	private static Log log = LogFactory.getLog(ChangeValidConf.class);

	/**
	 * メイン
	 * 
	 * @param args
	 */
	public static void main(String[] args) {

		// 実行ログを記載
		log.info(Messages.getMsg("ImportTool.Exec") + " : " + Arrays.toString(args));

		// 引数の数の確認
		boolean checkArgs = true;
		if (args.length >= 1 && args.length <= 2) {
			String modeString = "";
			String validString = "";
			// 引数の格納
			if(args.length == 1){
				modeString = "all";
				validString = args[0];
			}
			else{
				modeString = args[0];
				validString = args[1];
			}
			if(validString.equals("on") || validString.equals("off")){
				mode = modeString;
				if(validString.equals("on"))
					valid = true;
				else
					valid = false;
			}
			else
				checkArgs = false;
		}
		else {
			checkArgs = false;
		}

		if (!checkArgs) {
			log.error(Messages.getMsg("ArgsInvalid"));
			System.exit(11);
		}

		if(mode.equalsIgnoreCase("notify") || mode.equalsIgnoreCase("all")){
			//通知
			ChangeValidNotify notify = new ChangeValidNotify();
			notify.changeValid(valid);
		}
		if(mode.equalsIgnoreCase("node") || mode.equalsIgnoreCase("all")){
			//ノード
			ChangeValidNode node = new ChangeValidNode();
			node.changeValid(valid);
		}
		if(mode.equalsIgnoreCase("log") || mode.equalsIgnoreCase("all")){
			//ログ転送
			ChangeValidLogTransfer log = new ChangeValidLogTransfer();
			log.changeValid(valid);
		}
		if(mode.equalsIgnoreCase("agent") || mode.equalsIgnoreCase("all")){
			//エージェント監視
			ChangeValidMonitorAgent agent = new ChangeValidMonitorAgent();
			agent.changeValid(valid);
		}
		if(mode.equalsIgnoreCase("http") || mode.equalsIgnoreCase("all")){
			//HTTP監視
			ChangeValidMonitorHttp http = new ChangeValidMonitorHttp();
			http.changeValid(valid);
		}
		if(mode.equalsIgnoreCase("ping") || mode.equalsIgnoreCase("all")){
			//Ping監視
			ChangeValidMonitorPing ping = new ChangeValidMonitorPing();
			ping.changeValid(valid);
		}
		if(mode.equalsIgnoreCase("port") || mode.equalsIgnoreCase("all")){
			//サービス・ポート監視
			ChangeValidMonitorPort port = new ChangeValidMonitorPort();
			port.changeValid(valid);
		}
		if(mode.equalsIgnoreCase("process") || mode.equalsIgnoreCase("all")){
			//プロセス監視
			ChangeValidMonitorProcess process = new ChangeValidMonitorProcess();
			process.changeValid(valid);
		}
		if(mode.equalsIgnoreCase("resource") || mode.equalsIgnoreCase("all")){
			//リソース監視
			ChangeValidMonitorPerformance perf = new ChangeValidMonitorPerformance();
			perf.changeValid(valid);
		}
		if(mode.equalsIgnoreCase("sql") || mode.equalsIgnoreCase("all")){
			//SQL監視
			ChangeValidMonitorSql sql = new ChangeValidMonitorSql();
			sql.changeValid(valid);
		}
		if(mode.equalsIgnoreCase("snmp") || mode.equalsIgnoreCase("all")){
			//SNMP監視
			ChangeValidMonitorSnmp snmp = new ChangeValidMonitorSnmp();
			snmp.changeValid(valid);
		}
		if(mode.equalsIgnoreCase("trap") || mode.equalsIgnoreCase("all")){
			//SNMPTRAP監視
			ChangeValidMonitorSnmpTrap trap = new ChangeValidMonitorSnmpTrap();
			trap.changeValid(valid);
		}
		if(mode.equalsIgnoreCase("syslog") || mode.equalsIgnoreCase("all")){
			//Syslog-ng監視
			ChangeValidMonitorSyslogng syslogng = new ChangeValidMonitorSyslogng();
			syslogng.changeValid(valid);
		}
//		if(mode.equalsIgnoreCase("perf") || mode.equalsIgnoreCase("all")){
//		//性能管理機能の実績収集
//		ImportPerformance perf = new ImportPerformance();
//		perf.importPerformance();
//		}
		if(mode.equalsIgnoreCase("mainte") || mode.equalsIgnoreCase("all")){
			//メンテナンス
			ChangeValidMaintenance maintenance = new ChangeValidMaintenance();
			maintenance.changeValid(valid);
		}
		if(mode.equalsIgnoreCase("sche") || mode.equalsIgnoreCase("all")){
			//ジョブスケジュール
			ChangeValidSchedule sche = new ChangeValidSchedule();
			sche.changeValid(valid);
		}
//		else{
//		log.error(Messages.getMsg("ModeNotFound"));
//		System.exit(12);
//		}

		// マネージャー接続の切断
		try {
			LoginManager.getContextManager().logout();
		} catch (NamingException e) {
			log.warn(Messages.getMsg("DisconnectManagerFailed"), e);
		}

		// 正常終了
		log.info(Messages.getMsg("ImportTool.Exit"));
		System.exit(0);
	}
}
